/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.connect_direct.convertor;

import com.bmc.ctmconvert.common.message.NewMessage;
import com.bmc.ctmconvert.connect_direct.convertor.SymbolPredicate;
import com.bmc.ctmconvert.dataObject.DataEntity;
import com.bmc.ctmconvert.dataObject.DataEntityId;
import com.bmc.ctmconvert.dataObject.DataObject;
import com.bmc.ctmconvert.workspace.IWorkspaceEntity;
import com.bmc.ctmconvert.workspace.OrderableEntity;
import com.bmc.ctmconvert.workspace.Workspace;
import com.bmc.ctmconvert.workspace.WorkspaceId;
import java.util.HashMap;
import java.util.Optional;

public class SymbolHandler {
    private DataObject dataObject;
    private Workspace workspace;
    private HashMap<DataEntityId, WorkspaceId> dataEntityToWorkspaceEntityMap;

    public SymbolHandler(DataObject dataObject, Workspace workspace, HashMap<DataEntityId, WorkspaceId> dataEntityToWorkspaceEntityMap) {
        this.dataObject = dataObject;
        this.workspace = workspace;
        this.dataEntityToWorkspaceEntityMap = dataEntityToWorkspaceEntityMap;
    }

    public void handleSymbols() {
        SymbolPredicate symbolPredicate = new SymbolPredicate();
        this.dataObject.stream().filter(symbolPredicate).forEach(symbolStatement -> this.issueMessage((DataEntity)symbolStatement));
    }

    private void issueMessage(DataEntity symbolStatment) {
        Optional process = symbolStatment.getParent();
        if (!process.isPresent()) {
            return;
        }
        Optional<OrderableEntity> folder = this.getEquivalentFolder((DataEntity)process.get());
        if (folder.isPresent()) {
            String processName = (String)((DataEntity)process.get()).getAttributes().findFirst("PROCESS_NAME").get();
            String symbolText = (String)symbolStatment.getAttributes().findFirst("ORIGINAL_TEXT").get();
            NewMessage symbolMessage = new NewMessage("WRN18002", new String[]{processName, symbolText});
            folder.get().addMessage(symbolMessage);
        }
    }

    private Optional<OrderableEntity> getEquivalentFolder(DataEntity process) {
        IWorkspaceEntity folder;
        Optional<OrderableEntity> ret = Optional.empty();
        DataEntityId processEntityID = process.getId();
        WorkspaceId folderId = this.dataEntityToWorkspaceEntityMap.get(processEntityID);
        if (folderId != null && (folder = this.workspace.getEntityByID(folderId)) != null && folder instanceof OrderableEntity) {
            ret = Optional.of((OrderableEntity)folder);
        }
        return ret;
    }
}

