/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.connect_direct.convertor;

import com.bmc.ctmconvert.common.message.Action;
import com.bmc.ctmconvert.common.message.AftAccountAction;
import com.bmc.ctmconvert.common.message.NewMessage;
import com.bmc.ctmconvert.connect_direct.convertor.JobsCollector;
import com.bmc.ctmconvert.connect_direct.convertor.SymbolPredicate;
import com.bmc.ctmconvert.connect_direct.data.Statement;
import com.bmc.ctmconvert.connect_direct.globs.CDGlobals;
import com.bmc.ctmconvert.convertor.actions.JobsCreator;
import com.bmc.ctmconvert.dataObject.Data;
import com.bmc.ctmconvert.dataObject.DataEntity;
import com.bmc.ctmconvert.dataObject.DataEntityId;
import com.bmc.ctmconvert.dataObject.DataObject;
import com.bmc.ctmconvert.vc.FieldValidation;
import com.bmc.ctmconvert.workspace.IWorkspaceEntity;
import com.bmc.ctmconvert.workspace.OrderableEntity;
import com.bmc.ctmconvert.workspace.Workspace;
import com.bmc.ctmconvert.workspace.WorkspaceId;
import com.bmc.ctmconvert.workspace.entities.AftJob;
import com.bmc.ctmconvert.workspace.entities.BaseJob;
import com.bmc.ctmconvert.workspace.entities.Variable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;

public class CDJobCreator
implements JobsCreator {
    private DataObject dataObject;
    private Workspace ws;
    private HashMap<DataEntityId, WorkspaceId> dataEntityToWorkspaceEntityMap;
    private int statementCounter = 1;
    private JobsCollector collector;

    public CDJobCreator(DataObject dataObject, Workspace ws, HashMap<DataEntityId, WorkspaceId> dataEntityToWorkspaceEntityMap) {
        this.dataObject = dataObject;
        this.ws = ws;
        this.dataEntityToWorkspaceEntityMap = dataEntityToWorkspaceEntityMap;
        this.collector = new JobsCollector();
    }

    public static <T> Predicate<T> not(Predicate<T> t) {
        return t.negate();
    }

    public void act() {
        SymbolPredicate symbolPredicate = new SymbolPredicate();
        this.dataObject.stream().filter(this::isStatementContainsIfElseGoToOrExit).filter(CDJobCreator.not(symbolPredicate::test)).forEach(this::generateJob);
        this.issueMessagesForIgnoredJobs();
    }

    private boolean isStatementContainsIfElseGoToOrExit(DataEntity de) {
        boolean isStatmentType = false;
        Data data = de.getData();
        if (data instanceof Statement) {
            Statement statementData = (Statement)data;
            isStatmentType = CDGlobals.CDUtils.isStatementType(statementData);
        }
        return isStatmentType;
    }

    private void storeNotStatement(DataEntity de) {
        Data data = de.getData();
        if (data instanceof Statement) {
            Statement statementData = (Statement)data;
            Optional processEntity = this.dataObject.getParentOf(de);
            this.collector.addJobIdToFoldersIgnoredJobsList(processEntity, statementData.getOriginalStatementText().trim());
        }
    }

    private void issueMessagesForIgnoredJobs() {
        this.dataObject.stream().filter(de -> !this.isStatementContainsIfElseGoToOrExit((DataEntity)de)).forEach(this::storeNotStatement);
        Set<Optional<DataEntity>> foldersList = this.collector.getFoldersList();
        for (Optional<DataEntity> folder : foldersList) {
            if (!folder.isPresent()) continue;
            WorkspaceId wsID = this.dataEntityToWorkspaceEntityMap.get(folder.get().getId());
            OrderableEntity wsFolder = (OrderableEntity)this.ws.getEntityByID(wsID);
            List<String> ignoredJobsList = this.collector.getIgnoredJobsForFolder(folder);
            for (String igonredJob : ignoredJobsList) {
                wsFolder.addMessage(new NewMessage("WRN18001", new String[]{wsFolder.getName(), igonredJob}));
            }
        }
    }

    private void generateJob(DataEntity de) {
        String statementType = null;
        BaseJob job = null;
        String processName = null;
        Data data = de.getData();
        if (!(data instanceof Statement)) {
            return;
        }
        Statement statementData = (Statement)data;
        ArrayList<NewMessage> messages = new ArrayList<NewMessage>();
        WorkspaceId wsID = new WorkspaceId();
        String name = this.getJobName(statementData, messages);
        this.dataEntityToWorkspaceEntityMap.put(de.getId(), wsID);
        switch (statementType = this.getStatementType(statementData)) {
            case "COPY": {
                job = this.createAftJob(statementData, wsID, name, de);
                break;
            }
            default: {
                job = new BaseJob(name, wsID);
                job.addAttribute("TASKTYPE", "Dummy");
                job.addMessage(new NewMessage("WRN18000", new String[]{name, name}));
            }
        }
        job.addVariable(new Variable("TYPE", statementType));
        job.setDescription(statementData.getOriginalStatementText());
        processName = (String)((DataEntity)de.getParent().get()).getAttributes().findFirst("PROCESS_NAME").get();
        job.addAttribute("APPLICATION", processName);
        job.addAttribute("GROUP", "DEFAULT_SUB_APPLICATION");
        this.ws.addJob((IWorkspaceEntity)job);
    }

    private String getStatementType(Statement statementData) {
        return (String)statementData.getAttributes().findFirst("STATEMENT_TYPE").get();
    }

    private AftJob createAftJob(Statement statementData, WorkspaceId wsID, String name, DataEntity de) {
        AftJob aftjob = new AftJob(name, wsID);
        String fromNode = statementData.getAttributes().findFirst("FROM_NODE").orElse("");
        String toNode = statementData.getAttributes().findFirst("TO_NODE").orElse("");
        if (fromNode.isEmpty() && toNode.equals("PNODE")) {
            fromNode = "SNODE";
        } else if (fromNode.isEmpty() && toNode.equals("SNODE")) {
            fromNode = "PNODE";
        } else if (toNode.isEmpty() && fromNode.equals("PNODE")) {
            toNode = "SNODE";
        } else if (toNode.isEmpty() && fromNode.equals("SNODE")) {
            toNode = "PNODE";
        } else if (toNode.isEmpty() && fromNode.isEmpty()) {
            fromNode = "SNODE";
            toNode = "PNODE";
        }
        String account = "%%".concat(fromNode).concat(".-").concat("%%").concat(toNode);
        String pnode = ((DataEntity)de.getParent().get()).getAttributes().findFirst("PROCESS_PNODE").orElse("");
        String snode = ((DataEntity)de.getParent().get()).getAttributes().findFirst("PROCESS_SNODE").orElse("");
        if (pnode != null && !pnode.isEmpty() && !pnode.startsWith("&")) {
            account = account.replaceAll("%%PNODE\\.", pnode);
            account = account.replaceAll("%%PNODE", pnode);
        }
        if (snode != null && !snode.isEmpty() && !snode.startsWith("&")) {
            account = account.replaceAll("%%SNODE\\.", snode);
            account = account.replaceAll("%%SNODE", snode);
        }
        aftjob.setAccount(account);
        aftjob.setLpath(statementData.getAttributes().findFirst("FROM_DSN").orElse(""));
        aftjob.setRpath(statementData.getAttributes().findFirst("TO_DSN").orElse(""));
        aftjob.addAction((Action)new AftAccountAction(name, account));
        return aftjob;
    }

    private String getJobName(Statement statement, ArrayList<NewMessage> messages) {
        Object head;
        String labelName = statement.getLabel().orElse("");
        Object newJobName = "";
        Object object = head = labelName.length() > 63 ? labelName.substring(0, 62) : labelName;
        if (!((String)head).isEmpty()) {
            head = (String)head + "#";
        }
        String tail = this.getStatementType(statement) + "#" + Integer.toString(this.statementCounter++);
        newJobName = (String)head + tail;
        while (((String)newJobName).length() > 64) {
            newJobName = ((String)newJobName).substring(1);
        }
        return FieldValidation.instance().validateAndReturnFixedValue(messages, "JOBNAME", "JOBNAME", (String)newJobName, true, "STATEMENT_LABEL", (String)newJobName);
    }
}

