/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.connect_direct.convertor;

import com.bmc.ctmconvert.connect_direct.data.Statement;
import com.bmc.ctmconvert.connect_direct.globs.CDGlobals;
import com.bmc.ctmconvert.convertor.actions.HierarchyCreator;
import com.bmc.ctmconvert.dataObject.DataEntity;
import com.bmc.ctmconvert.dataObject.DataEntityId;
import com.bmc.ctmconvert.dataObject.DataObject;
import com.bmc.ctmconvert.workspace.IWorkspaceEntity;
import com.bmc.ctmconvert.workspace.Workspace;
import com.bmc.ctmconvert.workspace.WorkspaceId;
import com.bmc.ctmconvert.workspace.entities.Folder;
import java.util.HashMap;
import java.util.List;
import java.util.function.Predicate;

public class CDHierarchyCreator
implements HierarchyCreator {
    private Workspace ws;
    private DataObject dataObject;
    private HashMap<DataEntityId, WorkspaceId> dataEntityToWorkspaceEntityMap;

    CDHierarchyCreator(DataObject dataObject, Workspace workspace, HashMap<DataEntityId, WorkspaceId> dataEntityToWorkspaceEntityMap) {
        this.ws = workspace;
        this.dataObject = dataObject;
        this.dataEntityToWorkspaceEntityMap = dataEntityToWorkspaceEntityMap;
    }

    public void act() {
        this.dataObject.stream().filter(this.isProcess()).forEach(this::addJobsToFolder);
    }

    private void addJobsToFolder(DataEntity process) {
        List statments = this.dataObject.getChildrenOf(process, this.isValidStatment());
        this.addConvertedJobsToFolder(statments, process);
    }

    private void addConvertedJobsToFolder(List<DataEntity> statments, DataEntity process) {
        IWorkspaceEntity folder = this.getEquivalentCtmEntity(process);
        for (DataEntity statement : statments) {
            IWorkspaceEntity job = this.getEquivalentCtmEntity(statement);
            if (job == null) continue;
            this.ws.insertChildToFolder(job, (Folder)folder);
        }
    }

    private IWorkspaceEntity getEquivalentCtmEntity(DataEntity process) {
        WorkspaceId ctmId = this.dataEntityToWorkspaceEntityMap.get(process.getId());
        IWorkspaceEntity ret = this.ws.getEntityByID(ctmId);
        return ret;
    }

    private Predicate<DataEntity> isValidStatment() {
        return dataEntity -> {
            if (dataEntity.getData() instanceof Statement) {
                Statement statement = (Statement)dataEntity.getData();
                return CDGlobals.CDUtils.isStatementType(statement);
            }
            return false;
        };
    }

    private Predicate<DataEntity> isProcess() {
        return p -> p.getAttributes().findFirst("process_file_name").isPresent();
    }
}

