/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.connect_direct.convertor;

import com.bmc.ctmconvert.common.message.NewMessage;
import com.bmc.ctmconvert.common.rbc.RBC;
import com.bmc.ctmconvert.connect_direct.data.ProcessHeader;
import com.bmc.ctmconvert.convertor.actions.FoldersCreator;
import com.bmc.ctmconvert.dataObject.DataEntity;
import com.bmc.ctmconvert.dataObject.DataEntityId;
import com.bmc.ctmconvert.dataObject.DataObject;
import com.bmc.ctmconvert.utils.Pair;
import com.bmc.ctmconvert.utils.UniqueValueGenerator;
import com.bmc.ctmconvert.vc.FieldValidation;
import com.bmc.ctmconvert.workspace.Workspace;
import com.bmc.ctmconvert.workspace.WorkspaceId;
import com.bmc.ctmconvert.workspace.entities.BaseFolder;
import com.bmc.ctmconvert.workspace.entities.Folder;
import com.bmc.ctmconvert.workspace.entities.IRBC;
import com.bmc.ctmconvert.workspace.entities.RbcAPI;
import com.bmc.ctmconvert.workspace.entities.Variable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.function.Predicate;

public class CDFolderCreator
implements FoldersCreator {
    private Workspace ws;
    DataObject dataObject;
    private UniqueValueGenerator uniqueValue;
    HashMap<DataEntityId, WorkspaceId> dataEntityToWorkspaceEntityMap;

    public CDFolderCreator(DataObject dataObj, Workspace workspace, HashMap<DataEntityId, WorkspaceId> dataEntityToWorkspaceEntityMap) {
        this.ws = workspace;
        this.dataObject = dataObj;
        this.dataEntityToWorkspaceEntityMap = dataEntityToWorkspaceEntityMap;
        this.uniqueValue = new UniqueValueGenerator();
    }

    private String getFolderName(DataEntity dataEntity, ArrayList<NewMessage> messages) {
        String originalFolderName = dataEntity.getAttributes().findFirst("process_file_name").orElse("");
        String fixedTableName = FieldValidation.instance().validateAndReturnFixedUniqueValue("TABLE_NAME", "Folder Name", originalFolderName.trim(), true, "Process file name", originalFolderName, messages, this.uniqueValue, "TABLE_NAME", 64, "#", true);
        return fixedTableName;
    }

    private RbcAPI getRBC() {
        RbcAPI rbc = new RbcAPI();
        rbc.addAttribute("NAME", "EMPTY_RBC");
        rbc.addAttribute("MAXWAIT", "00");
        rbc.addAttribute("DAYS_AND_OR", "O");
        rbc.addAttribute("SHIFT", "Ignore Job");
        rbc.addAttribute("SHIFTNUM", "0");
        rbc.addAttribute("RETRO", "0");
        rbc.addAttribute("LEVEL", "N");
        for (RBC.MONTHS month : RBC.MONTHS.values()) {
            rbc.addAttribute(month.toString(), "1");
        }
        return rbc;
    }

    public void act() {
        this.dataObject.stream().filter(this.isFolder()).forEach(this::generateFolder);
    }

    private Predicate<DataEntity> isFolder() {
        return de -> de.getData().getDataType().equals("PROCESS");
    }

    private void generateFolder(DataEntity de) {
        ArrayList<NewMessage> messages = new ArrayList<NewMessage>();
        String name = this.getFolderName(de, messages);
        WorkspaceId id = new WorkspaceId();
        BaseFolder folder = new BaseFolder(id, name);
        String originalText = de.getAttributes().findFirst("ORIGINAL_TEXT").orElse("");
        folder.setDescription(originalText);
        folder.addAttribute("APPLICATION", name);
        folder.addAttribute("GROUP", "DEFAULT_SUB_APPLICATION");
        String pnode = de.getAttributes().findFirst("PROCESS_PNODE").orElse("").replaceAll("&", "%%");
        folder.addVariable(new Variable("PNODE", pnode));
        String snode = de.getAttributes().findFirst("PROCESS_SNODE").orElse("").replaceAll("&", "%%");
        folder.addVariable(new Variable("SNODE", snode));
        ProcessHeader processHeader = (ProcessHeader)de.getData();
        List<Pair<String, String>> processArgs = processHeader.getProcessArgs();
        for (Pair<String, String> args : processArgs) {
            folder.addVariable(new Variable((String)args.getKey(), (String)args.getValue()));
        }
        RbcAPI defaultRbc = this.getRBC();
        folder.addRBC((IRBC)defaultRbc);
        for (NewMessage message : messages) {
            folder.addMessage(message);
        }
        this.dataEntityToWorkspaceEntityMap.put(de.getId(), id);
        this.ws.addFolder((Folder)folder);
    }
}

