/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.rule;

import com.bmc.ctmconvert.Context;
import com.bmc.ctmconvert.common.GlobalFunctions;
import com.bmc.ctmconvert.common.Globs;
import com.bmc.ctmconvert.common.xml.XmlElement;
import com.bmc.ctmconvert.exception.ScriptRuleException;
import com.bmc.ctmconvert.getter.CtmEntityGetter;
import com.bmc.ctmconvert.rule.ConversionBuilderRule;
import com.bmc.ctmconvert.rule.Debugger;
import com.bmc.ctmconvert.scriptelement.CtmBaseEntity;
import com.bmc.ctmconvert.scriptelement.CtmFolder;
import com.bmc.ctmconvert.scriptelement.CtmJob;
import com.bmc.ctmconvert.scriptelement.CtmWorkspace;
import com.bmc.ctmconvert.scriptelement.CtmXmlQuery;
import com.bmc.ctmconvert.scriptelement.XmlQueryImp;
import groovy.lang.Binding;
import groovy.lang.GroovyShell;
import groovy.lang.Script;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.LocalDateTime;
import org.codehaus.groovy.control.CompilerConfiguration;
import org.codehaus.groovy.control.customizers.CompilationCustomizer;
import org.codehaus.groovy.control.customizers.ImportCustomizer;

public class ScriptRule
implements ConversionBuilderRule {
    private Binding binding;
    protected Script groovyScript;
    private String inputScript;
    protected CtmEntityGetter ctmEntityMapper;
    private final String script;

    public ScriptRule(String inputScript, CtmEntityGetter ctmEntityMapper) {
        this.ctmEntityMapper = ctmEntityMapper;
        this.inputScript = inputScript;
        this.script = inputScript;
        this.binding = new Binding();
        CompilerConfiguration config = new CompilerConfiguration();
        ImportCustomizer importCustomizer = new ImportCustomizer();
        importCustomizer.addImports(ScriptRule.getImportsForScript());
        importCustomizer.addStarImports(ScriptRule.getStarImportsForScript());
        config.addCompilationCustomizers(new CompilationCustomizer[]{importCustomizer});
        GroovyShell shell = new GroovyShell(this.binding, config);
        try {
            this.groovyScript = shell.parse(this.script);
        }
        catch (RuntimeException e) {
            throw new ScriptRuleException("Error in Script Rule syntax, please fix the relevant script syntax.", e, inputScript);
        }
    }

    private void writeScriptToFileForDebugging() throws IOException {
        if (GlobalFunctions.isRunningInDebugger()) {
            Path scriptPath = Paths.get(Globs.TEMP_DIR + Globs.DIRSEP + "Script1.groovy", new String[0]);
            Files.write(scriptPath, ("//Script started running at " + this.getTime() + System.lineSeparator() + this.script).getBytes(), new OpenOption[0]);
        }
    }

    private String getTime() {
        return LocalDateTime.now().toString();
    }

    public static String[] getImportsForScript() {
        return new String[]{"com.bmc.ctmconvert.common.xml.XmlElement", "java.util.regex.Matcher", "com.bmc.ctmconvert.scriptelement.CtmJob", "com.bmc.ctmconvert.scriptelement.CtmFolder", "com.bmc.ctmconvert.scriptelement.TimeUnit", "com.bmc.ctmconvert.scriptelement.ToTime", "com.bmc.ctmconvert.scriptelement.FromJob", "java.util.regex.Pattern", "com.bmc.ctmconvert.sap.Step", "com.bmc.ctmconvert.sap.SapBWProcessType", "com.bmc.ctmconvert.sap.SapBWRerunOption", "com.bmc.ctmconvert.scriptelement.SapR3Action", "com.bmc.ctmconvert.scriptelement.CtmXmlElement", "com.bmc.ctmconvert.api.CtmTransfer.TransferType", "com.bmc.ctmconvert.api.CtmTransfer.TransferOption", "com.bmc.ctmconvert.api.InConditionAndOr", "com.bmc.ctmconvert.api.OutConditionSign", "com.bmc.ctmconvert.scriptelement.CtmWorkspace.JobType", "com.bmc.ctmconvert.scriptelement.SapR3ExecTarget", "com.bmc.ctmconvert.scriptelement.SapR3JobClass", "com.bmc.ctmconvert.api.SapR3AbapStepAPI.PrintArchiveMode", "com.bmc.ctmconvert.api.SapR3AbapStepAPI.TimeOfPrint", "com.bmc.ctmconvert.api.SapR3AbapStepAPI.OsCoverSheet", "com.bmc.ctmconvert.api.SapR3AbapStepAPI.SapCoverPage", "com.bmc.ctmconvert.api.DatabasesParametersAPI.DatabasesExecutionType", "com.bmc.ctmconvert.api.FileWatcherParametersAPI.FileWatcherMode", "com.bmc.ctmconvert.api.FileWatcherParametersAPI.FileWatcherSizeIn", "com.bmc.ctmconvert.scriptelement.AirFlowOutputMode", "com.bmc.ctmconvert.api.Os2200ParametersAPI.ShowOutputType"};
    }

    public static String[] getStarImportsForScript() {
        return new String[]{"com.bmc.ctmconvert.api"};
    }

    static String doImport(String qualifiedName) {
        return ScriptRule.statement("import " + qualifiedName);
    }

    static String statement(String code) {
        return code + ";\r\n";
    }

    @Override
    public void activate(XmlElement xmlElement) {
        this.initGroovyScriptProperties(xmlElement);
        try {
            this.writeScriptToFileForDebugging();
            this.groovyScript.run();
        }
        catch (Exception e) {
            throw new ScriptRuleException("Runtime error in Script Rule , please fix the relevant script rule logic.", e, this.inputScript);
        }
    }

    private void initGroovyScriptProperties(XmlElement xmlElement) {
        CtmWorkspace workspaceScriptElement = this.getWorkspace();
        CtmBaseEntity ctmEntity = this.ctmEntityMapper.get(xmlElement);
        CtmXmlQuery xmlQuery = this.getXmlQuery();
        this.groovyScript.setProperty("ctmWorkspace", (Object)workspaceScriptElement);
        this.groovyScript.setProperty("debugger", (Object)new Debugger());
        this.groovyScript.setProperty("mapper", (Object)this.ctmEntityMapper);
        this.groovyScript.setProperty("xmlElement", (Object)xmlElement);
        this.groovyScript.setProperty("ctmEntity", (Object)ctmEntity);
        this.initCtmEntityType(ctmEntity);
        this.groovyScript.setProperty("ctmXmlQuery", (Object)xmlQuery);
    }

    private void initCtmEntityType(CtmBaseEntity ctmEntity) {
        if (ctmEntity instanceof CtmJob) {
            this.groovyScript.setProperty("ctmJob", (Object)ctmEntity);
        } else if (ctmEntity instanceof CtmFolder) {
            this.groovyScript.setProperty("ctmFolder", (Object)ctmEntity);
        }
    }

    CtmWorkspace getWorkspace() {
        return Context.getWorkspace();
    }

    public String getScript() {
        return this.inputScript;
    }

    CtmXmlQuery getXmlQuery() {
        return new XmlQueryImp();
    }
}

