/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.rule;

import com.bmc.ctmconvert.exception.ScriptRuleException;
import com.bmc.ctmconvert.getter.CtmEntityMapper;
import com.bmc.ctmconvert.rule.ConversionBuilderRule;
import com.bmc.ctmconvert.rule.RulesProvider;
import com.bmc.ctmconvert.rule.RunOnceRule;
import com.bmc.ctmconvert.rule.ScriptRule;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONObject;

public class RulesParser
implements RulesProvider {
    private static final String CHOOSE_XML_OPERATION = "Choose XML Operation";
    private JSONArray rulesJsonArray;

    public RulesParser(JSONArray rulesJsonArray) {
        this.rulesJsonArray = rulesJsonArray;
    }

    @Override
    public List<ConversionBuilderRule> getRules() {
        ArrayList<ConversionBuilderRule> rulesList = new ArrayList<ConversionBuilderRule>();
        this.rulesJsonArray.forEach(ruleJsonObject -> rulesList.add(this.getRuleFromType((JSONObject)ruleJsonObject)));
        return rulesList;
    }

    private ConversionBuilderRule getRuleFromType(JSONObject ruleJsonObject) {
        ConversionBuilderRule result = xml -> {};
        String ruleTypeString = ruleJsonObject.getString("type");
        JSONObject rulesData = ruleJsonObject.getJSONObject("rulesData");
        switch (ruleTypeString.toLowerCase()) {
            default: 
        }
        String script = rulesData.getString("script");
        this.validateRuleTripletData(rulesData, script);
        result = new RunOnceRule(new ScriptRule(script, new CtmEntityMapper()));
        return result;
    }

    private void validateRuleTripletData(JSONObject rulesData, String rule) {
        JSONArray triplets;
        if (!rulesData.isNull("triplets") && (triplets = rulesData.getJSONArray("triplets")) != null && triplets.getJSONObject(0) != null && triplets.getJSONObject(0).getString("entityType") != null && (triplets.getJSONObject(0).getString("entityType").equals(CHOOSE_XML_OPERATION) || triplets.getJSONObject(0).getString("entityType").equals("")) && !triplets.getJSONObject(0).getString("value").equals("")) {
            throw new ScriptRuleException("Error in Script Rule syntax, please fix the relevant script syntax.", rule);
        }
    }
}

