/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.dollar_universe.session;

import com.bmc.ctmconvert.common.AssistingJob;
import com.bmc.ctmconvert.common.IAttrHolder;
import com.bmc.ctmconvert.common.SchedEntity;
import com.bmc.ctmconvert.dollar_universe.DollarUniverseDefs;
import com.bmc.ctmconvert.dollar_universe.DollarUniverseJob;
import com.bmc.ctmconvert.dollar_universe.ResourceConvertor;
import com.bmc.ctmconvert.dollar_universe.condition.HdpConditionsHandler;
import com.bmc.ctmconvert.dollar_universe.hdpmu.HdpHandler;
import com.bmc.ctmconvert.dollar_universe.session.DollarUniverseSession;
import com.bmc.ctmconvert.dollar_universe.session.SessionEntry;
import com.bmc.ctmconvert.ondo.Do;
import com.bmc.ctmconvert.ondo.DoShout;
import com.bmc.ctmconvert.ondo.OnStatement;
import com.bmc.ctmconvert.rules.RuleManager;
import com.bmc.ctmconvert.rules.RulesDataSet;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public class SessionEntryHDPHandler {
    private final DollarUniverseSession session;
    private SessionEntry sessionEntry;
    private Map<Integer, DollarUniverseJob> jobMap;
    private HdpHandler.HdpLogicHandler hdpLogicHandler;
    private ResourceConvertor resourceConvertor;

    public SessionEntryHDPHandler(DollarUniverseSession session, SessionEntry sessionEntry, Map<Integer, DollarUniverseJob> jobMap, DollarUniverseDefs sourceDefinitions) {
        this.session = session;
        this.sessionEntry = sessionEntry;
        this.jobMap = jobMap;
        this.hdpLogicHandler = sourceDefinitions.getHdpLogic();
        this.resourceConvertor = sourceDefinitions.getResourceConvertor();
    }

    public void handleSessionEntry() {
        if (this.sessionEntry.isFatherAHeader()) {
            this.handleFatherAutoEdits();
        }
        this.addSonJobFatherConditions();
        this.manipulateSonJob();
        this.addCtmOrderShoutToProgramToFatherJob();
    }

    private void handleFatherAutoEdits() {
        DollarUniverseJob fatherJob = this.jobMap.get(this.sessionEntry.getFatherNumber());
        this.hdpLogicHandler.handleFatherJob(fatherJob, this.session.getHeaderMu());
    }

    private void addSonJobFatherConditions() {
        DollarUniverseJob sonJob = this.jobMap.get(this.sessionEntry.getSonNumber());
        DollarUniverseJob fatherJob = this.jobMap.get(this.sessionEntry.getFatherNumber());
        HdpConditionsHandler.addHdpConditions(sonJob, fatherJob, this.sessionEntry);
    }

    private void manipulateSonJob() {
        DollarUniverseJob sonJob = this.jobMap.get(this.sessionEntry.getSonNumber());
        this.changeSonHostGroup();
        this.manipulateAssistingJobs(sonJob);
    }

    private void changeSonHostGroup() {
        DollarUniverseJob sonJob = this.jobMap.get(this.sessionEntry.getSonNumber());
        sonJob.setNodeId("HostGroupPlaceholder");
        boolean isHDPUsed = this.sessionEntry.isUsingHdp();
        sonJob.setMultyAgent(isHDPUsed);
    }

    private void manipulateAssistingJobs(DollarUniverseJob sonJob) {
        List<AssistingJob> sonAssistingJobs = sonJob.getAssistingJobs();
        for (AssistingJob assistingJob : sonAssistingJobs) {
            String resconMu = this.getResconMu(assistingJob);
            boolean isAssistingJobShouldRunOnSameNode = resconMu != null && resconMu.equals("same");
            if (!isAssistingJobShouldRunOnSameNode) continue;
            assistingJob.setAttribute("MULTY_AGENT", "Y");
            this.addNodeVariableToConditionName(assistingJob);
        }
    }

    private void addNodeVariableToConditionName(AssistingJob assistingJob) {
        List assitingJobOutCond = assistingJob.getOutConds();
        for (Properties conditionProperties : assitingJobOutCond) {
            this.addNodeIdVaribleToName(conditionProperties);
        }
    }

    private void addNodeIdVaribleToName(Properties condition) {
        Object conditionName = condition.getProperty("NAME");
        conditionName = (String)conditionName + "_%%NODEID";
        condition.setProperty("NAME", (String)conditionName);
    }

    private void addCtmOrderShoutToProgramToFatherJob() {
        DollarUniverseJob fatherJob = this.jobMap.get(this.sessionEntry.getFatherNumber());
        OnStatement on = this.createOnStatement();
        ArrayList<Do> orderList = this.createDoList();
        on.addAllDo(orderList);
        fatherJob.addOnDoStmt(on);
    }

    private OnStatement createOnStatement() {
        Object on = this.sessionEntry.isPathOK() ? OnStatement.OnOkStatement.createOnOkStatement() : OnStatement.OnOkStatement.createOnNotOkStatement();
        return on;
    }

    private ArrayList<Do> createDoList() {
        ArrayList<Do> doList = new ArrayList<Do>();
        DoShout orderSon = this.createDoShoutForSon();
        ArrayList<DoShout> orderAsisstingJob = this.createDoShoutForAsisstingJobs();
        doList.add((Do)orderSon);
        doList.addAll(orderAsisstingJob);
        return doList;
    }

    private DoShout createDoShoutForSon() {
        DollarUniverseJob sonJob = this.jobMap.get(this.sessionEntry.getSonNumber());
        DoShout doShout = this.createOrderDoShout(sonJob);
        return doShout;
    }

    private ArrayList<DoShout> createDoShoutForAsisstingJobs() {
        ArrayList<DoShout> doList = new ArrayList<DoShout>();
        DollarUniverseJob sonJob = this.jobMap.get(this.sessionEntry.getSonNumber());
        List<AssistingJob> assitingJobs = sonJob.getAssistingJobs();
        for (AssistingJob assistingJob : assitingJobs) {
            DoShout assistingOrder = this.OrderAsisstingJob(assistingJob);
            if (assistingOrder == null) continue;
            doList.add(assistingOrder);
        }
        return doList;
    }

    private DoShout OrderAsisstingJob(AssistingJob assistingJob) {
        DoShout doShout = this.createOrderDoShout((SchedEntity)assistingJob);
        return doShout;
    }

    String getResconMu(AssistingJob assistingJob) {
        String resconMu = null;
        IAttrHolder resourceCondtionAttribute = this.resourceConvertor.getResconFwJobsOriginalAttributes(assistingJob);
        if (resourceCondtionAttribute != null) {
            resconMu = resourceCondtionAttribute.getAttr("mu");
        }
        return resconMu;
    }

    private DoShout createOrderDoShout(SchedEntity job) {
        String message = this.hdpLogicHandler.getScriptMessgae(job, this.sessionEntry);
        RulesDataSet rules = RuleManager.instance().getCurrentRules();
        String DefaultDestination = rules.getStringRule("HDP", new String[]{"messageDesitination"});
        DoShout doShout = Do.createDoShout((String)DefaultDestination);
        doShout.setMessage(message.toString());
        return doShout;
    }
}

