/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.dollar_universe.session;

import com.bmc.ctmconvert.dollar_universe.Tree;
import com.bmc.ctmconvert.dollar_universe.hdpmu.HDPRelationship;
import com.bmc.ctmconvert.dollar_universe.hdpmu.MuHierarchy;
import com.bmc.ctmconvert.dollar_universe.hdpmu.NoneRelationship;
import com.bmc.ctmconvert.dollar_universe.hdpmu.SpecificMU;
import com.bmc.ctmconvert.dollar_universe.session.DollarUniverseSession;
import com.bmc.ctmconvert.dollar_universe.session.DollarUniverseSessionTree;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class MuResolver {
    Map<DollarUniverseSessionTree.SessionElement, Set<String>> uprocToMus;
    private MuHierarchy muHierarchy;
    private Tree<DollarUniverseSessionTree.SessionElement> sessionTree;

    public MuResolver(MuHierarchy muHierarchy, DollarUniverseSession dollarUniverseSession) {
        this.sessionTree = dollarUniverseSession.getSessionTree();
        this.muHierarchy = muHierarchy;
        this.uprocToMus = new HashMap<DollarUniverseSessionTree.SessionElement, Set<String>>();
        this.addHeaderMu(dollarUniverseSession);
        this.sessionTree.forEachPreOrder(this::insertSessionElementToMap);
    }

    private void addHeaderMu(DollarUniverseSession dollarUniverseSession) {
        DollarUniverseSessionTree.SessionElement root = this.sessionTree.getRoot();
        HashSet<String> rootMus = new HashSet<String>();
        rootMus.add(dollarUniverseSession.getHeaderMu());
        this.uprocToMus.put(root, rootMus);
    }

    public HashSet<String> getUprocMus(Integer uprocNumber) {
        HashSet<String> mus = new HashSet<String>();
        if (!this.isNumberInTree(uprocNumber)) {
            return mus;
        }
        DollarUniverseSessionTree.SessionElement sessionElement = this.getElementByNumber(uprocNumber);
        if (this.uprocToMus.containsKey(sessionElement)) {
            Set<String> registerdMus = this.uprocToMus.get(sessionElement);
            mus.addAll(registerdMus);
        }
        return mus;
    }

    private DollarUniverseSessionTree.SessionElement getElementByNumber(Integer uprocNumber) {
        for (DollarUniverseSessionTree.SessionElement sessionElement : this.sessionTree) {
            if (!sessionElement.getUprocId().equals(uprocNumber)) continue;
            return sessionElement;
        }
        return null;
    }

    private boolean isNumberInTree(Integer uprocNumber) {
        DollarUniverseSessionTree.SessionElement SessionWithNumber = this.getElementByNumber(uprocNumber);
        return SessionWithNumber != null;
    }

    private void insertSessionElementToMap(DollarUniverseSessionTree.SessionElement element) {
        if (this.sessionTree.isRoot(element)) {
            return;
        }
        DollarUniverseSessionTree.SessionElement parentSesionElement = this.sessionTree.getParent(element);
        HashSet<String> childMus = new HashSet<String>();
        HDPRelationship relationship = element.getHdpRelationship();
        if (relationship instanceof SpecificMU) {
            childMus.add(relationship.getExpression());
        } else if (relationship instanceof NoneRelationship) {
            Set<String> parentMus = this.uprocToMus.get(parentSesionElement);
            if (parentMus != null) {
                childMus.addAll(parentMus);
            }
        } else if (relationship.isHdp().booleanValue()) {
            Set<String> parentMus = this.uprocToMus.get(parentSesionElement);
            Map<String, Set<String>> sonMus = relationship.resolveNodes(parentMus, this.muHierarchy);
            for (Set<String> mus : sonMus.values()) {
                childMus.addAll(mus);
            }
        }
        this.uprocToMus.put(element, childMus);
    }
}

