/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.dollar_universe.launch_window;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class MultiLaunchWindowTimeMatcher {
    private static final String MULW_GROUP = "MULW";
    private static final String MULW_OLD_FORMAT_PATTERN_AT = "(?<MULW>([0-9]{4},[0-9]{3},[0-9]{2}))";
    private static final String MULW_OLD_FORMAT_PATTERN_FROM = "(?<MULW>[0-9]{4},[0-9]{4},[0-9]{3}\\),[0-9]{3},[0-9]{2})";
    private static final String MULW_NEW_FORMAT_PATTERN = "(?<MULW>[0-9]{4})";
    private Pattern mulwpattern;
    private Optional<String> elapse;

    public MultiLaunchWindowTimeMatcher(Optional<String> elapse) {
        this.elapse = elapse;
    }

    private Pattern getThePatternOfATWindowOption(Optional<String> elapse) {
        Pattern temp = elapse.isPresent() ? Pattern.compile(MULW_NEW_FORMAT_PATTERN) : Pattern.compile(MULW_OLD_FORMAT_PATTERN_AT);
        return temp;
    }

    public boolean isLaunchWindowWithATOption(String mulw) {
        Pattern tempPatern = this.getThePatternOfATWindowOption(this.elapse);
        Matcher timeMatche = tempPatern.matcher(mulw);
        return timeMatche.find();
    }

    public boolean isLaunchWindowWithFROMOption(String mulw) {
        Pattern tempPatern = Pattern.compile(MULW_OLD_FORMAT_PATTERN_FROM);
        Matcher timeMatcher = tempPatern.matcher(mulw);
        return timeMatcher.find();
    }

    public List<String> getTimesOfATWindowOption(String mulw) {
        this.mulwpattern = this.getThePatternOfATWindowOption(this.elapse);
        ArrayList<String> ret = new ArrayList<String>();
        Matcher timeMatcher = this.mulwpattern.matcher(mulw);
        while (timeMatcher.find()) {
            String mulwRow = timeMatcher.group(MULW_GROUP);
            ret.add(mulwRow);
        }
        return ret;
    }

    public List<String> getTimesOfFROMWindowOption(String mulw) {
        this.mulwpattern = Pattern.compile(MULW_OLD_FORMAT_PATTERN_FROM);
        ArrayList<String> ret = new ArrayList<String>();
        Matcher timeMatcher = this.mulwpattern.matcher(mulw);
        while (timeMatcher.find()) {
            String mulwRow = timeMatcher.group(MULW_GROUP);
            ret.add(mulwRow);
        }
        return ret;
    }
}

