/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.dollar_universe.launch_window;

import com.bmc.ctmconvert.dollar_universe.DollarUniverseJob;
import com.bmc.ctmconvert.dollar_universe.DollarUniverseTaskAttributes;
import com.bmc.ctmconvert.dollar_universe.launch_window.CyclicalLaunchTime;
import com.bmc.ctmconvert.dollar_universe.launch_window.DailyLaunchWindow;
import com.bmc.ctmconvert.dollar_universe.launch_window.LaunchWindow;
import com.bmc.ctmconvert.dollar_universe.launch_window.MultiLaunchWindowFactory;
import com.bmc.ctmconvert.dollar_universe.launch_window.RuleLaunchTime;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.collections4.map.HashedMap;

public class LaunchWindowFactory {
    private DollarUniverseTaskAttributes sourceTaskDefinition;
    private DollarUniverseJob job;

    public LaunchWindowFactory(DollarUniverseTaskAttributes sourceTaskDefinition, DollarUniverseJob job) {
        this.sourceTaskDefinition = sourceTaskDefinition;
        this.job = job;
    }

    public Optional<LaunchWindow> getLaunchWindow() {
        String windowType = this.getLaunchWindowType();
        Optional<LaunchWindow> launchWindow = Optional.empty();
        switch (windowType) {
            case "dalw": {
                Map<String, String> allDays = this.getAllDaysOfTheWeek();
                launchWindow = Optional.of(new DailyLaunchWindow(this.job, allDays));
                launchWindow.get().convertLaunchWindow();
                break;
            }
            case "mulw": {
                MultiLaunchWindowFactory multiLaunchWindowFactory = new MultiLaunchWindowFactory(this.sourceTaskDefinition, this.job);
                launchWindow = multiLaunchWindowFactory.getMultiLuanchWindowConvertor();
                break;
            }
            case "emptyMultiWindow": {
                launchWindow = new RuleLaunchTime(this.sourceTaskDefinition).getLaunchWindow();
                break;
            }
            case "cyclical": {
                launchWindow = new CyclicalLaunchTime(this.sourceTaskDefinition).getLaunchWindow();
                break;
            }
            case "prlw": 
            case "relw": {
                this.job.addReporterMessage("INF7008", this.job.getOriginalJobName(), this.job.getJobName());
                break;
            }
        }
        return launchWindow;
    }

    private Map<String, String> getAllDaysOfTheWeek() {
        HashedMap mapDaysOfTheWeek = new HashedMap();
        mapDaysOfTheWeek.put("dalw", this.sourceTaskDefinition.getAttributes().getAttr("dalw"));
        mapDaysOfTheWeek.put("sun", this.sourceTaskDefinition.getAttributes().getAttr("sun"));
        mapDaysOfTheWeek.put("mon", this.sourceTaskDefinition.getAttributes().getAttr("mon"));
        mapDaysOfTheWeek.put("tue", this.sourceTaskDefinition.getAttributes().getAttr("tue"));
        mapDaysOfTheWeek.put("wed", this.sourceTaskDefinition.getAttributes().getAttr("wed"));
        mapDaysOfTheWeek.put("thu", this.sourceTaskDefinition.getAttributes().getAttr("thu"));
        mapDaysOfTheWeek.put("fri", this.sourceTaskDefinition.getAttributes().getAttr("fri"));
        mapDaysOfTheWeek.put("sat", this.sourceTaskDefinition.getAttributes().getAttr("sat"));
        return mapDaysOfTheWeek;
    }

    public String getLaunchWindowType() {
        String ret = "UNKNOWN_TYPE";
        if (!this.isEmptyMulwLaunchWindow()) {
            ret = "mulw";
        } else if (!this.isEmptyDalwLaunchWindow()) {
            ret = "dalw";
        } else if (!this.isEmptyCyclicalLaunchWindow()) {
            ret = "cyclical";
        } else if (!this.isEmptyRelwLaunchWindow()) {
            ret = "relw";
        } else if (!this.isEmptyPrlwLaunchWindow()) {
            ret = "prlw";
        } else if (this.isRuleWithLaunchTime()) {
            ret = "emptyMultiWindow";
        }
        return ret;
    }

    private boolean isRuleWithLaunchTime() {
        return this.isEmptyMulwLaunchWindow() && !RuleLaunchTime.getLaunchTimesFromTaskRule(this.sourceTaskDefinition).isEmpty();
    }

    private boolean isEmptyDalwLaunchWindow() {
        String dalw = this.sourceTaskDefinition.getAttributes().getAttr("dalw");
        return dalw == null || dalw.isEmpty() || dalw.matches("^[ \t]*\\(0{4}+,0{3}+,0{2}+\\)");
    }

    private boolean isEmptyCyclicalLaunchWindow() {
        String cyclical = this.sourceTaskDefinition.getAttributes().getAttr("cyclical");
        return cyclical == null || cyclical.isEmpty() || cyclical.matches("^[ \t]*\\(\\)");
    }

    private boolean isEmptyMulwLaunchWindow() {
        String mulw = this.sourceTaskDefinition.getAttributes().getAttr("mulw");
        return mulw == null || mulw.isEmpty() || mulw.matches("^[ \t]*\\(\\)");
    }

    private boolean isEmptyRelwLaunchWindow() {
        String relw = this.sourceTaskDefinition.getAttributes().getAttr("relw");
        return relw == null || relw.isEmpty() || relw.matches("^[ \t]*\\(0{4},0{3},0{2},0{3},0{2},0{4},0{3},0{2}\\)") || relw.matches("^[ \t]*\\(\\)");
    }

    private boolean isEmptyPrlwLaunchWindow() {
        String prlw = this.sourceTaskDefinition.getAttributes().getAttr("prlw");
        return prlw == null || prlw.isEmpty() || prlw.matches("^[ \t]*\\(0{4},0{3},0{2},0{4},0{4}\\)");
    }
}

