/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.dollar_universe.launch_window;

import com.bmc.ctmconvert.common.GlobalFunctions;
import com.bmc.ctmconvert.dollar_universe.DollarUniverseTaskAttributes;
import com.bmc.ctmconvert.dollar_universe.launch_window.LaunchWindow;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CyclicalLaunchTime
implements LaunchWindow {
    private final DollarUniverseTaskAttributes sourceTaskDefinition;

    public CyclicalLaunchTime(DollarUniverseTaskAttributes sourceTaskDefinition) {
        this.sourceTaskDefinition = sourceTaskDefinition;
    }

    public static List<String> getLaunchTimesFromTaskCyclical(DollarUniverseTaskAttributes sourceTaskDefinition) {
        String cyclical = sourceTaskDefinition.getAttributes().getAttr("cyclical");
        if (cyclical != null) {
            Pattern timePattern = Pattern.compile("every (\\d{5})h (\\d{2})min", 8);
            Matcher timeResults = timePattern.matcher(cyclical);
            ArrayList<String> results = new ArrayList<String>();
            while (timeResults.find()) {
                for (int i = 1; i <= timeResults.groupCount(); ++i) {
                    results.add(timeResults.group(i));
                }
            }
            return results;
        }
        return Collections.emptyList();
    }

    public Optional<LaunchWindow> getLaunchWindow() {
        return Optional.of(this);
    }

    @Override
    public HashMap<String, String> getAttributes() {
        List<String> results = CyclicalLaunchTime.getLaunchTimesFromTaskCyclical(this.sourceTaskDefinition);
        int hours = Integer.parseInt(results.get(0));
        int minuets = Integer.parseInt(results.get(1));
        if (hours > 0) {
            minuets += hours * 60;
        }
        return new HashMap<String, String>(GlobalFunctions.attributesCyclicInterval((String)"0000", (String)(minuets + "M")));
    }

    @Override
    public void convertLaunchWindow() {
    }
}

