/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.dollar_universe.hdpmu;

import com.bmc.ctmconvert.dollar_universe.hdpmu.HDPRelationship;
import com.bmc.ctmconvert.dollar_universe.hdpmu.MuHierarchy;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ParentsRelationship
extends HDPRelationship
implements HDPRelationship.TypedReleaionship {
    public static final String PARENT_PATTERN = "\\{\\s([a-zA-Z0-9_])\\}";
    private String parentType = "";

    protected ParentsRelationship(String hdpExpr, String commandNode) {
        super(hdpExpr, commandNode);
        Pattern pattern = Pattern.compile(PARENT_PATTERN);
        Matcher matcher = pattern.matcher(hdpExpr);
        if (matcher.matches()) {
            this.parentType = matcher.group(1);
        }
    }

    @Override
    public String getRelationshipString() {
        return String.format("%s_%s", new Object[]{this.parentType, HDPRelationship.HDPRelationShip.PARENTS});
    }

    @Override
    public Set<String> resolveNodes(String currentMu, MuHierarchy muHierarchy) {
        HashSet<String> ret = new HashSet<String>();
        Set<String> allparents = muHierarchy.getParents(currentMu);
        Set<String> parentByType = this.filterType(allparents, this.parentType);
        ret.addAll(parentByType);
        return ret;
    }

    @Override
    public String toString() {
        return this.getRelationshipString();
    }

    @Override
    public Boolean isHdp() {
        return true;
    }

    @Override
    public String getType() {
        return this.parentType;
    }

    @Override
    public HDPRelationship.HDPRelationShip getRelationship() {
        return HDPRelationship.HDPRelationShip.PARENTS;
    }
}

