/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.dollar_universe.hdpmu;

import com.bmc.ctmconvert.common.Forest;
import com.bmc.ctmconvert.common.Params;
import com.bmc.ctmconvert.common.log.ConversionLogger;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.Scanner;

public final class MuDependenciesParser {
    private Forest<String> dependencies = new Forest();

    public Forest<String> parse() {
        File defaultPath = new File(Params.instance().getDatasourcePath() + "MuDependencies.txt");
        return this.parse(defaultPath);
    }

    public Forest<String> parse(File muDependencies) {
        try (Scanner scanner = new Scanner(muDependencies);){
            this.skipHeader(scanner);
            this.parseEntries(scanner);
        }
        catch (FileNotFoundException e) {
            String message = String.format("cannot find file: '%s':\n%s", muDependencies.getAbsolutePath(), e.getMessage());
            ConversionLogger.getLogger().warning(message);
        }
        return this.dependencies;
    }

    private void skipHeader(Scanner reader) {
        String line;
        String HEADER_SEPARATOR_PATTERN = "^\\s*-+\\s+-+\\s*$";
        while (reader.hasNextLine() && !(line = reader.nextLine()).matches("^\\s*-+\\s+-+\\s*$")) {
        }
    }

    private void parseEntries(Scanner reader) {
        boolean MU_COLUMN = false;
        boolean DEPMU_COLUMN = true;
        int COLUMNS_PER_ROW = 2;
        while (reader.hasNextLine()) {
            String SPACES;
            String line = reader.nextLine().trim();
            String[] columns = line.split(SPACES = "\\s+");
            if (columns.length == 2) {
                String mu = columns[0];
                String depmu = columns[1];
                this.dependencies.addLink((Object)mu, (Object)depmu);
                continue;
            }
            String message = String.format("expected %d columns. actual %d", 2, columns.length);
            ConversionLogger.getLogger().warning(message);
        }
    }
}

