/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.dollar_universe.hdpmu;

import com.bmc.ctmconvert.dollar_universe.hdpmu.HDPFactory;
import com.bmc.ctmconvert.dollar_universe.hdpmu.MuHierarchy;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public abstract class HDPRelationship {
    public static final String HDP_GROUP_FORMAT = "%s_%s";
    public static final String HDP_MU_RELATION_FORMAT = "%s_%s";
    public static final String MU_CHARACTERS = "a-zA-Z0-9_";
    private String commandNode;
    private String HDPexpression;

    public abstract String getRelationshipString();

    public abstract HDPRelationShip getRelationship();

    public abstract Set<String> resolveNodes(String var1, MuHierarchy var2);

    public abstract Boolean isHdp();

    public HDPRelationship(String HDPexpression, String commandNode) {
        this.HDPexpression = HDPexpression;
        this.commandNode = commandNode;
    }

    public Map<String, Set<String>> resolveNodes(Set<String> currentMUs, MuHierarchy muHierarchy) {
        HashMap<String, Set<String>> resolvedMus = new HashMap<String, Set<String>>();
        for (String currentMu : currentMUs) {
            Set<String> childsNames = this.resolveNodes(currentMu, muHierarchy);
            if (childsNames.isEmpty()) continue;
            resolvedMus.put(currentMu, childsNames);
        }
        return resolvedMus;
    }

    public String getExpression() {
        return this.HDPexpression;
    }

    public String getCommandNodeName() {
        return this.commandNode;
    }

    public String resolveNodeGroupName(String mu) {
        return String.format("%s_%s", mu, this.getRelationshipString());
    }

    protected Set<String> filterType(Set<String> nodes, String type) {
        HashSet<String> ret = new HashSet<String>();
        for (String node : nodes) {
            if (!node.startsWith(type)) continue;
            ret.add(node);
        }
        return ret;
    }

    public String toString() {
        return "HDPRelationship [HDPexpression=" + this.HDPexpression + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.HDPexpression == null ? 0 : this.HDPexpression.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        HDPRelationship other = (HDPRelationship)obj;
        return !(this.HDPexpression == null ? other.HDPexpression != null : !this.HDPexpression.equals(other.HDPexpression));
    }

    public String getNodeGroupAutoEditValue() {
        return this.resolveNodeGroupName("%%NODEID.");
    }

    public static boolean isHdpExpression(String expression, String commandNode) {
        HDPFactory factory = new HDPFactory();
        HDPRelationship hdpExpreession = factory.makeRelationShip(expression, commandNode);
        return hdpExpreession.isHdp();
    }

    public static enum HDPRelationShip {
        CHILDREN,
        PARENTS,
        BROTHERS,
        NONE,
        SPECIFIC;

    }

    public static interface TypedReleaionship {
        public String getType();
    }
}

