/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.dollar_universe.hdpmu;

import com.bmc.ctmconvert.dollar_universe.hdpmu.HDPRelationship;
import com.bmc.ctmconvert.dollar_universe.hdpmu.MuHierarchy;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ChildRelationship
extends HDPRelationship
implements HDPRelationship.TypedReleaionship {
    public static final String CHILDREN_PATTERN = "\\{([a-zA-Z0-9_])\\s\\}";
    private String childType;

    protected ChildRelationship(String hdpExpr, String commandNode) {
        super(hdpExpr, commandNode);
        Pattern childrenPattern = Pattern.compile(CHILDREN_PATTERN);
        Matcher childrenMatcher = childrenPattern.matcher(hdpExpr);
        if (childrenMatcher.matches()) {
            this.childType = childrenMatcher.group(1);
        }
    }

    @Override
    public String getRelationshipString() {
        return String.format("%s_%s", new Object[]{this.childType, HDPRelationship.HDPRelationShip.CHILDREN});
    }

    @Override
    public Set<String> resolveNodes(String currentMu, MuHierarchy muHierarchy) {
        HashSet<String> ret = new HashSet<String>();
        Set<String> allchilds = muHierarchy.getChildren(currentMu);
        Set<String> childsByType = this.filterType(allchilds, this.childType);
        ret.addAll(childsByType);
        return ret;
    }

    @Override
    public String toString() {
        return "ChildRelationship [childType=" + this.childType + ", getName()=" + this.getRelationshipString() + "]";
    }

    @Override
    public Boolean isHdp() {
        return true;
    }

    @Override
    public HDPRelationship.HDPRelationShip getRelationship() {
        return HDPRelationship.HDPRelationShip.CHILDREN;
    }

    @Override
    public String getType() {
        return this.childType;
    }
}

