/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.dollar_universe.handlers;

import com.bmc.ctmconvert.common.IAttrHolder;
import com.bmc.ctmconvert.ondo.Do;
import com.bmc.ctmconvert.ondo.OnStatement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class UprStatusHandler {
    private List<OnStatement> onDoActions;

    public UprStatusHandler(IAttrHolder upr) {
        String uprStatus = upr.getAttr("upr_status");
        List<Map<String, String>> uprStatusMaps = this.analyzeUprStatus(uprStatus);
        this.onDoActions = this.createOnDoAction(uprStatusMaps);
    }

    private List<Map<String, String>> analyzeUprStatus(String uprStatus) {
        ArrayList<Map<String, String>> mapList = new ArrayList<Map<String, String>>();
        if (UprStatusHandler.isNotEmptyUprStatus(uprStatus)) {
            String[] blocks = uprStatus.split("\\)(,*)\\s*(,*)\\s*\\(");
            blocks[0] = blocks[0].substring(1);
            for (String block : blocks) {
                block = block.trim();
                String[] lines = block.split("\n");
                HashMap<String, String> map = new HashMap<String, String>();
                for (String line : lines) {
                    String[] parts;
                    if ((line = line.trim()).isEmpty() || (parts = line.split(":")).length != 2) continue;
                    String key = parts[0].trim();
                    String value = parts[1].trim();
                    map.put(key, value);
                }
                mapList.add(map);
            }
        }
        return mapList;
    }

    private static boolean isNotEmptyUprStatus(String uprStatus) {
        if (uprStatus == null || uprStatus.isEmpty()) {
            return false;
        }
        return !uprStatus.trim().matches("^\\(\\s*\\R*\\s*\\)$");
    }

    private List<OnStatement> createOnDoAction(List<Map<String, String>> uprStatusList) {
        return uprStatusList.stream().filter(uprStatus -> ((String)uprStatus.get("enable")).trim().startsWith("Y")).map(uprStatus -> {
            if (uprStatus.containsKey("retcode")) {
                return this.getOnDoReturnCode((Map<String, String>)uprStatus);
            }
            return this.getOnDoSearchStringInLogFile((Map<String, String>)uprStatus);
        }).filter(Objects::nonNull).toList();
    }

    private OnStatement getOnDoSearchStringInLogFile(Map<String, String> uprStatus) {
        OnStatement.OnSpecificStatement onStatement = null;
        if (uprStatus.containsKey("string") && (uprStatus.containsKey("search_file") && uprStatus.get("search_file").contains("job log") || !uprStatus.containsKey("search_file"))) {
            onStatement = new OnStatement.OnSpecificStatement("*", "*" + uprStatus.get("string") + "*");
            onStatement.addDo(this.getDoAction(uprStatus));
        }
        return onStatement;
    }

    private OnStatement getOnDoReturnCode(Map<String, String> uprStatus) {
        OnStatement.OnCompletionStatus onStatement = null;
        String[] retcode = uprStatus.get("retcode").split(",");
        if (retcode.length == 2) {
            String compareStatus = retcode[1].trim().toUpperCase();
            int exitCode = Integer.parseInt(retcode[0].trim());
            if (compareStatus.equals("LO")) {
                compareStatus = "LT";
            }
            onStatement = OnStatement.createOnCompletionStatus((int)exitCode, (String)compareStatus);
            onStatement.addDo(this.getDoAction(uprStatus));
        }
        return onStatement;
    }

    private Do getDoAction(Map<String, String> uprStatus) {
        Do onDo = uprStatus.get("set").trim().equalsIgnoreCase("A") ? Do.createDoNotOk() : Do.createDoOk();
        return onDo;
    }

    public List<OnStatement> getOnDoActions() {
        return this.onDoActions;
    }
}

