/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.dollar_universe.handlers;

import com.bmc.ctmconvert.common.Globs;
import com.bmc.ctmconvert.dollar_universe.DollarUniverseJob;
import java.util.Optional;
import java.util.function.UnaryOperator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SapApiCommandConverter {
    private final String script;
    private final DollarUniverseJob job;

    public SapApiCommandConverter(String script, DollarUniverseJob dollarUniverseJob) {
        this.script = script;
        this.job = dollarUniverseJob;
    }

    public void convert() {
        this.convertJobName();
        this.addSapApiCommandFromScript();
    }

    private void convertJobName() {
        Pattern pJobName = Pattern.compile("uxstr SAP API JOBNAME=(.*?)\\s+");
        Matcher mJobName = pJobName.matcher(this.script);
        String sapJobName = "";
        if (mJobName.find()) {
            sapJobName = mJobName.group(1);
        }
        String resolvedSapJobName = (String)this.resolveVariables().apply(sapJobName);
        this.job.addAttribute("MEMNAME", resolvedSapJobName);
        this.job.addAutoEdits("%%SAPR3-JOBNAME", resolvedSapJobName);
    }

    private void addSapApiCommandFromScript() {
        Pattern p = Pattern.compile("STEPLIST=\"[(]+(.*?(?=,))[,]?(.*?(?=[,|)]))[,]?(.*?(?=[,|)]))[,]?(.*?(?=[,|)]))[,]?(.*?(?=[,|)]))[,]?(.*?(?=[,|)]))[,]?(.*?(?=[,|)]))[,]?(.*?(?=[,|)]))[,]?(.*?(?=[,|)]))[,]?(.*?(?=[,|)]))[,]?(.*?(?=[,|)])).*[)]+\"", 2);
        Matcher m = p.matcher(this.script);
        if (m.find()) {
            String user = "";
            String language = "";
            String variant = "";
            String printer = "";
            String delete = "";
            String authorization = "";
            String printImm = "";
            int paramLength = m.groupCount();
            if (paramLength >= 1) {
                user = m.group(1);
            }
            if (paramLength >= 2) {
                language = m.group(2);
            }
            if (paramLength >= 3) {
                this.convertProgram(m.group(3));
            }
            if (paramLength >= 4) {
                variant = m.group(4);
            }
            if (paramLength >= 5) {
                printer = m.group(5);
            }
            if (paramLength >= 6) {
                delete = m.group(6);
            }
            if (paramLength >= 7) {
                this.convertNCopies(m.group(7));
            }
            if (paramLength >= 8) {
                authorization = m.group(8);
            }
            if (paramLength >= 9) {
                this.convertArchMode(m.group(9));
            }
            if (paramLength >= 11) {
                printImm = m.group(11);
            }
            if (delete.isEmpty() && paramLength < 6) {
                delete = "X";
            } else if (delete.isEmpty()) {
                delete = "N";
            }
            if (authorization.isEmpty()) {
                authorization = user;
            }
            if (printImm.isEmpty() && paramLength < 11) {
                printImm = "A";
            }
            this.convertHost();
            this.addABAPJob(user, language, variant, printer, delete, authorization, printImm);
        }
    }

    private void convertNCopies(String nCopies) {
        String value = Optional.ofNullable(nCopies).filter(s -> !s.isBlank()).orElse("1");
        this.job.addAutoEdits(String.format("%%%%SAPR3-STEP-S%02d-PRINT_COPIES", 1), value);
    }

    private void convertHost() {
        String host = "DEFAULT_CONNECTION";
        this.job.addAttribute("OWNER", host);
        this.job.addAttribute("OWNER", host);
        this.job.addAutoEdits("%%SAPR3-ACCOUNT", host);
    }

    private void convertProgram(String program) {
        this.job.addAutoEdits("%%SAPR3-STEP-S01-PROGRAM", (String)this.resolveVariables().apply(program));
    }

    private void convertArchMode(String archMode) {
        String ctmValue = switch (Optional.ofNullable(archMode).orElse("")) {
            case "1" -> "Print";
            case "2" -> "PRINT_ARCHIVE";
            case "3" -> "ARCHIVE";
            default -> "Print";
        };
        this.job.addAutoEdits(String.format("%%%%SAPR3-STEP-S%02d-PRINT_ARCHMODE", 1), ctmValue);
    }

    UnaryOperator<String> resolveVariables() {
        return variable -> variable.replaceAll("^\\$", "%%");
    }

    private void addABAPJob(String user, String language, String variant, String printer, String delete, String authorization, String printImm) {
        this.job.addAttribute("MEMLIB", "Not in use for SAP jobs");
        Globs.SAP_TYPE_FORM_VERSION.forEach(this.job::setOptionalAtrribute);
        this.job.addAutoEdits("%%SAPR3-GROUP_ORDID", "%%GROUP_ORDID");
        this.job.addAutoEdits("%%SAPR3-DETECT_CHILD_TABLE", "%%SCHEDTAB");
        this.job.addAutoEdits("%%SAPR3-JOB_MODE", "CREATE");
        this.job.addAutoEdits("%%SAPR3-SERVER_OR_GROUP_TYPE", "S");
        this.job.addAutoEdits("%%SAPR3-JOBCLASS", "C");
        this.job.addAutoEdits("%%SAPR3-JOB_COUNT", "LAST_SCHEDULED");
        this.job.addAutoEdits("%%SAPR3-JOBCOUNT", "LAST_SCHEDULED");
        this.job.addAutoEdits("%%SAPR3-KEEP_JOBLOG_OPTION", "S");
        this.job.addAutoEdits("%%SAPR3-OVERRIDE_JOBLOG_DEFAULT", "X");
        this.job.addAutoEdits("%%SAPR3-JOBLOG", "*SYSOUT");
        this.job.addAutoEdits("%%SAPR3-SUBMIT_ASAP", "X");
        this.job.addAutoEdits("%%SAPR3-DETECT_CHILD_RELEASE", "N");
        this.job.addAutoEdits("%%SAPR3-DETECT_OPTION", "1");
        this.job.addAutoEdits("%%SAPR3-INC_APP_STAT", "no");
        this.job.addAutoEdits("%%SAPR3-RERUN_STEP_NUM", "1");
        this.job.addAutoEdits(String.format("%%%%SAPR3-STEP-S%02d-STEP_TYPE", 1), "A");
        if (delete != null && !delete.isEmpty()) {
            this.job.addAutoEdits(String.format("%%%%SAPR3-STEP-S%02d-PRINT_RELEASE", 1), delete);
        } else {
            this.job.addAutoEdits(String.format("%%%%SAPR3-STEP-S%02d-PRINT_RELEASE", 1), "N");
        }
        this.job.addAutoEdits(String.format("%%%%SAPR3-STEP-S%02d-NEW_LIST_ID", 1), "X");
        this.job.addAutoEdits(String.format("%%%%SAPR3-STEP-S%02d-PRINT_EXPIRATION", 1), "8");
        this.job.addAutoEdits(String.format("%%%%SAPR3-STEP-S%02d-PRINT_BANNER", 1), "D");
        this.job.addAutoEdits(String.format("%%%%SAPR3-STEP-S%02d-PRINT_HOST_BANNER", 1), "D");
        if (printImm == null || printImm.isEmpty()) {
            printImm = "N";
        }
        this.job.addAutoEdits(String.format("%%%%SAPR3-STEP-S%02d-PRINT_IMMED", 1), printImm);
        if (printer != null && !printer.isEmpty()) {
            this.job.addAutoEdits(String.format("%%%%SAPR3-STEP-S%02d-PRINT_DEST", 1), printer);
        }
        if (language != null && !language.isEmpty()) {
            this.job.addAutoEdits(String.format("%%%%SAPR3-STEP-S%02d-LANGU", 1), language);
        }
        if (user != null && !user.isEmpty()) {
            this.job.addAutoEdits(String.format("%%%%SAPR3-STEP-S%02d-OWNER", 1), user);
        }
        if (variant != null && !variant.isEmpty()) {
            this.job.addAutoEdits(String.format("%%%%SAPR3-STEP-S%02d-VAR-NAME", 1), (String)this.resolveVariables().apply(variant.toUpperCase()));
        }
        this.job.addAutoEdits(String.format("%%%%SAPR3-STEP-S%02d-PRINT_BANNER_PAGE", 1), "N");
        if (authorization != null && !authorization.isEmpty()) {
            this.job.addAutoEdits(String.format("%%%%SAPR3-STEP-S%02d-LIST_NAME", 1), authorization);
        }
        this.job.addAutoEdits("%%SAPR3-XBP_VERSION", "XBP30");
    }
}

