/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.dollar_universe.handlers;

import com.bmc.ctmconvert.common.AssistingJob;
import com.bmc.ctmconvert.common.IAttrHolder;
import com.bmc.ctmconvert.common.SchedEntity;
import com.bmc.ctmconvert.dollar_universe.DollarUniverseGlobals;
import com.bmc.ctmconvert.dollar_universe.utils.DollarUniverseUtils;
import com.bmc.ctmconvert.rules.RulesDataSet;
import com.bmc.ctmconvert.utils.UniqueConditionNameGenerator;
import java.util.Properties;
import org.jetbrains.annotations.NotNull;

public class HandlerEndFolderDummyJobForFileWatcher {
    private RulesDataSet rules;
    private UniqueConditionNameGenerator uniqueConditionNameGenerator;

    public HandlerEndFolderDummyJobForFileWatcher(RulesDataSet rules, UniqueConditionNameGenerator uniqueConditionNameGenerator) {
        this.rules = rules;
        this.uniqueConditionNameGenerator = uniqueConditionNameGenerator;
    }

    public AssistingJob buildEndFolderJobForFW(IAttrHolder uprExtAttrs, String fWjobName) {
        AssistingJob toRet = new AssistingJob(SchedEntity.TYPE.JOB);
        toRet.setAttribute("JOBNAME", String.format(DollarUniverseGlobals.END_FOLDER_JOB_NAME_FORMAT, "%s_" + uprExtAttrs.getAttr("res")));
        toRet.setAttribute("TASKTYPE", "Dummy");
        toRet.setAttribute("NODEID", uprExtAttrs.getAttr("NODE"));
        toRet.setAttribute("END_FOLDER", "Y");
        toRet.setAttribute("DESCRIPTION", String.format(DollarUniverseGlobals.END_FOLDER_JOB_DESCRIPTION, fWjobName));
        Properties inCond = this.getInConditionForEndFolderJob(uprExtAttrs.getAttr("res"));
        toRet.addInCondition(inCond);
        return toRet;
    }

    @NotNull
    public static Properties getCode7OnDoStmt(Properties outCond) {
        Properties stmt = new Properties();
        stmt.setProperty("CODE", "COMPSTAT EQ 7");
        stmt.setProperty("STMT", "*");
        stmt.setProperty("ACTION", "DOCOND");
        stmt.setProperty("NAME", outCond.get("NAME").toString());
        stmt.setProperty("ODATE", outCond.get("ODATE").toString());
        stmt.setProperty("SIGN", outCond.get("SIGN").toString());
        return stmt;
    }

    public Properties getOutConditionForEndFolderJob(String res) {
        Properties outCond = new Properties();
        outCond.put("NAME", this.uniqueConditionNameGenerator.getUniqueOutConditionName(this.buildConditionName(res)));
        outCond.put("ODATE", "ODAT");
        outCond.put("SIGN", "ADD");
        return outCond;
    }

    public Properties getInConditionForEndFolderJob(String res) {
        Properties inCond = new Properties();
        inCond.put("NAME", this.buildConditionName(res));
        inCond.put("ODATE", "ODAT");
        inCond.put("AND_OR", "AND");
        return inCond;
    }

    private String buildConditionName(String res) {
        return String.format(this.getConditionFormatForEndFolderJob(this.rules), "%s_" + res);
    }

    public String getConditionFormatForEndFolderJob(RulesDataSet rules) {
        boolean isAtoBFormat = DollarUniverseUtils.isAtoBConditionFormat(rules);
        if (isAtoBFormat) {
            return DollarUniverseGlobals.END_FOLDER_COND_NAME_NEW_FORMAT_TRIGGERED_BY_FW;
        }
        return DollarUniverseGlobals.END_FOLDER_COND_NAME_FORMAT_TRIGGERED_BY_FW;
    }
}

