/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.dollar_universe.handlers;

import com.bmc.ctmconvert.common.AttrHolderList;
import com.bmc.ctmconvert.common.IAttrHolder;
import com.bmc.ctmconvert.dollar_universe.DollarUniverseDefs;
import com.bmc.ctmconvert.dollar_universe.DollarUniverseJob;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Optional;

public class HandlerDepcon {
    private HashMap<String, AttrHolderList> UprsDepconDep = new HashMap();
    private HashMap<String, ArrayList<String>> UprsDepconInCondition = new HashMap();
    private HashMap<String, IAttrHolder> m_UprsDepconUpr = new HashMap();

    public void updateDepconLists(IAttrHolder upr) {
        String type = upr.getAttr("ENTRY_TYPE");
        if (!type.equalsIgnoreCase("depcon")) {
            return;
        }
        String uprId = upr.getAttr("PARENT_UPR");
        String condno = upr.getAttr("condno");
        String dep = upr.getAttr("dep");
        if (dep.isEmpty()) {
            DollarUniverseJob.addExtReporterMessage("WRN7002", null, null, uprId, condno, uprId);
            return;
        }
        String dtype = upr.getAttr("dtype");
        if (!dtype.equalsIgnoreCase("a")) {
            DollarUniverseJob.addExtReporterMessage("WRN7003", "", null, uprId, condno, uprId, dtype);
            return;
        }
        String key = this.buildDepconKey(uprId, condno);
        this.m_UprsDepconUpr.put(key, upr);
        AttrHolderList list = this.UprsDepconDep.get(dep);
        if (list == null) {
            list = new AttrHolderList();
            this.UprsDepconDep.put(dep, list);
        }
        list.add((Object)upr);
        ArrayList<String> listIn = this.UprsDepconInCondition.get(upr.getAttr("PARENT_UPR"));
        if (listIn == null) {
            listIn = new ArrayList();
            this.UprsDepconInCondition.put(upr.getAttr("PARENT_UPR"), listIn);
        }
        listIn.add(dep);
    }

    public AttrHolderList getUprsDepconByDep(String dep) {
        return this.UprsDepconDep.get(dep);
    }

    public Optional<ArrayList<String>> getInconditionNameByUprName(String uprName) {
        Optional<ArrayList<String>> listInConditon = Optional.empty();
        if (this.UprsDepconInCondition.containsKey(uprName)) {
            listInConditon = Optional.of(this.UprsDepconInCondition.get(uprName));
        }
        return listInConditon;
    }

    public IAttrHolder getUprsDepconByUpr(String uprId, String condno) {
        String key = this.buildDepconKey(uprId, condno);
        return this.m_UprsDepconUpr.get(key);
    }

    private String buildDepconKey(String dep, String condno) {
        return dep + DollarUniverseDefs.HASH_SEPARATOR + condno;
    }
}

