/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.dollar_universe.handlers;

import com.bmc.ctmconvert.dollar_universe.DollarUniverseJob;
import com.bmc.ctmconvert.dollar_universe.hdpmu.HDPRelationship;

public class HandleDepCondName {
    public String handleMu(DollarUniverseJob job, String upr, String mu, String condno, Boolean writeMessage, DollarUniverseJob parent) {
        if (mu.equalsIgnoreCase("any")) {
            mu = "";
        } else if (mu.equalsIgnoreCase("same")) {
            mu = job.isStandAloneJob() ? job.taskParameterValue("mu") : parent.taskParameterValue("mu");
        } else if (mu.length() > 4 && mu.substring(0, 4).equalsIgnoreCase("mut(")) {
            mu = mu.substring(4, mu.length() - 1);
        } else if (mu.length() > 3 && mu.substring(0, 3).equalsIgnoreCase("mu(")) {
            mu = mu.substring(3, mu.length() - 1);
        } else if (mu.length() > 4 && mu.substring(0, 4).equalsIgnoreCase("hdp(") || HDPRelationship.isHdpExpression(mu, job.getOriginalSessionNode())) {
            if (writeMessage.booleanValue()) {
                job.addReporterMessage("WRN7006", condno, mu, upr, job.getJobName());
            }
            return null;
        }
        return mu;
    }

    public String handleSession(DollarUniverseJob job, String upr, String session, String condno, Boolean writeMessage) {
        if (session != null) {
            if (session.equalsIgnoreCase("any")) {
                session = "";
            } else if (session.equalsIgnoreCase("same")) {
                session = job.getOriginalSessionId();
            } else if (session.equalsIgnoreCase("samerun")) {
                session = job.getOriginalSessionId();
                if (writeMessage.booleanValue()) {
                    job.addReporterMessage("INF7003", session, upr, condno);
                }
            } else if (session.length() > 4 && session.substring(0, 5).equalsIgnoreCase("expl(")) {
                session = session.substring(5, session.length() - 1);
            }
        }
        return session;
    }

    public String handleUser(String user, DollarUniverseJob parent) {
        if (user.equalsIgnoreCase("any")) {
            user = "";
        } else if (user.equalsIgnoreCase("same") && parent != null) {
            user = parent.taskParameterValue("user");
        }
        return user;
    }

    public String handleStatus(DollarUniverseJob job, String upr, String mu, String status, String condno, Boolean writeMessage) {
        if (status.equalsIgnoreCase("completed")) {
            status = "OK";
        } else if (status.equalsIgnoreCase("terminated")) {
            status = "OK";
        } else if (status.equalsIgnoreCase("aborted")) {
            status = "NOTOK";
        } else if (status.equalsIgnoreCase("abnormal")) {
            status = "NOTOK";
        } else if (status.equalsIgnoreCase("ended")) {
            status = "ENDED";
        } else {
            if (writeMessage.booleanValue()) {
                job.addReporterMessage("WRN7007", condno, mu, upr, job.getJobName(), status);
            }
            return null;
        }
        return status;
    }
}

