/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.dollar_universe.handlers;

import com.bmc.ctmconvert.common.message.MessageHandler;
import com.bmc.ctmconvert.dollar_universe.DollarUniverseTaskAttributes;

public class DollarUniverseTaskOffsetHandler {
    private static final String midNight = "2400";
    private String formTime;
    private String newDayTime;
    private MessageHandler msgHandler;
    private String offset;

    public DollarUniverseTaskOffsetHandler(DollarUniverseTaskAttributes sourceTaskDefinition, String fromTime, String newDayTime, MessageHandler messageHandler) {
        this.formTime = fromTime != null && fromTime.equals("0000") ? midNight : fromTime;
        this.newDayTime = newDayTime.equals("0000") ? midNight : newDayTime;
        this.msgHandler = messageHandler;
        String tempOffset = sourceTaskDefinition.getAttributes().getAttr("offset");
        this.offset = tempOffset == null ? "" : tempOffset;
    }

    public void handle() {
        if (this.offset.startsWith("+")) {
            this.handleOffsetWithNextDay();
        } else if (this.offset.startsWith("-")) {
            this.handleOffsetWithPrevDay();
        }
    }

    private void handleOffsetWithPrevDay() {
        this.issueMessageOffsetValueNotSupported();
    }

    private void handleOffsetWithNextDay() {
        if (this.offset.matches("\\+1(D|d)")) {
            if (this.formTime != null && !this.formTime.isEmpty()) {
                this.handleFromTimeWithOfssetNextDay();
            } else {
                this.msgHandler.handleMessage("WRN7043", new String[]{this.offset});
            }
        } else {
            this.issueMessageOffsetValueNotSupported();
        }
    }

    private void handleFromTimeWithOfssetNextDay() {
        boolean result = this.isBetweenTwoTimes(this.formTime, this.newDayTime, midNight);
        if (result) {
            this.issueMessageOffsetWithFromTimeNotSupported();
        } else {
            this.issueDiffrentForcastReportInfo();
        }
    }

    private void issueDiffrentForcastReportInfo() {
        this.msgHandler.handleMessage("INF7010", new String[0]);
    }

    private void issueMessageOffsetValueNotSupported() {
        this.msgHandler.handleMessage("WRN7041", new String[]{this.offset});
    }

    private void issueMessageOffsetWithFromTimeNotSupported() {
        this.msgHandler.handleMessage("WRN7042", new String[]{this.offset, this.formTime, this.newDayTime});
    }

    private boolean isBetweenTwoTimes(String target, String start, String end) {
        return target.compareTo(start) >= 0 && target.compareTo(end) < 0;
    }
}

