/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.dollar_universe.condition;

import com.bmc.ctmconvert.common.conditions.InCondition;
import com.bmc.ctmconvert.common.conditions.OutCondition;
import com.bmc.ctmconvert.common.conditions.Sign;
import com.bmc.ctmconvert.dollar_universe.DollarUniverseJob;
import com.bmc.ctmconvert.dollar_universe.session.SessionEntry;
import com.bmc.ctmconvert.rules.RuleManager;
import com.bmc.ctmconvert.rules.RulesDataSet;
import java.util.List;
import java.util.Properties;

public class HdpConditionsHandler {
    private static final String PLANING_CONDITION_FORMAT = "%s-To-%s_Ended_%s_%%%%ORDERID";
    private static final String MONITORING_CONDITION_FORMAT = "%s-To-%s_Ended_%s_%%%%%s";
    private DollarUniverseJob sonJob;
    private DollarUniverseJob fatherJob;
    private SessionEntry sessionEntry;
    private Boolean isAddConditionForMonitiringView;
    private Boolean isAddConditionForPlaningView;

    private HdpConditionsHandler(DollarUniverseJob sonJob, DollarUniverseJob fatherJob, SessionEntry sessionEntry) {
        this.sonJob = sonJob;
        this.fatherJob = fatherJob;
        this.sessionEntry = sessionEntry;
        RulesDataSet rules = RuleManager.instance().getCurrentRules();
        this.isAddConditionForMonitiringView = false;
        this.isAddConditionForPlaningView = false;
    }

    public static void addHdpConditions(DollarUniverseJob sonJob, DollarUniverseJob fatherJob, SessionEntry sessionEntry) {
        HdpConditionsHandler handler = new HdpConditionsHandler(sonJob, fatherJob, sessionEntry);
        handler.addHdpConditions();
    }

    private void addHdpConditions() {
        if (!this.isValidParameters()) {
            return;
        }
        if (this.isAddConditionForMonitiringView.booleanValue() || this.isAddConditionForPlaningView.booleanValue()) {
            this.addOutConditionToFatherJob();
            this.addInconditionsToSonJob();
        }
    }

    private boolean isValidParameters() {
        return this.sonJob != null && this.fatherJob != null && this.sessionEntry != null;
    }

    private void addInconditionsToSonJob() {
        if (this.isAddConditionForMonitiringView.booleanValue()) {
            this.addMonitoringConditionToJob();
        }
        if (this.isAddConditionForPlaningView.booleanValue()) {
            this.addPlaningConditionToJob();
        }
    }

    private void addPlaningConditionToJob() {
        InCondition planingIncondition = this.createPlaningIncondition();
        this.addConditionToJob(this.sonJob, planingIncondition);
    }

    private void addMonitoringConditionToJob() {
        InCondition monitoringIncondition = this.createMonitoringCondition();
        this.addConditionToJob(this.sonJob, monitoringIncondition);
    }

    private void addOutConditionToFatherJob() {
        String outcondName = String.format(PLANING_CONDITION_FORMAT, this.fatherJob.getJobName(), this.sonJob.getJobName(), this.sessionEntry.getPath());
        OutCondition outcondition = new OutCondition(outcondName, "ODATE", Sign.Add);
        this.fatherJob.addOutCondtions(outcondition.getProperties());
    }

    private void addConditionToJob(DollarUniverseJob sonJob, InCondition incondition) {
        List<Properties> sonInconds = sonJob.getInConds();
        sonInconds.add(0, incondition.getProperties());
    }

    private InCondition createMonitoringCondition() {
        String incondName = String.format(MONITORING_CONDITION_FORMAT, this.fatherJob.getJobName(), this.sonJob.getJobName(), this.sessionEntry.getPath(), "Monitoring_View_Variable");
        InCondition incondition = new InCondition(incondName, "AND", "ODATE");
        if (this.isAddConditionForMonitiringView.booleanValue() && this.isAddConditionForPlaningView.booleanValue()) {
            incondition.setOp(")");
        }
        return incondition;
    }

    private InCondition createPlaningIncondition() {
        String condName = String.format(PLANING_CONDITION_FORMAT, this.fatherJob.getJobName(), this.sonJob.getJobName(), this.sessionEntry.getPath());
        InCondition incondition = new InCondition(condName, "OR", "ODATE");
        if (this.isAddConditionForMonitiringView.booleanValue() && this.isAddConditionForPlaningView.booleanValue()) {
            incondition.setOp("(");
        }
        return incondition;
    }
}

