/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.dollar_universe.assessmentreport;

import com.bmc.ctmconvert.base.AbstractAssessmentReport;
import com.bmc.ctmconvert.common.AssessmentXMLDescriptionReader;
import com.bmc.ctmconvert.common.Params;
import com.bmc.ctmconvert.dollar_universe.assessmentreport.ASSESSMENT_SOURCE_INPUT_TYPE;
import com.bmc.ctmconvert.dollar_universe.assessmentreport.DUAssessmentReportReplier;
import com.bmc.ctmconvert.dollar_universe.assessmentreport.TasksDescriptionGetter;
import com.bmc.ctmconvert.dollar_universe.assessmentreport.UPROC_ENTITIES;
import com.bmc.ctmconvert.dollar_universe.assessmentreport.UprocExtension;
import com.bmc.ctmconvert.dollar_universe.utils.DollarUniverseUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import javax.swing.tree.DefaultMutableTreeNode;

public class DollarUniverseAssessmentReport
extends AbstractAssessmentReport {
    private final String tasksTitle = "Tasks";
    private final String muTitle = "Management Units";
    private final String muDefinedTitle = "Management Units - Defined";
    private final String muNotInUseTitle = "Management Units - Not In Use";
    private final String sessionTitle = "Sessions";
    private final String uprocsTitle = "UPROCs";
    private final String uprocsDefinedTitle = "UPROCs - Defined";
    private final String uprocsInUseTitle = "UPROCs- With Task";
    private final String uprocsNotInUseTitle = "UPROCs - Without Task";
    private final String FTPJobsTitle = "FTP";
    private final String calendarsTitle = "Calendars";
    private final String rulesTitle = "Rules";
    private final String resourcesTitle = "Resources";
    private final String agents = "Agents";
    private final String muInUseTitle = "Management Units - In Use";
    private HashMap<String, String> m_NodeName_EntityCount = null;
    private Map<String, Integer> Type2CounterUprs;
    private AssessmentXMLDescriptionReader m_DescriptionXMLReader = null;
    private Map<String, String> m_nodeName_nodeDescription;
    private Map<String, String> resourceName2resourceDescription;
    private Map<String, String> ruleName2ruleDescription;
    private Map<String, String> muName2muDescription;
    private Map<String, String> sessionName2sessionDescription;
    private Map<String, String> taskName2taskDescription;
    private Map<String, String> taskUprName2taskUprDescription;
    private Map<String, String> taskSessionName2taskSessionDescription;
    private Map<String, String> calendarName2calendarDescription;
    private final String NATitle = "N/A";
    private DUAssessmentReportReplier replier = new DUAssessmentReportReplier();
    private Map<String, String> uprName2uprDescription;

    public DollarUniverseAssessmentReport(String pathName, String descriptionXMLFileName, String optionalFile) {
        super(pathName, descriptionXMLFileName, optionalFile);
    }

    protected void initSourceData(String pathName, String descriptionXMLFileName, String optionalFile) {
        this.replier.initSourceData(pathName, descriptionXMLFileName, optionalFile);
        this.m_NodeName_EntityCount = new HashMap();
        this.Type2CounterUprs = new HashMap<String, Integer>();
        this.m_DescriptionXMLReader = new AssessmentXMLDescriptionReader(descriptionXMLFileName, Params.instance().getVendorName());
        this.resourceName2resourceDescription = new HashMap<String, String>();
        this.ruleName2ruleDescription = new HashMap<String, String>();
        this.muName2muDescription = new HashMap<String, String>();
        this.sessionName2sessionDescription = new HashMap<String, String>();
        this.taskName2taskDescription = new HashMap<String, String>();
        this.taskUprName2taskUprDescription = new HashMap<String, String>();
        this.taskSessionName2taskSessionDescription = new HashMap<String, String>();
        this.calendarName2calendarDescription = new HashMap<String, String>();
        this.uprName2uprDescription = new HashMap<String, String>();
    }

    protected String getJobInfo(String messageID) {
        String[] messagePartArray = messageID.split(";");
        String message = null;
        String entityName = messagePartArray[messagePartArray.length - 1];
        if (messageID == null || messageID.isEmpty()) {
            return "";
        }
        if (messagePartArray[messagePartArray.length - 1].endsWith(")")) {
            entityName = entityName.substring(0, entityName.lastIndexOf("("));
        }
        if (this.replier.getEntityDescription().get(entityName) == null) {
            entityName = "N/A";
        }
        if (messagePartArray[1].contains("Resources")) {
            message = this.resourceName2resourceDescription.get(messagePartArray[2]);
        } else if (messagePartArray[1].contains("Rules")) {
            message = this.ruleName2ruleDescription.get(messagePartArray[2]);
        } else if (messagePartArray[1].contains("Management Units")) {
            if (messagePartArray.length > 3) {
                message = this.muName2muDescription.get(messagePartArray[3]);
            } else if (messagePartArray.length == 3) {
                message = this.m_nodeName_nodeDescription.get(entityName);
            }
        } else if (messagePartArray[1].contains("Sessions")) {
            message = this.sessionName2sessionDescription.get(messagePartArray[2]);
        } else if (messagePartArray[1].contains("Tasks")) {
            message = this.taskName2taskDescription.get(messagePartArray[2]);
        } else if (messagePartArray[1].contains("Calendars")) {
            message = this.calendarName2calendarDescription.get(messagePartArray[2]);
        } else if (messagePartArray[1].contains("UPROCs")) {
            if (messagePartArray.length > 5) {
                if (messagePartArray[4].contains(UPROC_ENTITIES.LAUNCHVAR.name())) {
                    message = this.replier.getUprExtDescription().get(messagePartArray[3]).getLaunchvarName2Description().get(messagePartArray[5]);
                } else if (messagePartArray[4].contains(UPROC_ENTITIES.DEPCON.name())) {
                    message = this.replier.getUprExtDescription().get(messagePartArray[3]).getDepconName2Description().get(messagePartArray[5]);
                } else if (messagePartArray[4].contains(UPROC_ENTITIES.RESCON.name())) {
                    message = this.replier.getUprExtDescription().get(messagePartArray[3]).getResconName2Description().get(messagePartArray[5]);
                } else if (messagePartArray[4].contains(UPROC_ENTITIES.INCON.name())) {
                    message = this.replier.getUprExtDescription().get(messagePartArray[3]).getInconName2Description().get(messagePartArray[5]);
                }
            } else {
                message = messagePartArray.length == 5 ? (messagePartArray[4].contains(UPROC_ENTITIES.LAUNCHVAR.name()) || messagePartArray[4].contains(UPROC_ENTITIES.DEPCON.name()) || messagePartArray[4].contains(UPROC_ENTITIES.RESCON.name()) || messagePartArray[4].contains(UPROC_ENTITIES.INCON.name()) ? this.replier.getEntityDescription().get(entityName) : this.replier.getUprExtDescription().get(messagePartArray[3]).getUprocAttributesName2Description().get(messagePartArray[4])) : (messagePartArray.length < 4 ? this.m_nodeName_nodeDescription.get(entityName) : this.replier.getUprName2uprDescriptionCsvData().get(messagePartArray[3]));
            }
        } else if (messagePartArray[1].contains("FTP")) {
            if (messagePartArray.length > 4) {
                if (messagePartArray[3].contains(UPROC_ENTITIES.LAUNCHVAR.name())) {
                    message = this.replier.getUprExtDescription().get(messagePartArray[2]).getLaunchvarName2Description().get(messagePartArray[4]);
                } else if (messagePartArray[3].contains(UPROC_ENTITIES.DEPCON.name())) {
                    message = this.replier.getUprExtDescription().get(messagePartArray[2]).getDepconName2Description().get(messagePartArray[4]);
                } else if (messagePartArray[3].contains(UPROC_ENTITIES.RESCON.name())) {
                    message = this.replier.getUprExtDescription().get(messagePartArray[2]).getResconName2Description().get(messagePartArray[4]);
                } else if (messagePartArray[3].contains(UPROC_ENTITIES.INCON.name())) {
                    message = this.replier.getUprExtDescription().get(messagePartArray[2]).getInconName2Description().get(messagePartArray[4]);
                }
            } else {
                message = messagePartArray.length == 4 ? (messagePartArray[3].contains(UPROC_ENTITIES.LAUNCHVAR.name()) || messagePartArray[3].contains(UPROC_ENTITIES.DEPCON.name()) || messagePartArray[3].contains(UPROC_ENTITIES.RESCON.name()) || messagePartArray[3].contains(UPROC_ENTITIES.INCON.name()) ? this.replier.getEntityDescription().get(entityName) : this.replier.getUprExtDescription().get(messagePartArray[2]).getUprocAttributesName2Description().get(messagePartArray[3])) : (messagePartArray.length < 3 ? this.m_nodeName_nodeDescription.get(entityName) : this.replier.getUprName2uprDescriptionCsvData().get(messagePartArray[2]));
            }
        } else {
            message = this.m_nodeName_nodeDescription.get(entityName);
        }
        return message;
    }

    public Map<String, String> getNodeName2Description() {
        return this.m_DescriptionXMLReader.getNodeNameNodeDescriptionMap();
    }

    protected DefaultMutableTreeNode getDefaultTreeModel() {
        String[] keys;
        DefaultMutableTreeNode mainTreeNodes = new DefaultMutableTreeNode(Params.instance().getDatasourceName());
        DefaultMutableTreeNode mainTasksNodes = new DefaultMutableTreeNode("Tasks");
        DefaultMutableTreeNode mainMUNodes = null;
        DefaultMutableTreeNode mainSessionNodes = null;
        DefaultMutableTreeNode mainSplitUprocsNodes = null;
        DefaultMutableTreeNode mainFTPJobsNodes = new DefaultMutableTreeNode("FTP");
        DefaultMutableTreeNode mainCalendarsNodes = null;
        DefaultMutableTreeNode mainRulesNodes = null;
        DefaultMutableTreeNode mainResourcesNodes = null;
        DefaultMutableTreeNode definedNodes = null;
        DefaultMutableTreeNode inUseNodes = new DefaultMutableTreeNode();
        DefaultMutableTreeNode notInNodes = null;
        this.resourceName2resourceDescription = this.replier.getResourceName2resourceDescriptionCsvData();
        this.ruleName2ruleDescription = this.replier.getRuleName2ruleDescriptionCsvData();
        this.muName2muDescription = this.replier.getMuName2muDescriptionCsvData();
        this.replier.loadTasksFromCSV();
        TasksDescriptionGetter taskDescriptionGetter = new TasksDescriptionGetter();
        this.taskUprName2taskUprDescription = taskDescriptionGetter.getDescription(this.replier.getTaskUprName2taskUprAttributes(), ASSESSMENT_SOURCE_INPUT_TYPE.TASK_UPR);
        this.taskSessionName2taskSessionDescription = taskDescriptionGetter.getDescription(this.replier.getTaskSessionName2taskSessionAttributes(), ASSESSMENT_SOURCE_INPUT_TYPE.TASK_SESSION);
        this.taskName2taskDescription.putAll(this.taskUprName2taskUprDescription);
        this.taskName2taskDescription.putAll(this.taskSessionName2taskSessionDescription);
        this.sessionName2sessionDescription = this.replier.getSessionData();
        this.calendarName2calendarDescription = this.replier.getCalendarData();
        this.replier.loadUprExtraDataFromCsv();
        this.uprName2uprDescription = this.replier.getUprName2uprDescriptionCsvData();
        Map<String, String> resource = this.resourceName2resourceDescription;
        if (!resource.isEmpty()) {
            mainResourcesNodes = new DefaultMutableTreeNode("Resources(" + resource.size() + ")");
            keys = resource.keySet().toArray(new String[0]);
            Arrays.sort(keys, new InternalNumberComparator(this));
            for (String resourceName : keys) {
                mainResourcesNodes.add(new DefaultMutableTreeNode(resourceName));
            }
        }
        if (!this.ruleName2ruleDescription.isEmpty()) {
            mainRulesNodes = new DefaultMutableTreeNode("Rules(" + this.ruleName2ruleDescription.size() + ")");
            keys = this.ruleName2ruleDescription.keySet().toArray(new String[0]);
            Arrays.sort(keys, new InternalNumberComparator(this));
            for (String ruleName : keys) {
                mainRulesNodes.add(new DefaultMutableTreeNode(ruleName));
            }
        }
        if (!this.taskName2taskDescription.isEmpty()) {
            mainTasksNodes = new DefaultMutableTreeNode("Tasks(" + this.taskName2taskDescription.size() + ")");
            keys = this.taskName2taskDescription.keySet().toArray(new String[0]);
            Arrays.sort(keys, new InternalNumberComparator(this));
            for (String taskName : keys) {
                mainTasksNodes.add(new DefaultMutableTreeNode(taskName));
            }
        }
        if (!this.sessionName2sessionDescription.isEmpty()) {
            mainSessionNodes = new DefaultMutableTreeNode("Sessions(" + this.sessionName2sessionDescription.size() + ")");
            keys = this.sessionName2sessionDescription.keySet().toArray(new String[0]);
            Arrays.sort(keys, new InternalNumberComparator(this));
            for (String sessionName : keys) {
                mainSessionNodes.add(new DefaultMutableTreeNode(sessionName));
            }
        }
        if (!this.calendarName2calendarDescription.isEmpty()) {
            mainCalendarsNodes = new DefaultMutableTreeNode("Calendars(" + this.calendarName2calendarDescription.size() + ")");
            keys = this.calendarName2calendarDescription.keySet().toArray(new String[0]);
            Arrays.sort(keys, new InternalNumberComparator(this));
            for (String calendarName : keys) {
                mainCalendarsNodes.add(new DefaultMutableTreeNode(calendarName));
            }
        }
        this.replier.loadDataToUsageMap();
        if (!this.muName2muDescription.isEmpty()) {
            Set<String> inUseMu = this.replier.getInUseMu();
            mainMUNodes = new DefaultMutableTreeNode("Management Units(" + this.muName2muDescription.size() + ")");
            definedNodes = new DefaultMutableTreeNode("Management Units - Defined(" + this.muName2muDescription.size() + ")");
            notInNodes = new DefaultMutableTreeNode("Management Units - Not In Use");
            keys = this.muName2muDescription.keySet().toArray(new String[0]);
            Arrays.sort(keys, new InternalNumberComparator(this));
            for (String muName : keys) {
                definedNodes.add(new DefaultMutableTreeNode(muName));
                if (inUseMu.contains(muName)) {
                    inUseNodes.add(new DefaultMutableTreeNode(muName));
                    continue;
                }
                notInNodes.add(new DefaultMutableTreeNode(muName));
            }
            inUseNodes.setUserObject("Management Units - In Use(" + inUseNodes.getChildCount() + ")");
            notInNodes.setUserObject("Management Units - Not In Use(" + notInNodes.getChildCount() + ")");
            this.m_NodeName_EntityCount.put("Management Units - Not In Use", Integer.toString(notInNodes.getChildCount()));
            this.m_NodeName_EntityCount.put("Agents", Integer.toString(inUseNodes.getChildCount()));
            if (definedNodes != null && definedNodes.getChildCount() > 0) {
                mainMUNodes.add(definedNodes);
            }
            if (inUseNodes != null && inUseNodes.getChildCount() > 0) {
                mainMUNodes.add(inUseNodes);
            }
            if (notInNodes != null && notInNodes.getChildCount() > 0) {
                mainMUNodes.add(notInNodes);
            }
        }
        mainSplitUprocsNodes = this.addUprocsToTree(mainSplitUprocsNodes, mainFTPJobsNodes);
        this.putTitlesForNodes(mainFTPJobsNodes, inUseNodes);
        this.m_nodeName_nodeDescription = this.getNodeName2Description();
        if (mainTasksNodes != null && mainTasksNodes.getChildCount() > 0) {
            mainTreeNodes.add(mainTasksNodes);
        }
        if (mainSessionNodes != null && mainSessionNodes.getChildCount() > 0) {
            mainTreeNodes.add(mainSessionNodes);
        }
        if (mainSplitUprocsNodes != null && mainSplitUprocsNodes.getChildCount() > 0) {
            mainTreeNodes.add(mainSplitUprocsNodes);
        }
        if (mainFTPJobsNodes != null && mainFTPJobsNodes.getChildCount() > 0) {
            mainTreeNodes.add(mainFTPJobsNodes);
        }
        if (mainMUNodes != null && mainMUNodes.getChildCount() > 0) {
            mainTreeNodes.add(mainMUNodes);
        }
        if (mainResourcesNodes != null && mainResourcesNodes.getChildCount() > 0) {
            mainTreeNodes.add(mainResourcesNodes);
        }
        if (mainRulesNodes != null && mainRulesNodes.getChildCount() > 0) {
            mainTreeNodes.add(mainRulesNodes);
        }
        if (mainCalendarsNodes != null && mainCalendarsNodes.getChildCount() > 0) {
            mainTreeNodes.add(mainCalendarsNodes);
        }
        return mainTreeNodes;
    }

    private void putTitlesForNodes(DefaultMutableTreeNode mainFTPJobsNodes, DefaultMutableTreeNode inUseNodes) {
        this.m_NodeName_EntityCount.put("Tasks", Integer.toString(this.taskName2taskDescription.size()));
        this.m_NodeName_EntityCount.put("Sessions", Integer.toString(this.sessionName2sessionDescription.size()));
        this.m_NodeName_EntityCount.put("UPROCs", Integer.toString(this.uprName2uprDescription.size()));
        this.m_NodeName_EntityCount.put("UPROCs - Defined", Integer.toString(this.uprName2uprDescription.size()));
        Set<String> inUseUprocs = this.replier.getInUseUprocs();
        this.m_NodeName_EntityCount.put("UPROCs- With Task", Integer.toString(inUseUprocs.size()));
        this.m_NodeName_EntityCount.put("FTP", Integer.toString(mainFTPJobsNodes.getChildCount()));
        this.m_NodeName_EntityCount.put("Management Units", Integer.toString(this.muName2muDescription.size()));
        this.m_NodeName_EntityCount.put("Management Units - Defined", Integer.toString(this.muName2muDescription.size()));
        this.m_NodeName_EntityCount.put("Management Units - In Use", Integer.toString(inUseNodes.getChildCount()));
        this.m_NodeName_EntityCount.put("Calendars", Integer.toString(this.calendarName2calendarDescription.size()));
        this.m_NodeName_EntityCount.put("Rules", Integer.toString(this.ruleName2ruleDescription.size()));
        this.m_NodeName_EntityCount.put("Resources", Integer.toString(this.resourceName2resourceDescription.size()));
    }

    private DefaultMutableTreeNode addUprocsToTree(DefaultMutableTreeNode mainSplitUprocsNodes, DefaultMutableTreeNode mainFTPJobsNodes) {
        if (!this.uprName2uprDescription.isEmpty()) {
            mainSplitUprocsNodes = new DefaultMutableTreeNode("UPROCs(" + this.uprName2uprDescription.size() + ")");
            DefaultMutableTreeNode definedUprocTree = new DefaultMutableTreeNode("UPROCs - Defined(" + this.uprName2uprDescription.size() + ")");
            Set<String> inUseUprocs = this.replier.getInUseUprocs();
            DefaultMutableTreeNode inUseUprocTree = new DefaultMutableTreeNode("UPROCs- With Task(" + inUseUprocs.size() + ")");
            DefaultMutableTreeNode notInUseUprocTree = new DefaultMutableTreeNode("UPROCs - Without Task");
            boolean FTPFlag = false;
            this.updateUptTypeCounter();
            String[] keys = this.uprName2uprDescription.keySet().toArray(new String[0]);
            Arrays.sort(keys, new DUAssessmentReportReplier.UprocsComparator(this.replier));
            for (String uprName : keys) {
                DefaultMutableTreeNode currUprTree = new DefaultMutableTreeNode(uprName);
                DefaultMutableTreeNode currDefinedUprTree = new DefaultMutableTreeNode(uprName);
                DefaultMutableTreeNode tmpFTPUprTree = new DefaultMutableTreeNode(uprName);
                UprocExtension currUproc = this.replier.getUprExtDescription().get(uprName);
                if (currUproc == null) {
                    currUproc = new UprocExtension();
                }
                for (UPROC_ENTITIES entity : UPROC_ENTITIES.values()) {
                    Map<String, String> tmpHash = currUproc.getUprocEntitiesHash(entity);
                    if (tmpHash.isEmpty()) continue;
                    DefaultMutableTreeNode tmpTree = new DefaultMutableTreeNode(currUproc.getUprocEntitiesName(entity) + "(" + tmpHash.size() + ")");
                    DefaultMutableTreeNode tmpDefinedTree = new DefaultMutableTreeNode(currUproc.getUprocEntitiesName(entity) + "(" + tmpHash.size() + ")");
                    DefaultMutableTreeNode tmpFTPTree = new DefaultMutableTreeNode(currUproc.getUprocEntitiesName(entity) + "(" + tmpHash.size() + ")");
                    keys = tmpHash.keySet().toArray(new String[0]);
                    Arrays.sort(keys, new InternalNumberComparator(this));
                    for (String name : keys) {
                        if (entity.equals((Object)UPROC_ENTITIES.ATTRIBUTES)) {
                            if (name.equalsIgnoreCase("ftp_get") || name.equalsIgnoreCase("ftp_put")) {
                                FTPFlag = true;
                            }
                            currUprTree.add(new DefaultMutableTreeNode(name));
                            currDefinedUprTree.add(new DefaultMutableTreeNode(name));
                            tmpFTPUprTree.add(new DefaultMutableTreeNode(name));
                            continue;
                        }
                        tmpTree.add(new DefaultMutableTreeNode(name));
                        tmpDefinedTree.add(new DefaultMutableTreeNode(name));
                        tmpFTPTree.add(new DefaultMutableTreeNode(name));
                    }
                    if (entity.equals((Object)UPROC_ENTITIES.ATTRIBUTES)) continue;
                    currUprTree.add(tmpTree);
                    currDefinedUprTree.add(tmpDefinedTree);
                    tmpFTPUprTree.add(tmpFTPTree);
                }
                definedUprocTree.add(currDefinedUprTree);
                if (FTPFlag) {
                    mainFTPJobsNodes.add(tmpFTPUprTree);
                    FTPFlag = false;
                }
                if (inUseUprocs.contains(uprName)) {
                    inUseUprocTree.add(currUprTree);
                    continue;
                }
                notInUseUprocTree.add(currUprTree);
            }
            if (definedUprocTree != null && definedUprocTree.getChildCount() > 0) {
                mainSplitUprocsNodes.add(definedUprocTree);
            }
            if (inUseUprocTree != null && inUseUprocTree.getChildCount() > 0) {
                mainSplitUprocsNodes.add(inUseUprocTree);
            }
            if (notInUseUprocTree != null && notInUseUprocTree.getChildCount() > 0) {
                mainSplitUprocsNodes.add(notInUseUprocTree);
            }
            mainFTPJobsNodes.setUserObject("FTP(" + mainFTPJobsNodes.getChildCount() + ")");
            inUseUprocTree.setUserObject("UPROCs- With Task(" + inUseUprocTree.getChildCount() + ")");
            notInUseUprocTree.setUserObject("UPROCs - Without Task(" + notInUseUprocTree.getChildCount() + ")");
            this.m_NodeName_EntityCount.put("UPROCs - Without Task", Integer.toString(notInUseUprocTree.getChildCount()));
        }
        return mainSplitUprocsNodes;
    }

    private void updateUptTypeCounter() {
        Collection<String> values = this.replier.getUprName2uprDescriptionCsvData().values();
        for (String uprDescription : values) {
            if (!uprDescription.contains("upt")) continue;
            this.DUtypesToCTMtypes(uprDescription);
        }
    }

    private void DUtypesToCTMtypes(String uptType) {
        if (uptType.contains("CL_INT")) {
            this.incCounter2UptTypeMap("CL_INT:          #NUM#  UPROCs. These UPROCs  will be converted to Control-M OS Jobs");
            return;
        }
        if (uptType.contains("AFT")) {
            this.incCounter2UptTypeMap("AFT:                    #NUM#  UPROCs. These UPROCs  will be converted to Control-M File Transfer");
            return;
        }
        if (uptType.contains("SAP_XBP2")) {
            this.incCounter2UptTypeMap("SAP_XBP2:     #NUM#  UPROCs. These UPROCs  will be converted to Control-M SAP R3 Jobs");
            return;
        }
        if (uptType.contains("CL_EXT")) {
            this.incCounter2UptTypeMap("CL_EXT:          #NUM#  UPROCs. These UPROCs  will be converted to Control-M OS Jobs");
            return;
        }
        if (uptType.contains("SAP_PCHAIN")) {
            this.incCounter2UptTypeMap("SAP_PCHAIN: #NUM#  UPROCs. These UPROCs  will be converted to Control-M SAP Business Warehouse Jobs");
            return;
        }
        if (uptType.contains("SAP_IPACK")) {
            this.incCounter2UptTypeMap("SAP_IPACK:  #NUM#  UPROCs. These UPROCs  will be converted to Control-M SAP BW Infopackage Jobs");
            return;
        }
        this.incCounter2UptTypeMap("NO UPT Type: #NUM#  UPROCs. These UPROCs  will be converted to Control-M Dummy Jobs");
    }

    private void incCounter2UptTypeMap(String key) {
        Integer counter = 1;
        if (this.Type2CounterUprs.containsKey(key)) {
            Integer n = counter = this.Type2CounterUprs.get(key);
            counter = counter + 1;
        }
        this.Type2CounterUprs.put(key, counter);
    }

    protected ArrayList<String> getDescriptionTypeLookNodes() {
        ArrayList<String> result = new ArrayList<String>();
        result.add(Params.instance().getDatasourceName());
        result.add("Resources");
        result.add("Rules");
        result.add("Management Units");
        result.add("UPROCs");
        result.add("FTP");
        result.add("Sessions");
        result.add("Tasks");
        result.add("Calendars");
        return result;
    }

    protected ArrayList<String> getDescriptionTypeSplitLookNodes() {
        return null;
    }

    protected ArrayList<String> getSelectionList(String parentNodeID) {
        return null;
    }

    protected String getJobInfoFromSelectionList(String messageID) {
        return null;
    }

    protected HashMap<String, String> getDescriptionNodes() {
        String sMainSummary;
        LinkedHashMap descriptionMap_NodeName_NodeDesc = this.m_DescriptionXMLReader.getNodeNameNodeDescriptionMap();
        StringBuilder mainSummary = new StringBuilder();
        mainSummary.append("Dollar Universe input data analysis:\r\n");
        mainSummary.append("----------------------------------------------");
        String extraSummary = null;
        for (String nodeName : descriptionMap_NodeName_NodeDesc.keySet()) {
            if (this.m_DescriptionXMLReader.isAutoBuildMainSummary() && nodeName.compareToIgnoreCase("MainSummary") != 0) {
                if (nodeName.compareToIgnoreCase("ExtraSummary") == 0) {
                    extraSummary = (String)descriptionMap_NodeName_NodeDesc.get(nodeName);
                } else {
                    String numS = this.m_NodeName_EntityCount.get(nodeName);
                    if (numS != null && Integer.parseInt(numS) != 0) {
                        if (!nodeName.equals("UPROCs- With Task") && !nodeName.equals("UPROCs - Without Task")) {
                            if (!nodeName.equals("UPROCs") && !nodeName.equals("Sessions")) {
                                mainSummary.append(nodeName);
                            }
                            mainSummary.append(this.m_newline);
                        }
                        if (nodeName.equals("Sessions")) {
                            this.addingNotesAndDistribution(mainSummary);
                            mainSummary.append(nodeName);
                            mainSummary.append(this.m_newline);
                        }
                        mainSummary.append(this.evaluateDescriptionParameters(nodeName, (String)descriptionMap_NodeName_NodeDesc.get(nodeName)));
                    }
                }
            }
            if (nodeName.equals("UPROCs - Without Task")) {
                descriptionMap_NodeName_NodeDesc.put(nodeName, this.evaluateDescriptionParameters(nodeName, this.listNotInUsed()));
                continue;
            }
            descriptionMap_NodeName_NodeDesc.put(nodeName, this.evaluateDescriptionParameters(nodeName, (String)descriptionMap_NodeName_NodeDesc.get(nodeName)));
        }
        if (null != extraSummary) {
            mainSummary.append("ExtraSummary");
            mainSummary.append(this.m_newline);
            mainSummary.append(this.evaluateDescriptionParameters("ExtraSummary", extraSummary));
            mainSummary.append(this.m_newline);
            mainSummary.append(this.m_newline);
        }
        if (!this.m_DescriptionXMLReader.isAutoBuildMainSummary() && null != (sMainSummary = (String)descriptionMap_NodeName_NodeDesc.get("MainSummary"))) {
            mainSummary.append(sMainSummary);
            String sExtraSummary = (String)descriptionMap_NodeName_NodeDesc.get("ExtraSummary");
            if (null != sExtraSummary) {
                mainSummary.append(this.m_newline);
                mainSummary.append(this.m_newline);
                mainSummary.append("ExtraSummary");
                mainSummary.append(this.m_newline);
                mainSummary.append(this.evaluateDescriptionParameters("ExtraSummary", sExtraSummary));
                mainSummary.append(this.m_newline);
            }
        }
        descriptionMap_NodeName_NodeDesc.put(Params.instance().getDatasourceName(), mainSummary.toString());
        return descriptionMap_NodeName_NodeDesc;
    }

    private void addingNotesAndDistribution(StringBuilder mainSummary) {
        mainSummary.append(this.m_newline);
        mainSummary.append(this.getNote(1));
        mainSummary.append(this.m_newline);
        mainSummary.append(this.m_newline);
        mainSummary.append(this.m_newline);
        mainSummary.append("UPROCs type distribution:");
        mainSummary.append(this.m_newline);
        mainSummary.append("----------------------------------------");
        mainSummary.append(this.m_newline);
        mainSummary.append(this.getDistribution());
        mainSummary.append(this.getNote(2));
        mainSummary.append(this.m_newline);
        mainSummary.append(this.m_newline);
        mainSummary.append(this.m_newline);
    }

    private String getNote(int numNote) {
        if (numNote == 1) {
            return "Note:\r\nBy default UPROCs without scheduling (reference from a Task) are not being converted, \r\nThe reason that they are not being converted by default is that many times they are scheduled from another DU Node or they are just unnecessary UPROCs.\r\nIf you do want to convert those UPROCs, you can update the Conversion Settings under \u201cAdditional Dollar Universe rules\u201d tab.";
        }
        if (numNote == 2) {
            return "Note: \r\nThe number of Control-M jobs that will be created after conversion can be larger than the number of  Dollar universe UPROCs found in the input data,\r\nas in Control-M we create a job for each Dollar universe UPROC instance. ";
        }
        return "";
    }

    private String evaluateDescriptionParameters(String sNodeName, String sDescription) {
        if (!sDescription.contains("#")) {
            return sDescription;
        }
        String sNum = null;
        sNum = this.m_NodeName_EntityCount.get(sNodeName);
        if (null == sNum) {
            sNum = "0";
        }
        if ((sDescription = sDescription.replaceAll("#NUM_ENTITIES#", sNum)).contains("#NUM_LOW_USED_MACHINES_LIST#")) {
            StringBuilder machinesList = new StringBuilder();
            for (String machine : this.replier.getMuUsage().keySet()) {
                if (this.replier.getMuUsage().get(machine) > 25) continue;
                ++this.lowMachinesUseCount;
                machinesList.append(machine);
                machinesList.append(this.m_newline);
            }
            machinesList.append(this.m_newline);
            machinesList.append(this.m_newline);
            sDescription = sDescription.replaceAll("#NUM_LOW_USED_MACHINES_LIST#", machinesList.toString());
        }
        sDescription = sDescription.replaceAll("#NUM_LOW_USED_MACHINES#", Integer.toString(this.lowMachinesUseCount));
        return sDescription;
    }

    private String listNotInUsed() {
        StringBuilder uprocList = new StringBuilder();
        uprocList.append("Number of UPROCs Not In Use is: " + this.replier.getNotInUseUprocList().size());
        uprocList.append(this.m_newline);
        uprocList.append("++++++++++++++++++++++++++++");
        uprocList.append(this.m_newline);
        for (String uproc : this.replier.getNotInUseUprocList()) {
            uprocList.append(uproc);
            uprocList.append(this.m_newline);
        }
        return uprocList.toString();
    }

    public <K, V extends Comparable<? super V>> Map<K, V> sortByValue(Map<K, V> map) {
        LinkedList<Map.Entry<K, V>> list = new LinkedList<Map.Entry<K, V>>(map.entrySet());
        Collections.sort(list, new Comparator<Map.Entry<K, V>>(this){

            @Override
            public int compare(Map.Entry<K, V> e1, Map.Entry<K, V> e2) {
                return ((Comparable)e2.getValue()).compareTo(e1.getValue());
            }
        });
        LinkedHashMap result = new LinkedHashMap();
        for (Map.Entry entry : list) {
            result.put(entry.getKey(), (Comparable)entry.getValue());
        }
        return result;
    }

    private String getDistribution() {
        StringBuilder distribution = new StringBuilder();
        this.Type2CounterUprs = (HashMap)this.sortByValue(this.Type2CounterUprs);
        for (Map.Entry<String, Integer> entry : this.Type2CounterUprs.entrySet()) {
            String description = entry.getKey();
            Integer counter = entry.getValue();
            String spaces = this.countSpaces(counter);
            String sDescription = description.replaceAll("#NUM#", spaces + Integer.toString(counter));
            distribution.append(sDescription);
            distribution.append(this.m_newline);
            distribution.append(this.m_newline);
        }
        return distribution.toString();
    }

    private String countSpaces(Integer counter) {
        if (counter < 10) {
            return "        ";
        }
        if (counter < 100) {
            return "      ";
        }
        if (counter < 1000) {
            return "    ";
        }
        return "";
    }

    public class InternalNumberComparator
    implements Comparator<Object> {
        public InternalNumberComparator(DollarUniverseAssessmentReport this$0) {
        }

        @Override
        public int compare(Object o1, Object o2) {
            return DollarUniverseUtils.compareContainNumber(o1, o2);
        }
    }
}

