/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.dollar_universe.assessmentreport;

import com.bmc.ctmconvert.common.ExceptionHandler;
import com.bmc.ctmconvert.dollar_universe.assessmentreport.ASSESSMENT_SOURCE_INPUT_TYPE;
import com.bmc.ctmconvert.dollar_universe.assessmentreport.DescriptionGetter;
import com.bmc.ctmconvert.dollar_universe.assessmentreport.VendorEntities;
import com.bmc.ctmconvert.io.csv.CsvReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;

public class DataReader {
    public Map<String, String> read(VendorEntities vEntities, InputStream fileInput) {
        HashMap<String, String> toRet = new HashMap<String, String>();
        ASSESSMENT_SOURCE_INPUT_TYPE type = vEntities.type;
        String entityNAme = vEntities.name;
        InputStreamReader reader = new InputStreamReader(fileInput);
        try (CsvReader csvReader = new CsvReader((Reader)reader);){
            csvReader.readHeaders();
            DescriptionGetter descriptionGetter = new DescriptionGetter();
            while (csvReader.readRecord()) {
                String name = csvReader.get(entityNAme);
                if (name == null || name.isEmpty()) continue;
                StringBuilder description = new StringBuilder();
                for (int i = 0; i < csvReader.getHeaderCount(); ++i) {
                    String param = csvReader.get(i);
                    if (param == null || param.isEmpty()) continue;
                    description.append(descriptionGetter.getDescriptionLine(type, csvReader.getHeader(i), param));
                }
                if (toRet.get(name) != null) continue;
                toRet.put(name, description.toString());
            }
        }
        catch (FileNotFoundException e) {
            ExceptionHandler.writeToExceptionFile((Exception)e);
        }
        catch (IOException e) {
            ExceptionHandler.writeToExceptionFile((Exception)e);
        }
        return toRet;
    }
}

