/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.dollar_universe.assessmentreport;

import com.bmc.ctmconvert.common.ExceptionHandler;
import com.bmc.ctmconvert.common.Params;
import com.bmc.ctmconvert.dollar_universe.DollarUniverseSessionAttributes;
import com.bmc.ctmconvert.dollar_universe.DollarUniverseTaskAttributes;
import com.bmc.ctmconvert.dollar_universe.SessionTable;
import com.bmc.ctmconvert.dollar_universe.TaskDetailsCollector;
import com.bmc.ctmconvert.dollar_universe.TaskTable;
import com.bmc.ctmconvert.dollar_universe.assessmentreport.ASSESSMENT_SOURCE_INPUT_TYPE;
import com.bmc.ctmconvert.dollar_universe.assessmentreport.DataReader;
import com.bmc.ctmconvert.dollar_universe.assessmentreport.DescriptionGetter;
import com.bmc.ctmconvert.dollar_universe.assessmentreport.UPROC_ENTITIES;
import com.bmc.ctmconvert.dollar_universe.assessmentreport.UprocExtension;
import com.bmc.ctmconvert.dollar_universe.assessmentreport.VendorEntities;
import com.bmc.ctmconvert.dollar_universe.handlers.SessionUprocsUsageHandler;
import com.bmc.ctmconvert.dollar_universe.utils.DollarUniverseUtils;
import com.bmc.ctmconvert.io.csv.CsvReader;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class DUAssessmentReportReplier {
    private Map<ASSESSMENT_SOURCE_INPUT_TYPE, VendorEntities> vendorEntities;
    private Map<String, DollarUniverseTaskAttributes> taskUprName2taskUprAttributes;
    private Map<String, String> uprName2uprDescription;
    private Map<String, DollarUniverseTaskAttributes> taskSessionName2taskSessionAttributes;
    private Map<String, UprocExtension> uprExtDescription;
    private DescriptionGetter descriptionGetter;
    private HashMap<String, String> entityDescription;
    private List<String> notInUseUprocList;
    private Set<String> inUseSessions;
    private Set<String> inUseMu;
    private Set<String> inUseUprocs;
    private Map<String, Integer> muUsage;
    private final String muInUseTitle = "Management Units - In Use";
    private final String muNotInUseTitle = "Management Units - Not In Use";
    private final String uprocsDefinedTitle = "UPROCs - Defined";
    private final String uprocsInUseTitle = "UPROCs- With Task";
    private final String uprocsNotInUseTitle = "UPROCs - Without Task";
    private final String FTPJobsTitle = "FTP";
    private final String NATitle = "N/A";

    public void initSourceData(String pathName, String descriptionXMLFileName, String optionalFile) {
        this.entityDescription = new HashMap();
        this.notInUseUprocList = new ArrayList<String>();
        this.uprName2uprDescription = new HashMap<String, String>();
        this.uprExtDescription = new HashMap<String, UprocExtension>();
        this.descriptionGetter = new DescriptionGetter();
        this.inUseSessions = new HashSet<String>();
        this.inUseMu = new HashSet<String>();
        this.muUsage = new HashMap<String, Integer>();
        this.initVendorEntities();
    }

    private void initVendorEntities() {
        this.vendorEntities = new HashMap<ASSESSMENT_SOURCE_INPUT_TYPE, VendorEntities>();
        this.vendorEntities.put(ASSESSMENT_SOURCE_INPUT_TYPE.RESOURCES, new VendorEntities(ASSESSMENT_SOURCE_INPUT_TYPE.RESOURCES, "Resources.csv", "RES"));
        this.vendorEntities.put(ASSESSMENT_SOURCE_INPUT_TYPE.RULES, new VendorEntities(ASSESSMENT_SOURCE_INPUT_TYPE.RULES, "Rules.csv", "RUL"));
        this.vendorEntities.put(ASSESSMENT_SOURCE_INPUT_TYPE.MU_DETAILS, new VendorEntities(ASSESSMENT_SOURCE_INPUT_TYPE.MU_DETAILS, "mu.csv", "mu"));
        this.vendorEntities.put(ASSESSMENT_SOURCE_INPUT_TYPE.UPR, new VendorEntities(ASSESSMENT_SOURCE_INPUT_TYPE.UPR, "UPR.csv", "upr"));
        this.vendorEntities.put(ASSESSMENT_SOURCE_INPUT_TYPE.UPR_EXTENSION, new VendorEntities(ASSESSMENT_SOURCE_INPUT_TYPE.UPR_EXTENSION, "UPR_EXTENSION.csv", "PARENT_UPR"));
        this.vendorEntities.put(ASSESSMENT_SOURCE_INPUT_TYPE.SESSION_DETAILS, new VendorEntities(ASSESSMENT_SOURCE_INPUT_TYPE.SESSION_DETAILS, "session.csv", "ses"));
        this.vendorEntities.put(ASSESSMENT_SOURCE_INPUT_TYPE.TASK_UPR, new VendorEntities(ASSESSMENT_SOURCE_INPUT_TYPE.TASK_UPR, "task_upr.csv", "ID"));
        this.vendorEntities.put(ASSESSMENT_SOURCE_INPUT_TYPE.TASK_SESSION, new VendorEntities(ASSESSMENT_SOURCE_INPUT_TYPE.TASK_SESSION, "task_session.csv", "ID"));
        this.entityDescription.put(UPROC_ENTITIES.LAUNCHVAR.name(), UPROC_ENTITIES.LAUNCHVAR.name());
        this.entityDescription.put(UPROC_ENTITIES.RESCON.name(), UPROC_ENTITIES.RESCON.name());
        this.entityDescription.put(UPROC_ENTITIES.DEPCON.name(), UPROC_ENTITIES.DEPCON.name());
        this.entityDescription.put(UPROC_ENTITIES.INCON.name(), UPROC_ENTITIES.INCON.name());
        this.entityDescription.put("Management Units - In Use", "Management Units - In Use");
        this.entityDescription.put("Management Units - Not In Use", "Management Units - Not In Use");
        this.entityDescription.put("UPROCs - Defined", "UPROCs - Defined");
        this.entityDescription.put("UPROCs- With Task", "UPROCs- With Task");
        this.entityDescription.put("UPROCs - Without Task", "UPROCs - Without Task");
        this.entityDescription.put("FTP", "FTP");
        this.entityDescription.put("N/A", "N/A");
    }

    public Map<String, String> getResourceName2resourceDescriptionCsvData() {
        return this.getDataFromCsv(this.vendorEntities.get((Object)ASSESSMENT_SOURCE_INPUT_TYPE.RESOURCES));
    }

    public Map<String, String> getRuleName2ruleDescriptionCsvData() {
        return this.getDataFromCsv(this.vendorEntities.get((Object)ASSESSMENT_SOURCE_INPUT_TYPE.RULES));
    }

    public Map<String, String> getMuName2muDescriptionCsvData() {
        return this.getDataFromCsv(this.vendorEntities.get((Object)ASSESSMENT_SOURCE_INPUT_TYPE.MU_DETAILS));
    }

    public void loadUprExtraDataFromCsv() {
        this.getUprExtDataFromCsv(this.vendorEntities.get((Object)ASSESSMENT_SOURCE_INPUT_TYPE.UPR_EXTENSION));
    }

    public Map<String, String> getUprName2uprDescriptionCsvData() {
        return this.getDataFromCsv(this.vendorEntities.get((Object)ASSESSMENT_SOURCE_INPUT_TYPE.UPR));
    }

    public HashMap<String, String> getEntityDescription() {
        return this.entityDescription;
    }

    public Map<String, UprocExtension> getUprExtDescription() {
        return this.uprExtDescription;
    }

    public void loadTasksFromCSV() {
        FileInputStream sessionTasKsInputStream;
        FileInputStream uprTasKsInputStream;
        VendorEntities sessionTasks = this.vendorEntities.get((Object)ASSESSMENT_SOURCE_INPUT_TYPE.TASK_SESSION);
        VendorEntities uprTasks = this.vendorEntities.get((Object)ASSESSMENT_SOURCE_INPUT_TYPE.TASK_UPR);
        try {
            uprTasKsInputStream = new FileInputStream(uprTasks.fileName);
            sessionTasKsInputStream = new FileInputStream(sessionTasks.fileName);
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
        this.taskUprName2taskUprAttributes = this.loadTasksFromCSV(uprTasKsInputStream);
        this.taskSessionName2taskSessionAttributes = this.loadTasksFromCSV(sessionTasKsInputStream);
    }

    private Map<String, DollarUniverseTaskAttributes> loadTasksFromCSV(InputStream tasksInputStream) {
        HashMap<String, DollarUniverseTaskAttributes> taskAttributes = new HashMap<String, DollarUniverseTaskAttributes>();
        TaskTable taskuprocs = new TaskTable(taskAttributes);
        taskuprocs.load(tasksInputStream);
        return taskAttributes;
    }

    private Map<String, String> getDataFromCsv(VendorEntities vEntities) {
        DataReader dataReader = new DataReader();
        String fileName = vEntities.fileName;
        InputStream input = new ByteArrayInputStream("".toString().getBytes());
        try {
            input = new FileInputStream(fileName);
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
        return dataReader.read(vEntities, input);
    }

    private String getDescriptionLine(ASSESSMENT_SOURCE_INPUT_TYPE source, String fieldName, String value) {
        return this.descriptionGetter.getDescriptionLine(source, fieldName, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HashMap<String, String> getSessionData() {
        HashMap<String, String> toRet = new HashMap<String, String>();
        BufferedReader inputStream = null;
        InputStreamReader fileReader = null;
        try {
            String currLine;
            fileReader = new FileReader(new File(Params.instance().getDatasourcePath() + "SessionDetails.txt"));
            inputStream = new BufferedReader(fileReader);
            ArrayList<String> rawEntry = new ArrayList<String>();
            ArrayList<ArrayList<String>> entities = new ArrayList<ArrayList<String>>();
            String entryPattern = "\\s*TYPE\\s*\\|\\s*SES\\s*";
            String fieldPattern = "\\s*(ITEMS)?\\s*\\|\\s*(\\S+)\\s*:\\s*(\\S+)\\s*";
            String currEntry = "";
            String currKey = "";
            StringBuilder currValue = null;
            StringBuilder description = null;
            Pattern keyValPat = Pattern.compile(fieldPattern);
            while ((currLine = inputStream.readLine()) != null && (currLine.trim().isEmpty() || !currLine.toUpperCase().matches(entryPattern))) {
            }
            while ((currLine = inputStream.readLine()) != null) {
                if (currLine.toUpperCase().matches(entryPattern)) {
                    if (!rawEntry.isEmpty()) {
                        entities.add(rawEntry);
                    }
                    rawEntry = new ArrayList();
                }
                rawEntry.add(currLine);
            }
            if (!rawEntry.isEmpty()) {
                entities.add(rawEntry);
            }
            for (ArrayList arrayList : entities) {
                if (arrayList.isEmpty()) continue;
                currEntry = "";
                currKey = "";
                currValue = new StringBuilder();
                description = new StringBuilder();
                for (String line : arrayList) {
                    Matcher keyValMatch = keyValPat.matcher(line);
                    if (keyValMatch.matches()) {
                        currKey = keyValMatch.group(2);
                        currValue.delete(0, currValue.length());
                        currValue.append(keyValMatch.group(3));
                        if (currKey.isEmpty()) continue;
                        if (currKey.equalsIgnoreCase("ses")) {
                            currEntry = currValue.toString();
                        }
                        description.append(String.format("%1$-15s : " + currValue.toString().replace("%", "%%") + "\n", currKey.toLowerCase()));
                        currKey = "";
                        currValue.delete(0, currValue.length());
                        if (currValue.toString().matches("\\s*(|)?\\s*")) {
                            currKey = "";
                            currValue.delete(0, currValue.length());
                            continue;
                        }
                        description.append(String.format("%1$-15s : " + currValue.toString().replace("%", "%%") + "\n", currKey.toLowerCase()));
                        currKey = "";
                        currValue.delete(0, currValue.length());
                        continue;
                    }
                    if (!line.toString().matches(".*[|][|].*")) continue;
                    currValue.append(line + "\n");
                }
                description.append(String.format("\n" + currValue.toString().replace("%", "%%") + "\n", new Object[0]));
                toRet.put(currEntry, description.toString());
            }
        }
        catch (IOException e) {
            ExceptionHandler.writeToExceptionFile((Exception)e);
        }
        finally {
            try {
                if (fileReader != null) {
                    fileReader.close();
                }
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException e) {
                ExceptionHandler.writeToExceptionFile((Exception)e);
            }
        }
        return toRet;
    }

    private void getUprExtDataFromCsv(VendorEntities vEntities) {
        try (CsvReader csvReader = new CsvReader(vEntities.fileName);){
            csvReader.readHeaders();
            while (csvReader.readRecord()) {
                String name = csvReader.get("PARENT_UPR");
                String entityType = csvReader.get("ENTRY_TYPE");
                if (name == null || name.isEmpty()) continue;
                UprocExtension currUproc = this.uprExtDescription.get(name);
                if (currUproc == null) {
                    currUproc = new UprocExtension();
                }
                StringBuilder description = new StringBuilder();
                for (int i = 0; i < csvReader.getHeaderCount(); ++i) {
                    String param = csvReader.get(i);
                    if (param == null || param.isEmpty()) continue;
                    description.append(this.getDescriptionLine(vEntities.type, csvReader.getHeader(i), param));
                }
                if (entityType.equalsIgnoreCase(UPROC_ENTITIES.LAUNCHVAR.name())) {
                    currUproc.getLaunchvarName2Description().put(csvReader.get("varname"), description.toString());
                } else if (entityType.equalsIgnoreCase(UPROC_ENTITIES.DEPCON.name())) {
                    currUproc.getDepconName2Description().put(csvReader.get("condno"), description.toString());
                } else if (entityType.equalsIgnoreCase(UPROC_ENTITIES.RESCON.name())) {
                    currUproc.getResconName2Description().put(csvReader.get("condno"), description.toString());
                } else if (entityType.equalsIgnoreCase(UPROC_ENTITIES.INCON.name())) {
                    currUproc.getInconName2Description().put(csvReader.get("condno"), description.toString());
                } else {
                    currUproc.getUprocAttributesName2Description().put(entityType, description.toString());
                }
                this.uprExtDescription.put(name, currUproc);
            }
        }
        catch (IOException e) {
            ExceptionHandler.writeToExceptionFile((Exception)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HashMap<String, String> getCalendarData() {
        HashMap<String, String> toRet = new HashMap<String, String>();
        BufferedReader inputStream = null;
        InputStreamReader fileReader = null;
        try {
            String currLine;
            fileReader = new FileReader(new File(Params.instance().getDatasourcePath() + "Calendars.txt"));
            inputStream = new BufferedReader(fileReader);
            ArrayList<String> rawEntry = new ArrayList<String>();
            ArrayList<ArrayList<String>> entities = new ArrayList<ArrayList<String>>();
            String entryPattern = "\\s*TYPE\\s*\\|\\s*CAL\\s*";
            String fieldPattern = "\\s*(ITEMS)?\\s*\\|\\s*(\\S+)\\s*(:\\s*(.*))?";
            String currEntry = "";
            String currKey = "";
            StringBuilder currValue = null;
            StringBuilder description = null;
            Pattern keyValPat = Pattern.compile(fieldPattern);
            while ((currLine = inputStream.readLine()) != null && (currLine.trim().isEmpty() || !currLine.toUpperCase().matches(entryPattern))) {
            }
            while ((currLine = inputStream.readLine()) != null) {
                if (currLine.toUpperCase().matches(entryPattern)) {
                    if (!rawEntry.isEmpty()) {
                        entities.add(rawEntry);
                    }
                    rawEntry = new ArrayList();
                }
                rawEntry.add(currLine);
            }
            if (!rawEntry.isEmpty()) {
                entities.add(rawEntry);
            }
            for (ArrayList arrayList : entities) {
                if (arrayList.isEmpty()) continue;
                currEntry = "";
                currKey = "";
                currValue = new StringBuilder();
                description = new StringBuilder();
                for (String line : arrayList) {
                    Matcher keyValMatch = keyValPat.matcher(line);
                    if (keyValMatch.matches()) {
                        currKey = keyValMatch.group(2);
                        currValue.delete(0, currValue.length());
                        currValue.append(keyValMatch.group(4));
                        if (currKey.isEmpty()) continue;
                        if (currKey.equalsIgnoreCase("mu")) {
                            currEntry = currValue.toString();
                            if (currEntry.isEmpty()) {
                                currEntry = "(empty)";
                            }
                            description.append(String.format("%1$-15s : " + currValue.toString().replace("%", "%%") + "\n", currKey.toLowerCase()));
                        }
                        if (!currKey.equalsIgnoreCase("nomodel")) continue;
                        description.append(currKey + "\n");
                        continue;
                    }
                    currValue.append(line + "\n");
                }
                description.append(String.format("%1$-15s : " + currValue.toString().replace("%", "%%") + "\n", currKey.toLowerCase()));
                toRet.put(currEntry, description.toString());
            }
        }
        catch (IOException e) {
            ExceptionHandler.writeToExceptionFile((Exception)e);
        }
        finally {
            try {
                if (fileReader != null) {
                    fileReader.close();
                }
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException e) {
                ExceptionHandler.writeToExceptionFile((Exception)e);
            }
        }
        return toRet;
    }

    public void loadDataToUsageMap() {
        this.inUseUprocs = new HashSet<String>();
        TaskDetailsCollector taskDetailsCollector = new TaskDetailsCollector(this.taskUprName2taskUprAttributes, this.taskSessionName2taskSessionAttributes);
        taskDetailsCollector.collect();
        Set<String> uprocsFromTask = taskDetailsCollector.getUsedUprocsFromTask();
        this.inUseUprocs.addAll(uprocsFromTask);
        Set<String> musFromTask = taskDetailsCollector.getinUseMuFromTask();
        this.inUseMu.addAll(musFromTask);
        Map<String, Integer> musUseageFromTask = taskDetailsCollector.getMuUSageFromTask();
        this.muUsage.putAll(musUseageFromTask);
        this.inUseSessions.addAll(taskDetailsCollector.getInUseSessionsFromTask());
        SessionTable sessionTable = this.getSessionsTable();
        HashMap<String, DollarUniverseSessionAttributes> sessionNameTosessionAttributes = sessionTable.getSessions();
        SessionUprocsUsageHandler sessionUprocsUsageHandler = new SessionUprocsUsageHandler(sessionNameTosessionAttributes, this.inUseSessions);
        sessionUprocsUsageHandler.collectUprocsFromInUseSessions();
        this.inUseUprocs.addAll(sessionUprocsUsageHandler.getUprocsFromInUseSessions());
        Predicate<String> notInUseUprocPredicate = uprocName -> !this.inUseUprocs.contains(uprocName);
        this.uprName2uprDescription = this.getDataFromCsv(this.vendorEntities.get((Object)ASSESSMENT_SOURCE_INPUT_TYPE.UPR));
        this.notInUseUprocList = this.uprName2uprDescription.keySet().stream().filter(notInUseUprocPredicate).collect(Collectors.toList());
    }

    private SessionTable getSessionsTable() {
        FileInputStream sessionDetailsInputStream;
        VendorEntities sessionDetails = this.vendorEntities.get((Object)ASSESSMENT_SOURCE_INPUT_TYPE.SESSION_DETAILS);
        SessionTable sessionTable = new SessionTable();
        try {
            sessionDetailsInputStream = new FileInputStream(sessionDetails.fileName);
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
        sessionTable.load(sessionDetailsInputStream);
        return sessionTable;
    }

    public Set<String> getInUseMu() {
        return new HashSet<String>(this.inUseMu);
    }

    public Set<String> getInUseUprocs() {
        return new HashSet<String>(this.inUseUprocs);
    }

    public Map<String, DollarUniverseTaskAttributes> getTaskUprName2taskUprAttributes() {
        return new HashMap<String, DollarUniverseTaskAttributes>(this.taskUprName2taskUprAttributes);
    }

    public Map<String, DollarUniverseTaskAttributes> getTaskSessionName2taskSessionAttributes() {
        return new HashMap<String, DollarUniverseTaskAttributes>(this.taskSessionName2taskSessionAttributes);
    }

    public List<String> getNotInUseUprocList() {
        return this.notInUseUprocList;
    }

    public Map<String, Integer> getMuUsage() {
        return this.muUsage;
    }

    public class UprocsComparator
    implements Comparator<Object> {
        @Override
        public int compare(Object obj1, Object obj2) {
            String uprName1 = (String)obj1;
            String uprName2 = (String)obj2;
            UprocExtension upr1 = DUAssessmentReportReplier.this.getUprExtDescription().get(uprName1);
            UprocExtension upr2 = DUAssessmentReportReplier.this.getUprExtDescription().get(uprName2);
            if (this.hasChiled(upr1) && !this.hasChiled(upr2)) {
                return -1;
            }
            if (!this.hasChiled(upr1) && this.hasChiled(upr2)) {
                return 1;
            }
            return DollarUniverseUtils.compareContainNumber(uprName1, uprName2);
        }

        private boolean hasChiled(UprocExtension uptExt) {
            return uptExt != null && (!uptExt.getDepconName2Description().isEmpty() || !uptExt.getDepconName2Description().isEmpty() || !uptExt.getInconName2Description().isEmpty() || !uptExt.getLaunchvarName2Description().isEmpty() || !uptExt.getResconName2Description().isEmpty() || !uptExt.getUprocAttributesName2Description().isEmpty());
        }
    }
}

