/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.dollar_universe;

import com.bmc.ctmconvert.dollar_universe.TreeNode;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.function.Consumer;

public class Tree<T>
implements Iterable<T> {
    private TreeNode<T> root;
    private ArrayList<TreeNode<T>> allNodes;

    public Tree(T root) {
        this.reset(root);
    }

    public Tree() {
        this.allNodes = new ArrayList();
    }

    public void reset(T root) {
        this.root = new TreeNode<T>(null, root);
        this.allNodes = new ArrayList();
        this.allNodes.add(this.root);
    }

    public boolean addChild(T parent, T child) {
        TreeNode<T> parentNode = this.getNode(parent);
        if (parentNode == null || this.contains(child)) {
            return false;
        }
        TreeNode<T> childNode = new TreeNode<T>(parentNode, child);
        parentNode.addChild(childNode);
        this.allNodes.add(childNode);
        return true;
    }

    private TreeNode<T> getNode(T data) {
        for (TreeNode<T> treeNode : this.allNodes) {
            if (!treeNode.data.equals(data)) continue;
            return treeNode;
        }
        return null;
    }

    public T getRoot() {
        return this.root.getData();
    }

    public List<T> getPathFromRoot(T element) {
        ArrayList<T> path = new ArrayList<T>();
        if (!this.contains(element)) {
            return path;
        }
        for (TreeNode<T> node = this.getNode(element); node != null; node = node.getParent()) {
            path.add(node.getData());
        }
        return path;
    }

    public List<T> getChildren(T element) {
        ArrayList<T> children = new ArrayList<T>();
        TreeNode<T> elementNode = this.getNode(element);
        if (elementNode != null) {
            children.addAll(elementNode.getChildren());
        }
        return children;
    }

    public List<T> getAllElements() {
        ArrayList<T> elements = new ArrayList<T>();
        for (TreeNode<T> childNode : this.allNodes) {
            elements.add(childNode.getData());
        }
        return elements;
    }

    public T getParent(T child) {
        TreeNode<T> node = this.getNode(child);
        if (node == null) {
            return null;
        }
        TreeNode<T> parentNode = node.getParent();
        if (parentNode == null) {
            return null;
        }
        return parentNode.getData();
    }

    public boolean hasParent(T child) {
        TreeNode<T> node = this.getNode(child);
        if (node == null) {
            return false;
        }
        TreeNode<T> parentNode = node.getParent();
        return parentNode != null;
    }

    public int size() {
        return this.allNodes.size();
    }

    public boolean isEmpty() {
        return this.allNodes.isEmpty();
    }

    public boolean contains(T o) {
        return this.getNode(o) != null;
    }

    @Override
    public Iterator<T> iterator() {
        final Iterator<TreeNode<T>> iterator = this.allNodes.iterator();
        Iterator ret = new Iterator<T>(){

            @Override
            public boolean hasNext() {
                return iterator.hasNext();
            }

            @Override
            public T next() {
                return ((TreeNode)iterator.next()).getData();
            }
        };
        return ret;
    }

    public List<T> toList() {
        ArrayList<T> ret = new ArrayList<T>();
        for (TreeNode<T> t : this.allNodes) {
            ret.add(t.getData());
        }
        return ret;
    }

    public void clear() {
        this.allNodes.clear();
        this.root = null;
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Tree \n root=" + String.valueOf(this.root)).append("\n");
        for (TreeNode<T> childNode : this.allNodes) {
            b.append("tree child=" + String.valueOf(childNode)).append("\n");
        }
        return b.toString();
    }

    public void forEachPreOrder(Consumer<? super T> action) {
        T root = this.getRoot();
        this.forEachPreOrder(root, action);
    }

    private void forEachPreOrder(T element, Consumer<? super T> action) {
        action.accept(element);
        List<T> children = this.getChildren(element);
        for (T child : children) {
            this.forEachPreOrder(child, action);
        }
    }

    public List<T> toListPreOrder() {
        ArrayList elements = new ArrayList();
        this.forEachPreOrder(element -> elements.add(element));
        return elements;
    }

    public boolean isRoot(T element) {
        return this.getRoot().equals(element);
    }
}

