/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.dollar_universe;

import com.bmc.ctmconvert.common.AttrHolder;
import com.bmc.ctmconvert.common.CsvFile;
import com.bmc.ctmconvert.common.IAttrHolder;
import com.bmc.ctmconvert.dollar_universe.DollarUniverseDefs;
import com.bmc.ctmconvert.dollar_universe.DollarUniverseTaskAttributes;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class TaskTable
extends CsvFile {
    private final Map<String, DollarUniverseTaskAttributes> tasks;

    public TaskTable(DollarUniverseDefs father, String taskType) {
        this.tasks = taskType.equals("SESSION") ? father.getSessionTasks() : father.getUPRTasks();
    }

    public TaskTable(Map<String, DollarUniverseTaskAttributes> tasks) {
        this.tasks = tasks;
    }

    protected void handleRecord(IAttrHolder task, int recordNumber) {
        String id = task.getAttr("ID");
        if (StringUtils.isNotEmpty((CharSequence)id)) {
            Map<String, List<String>> rulesGrouped;
            String ruleStr = task.getAttr("rule");
            if (StringUtils.isNotEmpty((CharSequence)ruleStr) && (rulesGrouped = DollarUniverseDefs.getArrayOfRulesFromRuleField(ruleStr).stream().collect(Collectors.groupingBy(rule -> DollarUniverseDefs.getLunchTime(rule.trim())))).keySet().size() > 1) {
                AtomicInteger counter = new AtomicInteger(1);
                AttrHolder attrHolder = (AttrHolder)task;
                rulesGrouped.values().forEach(ruleList -> {
                    AttrHolder clonedAttr = attrHolder.clone();
                    String rules = String.join((CharSequence)" ", ruleList);
                    String idForCloned = id + "_" + counter.getAndIncrement();
                    clonedAttr.setAttr("ID", idForCloned);
                    clonedAttr.setAttr("rule", rules);
                    this.tasks.computeIfAbsent(idForCloned, k -> new DollarUniverseTaskAttributes((IAttrHolder)clonedAttr));
                });
                return;
            }
            this.tasks.computeIfAbsent(id, k -> new DollarUniverseTaskAttributes(task));
        }
    }

    public String getTaskForUpr(String upr, String uprNodeName) {
        Optional<Map.Entry> first = this.tasks.entrySet().stream().filter(t -> ((DollarUniverseTaskAttributes)t.getValue()).getAttributes().getAttr("upr").equals(upr) && ((DollarUniverseTaskAttributes)t.getValue()).getAttributes().getAttr("node name").equals(uprNodeName)).findFirst();
        return first.map(Map.Entry::getKey).orElse("");
    }
}

