/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.dollar_universe;

import com.bmc.ctmconvert.dollar_universe.DollarUniverseTaskAttributes;
import com.bmc.ctmconvert.dollar_universe.UprTable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class TaskDetailsCollector {
    private Set<String> inUseUprocs;
    private Set<String> inUseMu;
    private Map<String, Integer> muUsage;
    private Set<String> inUseSessions;
    private Map<String, DollarUniverseTaskAttributes> taskSessionName2taskSessionAttributes;
    private Map<String, DollarUniverseTaskAttributes> taskUprName2taskUprAttributes;

    public TaskDetailsCollector(Map<String, DollarUniverseTaskAttributes> taskSessionName2taskUprAttributes, Map<String, DollarUniverseTaskAttributes> taskSessionName2taskSessionAttributes) {
        this.taskSessionName2taskSessionAttributes = taskSessionName2taskSessionAttributes;
        this.taskUprName2taskUprAttributes = taskSessionName2taskUprAttributes;
        this.inUseUprocs = new HashSet<String>();
        this.inUseSessions = new HashSet<String>();
        this.inUseMu = new HashSet<String>();
        this.muUsage = new HashMap<String, Integer>();
    }

    public void collect() {
        this.collectUprocsFromTask();
        this.collectSessionsFromTask();
    }

    private void collectSessionsFromTask() {
        for (DollarUniverseTaskAttributes sessionAttributes : this.taskSessionName2taskSessionAttributes.values()) {
            String sess = sessionAttributes.getAttributes().getAttr("ses");
            String upr = sessionAttributes.getAttributes().getAttr("upr");
            String nodeName = sessionAttributes.getAttributes().getAttr("node name");
            if (sess == null || upr == null || sess.isEmpty()) continue;
            String sessionID = sess + "#" + upr + "#" + nodeName;
            this.inUseSessions.add(sessionID);
            String mu = sessionAttributes.getAttributes().getAttr("mu");
            String muId = mu + "_" + nodeName;
            if (muId == null || muId.isEmpty()) continue;
            this.inUseMu.add(muId);
            int count = this.muUsage.getOrDefault(muId, 0);
            this.muUsage.put(muId, count + 1);
        }
    }

    private void collectUprocsFromTask() {
        for (DollarUniverseTaskAttributes taskattributes : this.taskUprName2taskUprAttributes.values()) {
            String mu;
            String muId;
            String nodeName = taskattributes.getAttributes().getAttr("node name");
            String uproc = taskattributes.getAttributes().getAttr("upr");
            String uprId = UprTable.getUprID(uproc, nodeName);
            if (uprId != null && !uprId.isEmpty()) {
                this.inUseUprocs.add(uprId);
            }
            if ((muId = (mu = taskattributes.getAttributes().getAttr("mu")) + "_" + nodeName) == null || muId.isEmpty()) continue;
            this.inUseMu.add(muId);
            int count = this.muUsage.containsKey(muId) ? this.muUsage.get(muId) : 0;
            this.muUsage.put(muId, count + 1);
        }
    }

    public Set<String> getUsedUprocsFromTask() {
        return this.inUseUprocs;
    }

    public Map<String, Integer> getMuUSageFromTask() {
        return this.muUsage;
    }

    public Set<String> getinUseMuFromTask() {
        return this.inUseMu;
    }

    public Set<String> getInUseSessionsFromTask() {
        return this.inUseSessions;
    }
}

