/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.dollar_universe;

import com.bmc.ctmconvert.common.ExceptionHandler;
import com.bmc.ctmconvert.dollar_universe.SessionDetailsReader;
import com.bmc.ctmconvert.io.csv.CsvWriter;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class Session {
    private static final String SESSION_HEADER = "header";
    private static final String SESSION_NAME = "ses";
    private static final String SESSION_LABEL = "label";
    private static final String[] CSV_HEADER = new String[]{"ID", "ses", "header", "NumF", "NumS", "Path", "Father", "Son", "HDP/MU", "LABEL", "Return Code", "node name"};
    List<OneRecord> csvRecords;
    private final Reader sessionDetailsInput;
    private final OutputStream outputCsv;
    private SessionDetailsReader sessionDetailsReader;

    public Session(File sessionDetailsFile, String convertPath) throws IOException {
        this(new FileInputStream(sessionDetailsFile), new FileOutputStream(convertPath + "session.csv"));
    }

    public Session(InputStream sessionDetailsFile, OutputStream output) {
        this.sessionDetailsInput = new InputStreamReader(sessionDetailsFile);
        this.outputCsv = output;
        this.csvRecords = new LinkedList<OneRecord>();
    }

    public static String sessionId(String sess, String header, String nodeName) {
        return sess + "#" + header + "#" + nodeName;
    }

    private List<OneRecord> getUprs(BufferedReader input, String sessionName, String headerName, String labelName, String nodeName) throws IOException {
        ArrayList<OneRecord> sessionRecords = new ArrayList<OneRecord>();
        String line = this.sessionDetailsReader.findExpression("( *)\\|\\|( *)NumF(.*)");
        if (line == null) {
            return sessionRecords;
        }
        while ((line = input.readLine()) != null) {
            if ((line = line.trim()).isEmpty()) continue;
            if (this.isLineIsARecord(line)) {
                line = line.substring(2);
                String[] params = (line = line.trim()).split("\\|");
                String fatherUproc = params[3].trim();
                if (!headerName.equals(fatherUproc)) {
                    labelName = "";
                }
                OneRecord nextRecord = this.createBasicRecord(sessionName, headerName, labelName, nodeName);
                nextRecord.setValue(3, params[0].trim());
                nextRecord.setValue(4, params[1].trim());
                nextRecord.setValue(5, params[2].trim());
                nextRecord.setValue(6, params[3].trim());
                nextRecord.setValue(7, params[4].trim());
                nextRecord.setValue(8, params[5].trim());
                if (params.length >= 7) {
                    nextRecord.setValue(10, params[6].trim());
                } else {
                    nextRecord.setValue(10, "");
                }
                sessionRecords.add(nextRecord);
            }
            if (!this.isEndOfSession(line)) continue;
            break;
        }
        return sessionRecords;
    }

    private OneRecord createBasicRecord(String sessionName, String headerName, String labelName, String nodeName) {
        OneRecord nextRecord = new OneRecord();
        nextRecord.setValue(0, Session.sessionId(sessionName, headerName, nodeName));
        nextRecord.setValue(1, sessionName);
        nextRecord.setValue(2, headerName);
        nextRecord.setValue(9, labelName);
        nextRecord.setValue(11, nodeName);
        return nextRecord;
    }

    private void writeRecords(CsvWriter writer) throws IOException {
        for (OneRecord csvRecord : this.csvRecords) {
            writer.writeRecord(csvRecord.getValues());
        }
    }

    private boolean isLineIsARecord(String line) {
        return line.startsWith("||");
    }

    private boolean isEndOfSession(String line) {
        return line.equals("|");
    }

    private boolean handleNextSession(BufferedReader input) throws IOException {
        Map<String, String> sessionAttributes = this.sessionDetailsReader.readNextSessionAttributes();
        if (!sessionAttributes.containsKey(SESSION_NAME) || !sessionAttributes.containsKey(SESSION_HEADER)) {
            return false;
        }
        String sessionName = sessionAttributes.get(SESSION_NAME);
        String sessionLabel = sessionAttributes.get(SESSION_LABEL);
        String headerName = sessionAttributes.get(SESSION_HEADER);
        List<OneRecord> uprs = this.getUprs(input, sessionName, headerName, sessionLabel, sessionAttributes.get("nodeName"));
        if (uprs.isEmpty()) {
            OneRecord headerRecord = this.createBasicRecord(sessionName, headerName, sessionLabel, sessionAttributes.get("nodeName"));
            headerRecord.setValue(3, "0001");
            headerRecord.setValue(5, "OK");
            headerRecord.setValue(6, headerName);
            uprs.add(headerRecord);
        }
        this.csvRecords.addAll(uprs);
        return true;
    }

    public void writeToCSV() {
        try (CsvWriter sessionCsvWriter = new CsvWriter((Writer)new OutputStreamWriter(this.outputCsv), ',');
             BufferedReader detailsFile = new BufferedReader(this.sessionDetailsInput);){
            sessionCsvWriter.writeRecord(CSV_HEADER);
            this.sessionDetailsReader = new SessionDetailsReader(detailsFile);
            while (this.handleNextSession(detailsFile)) {
            }
            this.writeRecords(sessionCsvWriter);
        }
        catch (IOException e) {
            ExceptionHandler.writeToExceptionFile((Exception)e);
            throw new RuntimeException(e);
        }
    }

    public static class OneRecord {
        private final String[] recordValues = new String[12];

        public void setValue(int index, String value) {
            if (index >= 0 && index <= 12) {
                this.recordValues[index] = value;
            }
        }

        public String[] getValues() {
            return this.recordValues;
        }
    }

    public static class parameters {
        public static final String ID = "ID";
        public static final String RETURN_CODE = "Return Code";
        public static final String NODE_NAME = "node name";
        public static final String SES = "ses";
        public static final String HEADER = "header";
        public static final String NUMF = "NumF";
        public static final String NUMS = "NumS";
        public static final String PATH = "Path";
        public static final String FATHER = "Father";
        public static final String SON = "Son";
        public static final String HDPMU = "HDP/MU";
        public static final String PATH_OK = "OK";
        public static final String PATH_NOT_OK = "KO";
        static final int RETURN_CODE_INDEX = 10;
        static final int ID_INDEX = 0;
        static final int SES_INDEX = 1;
        static final int HEADER_INDEX = 2;
        static final int NUMF_INDEX = 3;
        static final int NUMS_INDEX = 4;
        static final int PATH_INDEX = 5;
        static final int FATHER_INDEX = 6;
        static final int SON_INDEX = 7;
        static final int HDPMU_INDEX = 8;
        static final String LABEL = "LABEL";
        static final int LABEL_INDEX = 9;
        static final int NUMBER_PARAMETERS = 12;
        static final int NODE_NAME_INDEX = 11;
    }
}

