/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.dollar_universe;

import com.bmc.ctmconvert.common.AssistingJob;
import com.bmc.ctmconvert.common.AttrHolderList;
import com.bmc.ctmconvert.common.CsvFile;
import com.bmc.ctmconvert.common.IAttrHolder;
import com.bmc.ctmconvert.common.SchedEntity;
import com.bmc.ctmconvert.dollar_universe.handlers.HandlerEndFolderDummyJobForFileWatcher;
import com.bmc.ctmconvert.dollar_universe.handlers.HandlerFilewatcherJob;
import com.bmc.ctmconvert.dollar_universe.hdpmu.HDPRelationship;
import com.bmc.ctmconvert.rules.RulesDataSet;
import com.bmc.ctmconvert.utils.Pair;
import com.bmc.ctmconvert.utils.UniqueConditionNameGenerator;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Properties;
import org.jetbrains.annotations.NotNull;

public class ResourceConvertor
extends CsvFile {
    private HashMap<Pair<String, String>, IAttrHolder> resourceMap;
    private HashMap<String, HashMap<String, AttrHolderList>> uprExtensionRecordsMap;
    private HashMap<String, ArrayList<Properties>> upr2CR;
    private HashMap<String, ArrayList<Properties>> upr2QR;
    private HashMap<String, ArrayList<AssistingJob>> upr2FW;
    private HashMap<String, ArrayList<AssistingJob>> FW2EndFolderJob;
    private HashSet<String> lockRes;
    private HashSet<String> fileRes = new HashSet();
    private HashMap<Pair<String, String>, HashMap<String, ArrayList<String[]>>> resName2messages;
    private HashMap<AssistingJob, IAttrHolder> fw2Attribute;
    private HandlerFilewatcherJob handlerFileWathcer;
    private HandlerEndFolderDummyJobForFileWatcher handlerEndFolderDummyJob;

    public ResourceConvertor(InputStream resourcesCsv, InputStream uprExtenssionCsv, RulesDataSet currentRules, UniqueConditionNameGenerator uniqueConditionNameGenerator) {
        this.resourceMap = new HashMap();
        this.fw2Attribute = new LinkedHashMap<AssistingJob, IAttrHolder>();
        this.handlerFileWathcer = new HandlerFilewatcherJob(currentRules, uniqueConditionNameGenerator);
        this.handlerEndFolderDummyJob = new HandlerEndFolderDummyJobForFileWatcher(currentRules, uniqueConditionNameGenerator);
        this.load(resourcesCsv);
        this.load(uprExtenssionCsv);
        this.mapResourceUsage();
    }

    private void addMessage(String resName, String nodeName, String msgId, String ... args) {
        Pair keyForRes = new Pair((Object)resName, (Object)nodeName);
        if (this.resName2messages == null) {
            this.resName2messages = new HashMap();
        }
        if (!this.resName2messages.containsKey(keyForRes)) {
            this.resName2messages.put((Pair<String, String>)keyForRes, new HashMap());
        }
        if (!this.resName2messages.get(keyForRes).containsKey(msgId)) {
            this.resName2messages.get(keyForRes).put(msgId, new ArrayList());
        }
        this.resName2messages.get(keyForRes).get(msgId).add(args);
    }

    private void mapResourceUsage() {
        if (this.uprExtensionRecordsMap == null) {
            return;
        }
        for (String uproc : this.uprExtensionRecordsMap.keySet()) {
            CharSequence resName;
            if (this.uprExtensionRecordsMap.get(uproc).containsKey("inccon")) {
                AttrHolderList incconAttrList = this.uprExtensionRecordsMap.get(uproc).get("inccon");
                for (IAttrHolder attrs : incconAttrList) {
                    resName = new StringBuilder(uproc);
                    ((StringBuilder)resName).append('_');
                    ((StringBuilder)resName).append(attrs.getAttr("inc"));
                    Properties tmpProps = ResourceConvertor.createExclusiveControlResource(((StringBuilder)resName).toString());
                    this.addMessage(((StringBuilder)resName).toString(), "INF7006", uproc, new String[0]);
                    if (this.upr2CR == null) {
                        this.upr2CR = new HashMap();
                    }
                    if (!this.upr2CR.containsKey(uproc)) {
                        this.upr2CR.put(uproc, new ArrayList());
                    }
                    this.upr2CR.get(uproc).add(tmpProps);
                    if (!attrs.getAttr("inc").equals(uproc)) {
                        if (!this.upr2CR.containsKey(attrs.getAttr("inc"))) {
                            this.upr2CR.put(attrs.getAttr("inc"), new ArrayList());
                        }
                        this.upr2CR.get(attrs.getAttr("inc")).add(tmpProps);
                    }
                    if (attrs.isFieldExist("mu") && !attrs.getAttr("mu").equalsIgnoreCase("any") && !attrs.getAttr("mu").isEmpty()) {
                        String commandNode;
                        String muExpression = attrs.getAttr("mu");
                        if (HDPRelationship.isHdpExpression(muExpression, commandNode = attrs.getAttr("node name"))) {
                            this.addMessage(((StringBuilder)resName).toString(), "WRN7025", uproc, muExpression);
                        } else if (muExpression.equals("same")) {
                            this.addMessage(((StringBuilder)resName).toString(), "INF7011", attrs.getAttr("inc"), attrs.getAttr("mu"), uproc, "MU", ((StringBuilder)resName).toString());
                        } else {
                            Properties muExclusiveControlResource = ResourceConvertor.createExclusiveControlResource(muExpression);
                            this.upr2CR.get(uproc).add(muExclusiveControlResource);
                        }
                    }
                    if (attrs.isFieldExist("sess") && !attrs.getAttr("sess").equalsIgnoreCase("any") && !attrs.getAttr("sess").isEmpty()) {
                        this.addMessage(((StringBuilder)resName).toString(), "WRN7034", attrs.getAttr("inc"), attrs.getAttr("sess"), uproc, "Session", ((StringBuilder)resName).toString());
                    }
                    if (attrs.isFieldExist("user") && !attrs.getAttr("user").equalsIgnoreCase("user") && !attrs.getAttr("user").isEmpty()) {
                        this.addMessage(((StringBuilder)resName).toString(), "WRN7034", attrs.getAttr("inc"), attrs.getAttr("user"), uproc, "User", ((StringBuilder)resName).toString());
                    }
                    if (attrs.isFieldExist("exclud") && attrs.getAttr("exclud").equalsIgnoreCase("TRUE")) {
                        this.addMessage(((StringBuilder)resName).toString(), "WRN7013", uproc, "inccon", String.format("exclud=%s", attrs.getAttr("exclud")));
                    }
                    if (!attrs.isFieldExist("fatal") || !attrs.getAttr("fatal").equalsIgnoreCase("TRUE")) continue;
                    this.addMessage(((StringBuilder)resName).toString(), "WRN7035", uproc, "FATAL", ((StringBuilder)resName).toString());
                }
            }
            if (!this.uprExtensionRecordsMap.get(uproc).containsKey("rescon")) continue;
            AttrHolderList resconAttrList = this.uprExtensionRecordsMap.get(uproc).get("rescon");
            for (IAttrHolder attrs : resconAttrList) {
                String nodeName;
                resName = attrs.getAttr("res");
                Pair resKey = new Pair((Object)resName, (Object)(nodeName = attrs.getAttr("NODE")));
                if (!this.resourceMap.containsKey(resKey)) continue;
                if (this.resourceMap.get(resKey).getAttr("NATURE").equalsIgnoreCase("fil")) {
                    AssistingJob tmpAssisting;
                    if (this.upr2FW == null) {
                        this.upr2FW = new HashMap();
                    }
                    if (!this.upr2FW.containsKey(uproc)) {
                        this.upr2FW.put(uproc, new ArrayList());
                    }
                    String fwJobName = (tmpAssisting = this.resource2FilewatcherJob(attrs)) != null ? tmpAssisting.getAttr("JOBNAME") : "";
                    AssistingJob endFolderAssistingJob = this.handlerEndFolderDummyJob.buildEndFolderJobForFW(attrs, fwJobName);
                    if (tmpAssisting != null && endFolderAssistingJob != null) {
                        this.upr2FW.get(uproc).add(tmpAssisting);
                        this.upr2FW.get(uproc).add(endFolderAssistingJob);
                        this.fw2Attribute.put(tmpAssisting, attrs);
                    }
                    this.fileRes.add((String)resName);
                    continue;
                }
                Properties tmpProps = new Properties();
                if (this.lockRes != null && this.lockRes.contains(attrs.getAttr("res"))) {
                    tmpProps.put("NAME", String.format("%s_CONTROL", attrs.getAttr("res")));
                    tmpProps.put("TYPE", "E");
                    if (this.upr2CR == null) {
                        this.upr2CR = new HashMap();
                    }
                    if (!this.upr2CR.containsKey(uproc)) {
                        this.upr2CR.put(uproc, new ArrayList());
                    }
                    this.upr2CR.get(uproc).add(tmpProps);
                    if (attrs.isFieldExist("fatal") && attrs.getAttr("fatal").equalsIgnoreCase("TRUE")) {
                        this.addMessage(String.format("%s_CONTROL", attrs.getAttr("res")), "WRN7035", uproc, new String[]{"FATAL", resName});
                    }
                    if (!attrs.isFieldExist("unclear") || !attrs.getAttr("unclear").equalsIgnoreCase("unclear")) continue;
                    this.addMessage(String.format("%s_CONTROL", attrs.getAttr("res")), "WRN7013", uproc, attrs.getAttr("res"), String.format("unclear=%s", attrs.getAttr("unclear")));
                    continue;
                }
                if (this.upr2QR == null) {
                    this.upr2QR = new HashMap();
                }
                if (!this.upr2QR.containsKey(uproc)) {
                    this.upr2QR.put(uproc, new ArrayList());
                }
                int qrInt = 0;
                String resourceName = String.format("%s_QT1", attrs.getAttr("res"));
                tmpProps.put("NAME", resourceName);
                try {
                    qrInt = Integer.parseInt(attrs.getAttr("qt1"));
                    if (qrInt < 1) {
                        tmpProps.put("MSG", "INF7004");
                    }
                    tmpProps.put("QUANT", String.valueOf(qrInt));
                }
                catch (NumberFormatException ex) {
                    tmpProps.put("MSG", "WRN7008");
                }
                this.upr2QR.get(uproc).add(tmpProps);
                if (attrs.isFieldExist("fatal") && attrs.getAttr("fatal").equalsIgnoreCase("TRUE")) {
                    this.addMessage(resourceName, "WRN7013", uproc, attrs.getAttr("res"), String.format("fatal=%s", attrs.getAttr("fatal")));
                }
                if (attrs.isFieldExist("unclear") && attrs.getAttr("unclear").equalsIgnoreCase("unclear")) {
                    this.addMessage(resourceName, "WRN7013", uproc, attrs.getAttr("res"), String.format("unclear=%s", attrs.getAttr("unclear")));
                }
                tmpProps = new Properties();
                qrInt = 0;
                resourceName = String.format("%s_QT2", attrs.getAttr("res"));
                tmpProps.put("NAME", resourceName);
                try {
                    qrInt = Integer.parseInt(attrs.getAttr("qt2"));
                    if (qrInt < 1) {
                        tmpProps.put("MSG", "INF7004");
                    }
                    tmpProps.put("QUANT", String.valueOf(qrInt));
                }
                catch (NumberFormatException ex) {
                    tmpProps.put("MSG", "WRN7008");
                }
                this.upr2QR.get(uproc).add(tmpProps);
            }
        }
    }

    @NotNull
    static Properties createExclusiveControlResource(String resName) {
        Properties tmpProps = new Properties();
        tmpProps.put("NAME", resName);
        tmpProps.put("TYPE", "E");
        return tmpProps;
    }

    private AssistingJob resource2FilewatcherJob(IAttrHolder uprExtAttrs) {
        AssistingJob toRet = new AssistingJob(SchedEntity.TYPE.JOB);
        Pair resKey = new Pair((Object)uprExtAttrs.getAttr("res"), (Object)uprExtAttrs.getAttr("NODE"));
        IAttrHolder resAtts = this.resourceMap.get(resKey);
        toRet.setAttribute("JOBNAME", String.format("RES_FW_%s--%s", uprExtAttrs.getAttr("res"), uprExtAttrs.getAttr("PARENT_UPR")));
        toRet.setAttribute("DESCRIPTION", resAtts.getAttr("LABEL"));
        toRet.setAttribute("TASKTYPE", "Job");
        toRet.setAttribute("MEMLIB", "Not in use for File Watcher jobs");
        toRet.setAttribute("MEMNAME", resAtts.getAttr("FNAME"));
        toRet.setAttribute("NODEID", uprExtAttrs.getAttr("mu"));
        toRet.setOptionalAttribute("APPL_FORM", "File Watcher");
        toRet.setOptionalAttribute("APPL_TYPE", "FileWatch");
        toRet.setOptionalAttribute("CM_VER", "8.0.00");
        toRet.setOptionalAttribute("APPL_VER", "9.0.00.300");
        String testType = uprExtAttrs.getAttr("attrib");
        String fileDir = resAtts.getAttr("DIR");
        String value = uprExtAttrs.getAttr("value").trim();
        String oper = uprExtAttrs.getAttr("oper");
        boolean isUnixOs = fileDir.startsWith("/") || fileDir.startsWith("./") || fileDir.startsWith("$");
        String fname = resAtts.getAttr("FNAME");
        String resolvedFileName = fname.replace("!DTRAIT!", "%%$DATE");
        if (fileDir.endsWith("\\") || fileDir.endsWith("/")) {
            fileDir = fileDir.substring(0, fileDir.length() - 1);
        }
        toRet.setAutoedit("%%FileWatch-FILE_PATH", String.format("%s%c%s", fileDir, Character.valueOf(isUnixOs ? (char)'/' : '\\'), resolvedFileName));
        toRet.setAutoedit("%%FileWatch-MODE", "CREATE");
        if (testType.equalsIgnoreCase("size")) {
            if (value == null || value.isEmpty() || !value.matches("[0-9]+") || oper == null || !oper.equals(">") && !oper.equals(">=")) {
                if (!oper.equals(">") && !oper.equals(">=")) {
                    this.addMessage(uprExtAttrs.getAttr("res"), "WRN7013", uprExtAttrs.getAttr("PARENT_UPR"), uprExtAttrs.getAttr("res"), String.format("operator: '%s'", oper));
                }
                return null;
            }
            if (oper.equals(">")) {
                Integer intVal;
                Integer n = intVal = Integer.valueOf(value);
                intVal = intVal + 1;
                value = intVal.toString();
            }
            toRet.setAutoedit("%%FileWatch-MIN_DET_SIZE", value);
        } else {
            toRet.setAutoedit("%%FileWatch-MIN_DET_SIZE", "0");
        }
        if (testType.equalsIgnoreCase("DATEUNCHANGE") || testType.equalsIgnoreCase("SIZEUNCHANGE")) {
            if (!value.matches("^[0-9]+,[0-9]+,[0-9]+$")) {
                this.addMessage(uprExtAttrs.getAttr("res"), "WRN0017", testType + " value", "$Universe", value, "(ddd,hh,mm)");
                return null;
            }
            String[] dateArr = value.split(",");
            Integer days = Integer.valueOf(dateArr[0]);
            Integer hours = Integer.valueOf(dateArr[1]);
            Integer minutes = Integer.valueOf(dateArr[2]);
            StringBuilder ageString = new StringBuilder();
            if (days > 0) {
                ageString.append(days).append('D');
            }
            if (hours > 0) {
                ageString.append(hours).append('H');
            }
            if (minutes > 0) {
                ageString.append(minutes).append("Min");
            }
            if (testType.equalsIgnoreCase("DATEUNCHANGE")) {
                toRet.setAutoedit("%%FileWatch-MIN_AGE", ageString.toString());
                toRet.setAutoedit("%%FileWatch-NUM_OF_ITERATIONS", "3");
                toRet.setAutoedit("%%FileWatch-INT_FILESIZE_COMPARISON", "10");
            } else {
                Integer totalTime = days * 24 * 60 * 60 + hours * 60 * 60 + minutes * 60;
                toRet.setAutoedit("%%FileWatch-MIN_AGE", "NO_MIN_AGE");
                toRet.setAutoedit("%%FileWatch-NUM_OF_ITERATIONS", "3");
                toRet.setAutoedit("%%FileWatch-INT_FILESIZE_COMPARISON", Integer.toString(totalTime / 3));
            }
        } else {
            toRet.setAutoedit("%%FileWatch-MIN_AGE", "NO_MIN_AGE");
            toRet.setAutoedit("%%FileWatch-NUM_OF_ITERATIONS", "3");
            toRet.setAutoedit("%%FileWatch-INT_FILESIZE_COMPARISON", "10");
        }
        toRet.setAutoedit("%%FileWatch-FILESIZE_WILDCARD", "N");
        toRet.setAutoedit("%%FileWatch-INT_FILE_SEARCHES", "60");
        toRet.setAutoedit("%%FileWatch-MAX_AGE", "NO_MAX_AGE");
        toRet.setAutoedit("%%FileWatch-START_TIME", "NOW");
        toRet.setAutoedit("%%FileWatch-STOP_TIME", "2355");
        toRet.setAutoedit("%%FileWatch-TIME_LIMIT", "0");
        toRet.addOutCondition(this.handlerFileWathcer.getOutCondition(uprExtAttrs));
        Properties outCond = this.handlerEndFolderDummyJob.getOutConditionForEndFolderJob(uprExtAttrs.getAttr("res"));
        Properties stmt = HandlerEndFolderDummyJobForFileWatcher.getCode7OnDoStmt(outCond);
        toRet.addOnStmt(stmt);
        return toRet;
    }

    protected void handleRecord(IAttrHolder record, int record_number) {
        if (record.isFieldExist("PARENT_UPR")) {
            this.loadUprExtensionRecord(record);
        } else {
            this.resourceMap.put((Pair<String, String>)new Pair((Object)record.getAttr("RES"), (Object)record.getAttr("NODE")), record);
            if (record.getAttr("NATURE").equalsIgnoreCase("log") && record.getAttr("LOCK_FLAG").equalsIgnoreCase("lock")) {
                if (this.lockRes == null) {
                    this.lockRes = new HashSet();
                }
                this.lockRes.add(record.getAttr("RES"));
            }
        }
    }

    private void loadUprExtensionRecord(IAttrHolder record) {
        HashMap<String, AttrHolderList> tmpMap;
        String parentUpr;
        String recType = record.getAttr("ENTRY_TYPE").trim().toLowerCase();
        if (!(ResourceConvertor.isResconAttribute(recType) || ResourceConvertor.isIncclassAttribute(recType) || ResourceConvertor.isIncconAtrribute(recType))) {
            return;
        }
        if (this.uprExtensionRecordsMap == null) {
            this.uprExtensionRecordsMap = new HashMap();
        }
        if (!this.uprExtensionRecordsMap.containsKey(parentUpr = record.getAttr("PARENT_UPR"))) {
            this.uprExtensionRecordsMap.put(parentUpr, new HashMap());
        }
        if (!(tmpMap = this.uprExtensionRecordsMap.get(parentUpr)).containsKey(recType)) {
            tmpMap.put(recType, new AttrHolderList());
        }
        tmpMap.get(recType).add((Object)record);
    }

    private static boolean isIncclassAttribute(String recType) {
        return recType.equals("incclass");
    }

    private static boolean isResconAttribute(String recType) {
        return recType.equals("rescon");
    }

    private static boolean isIncconAtrribute(String recType) {
        return recType.equals("inccon");
    }

    ArrayList<Properties> getResconQr(String uproc) {
        ArrayList<Properties> toRet = null;
        if (this.upr2QR != null && this.upr2QR.containsKey(uproc)) {
            toRet = this.upr2QR.get(uproc);
        }
        return toRet;
    }

    ArrayList<Properties> getControlResource(String uproc) {
        ArrayList<Properties> toRet = null;
        if (this.upr2CR != null && this.upr2CR.containsKey(uproc)) {
            toRet = this.upr2CR.get(uproc);
        }
        return toRet;
    }

    ArrayList<AssistingJob> getResconFwJobs(String uproc) {
        ArrayList<AssistingJob> toRet = null;
        if (this.upr2FW != null && this.upr2FW.containsKey(uproc)) {
            toRet = this.upr2FW.get(uproc);
        }
        return toRet;
    }

    public IAttrHolder getResconFwJobsOriginalAttributes(AssistingJob assistingResourceJob) {
        return this.fw2Attribute.get(assistingResourceJob);
    }

    public HashMap<String, ArrayList<String[]>> getResourceMessages(String resName) {
        return this.resName2messages == null ? null : this.resName2messages.get(resName);
    }

    public boolean isFileRes(String resName) {
        return this.fileRes.contains(resName);
    }

    public String getResNameByUprId(String uprId) {
        if (this.uprExtensionRecordsMap.get(uprId).containsKey("rescon")) {
            return ((IAttrHolder)this.uprExtensionRecordsMap.get(uprId).get("rescon").get(0)).getAttr("res");
        }
        return "";
    }
}

