/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.dollar_universe;

import com.bmc.ctmconvert.common.CsvFile;
import com.bmc.ctmconvert.common.GlobalFunctions;
import com.bmc.ctmconvert.common.IAttrHolder;
import com.bmc.ctmconvert.common.rbc.DailyRbc;
import com.bmc.ctmconvert.dollar_universe.DollarUniverseCalendars;
import com.bmc.ctmconvert.dollar_universe.scheduling.DollarUniverseWeekDaysHandler;
import com.bmc.ctmconvert.rules.RulesDataSet;
import com.bmc.ctmconvert.utils.Pair;
import com.bmc.ctmconvert.utils.PropertiesBuilder;
import com.bmc.ctmconvert.vc.FieldValidation;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;

public class RbcGenerator
extends CsvFile {
    private static final Properties UNSCHEDULED = new PropertiesBuilder().setProperty("NAME", "Unscheduled").build();
    private final Map<Pair<String, String>, Properties> rule2RbcTemplate = new HashMap<Pair<String, String>, Properties>();
    private final Map<Pair<String, String>, Map<String, String[]>> rule2messageMap;
    private final List<Pair<String, String>> rulesWithOffsetList = new ArrayList<Pair<String, String>>();
    private final DollarUniverseWeekDaysHandler weekDaysHandler;

    public RbcGenerator(InputStream rules, RulesDataSet rulesDataSet) {
        this.weekDaysHandler = new DollarUniverseWeekDaysHandler(rulesDataSet);
        this.rule2messageMap = new HashMap<Pair<String, String>, Map<String, String[]>>();
        this.load(rules);
    }

    public static Properties getEveryDayRBC() {
        return new DailyRbc().getProperties();
    }

    public Properties getRbc(String rawRule, String mu, String area, String nodeName) {
        return this.getRuleAndPrefixFrom(rawRule).map(ruleAndPrefix -> {
            String rule = (String)ruleAndPrefix.getKey();
            String prefix = (String)ruleAndPrefix.getValue();
            return this.getRbc(mu, area, rule, prefix, nodeName);
        }).orElse(UNSCHEDULED);
    }

    private Properties getRbc(String mu, String area, String rule, String prefix, String nodeName) {
        Properties rbc;
        Pair key = new Pair((Object)rule, (Object)nodeName);
        if (this.rule2RbcTemplate.containsKey(key)) {
            String weeksCalType;
            rbc = (Properties)this.rule2RbcTemplate.get(key).clone();
            Object ruleName = rbc.get("NAME");
            rbc.put("NAME", this.createRbcName(mu, prefix, ruleName));
            if (rbc.containsKey("CONFCAL")) {
                String confCalType = (String)rbc.get("CONFCAL");
                rbc.put("CONFCAL", new DollarUniverseCalendars().geUsedCalendarName(area, mu, confCalType));
            }
            if (rbc.containsKey("WEEKSCAL")) {
                weeksCalType = (String)rbc.get("WEEKSCAL");
                rbc.put("WEEKSCAL", new DollarUniverseCalendars().geUsedCalendarName(area, mu, weeksCalType));
            }
            if (rbc.containsKey("DAYSCAL")) {
                weeksCalType = (String)rbc.get("DAYSCAL");
                rbc.put("DAYSCAL", new DollarUniverseCalendars().geUsedCalendarName(area, mu, weeksCalType));
            }
            if (this.rulesWithOffsetList.contains(key)) {
                this.addMessage((String)rbc.get("NAME"), nodeName, "WRN7037", rule, (String)rbc.get("NAME"));
            }
        } else {
            this.addMessage(rule, nodeName, "WRN7020", rule);
            rbc = new Properties();
            rbc.put("NAME", this.createRbcName(mu, prefix, rule));
        }
        return rbc;
    }

    private String createRbcName(String mu, String prefix, Object ruleName) {
        String rbcName = prefix + String.valueOf(ruleName) + "_" + mu;
        return FieldValidation.instance().validateAndReturnFixedValue("TAG_NAME", rbcName);
    }

    protected void handleRecord(IAttrHolder recordItem, int recordNumber) {
        this.rule2RbcTemplate.put((Pair<String, String>)new Pair((Object)recordItem.getAttr("RUL"), (Object)recordItem.getAttr("NODE")), this.ruleAttrs2RbcTemplate(recordItem));
    }

    private Properties ruleAttrs2RbcTemplate(IAttrHolder recordItem) {
        Properties toRet = new Properties();
        String ruleName = recordItem.getAttr("RUL");
        String nodeName = recordItem.getAttr("RUL");
        toRet.put("NAME", ruleName);
        this.convertDaysMask(ruleName, nodeName, recordItem.getAttr("AUTHO"), toRet);
        this.convertMonths(ruleName, nodeName, recordItem.getAttr("AUTHOM"), toRet);
        this.convertMonthDays(recordItem.getAttr("AUTHOD"), toRet);
        this.convertPosPeriod(ruleName, nodeName, recordItem.getAttr("POS"), recordItem.getAttr("PERIOD"), toRet, recordItem);
        this.completeRbcTemplate(toRet, recordItem);
        return toRet;
    }

    private void completeRbcTemplate(Properties rbc, IAttrHolder ruleRecord) {
        rbc.put("NAME", ruleRecord.getAttr("RUL"));
        for (int i = 0; i < GlobalFunctions.getMonthsArray().length; ++i) {
            if (rbc.containsKey(GlobalFunctions.getMonthsArray()[i])) continue;
            rbc.put(GlobalFunctions.getMonthsArray()[i], "1");
        }
        if (!rbc.containsKey("DAYS") && !rbc.containsKey("WEEKDAYS")) {
            rbc.put("DAYS", "ALL");
        }
        if ((rbc.containsKey("DAYS") || rbc.containsKey("DAYSCAL")) && (rbc.containsKey("WEEKDAYS") || rbc.containsKey("WEEKSCAL"))) {
            rbc.put("DAYS_AND_OR", "AND");
        } else {
            rbc.put("DAYS_AND_OR", "OR");
        }
        String offset = ruleRecord.getAttr("OFFSET");
        if (!offset.isEmpty() && !offset.equalsIgnoreCase("n")) {
            this.rulesWithOffsetList.add((Pair<String, String>)new Pair((Object)ruleRecord.getAttr("RUL"), (Object)ruleRecord.getAttr("NODE")));
        }
    }

    private void convertMonths(String rule, String nodeName, String rawMonthList, Properties rbc) {
        if (rawMonthList.isEmpty() || rbc.containsKey(GlobalFunctions.getMonthsArray()[0])) {
            return;
        }
        String monthList = rawMonthList.replaceAll("^\\s*\\(*\\s*", "").replaceAll("\\s*\\)*\\s*$", "");
        if (!monthList.matches("(0?[0-9]|1[0-2])(\\s*,\\s*(0?\\d|1[0-2]))*")) {
            this.addMessage(rule, nodeName, "WRN0017", "rule authom", "$Universe", rawMonthList, "(<mm>[,<mm>,...,<mm>])");
        }
        String[] monthNumArr = monthList.split("\\s*,\\s*");
        boolean[] monthFlagArr = new boolean[12];
        for (String month : monthNumArr) {
            monthFlagArr[Integer.parseInt((String)month) - 1] = true;
        }
        for (int i = 0; i < monthFlagArr.length; ++i) {
            rbc.put(GlobalFunctions.getMonthsArray()[i], monthFlagArr[i] ? "1" : "0");
        }
    }

    private void convertMonthDays(String daysList, Properties rbc) {
        if (daysList.isEmpty()) {
            return;
        }
        boolean negative = false;
        if ((daysList = daysList.trim()).matches("^[+-].*")) {
            negative = daysList.startsWith("-");
            daysList = daysList.substring(1);
        }
        daysList = daysList.replaceAll("^\\s*\\(*\\s*", "").replaceAll("\\s*\\)*\\s*$", "");
        String[] daysArr = daysList.split("\\s*,\\s*");
        StringBuilder monthDays = new StringBuilder();
        if (daysArr.length == 31) {
            monthDays.append("ALL");
        } else {
            for (int i = 0; i < daysArr.length; ++i) {
                daysArr[i] = daysArr[i].trim().replaceAll("^0+", "");
                if (monthDays.length() > 0) {
                    monthDays.append(',');
                }
                if (negative) {
                    monthDays.append('L');
                }
                monthDays.append(daysArr[i]);
            }
        }
        rbc.put("DAYS", monthDays.toString());
    }

    private void convertPosPeriod(String rule, String nodeName, String pos, String period, Properties rbc, IAttrHolder recordItem) {
        boolean conflict;
        period = period.toLowerCase().replaceAll("^\\s*\\(*\\s*", "").replaceAll("\\s*\\)*\\s*$", "");
        if ((pos = pos.toLowerCase().replaceAll("^\\s*\\(*\\s*", "").replaceAll("\\s*\\)*\\s*$", "")).trim().isEmpty() || period.trim().isEmpty()) {
            return;
        }
        if (!period.matches("^1[mdw]$")) {
            this.addMessage(rule, nodeName, "WRN7012", rule, period);
            return;
        }
        period = period.substring(1);
        if (!pos.matches("[+-]\\d+[wc]")) {
            this.addMessage(rule, nodeName, "WRN0017", "rule pos", "$Universe", pos, "({+|-}<number>{c|w})");
            return;
        }
        boolean isPosNegative = pos.startsWith("-");
        String posVal = pos.replaceAll("^.", "").replaceAll(".$", "");
        boolean posByWorkingDay = pos.endsWith("w");
        if (period.equalsIgnoreCase("d")) {
            if (!rbc.containsKey("DAYS") && !rbc.containsKey("WEEKDAYS")) {
                rbc.put("DAYS", "ALL");
            }
            return;
        }
        if (period.equalsIgnoreCase("w")) {
            if (posByWorkingDay) {
                rbc.put("WEEKSCAL", "W");
            } else if (isPosNegative) {
                rbc.put("WEEKSCAL", "ALLDAYS");
            }
            conflict = rbc.containsKey("WEEKDAYS");
            if (posByWorkingDay || isPosNegative) {
                rbc.put("WEEKDAYS", String.format("%c%s", Character.valueOf(isPosNegative ? (char)'L' : 'D'), posVal));
            } else {
                rbc.put("WEEKDAYS", String.format("%d", Integer.parseInt(posVal) % 7));
            }
            if (conflict) {
                this.addMessage(rule, nodeName, "INF0010", "$Universe", "rule-autho", recordItem.getAttr("AUTHO"), "rule-pos/period", String.format("pos=%s period=%s", pos, period), "WEEKDAYS", (String)rbc.get("WEEKDAYS"));
            }
        }
        if (period.equalsIgnoreCase("m")) {
            if (posByWorkingDay) {
                rbc.put("DAYSCAL", "W");
            } else if (isPosNegative) {
                rbc.put("DAYSCAL", "ALLDAYS");
            }
            conflict = rbc.containsKey("DAYS");
            if (posByWorkingDay || isPosNegative) {
                rbc.put("DAYS", String.format("%c%s", Character.valueOf(isPosNegative ? (char)'L' : 'D'), posVal));
            } else {
                rbc.put("DAYS", String.format("%d", Integer.valueOf(posVal) - (period.equalsIgnoreCase("w") ? 1 : 0)));
            }
            if (conflict) {
                this.addMessage(rule, nodeName, "INF0010", "$Universe", "rule-authod", recordItem.getAttr("AUTHOD"), "rule-pos/period", String.format("pos=%s period=%s", pos, period), "DAYS", (String)rbc.get("DAYS"));
            }
        }
    }

    private void convertDaysMask(String rule, String nodeName, String daysMask, Properties rbc) {
        String[] daysArr;
        String defaultDaysMask = "(ynn,ynn,ynn,ynn,ynn,ynn,ynn)";
        if (daysMask == null || daysMask.isEmpty() || daysMask.equals("()")) {
            daysMask = "(ynn,ynn,ynn,ynn,ynn,ynn,ynn)";
        }
        if ((daysArr = daysMask.replaceAll("^\\s*\\(*\\s*", "").replaceAll("\\s*\\)*\\s*$", "").split("\\s*,\\s*")).length != 7) {
            this.addMessage(rule, nodeName, "WRN0017", "rule autho", "$Universe", daysMask, "<{y|n}{y|n}{y|n},...,{y|n}{y|n}{y|n}>");
        }
        String wDays = this.weekDaysHandler.getWeekdaysInCtm(daysArr);
        String maskToUse = "";
        boolean raiseMassage = false;
        for (String day : daysArr) {
            if (day.equalsIgnoreCase("nnn")) continue;
            boolean bl = raiseMassage = raiseMassage || !maskToUse.isEmpty() && !day.equals(maskToUse);
            if (raiseMassage || !maskToUse.isEmpty()) continue;
            maskToUse = day;
        }
        if (wDays.split(",").length == 7) {
            rbc.put("WEEKDAYS", "ALL");
        } else {
            rbc.put("WEEKDAYS", wDays);
        }
        Object calType = "";
        if (maskToUse.length() == 3) {
            if (maskToUse.toUpperCase().charAt(0) == 'Y') {
                calType = (String)calType + "W";
            }
            if (maskToUse.toUpperCase().charAt(1) == 'Y') {
                calType = (String)calType + "C";
            }
            if (maskToUse.toUpperCase().charAt(2) == 'Y') {
                calType = (String)calType + "H";
            }
        }
        if (((String)calType).equals("")) {
            for (int i = 0; i < GlobalFunctions.getMonthsArray().length; ++i) {
                rbc.put(GlobalFunctions.getMonthsArray()[i], "0");
            }
        }
        if (raiseMassage) {
            this.addMessage(rule, nodeName, "WRN7011", rule);
        } else if (((String)calType).length() < 3 && ((String)calType).length() > 0) {
            rbc.put("CONFCAL", calType);
        }
    }

    private void addMessage(String rule, String nodeName, String messageId, String ... messageArgs) {
        Map ruleMessages = this.rule2messageMap.computeIfAbsent((Pair<String, String>)new Pair((Object)rule, (Object)nodeName), k -> new HashMap());
        ruleMessages.computeIfAbsent(messageId, k -> messageArgs);
    }

    public Map<String, String[]> getRuleMessages(String dollarURule, String nodeName) {
        if (this.rule2messageMap == null) {
            return null;
        }
        return this.rule2messageMap.get(new Pair((Object)dollarURule, (Object)nodeName));
    }

    private Optional<Pair<String, String>> getRuleAndPrefixFrom(String rule) {
        return Optional.ofNullable(rule).filter(r -> !r.isEmpty()).map(r -> {
            String prefix = this.convertPrefix(rule);
            return new Pair((Object)RbcGenerator.trimRulePrefix(r), (Object)prefix);
        });
    }

    private String convertPrefix(String rule) {
        return rule.startsWith("- ") ? "!" : "";
    }

    public static String trimRulePrefix(String rule) {
        return rule.replaceAll("^\\s*[+-]\\s+", "");
    }
}

