/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.dollar_universe;

import com.bmc.ctmconvert.common.AttrHolder;
import com.bmc.ctmconvert.common.IAttrHolder;
import com.bmc.ctmconvert.dollar_universe.DollarUniverseDefs;
import com.bmc.ctmconvert.dollar_universe.DollarUniverseSessionAttributes;
import com.bmc.ctmconvert.dollar_universe.DollarUniverseTaskAttributes;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class EntityNotInUseTaskGenerator {
    private DollarUniverseDefs dollarUniverseDefs;
    private List<IAttrHolder> listOfTasksForNotInUseSession;
    private List<IAttrHolder> listOfTasksForNotInUseUprocs;
    private Map<String, DollarUniverseTaskAttributes> TasksForNotInUseSessionMap;
    private Map<String, DollarUniverseTaskAttributes> TasksForNotInUseUprocsMap;

    public EntityNotInUseTaskGenerator(DollarUniverseDefs dollarUniverseDefs) {
        this.dollarUniverseDefs = dollarUniverseDefs;
        this.TasksForNotInUseSessionMap = new HashMap<String, DollarUniverseTaskAttributes>();
        this.TasksForNotInUseUprocsMap = new HashMap<String, DollarUniverseTaskAttributes>();
        this.listOfTasksForNotInUseSession = new ArrayList<IAttrHolder>();
        this.listOfTasksForNotInUseUprocs = new ArrayList<IAttrHolder>();
    }

    public void generateTasksForEntitiessWithoutTask() {
        this.listOfTasksForNotInUseUprocs = this.getNotInUseUprocsTaskAttributes();
        this.listOfTasksForNotInUseSession = this.getNotInUseSesssionTaskAttributes();
    }

    private List<IAttrHolder> getNotInUseSesssionTaskAttributes() {
        ArrayList<IAttrHolder> listOfTaskAttributes = new ArrayList<IAttrHolder>();
        List<String> notInUseSession = this.dollarUniverseDefs.getNotInUseSession();
        for (String sessID : notInUseSession) {
            DollarUniverseSessionAttributes session = this.dollarUniverseDefs.getSessions().get(sessID);
            String sessionName = session.getAttributes().getAttr("ses");
            String headerName = session.getHeaderUprName();
            String nodeName = session.getAttributes().getAttr("node name");
            AttrHolder taskAttributes = DollarUniverseDefs.getTaskAttr("SessionsWithoutATask", sessionName, headerName, nodeName);
            this.TasksForNotInUseSessionMap.put(sessionName, new DollarUniverseTaskAttributes((IAttrHolder)taskAttributes));
            listOfTaskAttributes.add((IAttrHolder)taskAttributes);
        }
        return listOfTaskAttributes;
    }

    private List<IAttrHolder> getNotInUseUprocsTaskAttributes() {
        ArrayList<IAttrHolder> listOfTaskAttributes = new ArrayList<IAttrHolder>();
        List<String> notInUseUprocs = this.dollarUniverseDefs.getNotInUseUprocs();
        for (String uprocName : notInUseUprocs) {
            String headerName = EntityNotInUseTaskGenerator.getUprNameFromUprKey(uprocName);
            String nodeName = EntityNotInUseTaskGenerator.getNodeNameFromUprKey(uprocName);
            String sessionName = "Standalone_" + headerName;
            AttrHolder taskAttributes = DollarUniverseDefs.getTaskAttr(uprocName, sessionName, headerName, nodeName);
            this.TasksForNotInUseUprocsMap.put(uprocName, new DollarUniverseTaskAttributes((IAttrHolder)taskAttributes));
            listOfTaskAttributes.add((IAttrHolder)taskAttributes);
        }
        return listOfTaskAttributes;
    }

    @NotNull
    private static String getNodeNameFromUprKey(String uprocName) {
        return uprocName.substring(EntityNotInUseTaskGenerator.getIndexOfnodeNamePart(uprocName) + 1);
    }

    private static int getIndexOfnodeNamePart(String uprocName) {
        return uprocName.lastIndexOf("_");
    }

    @NotNull
    private static String getUprNameFromUprKey(String uprocName) {
        return uprocName.substring(0, EntityNotInUseTaskGenerator.getIndexOfnodeNamePart(uprocName));
    }

    public List<IAttrHolder> getListOfTasksForNotInUseSession() {
        return this.listOfTasksForNotInUseSession;
    }

    public Map<String, DollarUniverseTaskAttributes> getTasksForNotInUseSessionMap() {
        return this.TasksForNotInUseSessionMap;
    }

    public List<IAttrHolder> getListOfTasksForNotInUseUprocs() {
        return this.listOfTasksForNotInUseUprocs;
    }

    public Map<String, DollarUniverseTaskAttributes> getTasksForNotInUseUprocsMap() {
        return this.TasksForNotInUseUprocsMap;
    }
}

