/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.dollar_universe;

import com.bmc.ctmconvert.common.GlobalFunctions;
import com.bmc.ctmconvert.dollar_universe.DollarUniverseCreateConditionByNewFormat;
import com.bmc.ctmconvert.dollar_universe.DollarUniverseDependencies;
import com.bmc.ctmconvert.dollar_universe.DollarUniverseSessionAttributes;
import com.bmc.ctmconvert.dollar_universe.SessionTable;
import com.bmc.ctmconvert.dollar_universe.session.DollarUniverseSessionTree;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public class DollarUniverseSessionsToTree {
    private HashMap<String, DollarUniverseSessionTree> mapOfSessionTree = new HashMap();

    public DollarUniverseSessionsToTree(SessionTable m_sessionTable) {
        for (DollarUniverseSessionAttributes sessionAttributes : m_sessionTable.getSessions().values()) {
            String nodeName = sessionAttributes.getAttributes().getAttr("node name");
            String sessionID = DollarUniverseSessionsToTree.getTreeSessionID(sessionAttributes.getAttributes().getAttr("ses"), nodeName);
            this.mapOfSessionTree.put(sessionID, new DollarUniverseSessionTree(sessionAttributes));
        }
    }

    public Optional<DollarUniverseSessionTree> getTreeBysession(String session, String nodeName) {
        String sessionID = DollarUniverseSessionsToTree.getTreeSessionID(session, nodeName);
        if (!this.mapOfSessionTree.containsKey(sessionID)) {
            return Optional.empty();
        }
        return Optional.of(this.mapOfSessionTree.get(sessionID));
    }

    private DollarUniverseSessionTree.SessionElement getElementByNameAndTree(DollarUniverseSessionTree sessionTree, DollarUniverseCreateConditionByNewFormat.nameToNum name) {
        List<DollarUniverseSessionTree.SessionElement> list = sessionTree.getSessionTree().getAllElements();
        for (DollarUniverseSessionTree.SessionElement sessionElement : list) {
            DollarUniverseCreateConditionByNewFormat.nameToNum mname = new DollarUniverseCreateConditionByNewFormat.nameToNum(sessionElement.getUprOriginalName(), DollarUniverseDependencies.getFormatNumS(sessionElement.getUprocId()));
            if (!mname.equals(name)) continue;
            return sessionElement;
        }
        return null;
    }

    public List<DollarUniverseSessionTree.SessionElement> getUprSonsByNameAndSession(DollarUniverseCreateConditionByNewFormat.nameToNum name, String sessionName, String nodeName) {
        List<Object> sons = new ArrayList();
        Optional<DollarUniverseSessionTree> sessionTree = this.getTreeBysession(sessionName, nodeName);
        if (sessionTree.isPresent()) {
            DollarUniverseSessionTree.SessionElement sessionElement = this.getElementByNameAndTree(sessionTree.get(), name);
            sons = sessionTree.get().getSessionTree().getChildren(sessionElement);
        }
        return sons.stream().filter(c -> this.nonEmptyUprocs((DollarUniverseSessionTree.SessionElement)c)).collect(Collectors.toList());
    }

    private boolean nonEmptyUprocs(DollarUniverseSessionTree.SessionElement upr) {
        return upr.getUprOriginalName() != null && GlobalFunctions.isNotEmpty((String)upr.getUprOriginalName());
    }

    public Optional<DollarUniverseSessionTree.SessionElement> getUprFatherByNameAndSession(DollarUniverseCreateConditionByNewFormat.nameToNum name, String sessionName, String sessionNodeName) {
        Optional<DollarUniverseSessionTree.SessionElement> father = Optional.empty();
        Optional<DollarUniverseSessionTree> sessionTree = this.getTreeBysession(sessionName, sessionNodeName);
        if (sessionTree.isPresent()) {
            DollarUniverseSessionTree.SessionElement sessionElement = this.getElementByNameAndTree(sessionTree.get(), name);
            if (sessionTree.get().getSessionTree().hasParent(sessionElement)) {
                father = Optional.of(sessionTree.get().getSessionTree().getParent(sessionElement));
            }
        }
        return father;
    }

    @NotNull
    private static String getTreeSessionID(String sessionName, String sessionNodeName) {
        return sessionName + "#" + sessionNodeName;
    }

    public List<Integer> getAllUprNums(String upr, String session, String nodeName) {
        String sessionID = DollarUniverseSessionsToTree.getTreeSessionID(session, nodeName);
        ArrayList<Integer> allNumS = new ArrayList<Integer>();
        if (this.mapOfSessionTree.containsKey(sessionID)) {
            DollarUniverseSessionTree treeSession = this.mapOfSessionTree.get(sessionID);
            List<DollarUniverseSessionTree.SessionElement> arraySession = treeSession.getSessionTree().getAllElements();
            for (DollarUniverseSessionTree.SessionElement sessionElement : arraySession) {
                if (sessionElement.getUprOriginalName() == null || !sessionElement.getUprOriginalName().equals(upr)) continue;
                allNumS.add(sessionElement.getUprocId());
            }
        }
        return allNumS;
    }
}

