/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.dollar_universe;

import com.bmc.ctmconvert.SAP.SapBWHandler;
import com.bmc.ctmconvert.SAP.SapXBP2Handler;
import com.bmc.ctmconvert.common.AssistingJob;
import com.bmc.ctmconvert.common.AttrHolderList;
import com.bmc.ctmconvert.common.CtmPriority;
import com.bmc.ctmconvert.common.ExceptionHandler;
import com.bmc.ctmconvert.common.GlobalFunctions;
import com.bmc.ctmconvert.common.Globs;
import com.bmc.ctmconvert.common.IAttrHolder;
import com.bmc.ctmconvert.common.MessageIdTable;
import com.bmc.ctmconvert.common.Params;
import com.bmc.ctmconvert.common.Reporter;
import com.bmc.ctmconvert.common.SchedEntity;
import com.bmc.ctmconvert.common.conditions.InConditionUtils;
import com.bmc.ctmconvert.common.log.ConversionLogger;
import com.bmc.ctmconvert.common.message_id.MessageId;
import com.bmc.ctmconvert.dollar_universe.DollarUniverseDefs;
import com.bmc.ctmconvert.dollar_universe.DollarUniverseGlobals;
import com.bmc.ctmconvert.dollar_universe.DollarUniverseMUAttributes;
import com.bmc.ctmconvert.dollar_universe.DollarUniverseSessionAttributes;
import com.bmc.ctmconvert.dollar_universe.DollarUniverseTaskAttributes;
import com.bmc.ctmconvert.dollar_universe.DollarUniverseTimeZone;
import com.bmc.ctmconvert.dollar_universe.DollarUniverseUprAttributes;
import com.bmc.ctmconvert.dollar_universe.FileConfigurationConvertor;
import com.bmc.ctmconvert.dollar_universe.MUTable;
import com.bmc.ctmconvert.dollar_universe.NodeGroup;
import com.bmc.ctmconvert.dollar_universe.NodeGroupCollector;
import com.bmc.ctmconvert.dollar_universe.RbcGenerator;
import com.bmc.ctmconvert.dollar_universe.ResourceConvertor;
import com.bmc.ctmconvert.dollar_universe.Session;
import com.bmc.ctmconvert.dollar_universe.SessionManipulator;
import com.bmc.ctmconvert.dollar_universe.condition.CleanUpConditionsHandler;
import com.bmc.ctmconvert.dollar_universe.handlers.DollarUniverseDummyEntityHandler;
import com.bmc.ctmconvert.dollar_universe.handlers.DollarUniverseTaskOffsetHandler;
import com.bmc.ctmconvert.dollar_universe.handlers.HandlerEndFolderDummyJobTriggeredByFolderJobs;
import com.bmc.ctmconvert.dollar_universe.handlers.ReferenceJobHandler;
import com.bmc.ctmconvert.dollar_universe.handlers.SapApiCommandConverter;
import com.bmc.ctmconvert.dollar_universe.handlers.UprStatusHandler;
import com.bmc.ctmconvert.dollar_universe.hdpmu.HdpHandler;
import com.bmc.ctmconvert.dollar_universe.hdpmu.HdpHandlerFactory;
import com.bmc.ctmconvert.dollar_universe.hdpmu.MuHierarchy;
import com.bmc.ctmconvert.dollar_universe.hdpmu.NoHDP;
import com.bmc.ctmconvert.dollar_universe.launch_window.LaunchWindow;
import com.bmc.ctmconvert.dollar_universe.launch_window.LaunchWindowCrossesNewdayCalculator;
import com.bmc.ctmconvert.dollar_universe.launch_window.LaunchWindowCrossesNewdayMessageIssuer;
import com.bmc.ctmconvert.dollar_universe.launch_window.LaunchWindowFactory;
import com.bmc.ctmconvert.dollar_universe.launch_window.NewdayTimeRule;
import com.bmc.ctmconvert.dollar_universe.session.DollarUniverseSession;
import com.bmc.ctmconvert.dollar_universe.session.SessionEntry;
import com.bmc.ctmconvert.ondo.Do;
import com.bmc.ctmconvert.ondo.DoCondition;
import com.bmc.ctmconvert.ondo.DoMail;
import com.bmc.ctmconvert.ondo.DoStopCyclic;
import com.bmc.ctmconvert.ondo.OnStatement;
import com.bmc.ctmconvert.rules.RulesDataSet;
import com.bmc.ctmconvert.shouts.ShoutsGenerator;
import com.bmc.ctmconvert.utils.Pair;
import com.bmc.ctmconvert.utils.PropertiesBuilder;
import com.bmc.ctmconvert.utils.UniqueConditionNameGenerator;
import com.bmc.ctmconvert.utils.UniqueValueGenerator;
import com.bmc.ctmconvert.vc.FieldValidation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;

public class DollarUniverseJob
implements SchedEntity {
    private static final CtmPriority priorityCalculator = new CtmPriority(1, 255);
    private static List<String> extMessages = null;
    private final ArrayList<String> messages = new ArrayList();
    private final Map<String, String> attributes = new HashMap<String, String>();
    private final LinkedHashMap<String, String> autoedits = new LinkedHashMap();
    private final List<Properties> parentTags = new ArrayList<Properties>();
    protected SchedEntity.TYPE type;
    private String uprFieldName;
    private RulesDataSet rules = null;
    private DollarUniverseJob parent;
    private boolean validEntity = true;
    private boolean standAloneJob = false;
    private IAttrHolder sessionUprAttributes = null;
    private DollarUniverseDefs sourceDefinitions;
    private DollarUniverseUprAttributes uprAttributes = null;
    private DollarUniverseTaskAttributes sourceTaskDefinition;
    private List<String> optionalAttributes;
    private boolean isHeaderJob = false;
    private List<Properties> onStatements = null;
    private List<AssistingJob> assistingJobs = null;
    private String fatherUpr = null;
    private String uprUpdatedRule;
    private List<SchedEntity> children;
    private List<Properties> rbcs;
    private LinkedHashMap<Properties, List<Properties>> onDoList;
    private ArrayList<Properties> shouts = null;
    private HdpHandler.HdpExpressionHandler hdpHandler;
    private List<Properties> inConditions;
    private List<Properties> outConds;
    private CleanUpConditionsHandler cleanUpConditionsHandler;
    private RbcGenerator rbcGenerator;
    private ResourceConvertor resourceConvertor;
    private DollarUniverseSession session;
    private DollarUniverseDummyEntityHandler dummyEntityHandler;
    private boolean handleDuxAUTOSETVariable = false;
    private UniqueValueGenerator uniqueValueGenerator;
    private UniqueConditionNameGenerator uniqueConditionNameGenerator;
    private HandlerEndFolderDummyJobTriggeredByFolderJobs handlerEndFolderDummyJob;
    private String containsFileWatcherJob = null;
    private boolean canceledJob = false;

    public DollarUniverseJob(String id, DollarUniverseDefs defs, UniqueValueGenerator uniqueValueGenerator) {
        this.constructTopLevel(id, defs, uniqueValueGenerator);
    }

    public DollarUniverseJob(String id, DollarUniverseJob parent, DollarUniverseDefs defs, UniqueValueGenerator uniqueValueGenerator) {
        this.init(defs, null);
        this.sourceTaskDefinition = this.sourceDefinitions.getChildrenForSessionWithoutTaskFolder().get(id);
        this.uniqueValueGenerator = uniqueValueGenerator;
        String sessionId = Session.sessionId(this.taskParameterValue("ses"), this.taskParameterValue("upr"), this.taskParameterValue("node name"));
        DollarUniverseSessionAttributes taskSession = this.sourceDefinitions.getSessions().get(sessionId);
        MuHierarchy muHierarchy = this.sourceDefinitions.getMuDependencies();
        this.session = new DollarUniverseSession(taskSession, "", muHierarchy);
        this.sessionUprAttributes = taskSession.getAttributes();
        this.hdpHandler = new NoHDP();
        this.isHeaderJob = false;
        this.type = SchedEntity.TYPE.SUB_TABLE;
        this.initSmartTable();
        this.parent = parent;
        this.setField("PARENT_TABLE", this.getParentName());
    }

    public DollarUniverseJob() {
    }

    public DollarUniverseJob(IAttrHolder sessionUprAttributes, DollarUniverseJob parent, DollarUniverseDefs defs) {
        this.constructChild(sessionUprAttributes, parent, defs);
    }

    public static void addExtReporterMessage(String msgId, String session, String mu, String jobName, String ... stringsArr) {
        if (extMessages == null) {
            extMessages = new ArrayList<String>();
        }
        Reporter.addMessage(extMessages, (String)msgId, (String)DollarUniverseJob.buildJobIdKey(session, mu, jobName), (String[])stringsArr);
    }

    public static String buildJobIdKey(String session, String mu, String jobName) {
        return Stream.of(session, mu, jobName).filter(Objects::nonNull).collect(Collectors.joining("#"));
    }

    private void init(DollarUniverseDefs defs, UniqueValueGenerator uniqueValueGenerator) {
        this.sourceDefinitions = defs;
        this.resourceConvertor = this.sourceDefinitions.getResourceConvertor();
        this.rbcGenerator = defs.getRbcGenerator();
        this.rules = defs.getRules();
        this.cleanUpConditionsHandler = new CleanUpConditionsHandler(this.rules);
        this.dummyEntityHandler = new DollarUniverseDummyEntityHandler();
        this.uniqueValueGenerator = uniqueValueGenerator;
        this.uniqueConditionNameGenerator = new UniqueConditionNameGenerator("_");
        this.handlerEndFolderDummyJob = new HandlerEndFolderDummyJobTriggeredByFolderJobs(this.rules, this.uniqueConditionNameGenerator);
    }

    public void addAttribute(String key, String value) {
        this.attributes.put(key, value);
    }

    public void addOnDoStmt(OnStatement onStatement) {
        OnStatement.addOnToOnMap(this.getOnDoStmt(), (OnStatement)onStatement);
    }

    public void addAutoEdits(String key, String value) {
        this.autoedits.put(key, value);
    }

    protected void constructTopLevel(String id, DollarUniverseDefs defs, UniqueValueGenerator uniqueValueGenerator) {
        this.init(defs, uniqueValueGenerator);
        this.sourceTaskDefinition = this.sourceDefinitions.getSessionTasks().get(id);
        this.hdpHandler = new NoHDP();
        this.isHeaderJob = false;
        if (this.sourceTaskDefinition == null) {
            this.type = SchedEntity.TYPE.JOB;
            this.sourceTaskDefinition = this.sourceDefinitions.getUPRTasks().get(id);
            String uprId = this.getUprIdByTaskOrSession(this.sourceTaskDefinition.getAttributes().getAttr("upr"));
            this.uprAttributes = this.sourceDefinitions.getUprs().get(uprId);
            if (this.uprAttributes == null) {
                Reporter.addMessage(this.messages, (String)"ERR7003", (String)this.getOriginalJobName(), (String[])new String[]{this.sourceTaskDefinition.getAttributes().getAttr("upr"), "", id});
            }
            this.standAloneJob = true;
            this.initJob();
        } else {
            this.type = SchedEntity.TYPE.SMART_TABLE;
            this.initSmartTable();
        }
    }

    public String getUprIdByTaskOrSession(String uprName) {
        String node = this.getNodeName();
        return uprName + "_" + node;
    }

    public String getUprIdByUprAttributes() {
        return this.getUprAttribute("upr") + "_" + this.getUprAttribute("node_name");
    }

    public void constructReferenceSubFolder(ReferenceJobHandler referenceJobHandler, IAttrHolder sessionUprAttributes, DollarUniverseJob parent, DollarUniverseDefs defs) {
        this.init(defs, this.uniqueValueGenerator);
        String sessionId = Session.sessionId("TemplateJobs", "", sessionUprAttributes.getAttr("node name"));
        this.sourceTaskDefinition = this.sourceDefinitions.getSessionTasks().get(referenceJobHandler.getUprIdBySessionUprAttributes());
        DollarUniverseSessionAttributes taskSession = this.sourceDefinitions.getSessions().get(sessionId);
        MuHierarchy muHierarchy = this.sourceDefinitions.getMuDependencies();
        this.session = new DollarUniverseSession(taskSession, "", muHierarchy);
        this.sessionUprAttributes = sessionUprAttributes;
        String uprId = this.getUprIdByTaskOrSession(this.getSessionUprAttribute(parent.getUprFieldName()));
        this.uprAttributes = this.sourceDefinitions.getUprs().get(uprId);
        this.hdpHandler = new NoHDP();
        this.type = SchedEntity.TYPE.SUB_TABLE;
        referenceJobHandler.process(this);
        this.initSmartTable();
        this.parent = parent;
        this.isHeaderJob = this.getParent().uprFieldName.equals("Father");
        this.setField("PARENT_TABLE", this.getParentName());
        this.addOnDoNotOkConditionWhenReturnCodeIsAsterisk();
        this.handelOutConditionForEndFolderJob();
    }

    protected void constructChild(IAttrHolder sessionUprAttributes, DollarUniverseJob parent, DollarUniverseDefs defs) {
        ReferenceJobHandler referenceJobHandler = new ReferenceJobHandler(sessionUprAttributes, parent, defs);
        if (referenceJobHandler.isTemplateJob()) {
            this.constructReferenceSubFolder(referenceJobHandler, sessionUprAttributes, parent, defs);
        } else {
            this.init(defs, this.uniqueValueGenerator);
            this.updateStandAloneFlag(sessionUprAttributes, parent);
            this.type = SchedEntity.TYPE.JOB;
            this.parent = parent;
            this.sessionUprAttributes = sessionUprAttributes;
            String uprId = this.getUprIdByTaskOrSession(this.getSessionUprAttribute(parent.getUprFieldName()));
            this.uprAttributes = this.sourceDefinitions.getUprs().get(uprId);
            this.isHeaderJob = this.getParent().uprFieldName.equals("Father");
            Integer uprocNumber = this.getUprocNumber();
            this.hdpHandler = HdpHandlerFactory.createHendler(uprocNumber, this.parent.getSession());
            this.initJob();
        }
    }

    private void updateStandAloneFlag(IAttrHolder sessionUprAttributes, DollarUniverseJob parent) {
        if (parent.getJobName().contains("StandAloneJobs")) {
            this.sourceTaskDefinition = this.sourceDefinitions.getUPRTasks().get(sessionUprAttributes.getAttr("ID"));
            this.standAloneJob = true;
        }
    }

    public Integer getUprocNumber() {
        SessionEntry session = new SessionEntry(this.sessionUprAttributes, this.getSession());
        if (this.isHeaderJob()) {
            return session.getFatherNumber();
        }
        return session.getSonNumber();
    }

    private void initCommon() {
        this.setPriority(this.getTaskAttribute("prty"));
        this.setField("OWNER", this.applyFieldConversion("OWNER"));
        this.setField("AUTHOR", this.applyFieldConversion("AUTHOR"));
        this.setField("APPLICATION", this.applyFieldConversion("APPLICATION"));
        this.setField("GROUP", this.applyFieldConversion("GROUP"));
        this.setField("DESCRIPTION", this.applyFieldConversion("DESCRIPTION"));
    }

    private void initSmartTable() {
        TASKTYPES taskType = this.getTaskType(this.taskParameterValue("type"));
        if (taskType == TASKTYPES.optional || taskType == TASKTYPES.illegal) {
            Reporter.addMessage(this.messages, (String)"WRN7017", (String)this.getTaskAttribute("upr"), (String[])new String[]{this.sourceTaskDefinition.getName(), this.taskParameterValue("type"), this.getTaskAttribute("upr")});
            this.validEntity = false;
            return;
        }
        this.initCommon();
        this.parent = null;
        this.setTableName();
        this.getCommonAutoedits();
        if (taskType == TASKTYPES.provoked) {
            this.attributes.put("TABLE_USERDAILY", "");
        }
        if (this.sourceDefinitions.isDisabledTask(this.sourceTaskDefinition)) {
            this.attributes.put("TABLE_USERDAILY", "DISABLED");
        }
        this.setTimeZone();
        this.handleTaskScheduling();
        this.handleVariableuxAUTOSEL(this.getAutoeditsFromLaunchvar(this.taskParameterValue("launchvar")));
    }

    private void setTableName() {
        Object value = this.rules.getStringRule("DOLLAR UNIVERSE rules", new String[]{"AREA"}) + "_" + this.taskParameterValue("ses") + "_" + this.taskParameterValue("mu") + this.getNodeNameSuffixIfExist();
        if (this.taskParameterValue("ID").contains("SessionsWithoutATask") && this.taskParameterValue("ses").isEmpty()) {
            value = "SessionsWithoutATask";
        }
        if (this.taskParameterValue("ID").contains("TemplateJobs") && this.isSubTable()) {
            value = this.taskParameterValue("node name");
        }
        String fixedTableName = this.isReferenceSubFolder() ? this.taskParameterValue("ID") : FieldValidation.instance().validateAndReturnFixedUniqueValue("TABLE_NAME", "Folder Name", (String)value, true, "Session/Task Name", this.getOriginalJobName(), new ArrayList(), this.uniqueValueGenerator, "TABLE_NAME", 64, "_", true);
        this.attributes.put("TABLE_NAME", fixedTableName);
        this.setJobName(fixedTableName);
    }

    public boolean isReferenceSubFolder() {
        String isReferencedAttr = this.getAttr("IS_REFERENCE");
        return isReferencedAttr != null && isReferencedAttr.equals("1");
    }

    private void handleTaskScheduling() {
        this.setLaunchWindow();
        this.handleOffset();
    }

    private void setPriority(String inPriority) {
        if (this.sourceDefinitions.convertPriority()) {
            GlobalFunctions.getNumberFrom((String)inPriority).map(arg_0 -> ((CtmPriority)priorityCalculator).calculatePriority(arg_0)).ifPresent(priority -> this.attributes.put("PRIORITY", (String)priority));
        }
    }

    private HashMap<String, String> timeWindowThatCrossesNewdayMapper(HashMap<String, String> launchWindowAttributes) {
        String newDayTime = this.getNewDayTime();
        LaunchWindowCrossesNewdayMessageIssuer messageIssuer = new LaunchWindowCrossesNewdayMessageIssuer(this::addReporterMessage, launchWindowAttributes, this.getOriginalJobName(), newDayTime);
        return new LaunchWindowCrossesNewdayCalculator(launchWindowAttributes, messageIssuer, newDayTime).handleTimeWindowThatCrossesNewday();
    }

    private String getNewDayTime() {
        NewdayTimeRule newdayTimeRule = new NewdayTimeRule(this.rules);
        return newdayTimeRule.getNewDay();
    }

    private void setLaunchWindow() {
        LaunchWindowFactory launchWindowFactory = new LaunchWindowFactory(this.sourceTaskDefinition, this);
        launchWindowFactory.getLaunchWindow().map(LaunchWindow::getAttributes).map(this::timeWindowThatCrossesNewdayMapper).ifPresent(this.attributes::putAll);
    }

    private void handleOffset() {
        String fromTime = this.getAttr("TIMEFROM");
        String newDayTime = this.getNewDayTime();
        DollarUniverseTaskOffsetHandler taskOffsetHandler = new DollarUniverseTaskOffsetHandler(this.sourceTaskDefinition, fromTime, newDayTime, this::addMessageWithJobName);
        taskOffsetHandler.handle();
    }

    private void setField(String field, String value) {
        String validateValue = this.validateField(field, value);
        this.attributes.put(field, validateValue);
    }

    private void setAutoedit(String key, String value) {
        this.autoedits.put(key, value);
    }

    private void initJob() {
        if (this.uprAttributes == null) {
            this.validEntity = false;
            return;
        }
        this.initCommon();
        if (!this.standAloneJob && this.getParent().uprFieldName.equals("Father")) {
            this.isHeaderJob = true;
        }
        this.setJobName(this.createUniqueJobName(this.applyFieldConversion("JOBNAME")));
        this.attributes.put("ACTIVE_TILL", "");
        if (this.standAloneJob) {
            this.attributes.put("ACTIVE_FROM", this.convertDate(this.getTaskAttribute("sdate")));
        } else {
            this.attributes.put("ACTIVE_FROM", this.convertDate(this.parent.getTaskAttribute("sdate")));
        }
        this.updateJobAccordingToMuAttributes();
        this.updateJobHostNameAccordingToSessionNodeID();
        this.updateTasktype();
        this.attributes.put("CYCLIC", "0");
        this.attributes.put("MAXRERUN", "0");
        this.attributes.put("TAG_RELATIONSHIP", "OR");
        this.getUprAutoedits();
        this.addOnDoFromUprStatus();
        if (!this.standAloneJob) {
            if (!this.isHeaderJob) {
                this.updateUprTaskAttributes();
            }
            this.createDefaultNotokOutCond();
            this.addMaxWaitToJobIfParentHasAllowSubmissionPastNextNewDay();
        } else {
            String value = this.rules.getStringRule("DOLLAR UNIVERSE rules", new String[]{"AREA"}) + "_" + this.taskParameterValue("mu") + "_" + this.taskParameterValue("upr") + this.getNodeNameSuffixIfExist();
            this.attributes.put("TABLE_NAME", FieldValidation.instance().validateAndReturnFixedValue("TABLE_NAME", value));
        }
        this.handleNotify();
        this.handleRetry();
        if (this.standAloneJob) {
            this.handleTaskScheduling();
        }
        if (!this.isParentHandledUXAUTOSEL()) {
            this.handleVariableuxAUTOSEL(this.autoedits);
        }
        if (!this.isTemplatesFolder()) {
            if (!this.standAloneJob) {
                this.addOnDoNotOkConditionWhenReturnCodeIsAsterisk();
            }
            this.handelOutConditionForEndFolderJob();
        } else {
            this.setJobNameForTemplateJob();
            this.clearDefaultOutCondsAndFileResInConds();
        }
        this.checkHeaderAndTrailerRule();
    }

    private void addOnDoFromUprStatus() {
        String uprKey = this.getUprIdByUprAttributes();
        IAttrHolder uptAttr = this.sourceDefinitions.getUprs().get(uprKey).getAttributes();
        UprStatusHandler uprStatusHandler = new UprStatusHandler(uptAttr);
        for (OnStatement onDoAction : uprStatusHandler.getOnDoActions()) {
            OnStatement.addOnToOnMap(this.getOnDoList(), (OnStatement)onDoAction);
        }
    }

    private void checkHeaderAndTrailerRule() {
        Pair<String, String> headerAndTrailer;
        if (this.sourceDefinitions.isRemoveHeadersAndTrailersRuleEnabled() && !this.isStandAloneJob() && (headerAndTrailer = this.sourceDefinitions.getHeaderAndTrailerOfSession(this.getSessionId())) != null) {
            String upr = this.sessionUprAttributes.getAttr(this.parent.getUprFieldName());
            boolean isHeader = ((String)headerAndTrailer.getKey()).equals(upr);
            boolean isTrailer = ((String)headerAndTrailer.getValue()).equals(upr);
            if (isHeader || isTrailer) {
                this.canceledJob = true;
                if (isHeader) {
                    this.addAllHeaderInConditionsToParentLevel(this.inConditions, this.parent);
                } else {
                    this.addAllTrailerOutCondtionsToParentLevel(this.outConds, this.parent);
                }
            }
        }
    }

    public boolean isRemoveHeaderAndTrailerRuleEnabled() {
        return this.sourceDefinitions.isRemoveHeadersAndTrailersRuleEnabled();
    }

    private void clearDefaultOutCondsAndFileResInConds() {
        this.getOutConds().clear();
        this.getInConds().clear();
    }

    public void setJobNameForTemplateJob() {
        this.setJobName(this.getOriginalJobName());
    }

    private void handelOutConditionForEndFolderJob() {
        if (this.handlerEndFolderDummyJob.checkIfJobHasInCondFromFW(this.getInConds()) && this.getParentContainsFwJobAttr() == null) {
            this.getParent().containsFileWatcherJob = this.getResNameByUprId();
        }
        if (this.getParent() != null && this.getParentContainsFwJobAttr() != null) {
            this.addOutCondtions(this.handlerEndFolderDummyJob.addOutCondForEndFolderJob(this.getJobName(), this.getParent().getJobName()));
        }
    }

    private String getResNameByUprId() {
        return this.resourceConvertor.getResNameByUprId(this.getUprIdByUprAttributes());
    }

    private String getNodeNameSuffixIfExist() {
        String nodeName = this.taskParameterValue("node name");
        if (nodeName == null) {
            return "";
        }
        if (nodeName.trim().isEmpty()) {
            return "";
        }
        return "_" + nodeName;
    }

    private void addMaxWaitToJobIfParentHasAllowSubmissionPastNextNewDay() {
        if (this.getParent().getAttr("TIMETO") != null && this.getParent().getAttr("TIMETO").equals(">")) {
            this.attributes.put("MAXWAIT", "01");
            Reporter.addMessage(this.messages, (String)"WRN7046", (String)this.getOriginalJobId(), (String[])new String[]{this.getOriginalJobName(), this.getJobName()});
        } else {
            this.attributes.put("MAXWAIT", "00");
        }
    }

    private String createUniqueJobName(String jobName) {
        return Optional.ofNullable(this.uniqueValueGenerator).map(uvg -> uvg.getUniqueValue("JOBNAME", jobName)).orElse(jobName);
    }

    private void addOnDoNotOkConditionWhenReturnCodeIsAsterisk() {
        this.getOutConds().stream().filter(outCondition -> "ADD".equals(outCondition.getProperty("SIGN"))).map(outCondition -> outCondition.getProperty("NAME")).filter(outConditionName -> this.session.hasAsteriskReturnCode((String)outConditionName, this.getTableName())).forEach(outConditionName -> {
            OnStatement.OnNotOkStatement onNotOkStatement = OnStatement.createOnNotOkStatement();
            DoCondition doCondition = Do.createDoCondition((String)outConditionName, (DoCondition.AddRemoveSign)DoCondition.AddRemoveSign.ADD);
            onNotOkStatement.addDo((Do)doCondition);
            this.addOnDoStmt((OnStatement)onNotOkStatement);
        });
    }

    private boolean hasMu() {
        return this.hasMu(this.getTaskAttribute("mu"), this.getTaskAttribute("node name"));
    }

    private void handleVariableuxAUTOSEL(Map<String, String> autoeditMap) {
        String uxAUTOSEVar = autoeditMap.get("%%uxAUTOSEL");
        this.handleDuxAUTOSETVariable = this.dummyEntityHandler.handle(this.type(), uxAUTOSEVar, this::setField, this::setAutoedit, this.attributes::get);
    }

    private void updateJobAccordingToMuAttributes() {
        if (this.hasMu()) {
            this.setTimeZone();
        } else {
            this.issueWarningAboutMUNotFound();
        }
    }

    private void issueWarningAboutMUNotFound() {
        String taskMuName = this.getTaskAttribute("mu");
        String taskUPRName = this.getTaskAttribute("upr");
        Reporter.addMessage(this.messages, (String)"WRN7024", (String)this.getOriginalJobId(), (String[])new String[]{taskMuName, taskUPRName});
    }

    public void updateJobHostNameAccordingToSessionNodeID() {
        if (this.hasMu()) {
            IAttrHolder attr = this.getTaskMuAttributes();
            String tnode = attr.getAttr("tnode");
            this.setNodeId(tnode);
        } else {
            this.issueWarningAboutMUNotFound();
            String sessionNodeID = this.getOriginalSessionNode();
            String taskNodeID = this.getOriginalTaskNode();
            if (sessionNodeID != null && !sessionNodeID.isEmpty()) {
                this.setNodeId(sessionNodeID);
            } else if (taskNodeID != null && !taskNodeID.isEmpty()) {
                this.setNodeId(taskNodeID);
            } else {
                this.setNodeId("DEFAULT_HOST");
            }
        }
    }

    public String getOriginalSessionId() {
        return this.getSessionUprAttribute("ses");
    }

    public String getSessionId() {
        return this.getSessionUprAttribute("ID");
    }

    public String getOriginalSessionNode() {
        return this.getSessionUprAttribute("node name");
    }

    public String getNodeName() {
        String nodeSession = this.getSessionUprAttribute("node name");
        String nodeName = "";
        nodeName = nodeSession != null && !nodeSession.isEmpty() ? nodeSession : this.getOriginalTaskNode();
        return nodeName;
    }

    public String getOriginalTaskNode() {
        if (this.sourceTaskDefinition != null) {
            return this.taskParameterValue("node name");
        }
        return "";
    }

    public String getOriginalSessionFather() {
        return this.getSessionUprAttribute("Father");
    }

    public String getOriginalSessionNumF() {
        return this.getSessionUprAttribute("NumF");
    }

    public String getOriginalSessionSon() {
        return this.getSessionUprAttribute("Son");
    }

    public String getOriginalSessionNumS() {
        return this.getSessionUprAttribute("NumS");
    }

    private boolean hasMu(String muName, String commandNode) {
        String muId = MUTable.buildMuId(muName, commandNode);
        DollarUniverseMUAttributes muAttributes = this.sourceDefinitions.getMUs().get(muId);
        return muAttributes != null && muAttributes.getAttributes() != null;
    }

    private IAttrHolder getTaskMuAttributes() {
        return this.sourceDefinitions.getMuAttributes(this.getTaskAttribute("mu"), this.getTaskAttribute("node name"));
    }

    public String getOriginalSessionPath() {
        return this.getSessionUprAttribute("Path");
    }

    public DollarUniverseJob getParent() {
        return this.parent;
    }

    public boolean isHeaderJob() {
        return this.isHeaderJob;
    }

    public String getOriginalSessionJobName() {
        if (this.isHeaderJob()) {
            return this.getSessionUprAttribute("Father");
        }
        return this.getSessionUprAttribute("Son");
    }

    public String applyFieldConversion(String field) {
        return this.rules.getFieldEditor().generateCTMField(field, this::getValueForFieldConversion);
    }

    public String getOriginalSessionJobNum() {
        if (this.isHeaderJob()) {
            return this.getSessionUprAttribute("NumF");
        }
        return this.getSessionUprAttribute("NumS");
    }

    public String getOriginalJobId() {
        if (this.type.equals((Object)SchedEntity.TYPE.JOB)) {
            String retJobId = this.getOriginalJobName();
            String sessionId = this.getOriginalSessionId();
            if (sessionId != null && !sessionId.isEmpty()) {
                retJobId = String.format("%s@%s", this.getOriginalJobName(), sessionId);
            }
            return retJobId;
        }
        return this.getOriginalJobName();
    }

    public String getApplication() {
        return this.attributes.get("APPLICATION");
    }

    private String validateField(String field, String convertedString) {
        String validatedValue = FieldValidation.instance().validateAndReturnFixedValue(field, convertedString);
        if (validatedValue.compareTo(convertedString) != 0) {
            String msgID = convertedString.length() != validatedValue.length() ? "INF0013" : "INF0014";
            Reporter.addMessage(this.messages, (String)msgID, (String)this.getOriginalJobId(), (String[])new String[]{this.getAttr("JOBNAME"), convertedString, validatedValue});
            convertedString = validatedValue;
        }
        return convertedString;
    }

    private String getValueForFieldConversion(String field) {
        String toRet = field.equalsIgnoreCase("UPROC") ? this.getUprAttribute("upr") : (field.equalsIgnoreCase("LABEL") ? (this.isJob() ? this.getUprAttribute("label") : this.getSessionAttributeValue()) : (field.equalsIgnoreCase("APPLICATION") ? (this.isJob() ? this.getUprAttribute("appl") : this.getHeaderSessionUprAttributeValue()) : (field.equalsIgnoreCase("MANAGEMENT_UNIT") ? this.getTaskAttribute("mu") : (field.equalsIgnoreCase("USER") ? this.getTaskAttribute("user") : (field.equalsIgnoreCase("NUM") ? (this.standAloneJob ? "" : this.getOriginalSessionJobNum()) : field)))));
        while (toRet.matches("^\".*\"$")) {
            toRet = toRet.replaceAll("^\"", "").replaceAll("\"$", "");
        }
        return toRet;
    }

    public String getAttr(String attrName) {
        return this.attributes.get(attrName);
    }

    public LinkedHashMap<String, String> getAutoedits() {
        return this.autoedits;
    }

    public List<AssistingJob> getAssistingJobs() {
        if (this.assistingJobs == null && !this.isSubTable()) {
            this.assistingJobs = new ArrayList<AssistingJob>();
            ArrayList<AssistingJob> fwJobs = this.resourceConvertor.getResconFwJobs(this.getUprIdByUprAttributes());
            if (fwJobs != null && !this.isTemplatesFolder()) {
                for (AssistingJob assisting : fwJobs) {
                    AssistingJob clonedAssistingJob = assisting.copy();
                    this.completeFwJobAttrs(clonedAssistingJob, this.handlerEndFolderDummyJob);
                    this.assistingJobs.add(clonedAssistingJob);
                }
                if (this.isEndFolderForJobsNeeded() && !this.isTemplatesFolder()) {
                    this.assistingJobs.add(this.handlerEndFolderDummyJob.initEndFolderJob(this));
                }
            }
        }
        return this.assistingJobs;
    }

    private boolean isEndFolderForJobsNeeded() {
        return this.getParentContainsFwJobAttr() != null && this.getParentContainsFwJobAttr().equals(this.getResNameByUprId());
    }

    private boolean isTemplatesFolder() {
        return this.getParent() == null ? false : this.getParentName().contains("TemplateJobs");
    }

    private String getParentContainsFwJobAttr() {
        return this.getParent().containsFileWatcherJob;
    }

    private List<SchedEntity> getChildrenForUPROCsAndSessionsWithoutATask() {
        ArrayList<SchedEntity> childs = new ArrayList<SchedEntity>();
        Map<String, DollarUniverseTaskAttributes> uprocs = this.sourceDefinitions.getChildrenForSessionWithoutTaskFolder();
        for (DollarUniverseTaskAttributes iAttrHolder : uprocs.values()) {
            String session = iAttrHolder.getAttributes().getAttr("ses");
            DollarUniverseJob subFolder = new DollarUniverseJob(session, this, this.sourceDefinitions, this.uniqueValueGenerator);
            subFolder.getChildren();
            subFolder.addMessageWithJobName("WRN7047", new String[0]);
            childs.add(subFolder);
        }
        this.children = childs;
        return childs;
    }

    private List<SchedEntity> getChildenForUPROCsWithoutASession() {
        ArrayList<SchedEntity> childs = new ArrayList<SchedEntity>();
        String sessionId = Session.sessionId(this.taskParameterValue("ses"), this.taskParameterValue("upr"), this.taskParameterValue("node name"));
        DollarUniverseSessionAttributes taskSession = this.sourceDefinitions.getSessions().get(sessionId);
        MuHierarchy muHierarchy = this.sourceDefinitions.getMuDependencies();
        SessionManipulator sessionManipulator = new SessionManipulator(this.session, muHierarchy, this.sourceDefinitions);
        AttrHolderList uprs = taskSession.getUprs();
        this.uprFieldName = "Son";
        for (IAttrHolder upr : uprs) {
            SchedEntity sonJob = this.sourceDefinitions.spawnJob(this, upr);
            sessionManipulator.addConvertedUprocInSession(upr, (DollarUniverseJob)sonJob);
            childs.add(sonJob);
        }
        this.children = childs;
        return childs;
    }

    private void completeFwJobAttrs(AssistingJob assisting, HandlerEndFolderDummyJobTriggeredByFolderJobs handlerEndFolderDummyJob) {
        String tmpNode;
        if (this.sourceDefinitions.isToDummy()) {
            assisting.setAttribute("TASKTYPE", "Dummy");
        }
        assisting.setAttribute("APPLICATION", this.getApplication());
        assisting.setAttribute("GROUP", FieldValidation.instance().validateAndReturnFixedValue("GROUP", this.getGroup()));
        assisting.setAttribute("OWNER", this.getAttr("OWNER"));
        assisting.setAttribute("AUTHOR", this.getAttr("AUTHOR"));
        assisting.setAttribute("PARENT_TABLE", FieldValidation.instance().validateAndReturnFixedValue("PARENT_TABLE", this.getParentName()));
        assisting.setAttribute("TAG_RELATIONSHIP", this.getAttr("TAG_RELATIONSHIP"));
        assisting.setAttribute("PRIORITY", this.getAttr("PRIORITY"));
        assisting.setM_tags(this.getTags());
        this.AddParentNameToTheOutConditions(assisting);
        handlerEndFolderDummyJob.UpdateJobAndCondsNamesForEndFolderJob(assisting, this);
        ArrayList inconds = (ArrayList)this.getAssitingJobInConds();
        if (inconds != null) {
            for (Properties tmpCond : inconds) {
                assisting.addInCondition(tmpCond);
            }
        }
        if ((tmpNode = (tmpNode = assisting.getAttr("NODEID")).equalsIgnoreCase("same") || tmpNode.equalsIgnoreCase("any") ? this.getAttr("NODEID") : this.sourceDefinitions.managmentUnitToPhysicalNode(tmpNode)) != null) {
            String validatedNodeID = FieldValidation.instance().validateAndReturnFixedValue("NODEID", tmpNode, true, "mu", assisting.getJobName(), (List)assisting.getMessages());
            assisting.setAttribute("NODEID", validatedNodeID);
        }
    }

    private void AddParentNameToTheOutConditions(AssistingJob assisting) {
        List outConds = assisting.getOutConds();
        List resConds = outConds.stream().filter(c -> c.getProperty("NAME").contains("RES")).collect(Collectors.toList());
        for (Properties resCond : resConds) {
            String condName = resCond.getProperty("NAME");
            String condNameWithParentName = String.format(condName, this.getParent().getJobName());
            resCond.setProperty("NAME", condNameWithParentName);
        }
    }

    public List<SchedEntity> getChildren() {
        if (this.children != null) {
            return this.children;
        }
        if (this.isJob() || this.isReferenceSubFolder()) {
            return null;
        }
        if ("SessionsWithoutATask".equals(this.getJobName())) {
            return this.getChildrenForUPROCsAndSessionsWithoutATask();
        }
        if (this.getJobName().contains("StandAloneJobs")) {
            return this.getChildenForUPROCsWithoutASession();
        }
        if (this.getJobName().contains("TemplateJobs") && !this.sourceDefinitions.isDataWithoutNodes()) {
            return this.getChildrenForTemplatesFolder();
        }
        return this.getChildrenForTaskSession();
    }

    private List<SchedEntity> getChildrenForTemplatesFolder() {
        ArrayList<SchedEntity> childrens = new ArrayList<SchedEntity>();
        this.uprFieldName = "Son";
        List<String> nodesWithTemplateUprs = this.sourceDefinitions.getNodesWithTemplateUprs();
        for (String nodeName : nodesWithTemplateUprs) {
            DollarUniverseJob subFolder = new DollarUniverseJob(this.uniqueValueGenerator, "TemplateJobs", this, this.sourceDefinitions, nodeName);
            subFolder.getChildren();
            childrens.add(subFolder);
        }
        this.children = childrens;
        return childrens;
    }

    public DollarUniverseJob(UniqueValueGenerator uniqueValueGenerator, String subFolderTaskId, DollarUniverseJob parent, DollarUniverseDefs defs, String nodeName) {
        this.init(defs, uniqueValueGenerator);
        String sessionId = Session.sessionId(subFolderTaskId, "", nodeName);
        this.sourceTaskDefinition = this.sourceDefinitions.getSessionTasks().get(sessionId);
        this.uniqueValueGenerator = uniqueValueGenerator;
        DollarUniverseSessionAttributes taskSession = this.sourceDefinitions.getSessions().get(sessionId);
        MuHierarchy muHierarchy = this.sourceDefinitions.getMuDependencies();
        this.session = new DollarUniverseSession(taskSession, "", muHierarchy);
        this.sessionUprAttributes = taskSession.getAttributes();
        this.hdpHandler = new NoHDP();
        this.isHeaderJob = false;
        this.type = SchedEntity.TYPE.SUB_TABLE;
        this.initSmartTable();
        this.parent = parent;
        this.setField("PARENT_TABLE", this.getParentName());
    }

    private List<SchedEntity> getChildrenForTaskSession() {
        SchedEntity fatherJob;
        ArrayList<SchedEntity> jobs = new ArrayList<SchedEntity>();
        String sessionId = Session.sessionId(this.taskParameterValue("ses"), this.taskParameterValue("upr"), this.taskParameterValue("node name"));
        DollarUniverseSessionAttributes taskSession = this.sourceDefinitions.getSessions().get(sessionId);
        DollarUniverseSession session = this.getSession();
        MuHierarchy muHierarchy = this.sourceDefinitions.getMuDependencies();
        SessionManipulator sessionManipulator = new SessionManipulator(session, muHierarchy, this.sourceDefinitions);
        this.uprFieldName = "Father";
        if (!this.existUpr(taskSession.getAttributes().getAttr(this.uprFieldName), this.getNodeName())) {
            Reporter.addMessage(this.messages, (String)"ERR7001", (String)taskSession.getAttributes().getAttr(this.uprFieldName), (String[])new String[]{sessionId, this.taskParameterValue("ID")});
            return null;
        }
        if (!taskSession.getAttributes().isFieldExist("isTemplateSubFolder") && !((DollarUniverseJob)(fatherJob = this.sourceDefinitions.spawnJob(this, taskSession.getAttributes()))).isCanceledJob()) {
            sessionManipulator.setHeader(taskSession.getAttributes(), (DollarUniverseJob)fatherJob);
            jobs.add(fatherJob);
        }
        this.fatherUpr = taskSession.getAttributes().getAttr(this.uprFieldName);
        this.uprFieldName = "Son";
        AttrHolderList uprs = taskSession.getUprs();
        for (IAttrHolder upr : uprs) {
            if (this.existUpr(upr.getAttr(this.uprFieldName), this.getNodeName())) {
                SchedEntity sonJob;
                String father = upr.getAttr("Father");
                if (father != null && !(father = father.trim()).isEmpty() && !father.equals(this.fatherUpr)) {
                    this.fatherUpr = father;
                }
                if (((DollarUniverseJob)(sonJob = this.sourceDefinitions.spawnJob(this, upr))).isCanceledJob()) continue;
                sessionManipulator.addConvertedUprocInSession(upr, (DollarUniverseJob)sonJob);
                jobs.add(sonJob);
                continue;
            }
            Reporter.addMessage(this.messages, (String)"ERR7003", (String)this.getJobName(), (String[])new String[]{upr.getAttr(this.uprFieldName), sessionId, this.taskParameterValue("ID")});
        }
        sessionManipulator.manipulateJobs();
        this.addNodeGroupsToActionsReport(sessionManipulator);
        this.children = jobs;
        return jobs;
    }

    public boolean isCanceledJob() {
        return this.canceledJob;
    }

    public String getGroup() {
        return this.attributes.get("GROUP");
    }

    private void addNodeGroupsToActionsReport(SessionManipulator sessionManipulator) {
        List<NodeGroup> nodeGroups = sessionManipulator.getNodeGroupsInSession();
        NodeGroupCollector nodeGroupCollector = this.sourceDefinitions.getNodeGroupCollector();
        for (NodeGroup nodeGroup : nodeGroups) {
            String nodeGroupName = nodeGroup.getName();
            if (nodeGroupCollector.containsNodeGroupWithName(nodeGroupName)) {
                if (!nodeGroupCollector.hasDifferentNodes(nodeGroup)) continue;
                Reporter.addMessage(this.messages, (String)"WRN7023", (String)this.getOriginalJobId(), (String[])new String[]{nodeGroupName, nodeGroupCollector.get(nodeGroupName).getNodesAsString(), nodeGroup.getNodesAsString()});
                continue;
            }
            nodeGroupCollector.add(nodeGroup);
            Reporter.addNodeGroupAction((String)nodeGroupName, (Set)nodeGroup, (String)this.getOriginalJobId());
        }
    }

    public List<Properties> getCtrlResources() {
        ArrayList<Properties> toRet = null;
        if (this.type == SchedEntity.TYPE.JOB && (toRet = this.resourceConvertor.getControlResource(this.getUprIdByUprAttributes())) != null) {
            for (Properties resource : toRet) {
                this.addResourceMessages(resource.getProperty("NAME"));
                HashMap<String, String> action = new HashMap<String, String>();
                action.put("ACTENTTYPE", "CTL");
                action.put("JOBID", this.getOriginalJobId());
                action.put("ACTENTNAME", resource.getProperty("NAME"));
                action.put("ACTSTATUS", "0");
                Reporter.addAction(action);
            }
        }
        return toRet;
    }

    public List<Properties> getInConds() {
        if (!(this.isJob() || this.isReferenceSubFolder() || this.isRemoveHeaderAndTrailerRuleEnabled())) {
            return new ArrayList<Properties>();
        }
        if (this.inConditions == null) {
            this.initInconditions();
        }
        return this.inConditions;
    }

    private List<Properties> getResconInConds() {
        return this.sourceDefinitions.getResconJobInconds(this);
    }

    public String getJobName() {
        return this.attributes.get("JOBNAME");
    }

    public void setJobName(String jobName) {
        this.setField("JOBNAME", jobName);
    }

    public static String generateConditionJobName(String uprocName, String num) {
        return String.format(DollarUniverseGlobals.JOB_NAME_FORMAT, uprocName, num);
    }

    public static String generateConditionJobName(String uprocName, int num) {
        return DollarUniverseJob.generateConditionJobName(uprocName, Integer.toString(num));
    }

    private void initInconditions() {
        this.inConditions = new ArrayList<Properties>();
        List<Properties> jobinconds = this.sourceDefinitions.getJobInconds(this);
        this.addAllInConditions(jobinconds);
    }

    public List<Properties> getAssitingJobInConds() {
        return InConditionUtils.removeConditionsByName(this.getInConds(), this.getResconInConds());
    }

    public ArrayList<String> getMessages() {
        this.appendExtReporterMessage();
        return this.messages;
    }

    public List<String> getOptionalAttributes() {
        return this.optionalAttributes;
    }

    public List<Properties> getOnStmt() {
        List<Properties> nonStandAlone;
        if (!this.standAloneJob && (nonStandAlone = this.sourceDefinitions.getJobOnstmts(this, true)) != null) {
            if (this.onStatements == null) {
                this.onStatements = new ArrayList<Properties>();
            }
            this.onStatements.addAll(nonStandAlone);
        }
        return this.onStatements;
    }

    public LinkedHashMap<Properties, List<Properties>> getOnDoStmt() {
        if (this.onDoList == null) {
            this.onDoList = new LinkedHashMap();
        }
        this.onDoList.putAll(this.getOnEndedDoConditionsFromDepCons());
        this.onDoList.putAll(this.getOnAbortedDoConditionsFromDepCons());
        return this.onDoList;
    }

    public LinkedHashMap<Properties, List<Properties>> getOnDoList() {
        if (this.onDoList == null) {
            this.onDoList = new LinkedHashMap();
        }
        return this.onDoList;
    }

    @NotNull
    private Map<Properties, List<Properties>> getOnAbortedDoConditionsFromDepCons() {
        if (SchedEntity.TYPE.SMART_TABLE.equals((Object)this.type())) {
            return Collections.emptyMap();
        }
        return this.sourceDefinitions.getOnEndedNotOkDoCond(this);
    }

    private Map<Properties, List<Properties>> getOnEndedDoConditionsFromDepCons() {
        if (SchedEntity.TYPE.SMART_TABLE.equals((Object)this.type())) {
            return Collections.emptyMap();
        }
        return this.sourceDefinitions.getOnEndedDoCond(this);
    }

    public String getOriginalJobName() {
        String origName = null;
        if (this.standAloneJob) {
            if (this.uprAttributes != null) {
                origName = this.getUprAttribute("upr");
            }
        } else {
            origName = this.isSmartTable() ? this.getTaskAttribute("tsk") : (this.isHeaderJob() ? this.getSessionUprAttribute("Father") : this.getSessionUprAttribute("Son"));
        }
        return origName;
    }

    public List<Properties> getOutConds() {
        if (!(this.isJob() || this.isReferenceSubFolder() || this.isRemoveHeaderAndTrailerRuleEnabled())) {
            return new ArrayList<Properties>();
        }
        if (this.outConds == null) {
            this.initOutConditions();
        }
        this.outConds = this.cleanUpConditionsHandler.addCleanUpConditions(this.outConds, this.getInConds());
        return this.outConds;
    }

    private void initOutConditions() {
        this.outConds = new ArrayList<Properties>();
        List<Properties> jobConditions = this.sourceDefinitions.getJobOutconds(this);
        this.addAllOutCondtions(jobConditions);
    }

    private void createDefaultNotokOutCond() {
        String sessionId = this.getOriginalSessionId();
        String jobName = this.getOriginalSessionSon();
        String num = this.getOriginalSessionNumS();
        String nodeName = this.getOriginalSessionNode();
        if (this.isHeaderJob()) {
            jobName = this.getOriginalSessionFather();
            num = this.getOriginalSessionNumF();
        }
        int numS = Integer.parseInt(num);
        String path = "KO";
        DollarUniverseJob parent = this.getParent();
        String mu = parent.taskParameterValue("mu");
        List<String> condsNames = this.sourceDefinitions.buildCondName(this.getParentName(), sessionId, mu, jobName, num, path, numS, nodeName, this);
        if (condsNames == null) {
            return;
        }
        for (String condName : condsNames) {
            OnStatement.OnNotOkStatement onNotOk = OnStatement.createOnNotOkStatement();
            DoCondition doCondition = Do.createDoCondition((String)condName, (DoCondition.AddRemoveSign)DoCondition.AddRemoveSign.ADD);
            onNotOk.addDo((Do)doCondition);
            this.addOnDoStmt((OnStatement)onNotOk);
        }
    }

    public String getParentName() {
        if (this.parent != null && this.parent.isSubTable()) {
            return this.parent.getParentName() + "/" + this.parent.getJobName();
        }
        return this.parent.getAttr("TABLE_NAME");
    }

    private String[] addJobNameToMessage(String[] args) {
        List<String> argLit = Arrays.asList(args);
        ArrayList<String> newArgLsit = new ArrayList<String>(argLit);
        newArgLsit.add(this.getJobName());
        return newArgLsit.toArray(new String[args.length + 1]);
    }

    public List<Properties> getShouts() {
        if (this.shouts == null) {
            this.shouts = new ArrayList();
        }
        return this.shouts;
    }

    public List<Properties> getQuantResources() {
        ArrayList<Properties> resources = new ArrayList<Properties>();
        resources.addAll(this.convertUprocQuantitativeResources());
        resources.addAll(this.convertTaskQuantitativeResources());
        return resources;
    }

    private List<Properties> convertTaskQuantitativeResources() {
        boolean isJob = this.type == SchedEntity.TYPE.JOB;
        Optional<String> queue = Optional.ofNullable(this.getTaskAttribute("queue")).filter(q -> !q.isBlank() && isJob);
        return queue.map(resourceName -> {
            HashMap<String, String> action = new HashMap<String, String>();
            action.put("ACTENTTYPE", "QR");
            action.put("JOBID", this.getOriginalJobId());
            action.put("ACTENTNAME", (String)resourceName);
            action.put("ACTENTQTY", "1");
            action.put("ACTSTATUS", "0");
            Reporter.addAction(action);
            return new PropertiesBuilder().setProperty("QUANT", "1").setProperty("NAME", resourceName).setProperty("ONFAIL", "R").setProperty("ONOK", "R").build();
        }).stream().collect(Collectors.toList());
    }

    private List<Properties> convertUprocQuantitativeResources() {
        ArrayList<Properties> toRet;
        ArrayList<Properties> resources = new ArrayList<Properties>();
        if (this.type == SchedEntity.TYPE.JOB && (toRet = this.resourceConvertor.getResconQr(this.getUprIdByUprAttributes())) != null) {
            for (Properties properties : toRet) {
                String resName = (String)properties.get("NAME");
                this.addResourceMessages((String)properties.get("NAME"));
                if (properties.containsKey("MSG")) {
                    String msgID = (String)properties.get("MSG");
                    if (msgID.equalsIgnoreCase("INF7004")) {
                        Reporter.addMessage(this.messages, (String)msgID, (String)this.getOriginalJobId(), (String[])new String[]{this.getUprAttribute("upr"), resName});
                        continue;
                    }
                    if (!msgID.equalsIgnoreCase("WRN7008")) continue;
                    Reporter.addMessage(this.messages, (String)msgID, (String)this.getOriginalJobId(), (String[])new String[]{resName});
                    continue;
                }
                resources.add(properties);
                HashMap<String, String> action = new HashMap<String, String>();
                action.put("ACTENTTYPE", "QR");
                action.put("JOBID", this.getOriginalJobId());
                action.put("ACTENTNAME", resName);
                action.put("ACTENTQTY", (String)properties.get("QUANT"));
                action.put("ACTSTATUS", "0");
                Reporter.addAction(action);
            }
        }
        return resources;
    }

    public String getTablePathForSons() {
        return null;
    }

    private void addResourceMessages(String resName) {
        HashMap<String, ArrayList<String[]>> messageMap = this.resourceConvertor.getResourceMessages(resName);
        if (messageMap != null) {
            for (String msgId : messageMap.keySet()) {
                for (String[] args : messageMap.get(msgId)) {
                    args = this.addJobNameToMessage(args);
                    this.addReporterMessage(msgId, args);
                }
            }
        }
    }

    public String getTableName() {
        if (this.isJob() && !this.standAloneJob) {
            return this.parent.attributes.get("JOBNAME");
        }
        if (this.isSmartTable()) {
            return this.attributes.get("JOBNAME");
        }
        return this.attributes.get("TABLE_NAME");
    }

    private void clearScheduling() {
        this.getTags().clear();
    }

    boolean isProvokedTask() {
        TASKTYPES task = this.isSmartTable() || this.standAloneJob ? this.getTaskType(this.taskParameterValue("type")) : this.getTaskType(this.parent.taskParameterValue("type"));
        return task == TASKTYPES.provoked;
    }

    public List<Properties> getTags() {
        if (this.rbcs == null) {
            this.rbcs = new ArrayList<Properties>();
            if (this.isProvokedTask()) {
                if (this.isSmartTable()) {
                    this.rbcs.add(this.rbcGenerator.getRbc(null, this.getTaskAttribute("mu"), this.rules.getStringRule("DOLLAR UNIVERSE rules", new String[]{"AREA"}), this.getNodeName()));
                }
            } else {
                this.rbcs = this.getTags(this.messages, this.getOriginalJobId());
            }
            if (this.getHdpExpressionHendler().ishdp()) {
                this.clearScheduling();
            }
        }
        return this.rbcs;
    }

    public List<Properties> getTags(List<String> messagesTarget, String recievingEnt) {
        ArrayList<Properties> toRet = new ArrayList<Properties>();
        HashSet<String> addedTags = new HashSet<String>();
        HashMap<String, Integer> rulesMap = new HashMap<String, Integer>();
        String rulesExpression = this.uprUpdatedRule != null ? this.uprUpdatedRule : this.getTaskAttribute("rule");
        ArrayList<String> rulesArr = DollarUniverseDefs.getArrayOfRulesFromRuleField(rulesExpression);
        for (String ruleStr : rulesArr) {
            String rule = DollarUniverseDefs.getRuleNameAndStartDate(ruleStr);
            String[] tmpArr = rule.trim().replaceAll("^\\(+", "").replaceAll("\\)+$", "").split(",", 2);
            rule = tmpArr[0];
            if ((rule = rule.trim()).matches("^\\d+/\\d+/\\d+$")) {
                rule = "";
            }
            String fromDate = "";
            if (tmpArr.length > 1) {
                fromDate = this.convertDate(tmpArr[1].trim());
            }
            if (this.type() == SchedEntity.TYPE.JOB) {
                this.handleJobTags(messagesTarget, recievingEnt, toRet, rule, fromDate);
                continue;
            }
            this.handleFolderTags(messagesTarget, recievingEnt, toRet, addedTags, rulesMap, rule, fromDate);
        }
        this.addTagsToChildrens(toRet, addedTags);
        return toRet;
    }

    private void handleJobTags(List<String> messagesTarget, String recievingEnt, ArrayList<Properties> toRet, String rule, String fromDate) {
        if (this.uprUpdatedRule != null || this.standAloneJob) {
            Properties jobTag = this.rbcGenerator.getRbc(rule, fromDate, this.rules.getStringRule("DOLLAR UNIVERSE rules", new String[]{"AREA"}), this.getNodeName());
            if (jobTag != null) {
                if (fromDate != null && !fromDate.isEmpty()) {
                    jobTag.put("ACTIVE_FROM", fromDate);
                }
                toRet.add(jobTag);
                this.addRbcMessages(recievingEnt, messagesTarget, rule, this.getNodeName());
            }
        } else if (!this.parent.parentTags.isEmpty()) {
            for (Properties parentTag : this.parent.parentTags) {
                if (toRet.contains(parentTag)) continue;
                toRet.add(parentTag);
            }
        }
    }

    private void handleFolderTags(List<String> messagesTarget, String recievingEnt, ArrayList<Properties> tagsToRet, HashSet<String> addedTags, HashMap<String, Integer> rulesMap, String rule, String fromDate) {
        Properties newTag = this.rbcGenerator.getRbc(rule, fromDate, this.rules.getStringRule("DOLLAR UNIVERSE rules", new String[]{"AREA"}), this.getNodeName());
        if (this.isFolderHasCyclicalLaunchWindow()) {
            DollarUniverseJob dollarUniverseJob = this;
            newTag = dollarUniverseJob.rbcGenerator.getEveryDayRBC();
        }
        if (fromDate != null && !fromDate.isEmpty()) {
            newTag.put("ACTIVE_FROM", fromDate);
        }
        if (!addedTags.contains(newTag.get("NAME"))) {
            this.addTag(messagesTarget, recievingEnt, tagsToRet, addedTags, rule, newTag);
        } else {
            String ruleName = (String)newTag.get("NAME");
            if (rulesMap.containsKey(ruleName)) {
                int ruleCount = rulesMap.get(ruleName) + 1;
                rulesMap.put(ruleName, ruleCount);
            } else {
                rulesMap.put(ruleName, 1);
            }
            int ruleNumber = rulesMap.get(ruleName);
            newTag.setProperty("NAME", String.valueOf(newTag.get("NAME")) + "#" + ruleNumber);
            this.addTag(messagesTarget, recievingEnt, tagsToRet, addedTags, rule, newTag);
        }
    }

    private boolean isFolderHasCyclicalLaunchWindow() {
        String cyclical = this.getTaskAttribute("cyclical");
        return cyclical != null && !cyclical.isEmpty() && !cyclical.matches("^[ \t]*\\(\\)");
    }

    private void addTag(List<String> messagesTarget, String recievingEnt, ArrayList<Properties> tagsToRet, HashSet<String> addedTags, String rule, Properties newTag) {
        addedTags.add((String)newTag.get("NAME"));
        this.addRbcMessages(recievingEnt, messagesTarget, RbcGenerator.trimRulePrefix(rule), this.getNodeName());
        this.addRbcMessages(recievingEnt, messagesTarget, (String)newTag.get("NAME"), this.getNodeName());
        tagsToRet.add(newTag);
        this.parentTags.add(newTag);
    }

    private void addTagsToChildrens(List<Properties> toRet, Set<String> addedTags) {
        if (this.children != null) {
            for (SchedEntity child : this.children) {
                DollarUniverseJob duChild = (DollarUniverseJob)child;
                ArrayList tags = (ArrayList)duChild.getTags();
                if (tags == null) continue;
                for (Properties jobTag : tags) {
                    if (jobTag == null || addedTags.contains(jobTag.get("NAME")) || toRet.contains(jobTag)) continue;
                    toRet.add(jobTag);
                    addedTags.add((String)jobTag.get("NAME"));
                }
            }
        }
    }

    private void addRbcMessages(String recievingEntId, List<String> messages, String dollarURule, String nodeName) {
        Map<String, String[]> ruleMessages = this.rbcGenerator.getRuleMessages(dollarURule, nodeName);
        if (ruleMessages == null) {
            return;
        }
        ArrayList tmpMessages = new ArrayList();
        for (Map.Entry<String, String[]> entry : ruleMessages.entrySet()) {
            Reporter.addMessage(tmpMessages, (String)entry.getKey(), (String)recievingEntId, (String[])entry.getValue());
        }
        for (String string : tmpMessages) {
            if (messages == null) {
                messages = new ArrayList<String>();
            }
            if (messages.contains(string)) continue;
            messages.add(string);
        }
    }

    public void addMessageWithJobName(String msgID, String ... stringsArr) {
        ArrayList<String> paramList = new ArrayList<String>();
        paramList.add(this.getOriginalJobName());
        paramList.add(this.getJobName());
        paramList.addAll(Arrays.asList(stringsArr));
        String[] paramListAsArray = (String[])paramList.toArray(String[]::new);
        Reporter.addMessage(this.messages, (String)msgID, (String)this.getOriginalJobId(), (String[])paramListAsArray);
    }

    public boolean isCyclic() {
        String cyclic = this.attributes.get("CYCLIC");
        if (cyclic == null) {
            return false;
        }
        return cyclic.equals("1");
    }

    public boolean isDSJob() {
        return true;
    }

    public boolean isValid() {
        return this.validEntity;
    }

    public String originalProductID() {
        Object name = this.getUniqueId();
        if (this.isJob()) {
            name = (String)name + "@" + this.parent.getUniqueId();
        }
        return name;
    }

    public SchedEntity.TYPE type() {
        return this.type;
    }

    private boolean isSmartTable() {
        return this.type == SchedEntity.TYPE.SMART_TABLE;
    }

    public String taskParameterValue(String param) {
        return this.sourceTaskDefinition.getAttributes().getAttr(param);
    }

    public boolean hasMessages() {
        this.appendExtReporterMessage();
        return !this.messages.isEmpty();
    }

    public boolean hasWarnings() {
        this.appendExtReporterMessage();
        if (this.messages.isEmpty()) {
            return false;
        }
        HashMap messageIds = MessageIdTable.instance().getMessageIds();
        return messageIds.keySet().stream().filter(id -> ((MessageId)messageIds.get(id)).getMessageType(id).equals("W")).anyMatch(id -> this.messages.stream().anyMatch(currMessage -> currMessage.startsWith((String)id)));
    }

    private String getSessionAttributeValue() {
        String sessionId = Session.sessionId(this.taskParameterValue("ses"), this.taskParameterValue("upr"), this.taskParameterValue("node name"));
        if (this.sourceDefinitions.getSessions().get(sessionId) != null) {
            return this.sourceDefinitions.getSessions().get(sessionId).getAttributes().getAttr("LABEL");
        }
        return "";
    }

    private boolean isSubTable() {
        return this.type == SchedEntity.TYPE.SUB_TABLE;
    }

    private String getHeaderSessionUprAttributeValue() {
        String uprId = this.getUprIdByTaskOrSession(this.taskParameterValue("upr"));
        if (this.sourceDefinitions.getUprs().containsKey(uprId)) {
            return this.sourceDefinitions.getUprs().get(uprId).getAttributes().getAttr("appl");
        }
        return "";
    }

    public String getTaskAttribute(String attr) {
        if (this.isSmartTable() || this.isSubTable() || this.standAloneJob) {
            return this.taskParameterValue(attr);
        }
        return this.parent.taskParameterValue(attr);
    }

    private String getSessionUprAttribute(String attr) {
        if (this.isSmartTable()) {
            return null;
        }
        if (this.sessionUprAttributes == null) {
            return null;
        }
        if (!this.sessionUprAttributes.isFieldExist(attr)) {
            return null;
        }
        return this.sessionUprAttributes.getAttr(attr);
    }

    public String getUniqueId() {
        if (this.isSmartTable()) {
            return this.attributes.get("TABLE_NAME");
        }
        return this.attributes.get("JOBNAME");
    }

    private void setDummyJob() {
        String sTaskType = this.attributes.get("TASKTYPE");
        if (null == sTaskType) {
            sTaskType = "Job";
        }
        this.autoedits.put("%%$BMCWAIORIGTYPE", sTaskType);
    }

    public String getUprAttribute(String attr) {
        if (this.isSmartTable()) {
            return null;
        }
        if (this.uprAttributes == null) {
            return null;
        }
        return this.uprAttributes.getAttributes().getAttr(attr);
    }

    private void updateTasktype() {
        String upt;
        if (this.isSmartTable()) {
            return;
        }
        switch (upt = this.getUprAttribute("upt").toLowerCase()) {
            case "cl_int": {
                this.attributes.put("TASKTYPE", "Job");
                String script = this.getUprAttribute("script");
                if (this.isSapScript(script)) {
                    this.addSapAttrToAttributes();
                    break;
                }
                if (this.isSapApiScript(script)) {
                    new SapApiCommandConverter(script, this).convert();
                    break;
                }
                this.attributes.put("USE_INSTREAM_JCL", "Y");
                this.attributes.put("MEMNAME", FieldValidation.instance().validateAndReturnFixedValue("MEMNAME", this.attributes.get("JOBNAME") + ".bat"));
                this.setOptionalAtrribute("INSTREAM_JCL", this.resolveVariables(this.getUprAttribute("script"), "Instream JCL"));
                break;
            }
            case "cl_ext": {
                this.attributes.put("TASKTYPE", "Command");
                String cmdLineClfil = this.getUprAttribute("clfil");
                FieldValidation.instance().cmdLineValidateAndReportMessages(cmdLineClfil, this.getOriginalJobId(), this.messages);
                this.attributes.put("CMDLINE", cmdLineClfil);
                this.attributes.put("MEMNAME", FieldValidation.instance().validateAndReturnFixedValue("MEMNAME", this.attributes.get("JOBNAME")));
                break;
            }
            case "cmd": {
                String execDir = this.getUprAttribute("execdir");
                if (execDir.isEmpty()) {
                    this.attributes.put("TASKTYPE", "Command");
                    String cmdLine = this.resolveVariables(this.getUprAttribute("command"), "Command line");
                    FieldValidation.instance().cmdLineValidateAndReportMessages(cmdLine, this.getOriginalJobId(), this.messages);
                    this.attributes.put("CMDLINE", cmdLine);
                    this.attributes.put("MEMNAME", FieldValidation.instance().validateAndReturnFixedValue("MEMNAME", this.attributes.get("JOBNAME")));
                    break;
                }
                String cmdLine = this.resolveVariables(this.getUprAttribute("command"), "Command line");
                FieldValidation.instance().cmdLineValidateAndReportMessages(cmdLine, this.getOriginalJobId(), this.messages);
                String cd = "cd";
                String concat = " ; ";
                if (execDir.contains("\\") || execDir.contains(":") || cmdLine.contains("\\") || cmdLine.contains(":")) {
                    cd = "pushd";
                    concat = " && ";
                }
                if (cmdLine.startsWith(execDir) || cmdLine.length() > 64 || cmdLine.contains("/") || cmdLine.contains("\\") || cmdLine.contains(":") || cmdLine.contains(" ")) {
                    this.attributes.put("TASKTYPE", "Command");
                    this.attributes.put("CMDLINE", cd + " " + execDir + concat + cmdLine);
                    this.attributes.put("MEMNAME", FieldValidation.instance().validateAndReturnFixedValue("MEMNAME", this.attributes.get("JOBNAME")));
                    break;
                }
                this.attributes.put("TASKTYPE", "Job");
                this.attributes.put("MEMNAME", cmdLine);
                this.attributes.put("MEMLIB", execDir);
                break;
            }
            case "ftp_get": 
            case "ftp_put": {
                this.attributes.put("TASKTYPE", "Job");
                this.attributes.put("MEMNAME", this.attributes.get("JOBNAME"));
                this.setOptionalAtrribute("APPL_FORM", "AFT");
                this.setOptionalAtrribute("APPL_TYPE", "FILE_TRANS");
                this.setOptionalAtrribute("APPL_VER", "6.1.01");
                this.setOptionalAtrribute("CM_VER", "610");
                this.attributes.put("MEMLIB", "Not in use for application jobs");
                this.autoedits.put("%%FTP-ACCOUNT", this.safeGetFTPAttribute(upt, "logon") + "_" + this.safeGetFTPAttribute(upt, "partner"));
                this.autoedits.put("%%FTP-TYPE1", this.getFTPType(upt));
                this.autoedits.put("%%FTP-SRCOPT1", this.safeGetFTPAttribute(upt, "delete").equalsIgnoreCase("TRUE") ? "1" : "0");
                this.autoedits.put("%%FTP-USE_DEF_NUMRETRIES", "0");
                this.autoedits.put("%%FTP-NUM_RETRIES", this.getFTPRetry(upt));
                this.setFTPFilePath(upt);
                this.setFTPDirection(upt);
                this.autoedits.put("%%FTP-TRANSFER_NUM", "1");
                this.addAFTAction();
                break;
            }
            case "sap_xbp2": {
                SapXBP2Handler uprocSapXBP2Upt = new SapXBP2Handler(this, this.uprAttributes);
                uprocSapXBP2Upt.execute();
                break;
            }
            case "sap_pchain": {
                SapBWHandler uprocSapBWUpt = new SapBWHandler(this, this.uprAttributes);
                uprocSapBWUpt.execute();
                break;
            }
            default: {
                this.attributes.put("TASKTYPE", "");
                Reporter.addMessage(this.messages, (String)"WRN7036", (String)this.getOriginalJobId(), (String[])new String[]{this.getUprAttribute("upt"), this.getUprAttribute("upr")});
                this.setDummyJob();
                this.attributes.put("TASKTYPE", "Dummy");
            }
        }
        if (this.sourceDefinitions.isToDummy()) {
            if (!Params.instance().getGUIVersion().equals("7")) {
                this.setDummyJob();
            }
            this.attributes.put("TASKTYPE", "Dummy");
        }
    }

    private boolean isSapApiScript(String script) {
        if (script == null) {
            return false;
        }
        return Pattern.compile(".*uxstr\\s+SAP\\s+API.*").matcher(script).find();
    }

    private String safeGetFTPAttribute(String ftpType, String attr) {
        String uprId = this.getUprIdByTaskOrSession(this.getUprAttribute("upr"));
        IAttrHolder ftpAttributes = (IAttrHolder)this.sourceDefinitions.getUprs().get(uprId).getVariableParameters(ftpType).get(0);
        String toRet = ftpAttributes.getAttr(attr);
        return toRet == null ? "" : this.resolveVariables(toRet, "FTP attribute " + attr);
    }

    private String getFTPType(String ftpType) {
        String toRet = this.safeGetFTPAttribute(ftpType, "mode").equalsIgnoreCase("ASCII") ? "A" : "I";
        return toRet;
    }

    private void addSapAttrToAttributes() {
        String uxJobName = this.getUprAttribute("upr");
        IAttrHolder sapJobAttributes = this.sourceDefinitions.getSapParams(uxJobName);
        FileConfigurationConvertor sapConvertor = this.sourceDefinitions.getCleanSapConvertor();
        if (sapJobAttributes == null) {
            Reporter.addMessage(this.messages, (String)"WRN7021", (String)this.getOriginalJobId(), (String[])new String[]{this.getUprAttribute("upr")});
        } else {
            for (String string : this.sourceDefinitions.getSAPHeaders()) {
                String parameterValue = sapJobAttributes.getAttr(string);
                if (parameterValue == null || parameterValue.isEmpty()) continue;
                String controlMSAPParameter = sapConvertor.getEquivalentAutoEdit(string);
                String controlMSAPParameterValue = sapConvertor.getEquivalentParameterValue(string, parameterValue);
                if (controlMSAPParameter != null && controlMSAPParameterValue != null) {
                    this.autoedits.put(String.format(controlMSAPParameter, 1), controlMSAPParameterValue);
                    continue;
                }
                if (controlMSAPParameterValue == null) continue;
                Reporter.addMessage(this.messages, (String)"WRN7022", (String)this.getOriginalJobId(), (String[])new String[]{uxJobName, string, parameterValue});
                ConversionLogger.getLogger().info(() -> "job " + this.getJobName() + " : parameter value '" + parameterValue + "' of dollar Universe parameter : " + string + " was not converted");
            }
        }
        HashMap<String, String> manadatoryAutoeditDefaultValueMap = sapConvertor.getLeftMandatoryAutoEdits();
        for (String parameter : manadatoryAutoeditDefaultValueMap.keySet()) {
            this.autoedits.put(String.format(parameter, 1), (String)manadatoryAutoeditDefaultValueMap.get(parameter));
        }
        HashMap<String, String> hashMap = sapConvertor.getLeftMandatoryAttributes();
        for (String parameter : hashMap.keySet()) {
            this.attributes.put(String.format(parameter, 1), (String)hashMap.get(parameter));
        }
        Globs.SAP_TYPE_FORM_VERSION.forEach(this::setOptionalAtrribute);
    }

    private boolean isSapScript(String script) {
        if (script == null) {
            return false;
        }
        return Pattern.compile(".*uxstr\\s+sap\\s+.*").matcher(script).find();
    }

    private void setFTPDirection(String upt) {
        this.autoedits.put("%%FTP-LHOST", "");
        this.autoedits.put("%%FTP-LUSER", "");
        this.autoedits.put("%%FTP-RHOST", this.safeGetFTPAttribute(upt.toLowerCase(), "partner"));
        this.autoedits.put("%%FTP-RUSER", this.safeGetFTPAttribute(upt.toLowerCase(), "logon"));
        if (upt.equalsIgnoreCase("ftp_put")) {
            this.autoedits.put("%%FTP-UPLOAD1", "1");
        } else {
            this.autoedits.put("%%FTP-UPLOAD1", "0");
        }
    }

    private String getFTPRetry(String ftpType) {
        String toRet = this.safeGetFTPAttribute(ftpType, "retry");
        if (toRet.equalsIgnoreCase("")) {
            toRet = "0";
        }
        return toRet;
    }

    private String getFTPExist(String ftpType) {
        String action = this.safeGetFTPAttribute(ftpType, "action");
        String toRet = action.equalsIgnoreCase("REPLACE") ? "0" : (action.equalsIgnoreCase("APPEND") ? "1" : (action.equalsIgnoreCase("NONE") ? "3" : "2"));
        return toRet;
    }

    private void setFTPFilePath(String upt) {
        String targetPathFile;
        String originPath = this.safeGetFTPAttribute(upt.toLowerCase(), "origin_pathname");
        String originFile = this.safeGetFTPAttribute(upt.toLowerCase(), "origin_filename");
        String originPathFile = originPath + this.getFTPFilePathSeparator(originPath, originFile) + originFile;
        String targetPath = this.safeGetFTPAttribute(upt.toLowerCase(), "target_pathname");
        String targetFile = this.safeGetFTPAttribute(upt.toLowerCase(), "target_filename");
        this.autoedits.put("%%FTP-IF_EXIST1", this.getFTPExist(upt.toLowerCase()));
        if (targetFile.equals(originFile)) {
            targetPathFile = targetPath + this.getFTPFilePathSeparator(targetPath, null);
        } else if (originFile.contains("*") || originFile.contains("?")) {
            this.autoedits.put("%%FTP-IF_EXIST1", "1");
            targetPathFile = targetPath + this.getFTPFilePathSeparator(targetPath, targetFile) + targetFile;
        } else {
            targetPathFile = targetPath + this.getFTPFilePathSeparator(targetPath, targetFile) + targetFile;
        }
        if (upt.equalsIgnoreCase("ftp_put")) {
            this.autoedits.put("%%FTP-LPATH1", originPathFile);
            this.autoedits.put("%%FTP-RPATH1", targetPathFile);
        } else {
            this.autoedits.put("%%FTP-LPATH1", targetPathFile);
            this.autoedits.put("%%FTP-RPATH1", originPathFile);
        }
    }

    private String getFTPFilePathSeparator(String path, String file) {
        String dirSep = "/";
        if (path.endsWith("/") || path.endsWith("\\")) {
            dirSep = "";
        }
        if (file != null && (file.startsWith("/") || file.startsWith("\\"))) {
            dirSep = "";
        }
        if (path.contains("\\")) {
            dirSep = "\\";
        }
        return dirSep;
    }

    private void addAFTAction() {
        HashMap<String, String> aftAction = new HashMap<String, String>();
        aftAction.put("ACTENTTYPE", "AFTACC");
        aftAction.put("JOBID", this.getAttr("JOBNAME"));
        aftAction.put("ACTENTNAME", this.getAttr("OWNER"));
        aftAction.put("ACTSTATUS", "0");
        Reporter.addAction(aftAction);
    }

    private Map<String, String> getAutoeditsFromLaunchvar(String launchvar) {
        int index;
        Pattern varExpr = Pattern.compile("(.*)varname[ ]*:[ ](.*?)\\n(.*)", 32);
        Pattern valueExpr = Pattern.compile("(.*)vvalue[ ]*:[ ](.*?)\\n(.*)", 32);
        HashMap<String, String> tempAutoedits = new HashMap<String, String>();
        String line = launchvar;
        while ((index = line.indexOf(93)) >= 0) {
            String next = line.substring(0, index + 1);
            Matcher matcher = varExpr.matcher(next);
            Object variable = matcher.matches() ? "%%" + matcher.group(2) : "";
            matcher = valueExpr.matcher(next);
            String value = matcher.matches() ? matcher.group(2) : "";
            if (!((String)variable).isEmpty() && !value.isEmpty()) {
                tempAutoedits.put((String)variable, value);
            }
            line = line.substring(index + 1);
        }
        return tempAutoedits;
    }

    public void setOptionalAtrribute(String attribute, String value) {
        if (this.optionalAttributes == null) {
            this.optionalAttributes = new ArrayList<String>();
        }
        this.optionalAttributes.add(attribute);
        this.attributes.put(attribute, value);
    }

    private void getCommonAutoedits() {
        this.autoedits.put("%%UG", this.taskParameterValue("mu"));
        String value = this.rules.getStringRule("DOLLAR UNIVERSE rules", new String[]{"AREA"});
        value = value.charAt(0) == 'E' ? "X" : value.substring(0, 1);
        this.autoedits.put("%%ESP", value);
        Optional.ofNullable(this.taskParameterValue("queue")).filter(q -> !q.isBlank()).ifPresent(queue -> this.autoedits.put("%%QUEUE", (String)queue));
        Optional.ofNullable(this.sourceTaskDefinition.getAttributes().getAttr("tsk")).filter(task -> !task.isBlank()).ifPresent(task -> this.autoedits.put("%%TASK", (String)task));
        if (this.sourceDefinitions.isDisabledTask(this.sourceTaskDefinition)) {
            this.autoedits.put("%%DISABLE", "YES");
        }
    }

    private void getUprAutoedits() {
        String uprKey = this.getUprIdByUprAttributes();
        AttrHolderList launchvarList = this.sourceDefinitions.getUprs().get(uprKey).getVariableParameters("launchvar");
        if (launchvarList != null && !launchvarList.isEmpty()) {
            for (IAttrHolder iAttrHolder : launchvarList) {
                String variable = "%%" + iAttrHolder.getAttr("varname").trim();
                String varExpr = iAttrHolder.getAttr("vvalue");
                if (varExpr == null || varExpr.isEmpty()) {
                    varExpr = "";
                }
                this.autoedits.put(variable, varExpr);
            }
        }
        if (this.standAloneJob) {
            this.getCommonAutoedits();
            this.autoedits.putAll(this.getAutoeditsFromLaunchvar(this.taskParameterValue("launchvar")));
        } else if (this.isHeaderJob) {
            this.autoedits.putAll(this.getAutoeditsFromLaunchvar(this.parent.taskParameterValue("launchvar")));
        }
    }

    private String getDateWithoutBackSlash(String inDate) {
        String format;
        return switch (format = this.rules.getStringRule("DOLLAR UNIVERSE rules", new String[]{"DATE_FORMAT"})) {
            case "ddmmyyyy" -> inDate.substring(4, 8) + inDate.substring(2, 4) + inDate.substring(0, 2);
            case "mmddyyyy" -> inDate.substring(4, 8) + inDate.substring(0, 4);
            default -> inDate;
        };
    }

    private String convertDate(String inDate) {
        String res = "";
        if (Pattern.matches("(.*)/(.*)/(.*)", inDate)) {
            res = this.getDateWithBackSlash(inDate);
        } else if (Pattern.matches("\\d{8}", inDate)) {
            res = this.getDateWithoutBackSlash(inDate);
        }
        return res;
    }

    private String getDateWithBackSlash(String inDate) {
        int[] formatArr = this.sourceDefinitions.getDateFormat();
        Pattern duDateFormat = Pattern.compile("(.*)/(.*)/(.*)");
        Matcher matcher = duDateFormat.matcher(inDate);
        matcher.matches();
        return matcher.group(formatArr[0]) + matcher.group(formatArr[1]) + matcher.group(formatArr[2]);
    }

    public void addReporterMessage(String msgId, String ... stringsArr) {
        Reporter.addMessage(this.messages, (String)msgId, (String)this.getOriginalJobId(), (String[])stringsArr);
    }

    private void appendExtReporterMessage() {
        if (extMessages != null) {
            this.messages.addAll(extMessages);
            extMessages = null;
        }
    }

    public String getUprFieldName() {
        return this.uprFieldName;
    }

    private boolean existUpr(String uprName, String nodeName) {
        return this.sourceDefinitions.getUprs().containsKey(uprName + "_" + nodeName);
    }

    private boolean isSessionHeader() {
        String header = this.getSessionUprAttribute("header");
        String fatherColumn = this.getSessionUprAttribute("Father");
        if (header == null || fatherColumn == null) {
            return false;
        }
        return header.equals(fatherColumn) && this.isHeaderJob;
    }

    private DollarUniverseTaskAttributes getSpecificTask(String uprName, String uprNodeName) {
        if (uprName == null) {
            return null;
        }
        if (uprName.trim().isEmpty()) {
            return null;
        }
        String id = this.sourceDefinitions.getTaskToSessionTable().getTaskForUpr(uprName, uprNodeName);
        return this.sourceDefinitions.getSessionTasks().get(id);
    }

    private void updateUprTaskAttributes() {
        DollarUniverseTaskAttributes[] tasks = new DollarUniverseTaskAttributes[2];
        String sessionId = Session.sessionId(this.getTaskAttribute("ses"), this.getUprAttribute("upr"), this.getTaskAttribute("node name"));
        tasks[0] = this.sourceDefinitions.getSessions().containsKey(sessionId) ? null : this.getSpecificTask(this.getUprAttribute("upr"), this.getUprAttribute("node_name"));
        sessionId = Session.sessionId(this.getTaskAttribute("ses"), this.parent.fatherUpr, this.getTaskAttribute("node name"));
        tasks[1] = this.sourceDefinitions.getSessions().containsKey(sessionId) ? null : this.getSpecificTask(this.parent.fatherUpr, this.parent.getNodeName());
        for (int i = 0; i < tasks.length; ++i) {
            String type;
            DollarUniverseTaskAttributes uprTask = tasks[i];
            if (uprTask == null || (type = uprTask.getAttributes().getAttr("type")) == null || type.trim().isEmpty()) continue;
            TASKTYPES taskType = this.getTaskType(type);
            this.autoedits.putAll(this.getAutoeditsFromLaunchvar(uprTask.getAttributes().getAttr("launchvar")));
            this.attributes.put("OWNER", uprTask.getAttributes().getAttr("user"));
            if (taskType == TASKTYPES.provoked) {
                this.setPriority(uprTask.getAttributes().getAttr("prty"));
                continue;
            }
            if (taskType == TASKTYPES.optional) {
                this.uprUpdatedRule = uprTask.getAttributes().getAttr("rule");
                continue;
            }
            if (taskType == TASKTYPES.cylical) {
                if (i != 0) continue;
                Reporter.addMessage(this.messages, (String)"WRN7017", (String)this.getUprAttribute("upr"), (String[])new String[]{uprTask.getName(), type, this.getUprAttribute("upr")});
                continue;
            }
            if (taskType == TASKTYPES.schedule) {
                this.setPriority(uprTask.getAttributes().getAttr("prty"));
                this.uprUpdatedRule = uprTask.getAttributes().getAttr("rule");
                this.attributes.put("ACTIVE_FROM", this.convertDate(uprTask.getAttributes().getAttr("sdate")));
                continue;
            }
            Reporter.addMessage(this.messages, (String)"WRN7017", (String)this.getUprAttribute("upr"), (String[])new String[]{uprTask.getName(), type, this.getUprAttribute("upr")});
        }
    }

    private boolean isParentHandledUXAUTOSEL() {
        if (this.parent != null) {
            return this.parent.ishandleduxAUTOSET();
        }
        return false;
    }

    private boolean ishandleduxAUTOSET() {
        return this.handleDuxAUTOSETVariable;
    }

    private String getAutoeditName(String var, String where) {
        int index = var.indexOf(58);
        Object retVar = "%%" + var;
        if (index >= 0) {
            int from;
            String[] params = var.split(":");
            try {
                from = Integer.parseInt(params[1]) + 1;
            }
            catch (NumberFormatException ex) {
                ExceptionHandler.writeToExceptionFile((Exception)ex);
                from = 1;
            }
            String addAutoedit = params.length == 2 ? "%%SUBSTR %%" + params[0] + " " + from + " 255" : "%%SUBSTR %%" + params[0] + " " + from + " " + params[2];
            retVar = "%%CONVSUBSTR1";
            for (int i = 0; i < this.autoedits.size() && this.autoedits.containsKey(retVar); ++i) {
                retVar = "%%CONVSUBSTR" + (i + 1);
            }
            this.autoedits.put((String)retVar, addAutoedit);
        }
        if (!this.autoedits.containsKey(retVar)) {
            Reporter.addMessage(this.messages, (String)"INF7007", (String)this.getOriginalJobId(), (String[])new String[]{retVar, where});
        }
        return retVar;
    }

    private String resolveVariables(String input, String where) {
        Object retVal = input;
        String delimiters = "<>[]{}()=;`~|:?+-*/&^#@,\"'\n\r ";
        Pattern findVar = Pattern.compile("(.*?)!([^! ]+?)!(.*)");
        if (input == null || input.isEmpty()) {
            return input;
        }
        Matcher matcher = findVar.matcher((CharSequence)retVal);
        while (matcher.matches()) {
            int index;
            String pre = matcher.group(1);
            String variable = matcher.group(2);
            Object after = matcher.group(3);
            if (after != null && !((String)after).isEmpty() && (index = delimiters.indexOf(((String)after).charAt(0))) < 0) {
                after = "." + (String)after;
            }
            retVal = pre + this.getAutoeditName(variable, where) + (String)after;
            matcher = findVar.matcher((CharSequence)retVal);
        }
        return retVal;
    }

    private boolean notifyWarnings(HashMap<String, String> params) {
        if (params.get("recipient").isEmpty()) {
            Reporter.addMessage(this.messages, (String)"WRN7009", (String)this.getOriginalJobId(), (String[])new String[]{this.getUprAttribute("upr")});
            return true;
        }
        if (params.get("timeoverrun").equalsIgnoreCase("Y") && this.uprTimeTo().equals("") && !this.uprTimeTo().equals(">")) {
            Reporter.addMessage(this.messages, (String)"WRN7045", (String)this.getOriginalJobId(), (String[])new String[]{this.getOriginalJobName(), this.getJobName(), "timeoverrun", params.get("timeoverrun")});
        }
        if (this.shouldIssueUnsupportedNotifyRefusedMessage(params)) {
            this.issueUnsupportedNotifyRefusedMessage();
        }
        if (GlobalFunctions.isNumber((String)params.get("joblog"))) {
            params.put("joblog", "Y");
        }
        return false;
    }

    private boolean shouldIssueUnsupportedNotifyRefusedMessage(HashMap<String, String> params) {
        return DollarUniverseJob.isNotifyRefused(params) && this.messageNotAlreadyIssued("WRN7044");
    }

    private boolean notifyRefusedMessageNotAlreadyIssued() {
        return this.messageNotAlreadyIssued("WRN7044");
    }

    private static boolean isNotifyRefused(HashMap<String, String> params) {
        return params.get("refused").equalsIgnoreCase("Y");
    }

    private void issueUnsupportedNotifyRefusedMessage() {
        Reporter.addMessage(this.sourceDefinitions.getGeneralMessages(), (String)"WRN7044", (String)"General", (String[])new String[0]);
    }

    private boolean messageNotAlreadyIssued(String messageId) {
        return this.sourceDefinitions.getGeneralMessages().stream().noneMatch(message -> message.contains(messageId));
    }

    private void handleNotify() {
        HashMap<String, String> params = new HashMap<String, String>();
        String notifyString = this.getUprAttribute("notify");
        if (notifyString == null) {
            return;
        }
        Object inLine = notifyString.replaceAll("[\\(\\)]", "");
        if (((String)(inLine = ((String)inLine).trim())).isEmpty()) {
            return;
        }
        inLine = ((String)inLine).trim() + "\n";
        params.put("mail", "N");
        params.put("completed", "N");
        params.put("aborted", "N");
        params.put("refused", "N");
        params.put("timeoverrun", "N");
        params.put("joblog", "N");
        params.put("recipient", "");
        Pattern notifyExpr = Pattern.compile("(.*?)(mail|completed|aborted|refused|timeoverrun|joblog|recipient)[ ]*:[ ](.*?)\\n(.*)", 34);
        Matcher matcher = notifyExpr.matcher((CharSequence)inLine);
        while (matcher.matches()) {
            params.put(matcher.group(2).toLowerCase(), matcher.group(3).trim());
            if (matcher.group(4) == null) break;
            matcher = notifyExpr.matcher(matcher.group(4));
        }
        if (((String)params.get("mail")).equalsIgnoreCase("Y")) {
            if (this.notifyWarnings(params)) {
                return;
            }
            String address = params.get("recipient");
            DoMail domail = Do.createDoMail((String)address);
            String attachSysout = params.get("joblog");
            if (attachSysout.equalsIgnoreCase("Y")) {
                domail.setAttachSysout(DoMail.AttachSysout.YES);
            } else {
                domail.setAttachSysout(DoMail.AttachSysout.NO);
            }
            if (params.get("completed").equalsIgnoreCase("Y")) {
                this.addOnDoStatement(domail, (OnStatement)OnStatement.createOnOkStatement(), "Ended OK");
            }
            if (params.get("aborted").equalsIgnoreCase("Y")) {
                this.addOnDoStatement(domail, (OnStatement)OnStatement.createOnNotOkStatement(), "Ended NOTOK");
            }
        }
        if (params.get("timeoverrun").equalsIgnoreCase("Y") && !this.uprTimeTo().equals("") && !this.uprTimeTo().equals(">")) {
            ShoutsGenerator generatorShouts = new ShoutsGenerator();
            this.getShouts().add(generatorShouts.generateShoutOnLateSub("EM", String.format("Job %s was not submitted by %s", this.getJobName(), this.uprTimeTo()), "", String.valueOf(this.uprTimeTo())));
        }
    }

    private void addOnDoStatement(DoMail domail, OnStatement on, String message) {
        if (on != null) {
            String subject = "%%JOBNAME %%ORDERID %%RUNCOUNT " + message;
            domail.setMessage(message);
            domail.setSubject(subject);
            on.addDo((Do)domail);
            this.addOnDoStmt(on);
        }
    }

    private String uprTimeTo() {
        if (this.parent.getAttr("TIMETO") == null && this.getAttr("TIMETO") == null) {
            return "";
        }
        if (this.getAttr("TIMETO") == null) {
            return this.parent.getAttr("TIMETO");
        }
        return this.getAttr("TIMETO");
    }

    private void handleRetry() {
        String retryString = this.getUprAttribute("retry");
        Pattern retryFields = Pattern.compile("\\(*\\s*(\\d*),(\\d*)\\s*\\)*");
        if (retryString == null) {
            return;
        }
        if ((retryString = retryString.trim()).isEmpty()) {
            return;
        }
        Matcher matcher = retryFields.matcher(retryString);
        if (matcher.matches()) {
            int interval = Integer.parseInt(matcher.group(2).trim());
            this.attributes.putAll(GlobalFunctions.attributesCyclicInterval(null, (String)String.format("%05dM", interval)));
            OnStatement.OnOkStatement onOkStatment = OnStatement.createOnOkStatement();
            DoStopCyclic doStopCyclic = Do.createDoStopCyclic();
            onOkStatment.addDo((Do)doStopCyclic);
            this.addOnDoStmt((OnStatement)onOkStatment);
            String numberOfReruns = matcher.group(1).trim();
            if (GlobalFunctions.isNumber((String)numberOfReruns)) {
                OnStatement.OnNumberOfReruns onNumbreOfReruns = OnStatement.createOnNumberOfReruns((int)Integer.parseInt(numberOfReruns));
                onNumbreOfReruns.addDo((Do)Do.createDoStopCyclic());
                this.addOnDoStmt((OnStatement)onNumbreOfReruns);
            }
        } else {
            Reporter.addMessage(this.messages, (String)"WRN7010", (String)this.getOriginalJobId(), (String[])new String[]{this.getUprAttribute("upr")});
        }
    }

    private void setTimeZone() {
        if (!this.hasMu()) {
            return;
        }
        IAttrHolder attr = this.getTaskMuAttributes();
        String muName = attr.getAttr("mu");
        String currTz = attr.getAttr("tz");
        if (currTz == null || currTz.isEmpty()) {
            return;
        }
        String tzName = DollarUniverseTimeZone.getInstance().getTimeZoneName(this, currTz, muName);
        if (tzName != null) {
            this.attributes.put("TIMEZONE", tzName);
        }
    }

    private TASKTYPES getTaskType(String in) {
        if (in == null) {
            return TASKTYPES.illegal;
        }
        char type = in.toLowerCase().charAt(0);
        return switch (type) {
            case 's' -> TASKTYPES.schedule;
            case 'p' -> TASKTYPES.provoked;
            case 'o' -> TASKTYPES.optional;
            case 'c' -> TASKTYPES.cylical;
            default -> TASKTYPES.illegal;
        };
    }

    public boolean isStandAloneJob() {
        return this.standAloneJob;
    }

    public void setNodeId(String nodeID) {
        this.attributes.put("NODEID", FieldValidation.instance().validateAndReturnFixedValue("NODEID", nodeID));
    }

    public void setMultyAgent(boolean b) {
        if (b) {
            this.attributes.put("MULTY_AGENT", "Y");
        } else {
            this.attributes.put("MULTY_AGENT", "N");
        }
    }

    public DollarUniverseSession getSession() {
        if (this.session == null) {
            if (this.isSmartTable()) {
                String sessionId = Session.sessionId(this.taskParameterValue("ses"), this.taskParameterValue("upr"), this.taskParameterValue("node name"));
                DollarUniverseSessionAttributes taskSession = this.sourceDefinitions.getSessions().get(sessionId);
                if (taskSession == null) {
                    ConversionLogger.getLogger().warning("Smart Table contain No Session atrribute , Smart Table : " + this.getJobName());
                }
                String headerMU = this.getTaskAttribute("mu");
                MuHierarchy muHierarchy = this.sourceDefinitions.getMuDependencies();
                this.session = new DollarUniverseSession(taskSession, headerMU, muHierarchy);
            } else {
                this.session = !this.isConvertedFromSession() ? null : this.getParent().getSession();
            }
        }
        return this.session;
    }

    private boolean isConvertedFromSession() {
        return this.sessionUprAttributes != null && !this.isStandAloneJob();
    }

    public HdpHandler.HdpExpressionHandler getHdpExpressionHendler() {
        return this.hdpHandler;
    }

    public void addOutCondtions(Properties outcondition) {
        if (this.outConds == null) {
            this.initOutConditions();
        }
        this.outConds.add(outcondition);
    }

    public void addAllOutCondtions(List<Properties> outconditions) {
        if (outconditions != null) {
            if (this.outConds == null) {
                this.initOutConditions();
            }
            for (Properties outcondition : outconditions) {
                this.fixConditionName(outcondition);
            }
            this.outConds.addAll(outconditions);
        }
    }

    public void addAllTrailerOutCondtionsToParentLevel(List<Properties> conditions, DollarUniverseJob parent) {
        if (parent.outConds == null) {
            parent.outConds = conditions;
        } else {
            parent.outConds.addAll(conditions);
        }
    }

    private void fixConditionName(Properties condition) {
        String newIncondName;
        String name = condition.getProperty("NAME");
        if (!name.equals(newIncondName = FieldValidation.instance().validateAndReturnFixedValue("COND_NAME", name))) {
            condition.put("NAME", newIncondName);
        }
    }

    public void addAllInConditions(List<Properties> conditions) {
        for (Properties condition : conditions) {
            this.fixConditionName(condition);
        }
        if (this.inConditions == null) {
            this.initInconditions();
        }
        this.inConditions.addAll(conditions);
    }

    public void addAllHeaderInConditionsToParentLevel(List<Properties> conditions, DollarUniverseJob parent) {
        if (parent.inConditions == null) {
            parent.inConditions = conditions;
        } else {
            parent.inConditions.addAll(conditions);
        }
    }

    public String toString() {
        return "DollarUniverseJob [uprFieldName=" + this.uprFieldName + "\n type=" + String.valueOf(this.type) + "\n parent=" + String.valueOf(this.parent) + "\n validEntity=" + this.validEntity + "\n standAloneJob=" + this.standAloneJob + "\n optionalAttributes=" + String.valueOf(this.optionalAttributes) + "\n sessionUprAttributes=" + String.valueOf(this.sessionUprAttributes) + "\n sourceDefinitions=" + String.valueOf(this.sourceDefinitions) + "\n assistingJobs=" + String.valueOf(this.assistingJobs) + "\n uprAttributes=" + String.valueOf(this.uprAttributes) + "\n sourceTaskDefinition=" + String.valueOf(this.sourceTaskDefinition) + "\n messages=" + String.valueOf(this.messages) + "\n attributes=" + String.valueOf(this.attributes) + "\n autoedits=" + String.valueOf(this.autoedits) + "\n isHeaderJob=" + this.isHeaderJob + "\n onStatements=" + String.valueOf(this.onStatements) + "\n children=" + String.valueOf(this.children) + "\n fatherUpr=" + this.fatherUpr + "\n uprUpdatedRule=" + this.uprUpdatedRule + "\n parentTag=" + String.valueOf(this.parentTags) + "\n rbcs=" + String.valueOf(this.rbcs) + "\n onDoList=" + String.valueOf(this.onDoList) + "\n hdpHandler=" + String.valueOf(this.hdpHandler) + "]";
    }

    public String getOriginalJobData() {
        StringBuilder jobData = new StringBuilder();
        if (this.uprAttributes != null) {
            this.attrHolderToString(jobData, this.uprAttributes.getAttributes());
        }
        if (this.sourceTaskDefinition != null) {
            this.attrHolderToString(jobData, this.sourceTaskDefinition.getAttributes());
        }
        return jobData.toString();
    }

    private void attrHolderToString(StringBuilder jobData, IAttrHolder jobAttributes) {
        if (jobAttributes != null) {
            String[] header;
            for (String field : header = jobAttributes.getCsvHeader().split(",")) {
                jobData.append(String.format("%-20s\t: %s%s", field, jobAttributes.getAttr(field), "\r\n"));
            }
        }
    }

    public SchedEntity.TYPE getType() {
        return this.type;
    }

    public static enum TASKTYPES {
        illegal,
        schedule,
        provoked,
        optional,
        cylical;

    }
}

