/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.dollar_universe;

import com.bmc.ctmconvert.base.BaseMessageDialog;
import com.bmc.ctmconvert.common.ExceptionHandler;
import com.bmc.ctmconvert.common.Globs;
import com.bmc.ctmconvert.common.TextManager;
import com.bmc.ctmconvert.common.log.ConversionLogger;
import com.bmc.ctmconvert.dataimport.ImportEntry;
import com.bmc.ctmconvert.dataimport.ImportEntryList;
import com.bmc.ctmconvert.dataimport.Importer;
import com.bmc.ctmconvert.dollar_universe.MU2csv;
import com.bmc.ctmconvert.dollar_universe.Resources2csv;
import com.bmc.ctmconvert.dollar_universe.Rules2csv;
import com.bmc.ctmconvert.dollar_universe.Session;
import com.bmc.ctmconvert.dollar_universe.Task;
import com.bmc.ctmconvert.dollar_universe.Uproc2csv;
import com.bmc.ctmconvert.io.csv.CsvReader;
import com.bmc.ctmconvert.io.csv.CsvWriter;
import com.bmc.ctmconvert.progress.Progressable;
import com.bmc.ctmconvert.services.ConversionEntitiesService;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class DollarUniverseImporter
extends Importer {
    private ImportEntryList entries;

    public DollarUniverseImporter(ImportEntryList entries) {
        this.entries = entries;
    }

    public Progressable.ProgressStatus performImport() {
        String dataDirectory = ConversionEntitiesService.getCurrentProjectDataDirectory();
        ImportEntry sessionList = null;
        ImportEntry sessionDetails = null;
        this.setProgressMax(this.entries.size());
        int count = 0;
        for (ImportEntry entry : this.entries) {
            this.setCurrentProgress(++count);
            if (this.isStopped()) break;
            try {
                File sourceFile = new File(dataDirectory + entry.getDestinationFileName());
                switch (entry.getID()) {
                    case "SESSION_LIST": {
                        if (sessionList == null) {
                            sessionList = entry;
                        }
                        if (sessionDetails == null) break;
                    }
                    case "SESSION_DETAILS": {
                        if (sessionDetails == null) {
                            sessionDetails = entry;
                        }
                        if (sessionDetails == null) break;
                        Session session2csv = new Session(new File(dataDirectory + sessionDetails.getDestinationFileName()), dataDirectory);
                        session2csv.writeToCSV();
                        break;
                    }
                    case "TASK": {
                        Task task2csv = new Task(sourceFile, dataDirectory);
                        task2csv.writeToCSV();
                        break;
                    }
                    case "UPR": {
                        File target = new File(dataDirectory);
                        FileOutputStream uprCSVOutput = new FileOutputStream(target.getPath() + Globs.DIRSEP + "UPR.csv");
                        FileOutputStream uprCSVExtensionOutput = new FileOutputStream(target.getPath() + Globs.DIRSEP + "UPR_EXTENSION.csv");
                        File uprocSourceFile = sourceFile;
                        FileInputStream uprInputStream = new FileInputStream(uprocSourceFile);
                        Uproc2csv tmpUpr = new Uproc2csv();
                        tmpUpr.readEntries(uprInputStream);
                        tmpUpr.dumpUpr2csv(uprCSVOutput, uprCSVExtensionOutput);
                        break;
                    }
                    case "RULE": {
                        Rules2csv rul = new Rules2csv(sourceFile, new File(dataDirectory + "Rules.csv"));
                        rul.writeToCSV();
                        break;
                    }
                    case "RESOURCE": {
                        Resources2csv res = new Resources2csv(sourceFile, new File(dataDirectory + "Resources.csv"));
                        res.writeToCSV();
                        break;
                    }
                    case "MU": {
                        MU2csv mu2csv = new MU2csv(sourceFile, new File(dataDirectory + "mu.csv"));
                        mu2csv.writeToCSV();
                        break;
                    }
                }
            }
            catch (Exception e) {
                if (entry.isMandatory()) {
                    this.setStatus(Progressable.ProgressStatus.ENDED_FAILURE);
                    this.showErrorDialogForException(e.getMessage());
                }
                ConversionLogger.getLogger().info(e.getMessage());
            }
        }
        this.setStatus(Progressable.ProgressStatus.ENDED_SUCCESS);
        return this.getStatus();
    }

    private void showErrorDialogForException(String message) {
        BaseMessageDialog.showMessageDialog((String)TextManager.instance().get("CONVERSION_PANEL_CONVERSION_ENDED_DIALOG_TITLE"), (String)TextManager.instance().get("CONVERSION_PANEL_CONVERSION_FAILED"), (BaseMessageDialog.TYPE)BaseMessageDialog.TYPE.ERROR_MESSAGE, (String)message);
    }

    public void postImportAction() {
        this.removeDuplicateEntriesFromCsvFiles();
    }

    private void removeDuplicateEntriesFromCsvFiles() {
        String dataDirectory = ConversionEntitiesService.getCurrentProjectDataDirectory();
        try (DirectoryStream<Path> files = Files.newDirectoryStream(Paths.get(dataDirectory, new String[0]));){
            for (Path file : files) {
                if (!file.toString().endsWith(".csv")) continue;
                this.overwriteWithUniqueLines(file);
            }
        }
        catch (Exception e) {
            ExceptionHandler.writeToExceptionFile((Exception)e);
            this.showErrorDialogForException(e.getMessage());
        }
    }

    private void overwriteWithUniqueLines(Path csvFile) throws IOException {
        DollarUniverseImporter.writeAllCsvRecords(csvFile, DollarUniverseImporter.readUniqueCsvRecords(csvFile));
    }

    private static void writeAllCsvRecords(Path filePath, Set<List<String>> csvRecords) throws IOException {
        try (CsvWriter csvWriter = new CsvWriter(filePath.toString());){
            for (List<String> csvRecord : csvRecords) {
                csvWriter.writeRecord(csvRecord.toArray(new String[0]));
            }
        }
    }

    @NotNull
    private static Set<List<String>> readUniqueCsvRecords(Path filePath) throws IOException {
        try (CsvReader csvReader = new CsvReader(filePath.toString());){
            LinkedHashSet<List<String>> linkedHashSet = new LinkedHashSet<List<String>>(csvReader.readAll());
            return linkedHashSet;
        }
    }
}

