/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.dollar_universe;

import com.bmc.ctmconvert.dollar_universe.DollarUniverseJob;
import com.bmc.ctmconvert.dollar_universe.ResourceConvertor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.Properties;

public class DollarUniverseFormulaExtension {
    public String checkPdate(DollarUniverseJob job, String session, String dep, String pdate) {
        String odate;
        if (pdate.equalsIgnoreCase("(same,same,same)") || pdate.equalsIgnoreCase("(,,)") || pdate.equalsIgnoreCase("( , , )")) {
            odate = "ODAT";
        } else if (pdate.equalsIgnoreCase("(any,any,any)")) {
            odate = "****";
        } else {
            odate = "ODAT";
            job.addReporterMessage("INF7002", session, dep, pdate, odate);
        }
        return odate;
    }

    public String getFormulaFromJob(DollarUniverseJob job) {
        String formula = job.getUprAttribute("formula");
        if (formula == null) {
            return null;
        }
        if (formula.isEmpty()) {
            return null;
        }
        if (formula.startsWith("(")) {
            formula = formula.substring(1);
        }
        if (formula.endsWith(")")) {
            formula = formula.substring(0, formula.length() - 1);
        }
        return formula;
    }

    public void validateBrackets(List<Properties> propList) {
        if (propList == null || propList.isEmpty()) {
            return;
        }
        Properties firstProperties = propList.get(0);
        if (propList.size() == 1) {
            firstProperties.remove("OP");
            return;
        }
        if (this.hasBrackets(propList)) {
            firstProperties.put("OP", "(");
            propList.get(propList.size() - 1).put("OP", ")");
        }
    }

    private boolean hasBrackets(List<Properties> propList) {
        return propList.stream().anyMatch(v -> v.contains("(") || v.contains(")"));
    }

    public Optional<String> checkIfItsAndOrCondition(String element) {
        Optional<String> ret = Optional.empty();
        if (element.equals("OU") || element.equals("OR")) {
            ret = Optional.of("OR");
        } else if (element.equals("ET") || element.equals("AND")) {
            ret = Optional.of("AND");
        }
        return ret;
    }

    public void writeResMesseges(DollarUniverseJob job, String res, ResourceConvertor resourceConvertor) {
        HashMap<String, ArrayList<String[]>> resMessages = resourceConvertor.getResourceMessages(res);
        if (resMessages != null) {
            for (String msgId : resMessages.keySet()) {
                if (resMessages.get(msgId) == null) continue;
                for (String[] msgArgs : resMessages.get(msgId)) {
                    job.addReporterMessage(msgId, msgArgs);
                }
            }
        }
    }
}

