/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.dollar_universe;

import com.bmc.ctmconvert.common.ExceptionHandler;
import com.bmc.ctmconvert.dataimport.ImportEntry;
import com.bmc.ctmconvert.dataimport.autofiledetect.DetectFileForEntry;
import com.bmc.ctmconvert.io.FileUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.nio.charset.CodingErrorAction;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public class DollarUniverseEntryDetector
implements DetectFileForEntry {
    public boolean isDuplicateFilesSupported() {
        return true;
    }

    public List<String> getFilesForEntry(ImportEntry entry, List<Path> files) {
        List<Path> regularFiles = files.stream().filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).collect(Collectors.toList());
        if (entry.getID().equals("AGENT_MAPPING")) {
            return this.detectByName(regularFiles);
        }
        return this.detectByCommand(entry, regularFiles);
    }

    private List<String> detectByName(List<Path> files) {
        return files.stream().map(Path::toAbsolutePath).map(Path::toString).filter(str -> str.toLowerCase().endsWith(".sck")).collect(Collectors.toList());
    }

    private List<String> detectByCommand(ImportEntry entry, List<Path> files) {
        String entryCommand = entry.getCommmand();
        if (entryCommand == null || entryCommand.isEmpty()) {
            return new ArrayList<String>();
        }
        String clearedEntryCommand = this.clearIrrelevantChar(entryCommand);
        return files.stream().filter(file -> this.getCommand((Path)file).contains(clearedEntryCommand)).map(Path::toAbsolutePath).map(Path::toString).collect(Collectors.toList());
    }

    private String getCommand(Path file) {
        String command = "";
        try (BufferedReader bufferedReader = FileUtils.createBufferedReader((Path)file, (CodingErrorAction)CodingErrorAction.REPLACE);){
            int lineCnt = 0;
            while ((command = bufferedReader.readLine()) != null && ++lineCnt < 20 && !(command = this.clearIrrelevantChar(command)).contains("command")) {
            }
        }
        catch (IOException e) {
            ExceptionHandler.writeToExceptionFile((Exception)e);
        }
        return command != null ? command : "";
    }

    private String clearIrrelevantChar(String str) {
        return str.replace("'", "").toLowerCase();
    }
}

