/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.dollar_universe;

import com.bmc.ctmconvert.common.AttrHolder;
import com.bmc.ctmconvert.common.AttrHolderList;
import com.bmc.ctmconvert.common.CsvTable;
import com.bmc.ctmconvert.common.EmptyAttrHolder;
import com.bmc.ctmconvert.common.ExceptionHandler;
import com.bmc.ctmconvert.common.Globs;
import com.bmc.ctmconvert.common.IAttrHolder;
import com.bmc.ctmconvert.common.Params;
import com.bmc.ctmconvert.common.Reporter;
import com.bmc.ctmconvert.common.SchedEntity;
import com.bmc.ctmconvert.common.SourceDefinitions;
import com.bmc.ctmconvert.common.calendars.DefCalFile;
import com.bmc.ctmconvert.common.exceptions.ConvertorCancelClickException;
import com.bmc.ctmconvert.dollar_universe.DollarUCal;
import com.bmc.ctmconvert.dollar_universe.DollarUniverseCalendars;
import com.bmc.ctmconvert.dollar_universe.DollarUniverseCreateConditionByNewFormat;
import com.bmc.ctmconvert.dollar_universe.DollarUniverseCreateDefaultConditions;
import com.bmc.ctmconvert.dollar_universe.DollarUniverseData;
import com.bmc.ctmconvert.dollar_universe.DollarUniverseJob;
import com.bmc.ctmconvert.dollar_universe.DollarUniverseMUAttributes;
import com.bmc.ctmconvert.dollar_universe.DollarUniverseReferencedEntitiesHandler;
import com.bmc.ctmconvert.dollar_universe.DollarUniverseSessionAttributes;
import com.bmc.ctmconvert.dollar_universe.DollarUniverseTaskAttributes;
import com.bmc.ctmconvert.dollar_universe.DollarUniverseTimeZone;
import com.bmc.ctmconvert.dollar_universe.DollarUniverseUprAttributes;
import com.bmc.ctmconvert.dollar_universe.EntityNotInUseTaskGenerator;
import com.bmc.ctmconvert.dollar_universe.FileConfigurationConvertor;
import com.bmc.ctmconvert.dollar_universe.Hdp.logic.HdpLogicInJava;
import com.bmc.ctmconvert.dollar_universe.Hdp.logic.HdpLogicInScript;
import com.bmc.ctmconvert.dollar_universe.MUTable;
import com.bmc.ctmconvert.dollar_universe.NodeGroupCollector;
import com.bmc.ctmconvert.dollar_universe.RbcGenerator;
import com.bmc.ctmconvert.dollar_universe.ResourceConvertor;
import com.bmc.ctmconvert.dollar_universe.Session;
import com.bmc.ctmconvert.dollar_universe.SessionTable;
import com.bmc.ctmconvert.dollar_universe.TaskDetailsCollector;
import com.bmc.ctmconvert.dollar_universe.TaskTable;
import com.bmc.ctmconvert.dollar_universe.UprTable;
import com.bmc.ctmconvert.dollar_universe.handlers.SessionUprocsUsageHandler;
import com.bmc.ctmconvert.dollar_universe.hdpmu.HdpHandler;
import com.bmc.ctmconvert.dollar_universe.hdpmu.MuHierarchy;
import com.bmc.ctmconvert.dollar_universe.utils.DollarUniverseUtils;
import com.bmc.ctmconvert.rules.RulesDataSet;
import com.bmc.ctmconvert.utils.Pair;
import com.bmc.ctmconvert.utils.UniqueConditionNameGenerator;
import com.bmc.ctmconvert.utils.UniqueValueGenerator;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public class DollarUniverseDefs
implements SourceDefinitions {
    private final HashMap<String, String> muToPhysicalNodes = new HashMap();
    private final HashMap<String, DollarUniverseTaskAttributes> sessionTasks = new HashMap();
    private final HashMap<String, DollarUniverseTaskAttributes> uprTasks = new HashMap();
    private final Map<String, DollarUniverseTaskAttributes> templatesTasks = new HashMap<String, DollarUniverseTaskAttributes>();
    private final SessionTable sessionTable;
    private final UprTable uprTable;
    private final MUTable muTable;
    private final CsvTable sapTable;
    private UniqueConditionNameGenerator uniqueConditionNameGenerator;
    private AttrHolderList topLevelParents = null;
    private RulesDataSet rules;
    private Boolean convertEqualPriority = null;
    private Boolean mIsIncludeType = null;
    private Boolean isOrCond = null;
    private final HashMap<String, List<Properties>> onStatements = new HashMap();
    private int[] datFormatArr = null;
    private Boolean m_sessionInconds = true;
    private Boolean m_depconInconds = true;
    private Boolean m_resconInconds = true;
    private Boolean isToDummy = null;
    private MuHierarchy muHierarchy;
    private NodeGroupCollector nodeGroupCollector;
    public static String HASH_SEPARATOR = " - ";
    private ArrayList<String> messages = new ArrayList();
    private FileConfigurationConvertor sapConvertor;
    private ResourceConvertor resourceConvertor;
    private RbcGenerator rbcGenerator;
    private DollarUniverseCreateDefaultConditions defaultConditions;
    private DollarUniverseCreateConditionByNewFormat newFormatCondition;
    private List<String> notInUseUprocs = new ArrayList<String>();
    private List<String> notInUseSess = new ArrayList<String>();
    private Map<String, DollarUniverseTaskAttributes> generatedSessionsWithoutATask = new HashMap<String, DollarUniverseTaskAttributes>();
    private TaskTable taskToSessionTable;
    private final UniqueValueGenerator uniqueValueGenerator;
    private List<String> nodesWithTemplateUprs;
    public boolean isDataWithoutNodes = false;
    public Map<String, Pair<String, String>> sessionsHeaderAndTrailer;

    public DollarUniverseDefs(DollarUniverseData data, RulesDataSet rules, UniqueConditionNameGenerator uniqueConditionNameGenerator) {
        this.rules = rules;
        this.sapTable = data.getSapTable();
        this.sessionTable = data.getSessionTable();
        this.uprTable = data.getUprTable();
        this.muTable = data.getmUTable();
        this.muHierarchy = data.getMuHierarchy();
        Params.instance().setFirstDayOfTheWeek(rules.getStringRule("DOLLAR UNIVERSE rules", new String[]{"FIRST_DAY_OF_WEEK"}));
        this.resourceConvertor = data.getResourcrConvertor();
        this.nodeGroupCollector = new NodeGroupCollector();
        this.rbcGenerator = data.getRbcGenertor();
        InputStream dataMappingStream = data.getDataMappingStream();
        if (dataMappingStream != null) {
            this.loadMUmapFile(dataMappingStream);
        }
        this.uniqueValueGenerator = new UniqueValueGenerator();
        this.uniqueConditionNameGenerator = uniqueConditionNameGenerator;
    }

    private void setUpConditions() {
        this.defaultConditions = new DollarUniverseCreateDefaultConditions(this.sessionTable, this.uprTable, this.resourceConvertor, this.m_sessionInconds, this.m_depconInconds, this.m_resconInconds, this.rules);
        this.newFormatCondition = new DollarUniverseCreateConditionByNewFormat(this.uprTable, this.sessionTable, this.resourceConvertor, this.uniqueConditionNameGenerator, this.rules);
    }

    private void generateNotInUseUprocs() {
        TaskDetailsCollector taskDetailsCollector = new TaskDetailsCollector(this.uprTasks, this.sessionTasks);
        taskDetailsCollector.collect();
        Set<String> inUseUprocs = taskDetailsCollector.getUsedUprocsFromTask();
        Set<String> inUseSessionsFromTask = taskDetailsCollector.getInUseSessionsFromTask();
        SessionUprocsUsageHandler sessionUprocsUsageHandler = new SessionUprocsUsageHandler(this.sessionTable.getSessions(), inUseSessionsFromTask);
        sessionUprocsUsageHandler.collectUprocsFromInUseSessions();
        inUseUprocs.addAll(sessionUprocsUsageHandler.getUprocsFromInUseSessions());
        Predicate<String> inUseSessionPredicate = sesName -> !inUseSessionsFromTask.contains(sesName);
        this.notInUseSess = this.sessionTable.getSessions().keySet().stream().filter(inUseSessionPredicate).collect(Collectors.toList());
        sessionUprocsUsageHandler = new SessionUprocsUsageHandler(this.sessionTable.getSessions(), new HashSet<String>(this.notInUseSess));
        sessionUprocsUsageHandler.collectUprocsFromInUseSessions();
        Set<String> notInUseSessUprocs = sessionUprocsUsageHandler.getUprocsFromInUseSessions();
        HashMap<String, DollarUniverseUprAttributes> uprocs = this.uprTable.getUprs();
        Predicate<String> inUseUprocPredicate = uprocName -> !inUseUprocs.contains(uprocName) && !notInUseSessUprocs.contains(uprocName);
        this.notInUseUprocs = uprocs.keySet().stream().filter(inUseUprocPredicate).collect(Collectors.toList());
    }

    public void applyFilter(String root) {
        AttrHolderList filteredList = new AttrHolderList();
        if (this.topLevelParents == null) {
            return;
        }
        for (IAttrHolder parent : this.topLevelParents) {
            if (!this.isFilter(parent)) continue;
            filteredList.add((Object)parent);
        }
        this.topLevelParents = null;
        this.topLevelParents = filteredList;
    }

    public Map<String, DollarUniverseTaskAttributes> getChildrenForSessionWithoutTaskFolder() {
        return this.generatedSessionsWithoutATask;
    }

    private boolean isFilter(IAttrHolder record) {
        boolean rc = true;
        boolean funcRC = false;
        boolean isInclude = this.getIncludeType();
        boolean isOrCondition = this.getOrCondition();
        ArrayList filterConds = this.rules.getFilterHandler().getConditions();
        if (filterConds.isEmpty()) {
            return true;
        }
        for (Map.Entry entry : filterConds) {
            String field = (String)entry.getKey();
            String regVal = (String)entry.getValue();
            String recordVal = "";
            if (field.equalsIgnoreCase("Session Name")) {
                recordVal = record.getAttr("ses");
            } else if (field.equalsIgnoreCase("MU Name")) {
                recordVal = record.getAttr("mu");
            } else if (field.equalsIgnoreCase("User Name")) {
                recordVal = record.getAttr("user");
            }
            funcRC = this.matchWildcard(recordVal, regVal);
            if (funcRC) {
                rc = true;
                if (!isOrCondition) continue;
                break;
            }
            rc = false;
            if (isOrCondition) continue;
            break;
        }
        return isInclude == rc;
    }

    private boolean getIncludeType() {
        if (this.mIsIncludeType == null) {
            this.mIsIncludeType = this.rules.getFilterHandler().isInclude();
        }
        return this.mIsIncludeType;
    }

    private boolean getOrCondition() {
        if (this.isOrCond == null) {
            this.isOrCond = this.rules.getFilterHandler().isOr();
        }
        return this.isOrCond;
    }

    private boolean matchWildcard(String value, String expr) {
        String regExp = expr.replaceAll("\\*", ".*");
        regExp = regExp.replaceAll("\\?", ".");
        return value.matches(regExp);
    }

    public void createDependencies(String root) {
    }

    public Set<Properties> createTags(String root) {
        return null;
    }

    public void finalize_() {
        DollarUniverseTimeZone.destroy();
        this.getHdpLogic().createHdpScriptsDir();
    }

    public AttrHolderList getChildren(String parentEntityId) {
        return null;
    }

    public String getEntNameFieldName() {
        return "upr";
    }

    public ArrayList<String> getGeneralMessages() {
        if (!this.messages.isEmpty()) {
            return this.messages;
        }
        return new ArrayList<String>();
    }

    public String getIdFieldName() {
        return "ID";
    }

    public List<Properties> getJobControlRes(SchedEntity job) {
        return null;
    }

    public void setJobIncondTypes(Boolean session, Boolean depcon, Boolean rescon) {
        this.m_sessionInconds = session;
        this.m_depconInconds = depcon;
        this.m_resconInconds = rescon;
        this.defaultConditions.setJobInConditionTypes(session, depcon, rescon);
    }

    public List<Properties> getJobInconds(SchedEntity job) {
        if (DollarUniverseUtils.isAtoBConditionFormat(this.rules)) {
            return this.newFormatCondition.getJobInconds(job);
        }
        return this.defaultConditions.getJobInconds(job);
    }

    public List<String> buildCondName(String parentName, String id, String mu, String job, String num, String path, int numS, String nodeName, DollarUniverseJob jobObject) {
        if (DollarUniverseUtils.isAtoBConditionFormat(this.rules)) {
            return this.newFormatCondition.buildAToBCondName(parentName, id, job, numS, jobObject, nodeName);
        }
        return this.defaultConditions.buildEndedNotOkConds(id, mu, job, num, nodeName, path, jobObject, numS);
    }

    public List<Properties> getJobOnstmts(SchedEntity job) {
        String sessionId = ((DollarUniverseJob)job).getOriginalSessionId();
        String jobName = ((DollarUniverseJob)job).getOriginalSessionJobName();
        String num = ((DollarUniverseJob)job).getOriginalSessionJobNum();
        String key = DollarUniverseDefs.buildJobIdKey(sessionId, jobName, num);
        return this.onStatements.get(key);
    }

    public List<Properties> getJobOnstmts(SchedEntity job, boolean create) {
        List<Properties> toRet = this.getJobOnstmts(job);
        if (toRet == null && create) {
            toRet = new ArrayList<Properties>();
            String sessionId = ((DollarUniverseJob)job).getOriginalSessionId();
            String jobName = ((DollarUniverseJob)job).getOriginalSessionJobName();
            String num = ((DollarUniverseJob)job).getOriginalSessionJobNum();
            String key = DollarUniverseDefs.buildJobIdKey(sessionId, jobName, num);
            this.onStatements.put(key, toRet);
        }
        return toRet;
    }

    public List<Properties> getJobOutconds(SchedEntity job) {
        if (DollarUniverseUtils.isAtoBConditionFormat(this.rules)) {
            return this.newFormatCondition.getJobOutconds(job);
        }
        return this.defaultConditions.getJobOutconds(job);
    }

    public String getParentEntFieldName() {
        return null;
    }

    public String getUprID(String uprName, String nodeName) {
        return uprName + "_" + nodeName;
    }

    public AttrHolderList getTopLevelEntities() {
        if (this.topLevelParents != null) {
            return this.topLevelParents;
        }
        this.setUpTopLevelEntities();
        return this.topLevelParents;
    }

    private void setUpTopLevelEntities() {
        this.topLevelParents = new AttrHolderList();
        for (String taskKey : this.sessionTasks.keySet()) {
            DollarUniverseTaskAttributes task = this.sessionTasks.get(taskKey);
            String taskNodeName = task.getAttributes().getAttr("node name");
            String header = task.getAttributes().getAttr("upr");
            if (this.getSessions().containsKey(Session.sessionId(task.getAttributes().getAttr("ses"), header, taskNodeName))) {
                if (!this.getUprs().containsKey(this.getUprID(header, taskNodeName))) {
                    Reporter.addMessage(this.messages, (String)"ERR7001", (String)task.getAttributes().getAttr("upr"), (String[])new String[]{task.getAttributes().getAttr("ses"), task.getAttributes().getAttr("ID")});
                    continue;
                }
                if (!this.convertDisabledTask(task)) continue;
                this.topLevelParents.add((Object)task.getAttributes());
                continue;
            }
            if (this.sessionTable.sessionHasSon(task.getAttributes().getAttr("ses"), task.getAttributes().getAttr("upr"))) continue;
            this.addSessionUprocHeaderNorFoundError(task);
        }
        EntityNotInUseTaskGenerator UprocNotInUseTaskGenerator = null;
        if (this.rules.getBooleanRule("DOLLAR UNIVERSE rules", new String[]{"ConvertUPROCsWithoutATask"}).booleanValue()) {
            UprocNotInUseTaskGenerator = new EntityNotInUseTaskGenerator(this);
            UprocNotInUseTaskGenerator.generateTasksForEntitiessWithoutTask();
            this.generatedSessionsWithoutATask = UprocNotInUseTaskGenerator.getTasksForNotInUseSessionMap();
            if (this.generatedSessionsWithoutATask.size() > 0) {
                AttrHolder parentTaskSessionWithoutTask = DollarUniverseDefs.getTaskAttr("SessionsWithoutATask", "", "", "");
                this.sessionTasks.put("SessionsWithoutATask", new DollarUniverseTaskAttributes((IAttrHolder)parentTaskSessionWithoutTask));
                this.topLevelParents.add((Object)parentTaskSessionWithoutTask);
            }
            this.uprTasks.putAll(UprocNotInUseTaskGenerator.getTasksForNotInUseUprocsMap());
        }
        if (this.isConvertTemplatesRuleEnabled()) {
            this.addTemplatesFoldersToTopLevelEntities();
        }
        if (this.isRemoveHeadersAndTrailersRuleEnabled()) {
            this.getSessionsHeaderAndTrailer();
        }
        this.addTasksWithOutSessionToTopLevelEntities(UprocNotInUseTaskGenerator);
        this.setUpConditions();
    }

    private void getSessionsHeaderAndTrailer() {
        this.sessionsHeaderAndTrailer = this.sessionTable.getSessionsHeaderAndTrailer();
    }

    public Pair<String, String> getHeaderAndTrailerOfSession(String sessionId) {
        return this.sessionsHeaderAndTrailer.get(sessionId);
    }

    public boolean isRemoveHeadersAndTrailersRuleEnabled() {
        return this.rules.getBooleanRule("DOLLAR UNIVERSE rules", new String[]{"removeHeadersAndTrailers"});
    }

    public boolean isConvertTemplatesRuleEnabled() {
        return this.rules.getBooleanRule("DOLLAR UNIVERSE rules", new String[]{"enableReferenceFolders"});
    }

    public List<String> getNodesWithTemplateUprs() {
        return this.nodesWithTemplateUprs;
    }

    public boolean isDataWithoutNodes() {
        return this.isDataWithoutNodes;
    }

    public List<String> getTemplateUprsByNode(String nodeName) {
        return this.templatesTasks.keySet().stream().filter(taskID -> taskID.contains(nodeName)).collect(Collectors.toList());
    }

    private void addTemplatesFoldersToTopLevelEntities() {
        DollarUniverseReferencedEntitiesHandler dollarUniverseReferencedEntitiesHandler = new DollarUniverseReferencedEntitiesHandler(this);
        dollarUniverseReferencedEntitiesHandler.generateTasksForTemplateUprs();
        this.templatesTasks.putAll(dollarUniverseReferencedEntitiesHandler.getTasksForTemplateUprocsMap());
        this.nodesWithTemplateUprs = dollarUniverseReferencedEntitiesHandler.getListOfNodes();
        String sessName = "TemplateJobs";
        String sessionId = Session.sessionId(sessName, "", "");
        IAttrHolder sessionAttrHolder = this.createSessionAttrHolder(sessionId, "", sessName, "");
        DollarUniverseSessionAttributes session = new DollarUniverseSessionAttributes(sessionAttrHolder);
        this.putTemplateUprsUnderOneSmartFolder(session, dollarUniverseReferencedEntitiesHandler);
        this.getSessions().put(sessionId, session);
        AttrHolder templateTasks = DollarUniverseDefs.getTaskAttr(sessName, sessName, "", "");
        this.sessionTasks.put(sessName, new DollarUniverseTaskAttributes((IAttrHolder)templateTasks));
        this.topLevelParents.add((Object)templateTasks);
    }

    private void putTemplateUprsUnderOneSmartFolder(DollarUniverseSessionAttributes mainSession, DollarUniverseReferencedEntitiesHandler dollarUniverseReferencedEntitiesHandler) {
        List<String> nodesWithTemplates = this.getNodesWithTemplateUprs();
        String sessName = mainSession.getAttributes().getAttr("ses");
        if (dollarUniverseReferencedEntitiesHandler.isDataWithoutNodes()) {
            this.isDataWithoutNodes = true;
            this.putTemplateUprsUnderSubFoldersAccordingToNode("", mainSession);
        } else {
            for (String nodeName : nodesWithTemplates) {
                String sessionId = Session.sessionId(sessName, "", nodeName);
                IAttrHolder sessionAttrHolder = this.createSessionAttrHolder(sessionId, "", sessName, nodeName);
                DollarUniverseSessionAttributes session = new DollarUniverseSessionAttributes(sessionAttrHolder);
                this.putTemplateUprsUnderSubFoldersAccordingToNode(nodeName, session);
                this.getSessions().put(sessionId, session);
                AttrHolder templateTasks = DollarUniverseDefs.getTaskAttr(sessionId, sessName, "", nodeName);
                this.sessionTasks.put(sessionId, new DollarUniverseTaskAttributes((IAttrHolder)templateTasks));
            }
        }
    }

    private void putTemplateUprsUnderSubFoldersAccordingToNode(String nodeName, DollarUniverseSessionAttributes session) {
        List<String> templateUprs = this.getTemplateUprsByNode(nodeName);
        Integer numberUpr = 1;
        Map<String, Integer> attrName2Index = this.getSessionAttrMap();
        for (String taskKey : templateUprs) {
            DollarUniverseTaskAttributes task = this.templatesTasks.get(taskKey);
            String uprNumberStr = String.format("%03d", numberUpr);
            IAttrHolder attributes = task.getAttributes();
            String uprName = attributes.getAttr("upr");
            this.addUprToSession(attrName2Index, session, uprNumberStr, attributes, uprName, attributes.getAttr("node name"));
            session.getAttributes().appendAttr("NumF", "000");
            session.getAttributes().appendAttr("NumS", uprNumberStr);
            session.getAttributes().appendAttr("Father", uprName);
            session.getAttributes().appendAttr("Son", uprName);
            session.getAttributes().appendAttr("isTemplateSubFolder", "1");
            this.sessionTasks.put(attributes.getAttr("ID"), task);
            Integer n = numberUpr;
            numberUpr = numberUpr + 1;
        }
    }

    private void addSessionUprocHeaderNorFoundError(DollarUniverseTaskAttributes task) {
        String uprocName = task.getAttributes().getAttr("upr");
        String taskName = task.getAttributes().getAttr("ses");
        String taskNodeName = task.getAttributes().getAttr("node name");
        String sessionName = Session.sessionId(taskName, uprocName, taskNodeName);
        String muId = MUTable.buildMuId(task.getAttributes().getAttr("mu"), taskNodeName);
        DollarUniverseMUAttributes dollarUniverseMUAttributes = this.muTable.getMU().get(muId);
        String nodeName = "";
        if (dollarUniverseMUAttributes != null) {
            nodeName = dollarUniverseMUAttributes.getAttributes().getAttr("tnode");
        }
        Reporter.addMessage(this.messages, (String)"ERR7004", (String)uprocName, (String[])new String[]{sessionName, uprocName, taskName, nodeName});
    }

    static ArrayList<String> getArrayOfRulesFromRuleField(String rulesExpression) {
        ArrayList<String> rulesArr = new ArrayList<String>();
        Pattern rulesPattern = Pattern.compile("\\(.*?\\)[^\\)\\(]*");
        Matcher match = rulesPattern.matcher(rulesExpression);
        while (match.find()) {
            if (match.group() == null) continue;
            rulesArr.add(match.group());
        }
        return rulesArr;
    }

    static String getRuleNameAndStartDate(String ruleExp) {
        Pattern rulesPattern = Pattern.compile("\\(.*?\\)");
        Matcher match = rulesPattern.matcher(ruleExp);
        if (match.find() && match.group() != null) {
            return match.group();
        }
        return ruleExp;
    }

    static String getLunchTime(String ruleExp) {
        Pattern rulesPattern = Pattern.compile("(launch time:)\\s.*(\\d{2}:\\d{2})");
        Matcher match = rulesPattern.matcher(ruleExp);
        if (match.find() && match.group() != null) {
            return match.group();
        }
        return "";
    }

    private void addTasksWithOutSessionToTopLevelEntities(EntityNotInUseTaskGenerator UprocNotInUseTaskGenerator) {
        if (!this.isStandAloneGrouped()) {
            this.putEachStandAloneJobIntoHisOwnSmartFolder();
        } else {
            this.putAllStandAloneJobsUnderOneSmartFolder(UprocNotInUseTaskGenerator);
        }
    }

    private void putAllStandAloneJobsUnderOneSmartFolder(EntityNotInUseTaskGenerator uprocNotInUseTaskGenerator) {
        if (uprocNotInUseTaskGenerator != null) {
            this.splitTheStandAloneJobsFolder(uprocNotInUseTaskGenerator);
        } else {
            this.putAllStandAloneJobsUnderOneSmartTable(this.uprTasks, "StandAloneJobs");
        }
    }

    private void splitTheStandAloneJobsFolder(EntityNotInUseTaskGenerator uprocNotInUseTaskGenerator) {
        Map<String, DollarUniverseTaskAttributes> tasksForNotInUseUprocsMap = uprocNotInUseTaskGenerator.getTasksForNotInUseUprocsMap();
        HashMap<String, DollarUniverseTaskAttributes> uprWithTask = new HashMap<String, DollarUniverseTaskAttributes>();
        HashMap<String, DollarUniverseTaskAttributes> uprWithoutTask = new HashMap<String, DollarUniverseTaskAttributes>();
        for (String entry : this.uprTasks.keySet()) {
            if (!tasksForNotInUseUprocsMap.containsKey(entry)) {
                uprWithTask.put(entry, this.uprTasks.get(entry));
                continue;
            }
            uprWithoutTask.put(entry, this.uprTasks.get(entry));
        }
        this.putAllStandAloneJobsUnderOneSmartTable(uprWithoutTask, "StandAloneJobs_WithoutScheduling");
        this.putAllStandAloneJobsUnderOneSmartTable(uprWithTask, "StandAloneJobs");
    }

    private void putAllStandAloneJobsUnderOneSmartTable(HashMap<String, DollarUniverseTaskAttributes> uprs, String sess) {
        if (!uprs.isEmpty()) {
            String sessionId = Session.sessionId(sess, "", "");
            IAttrHolder sessionAttrHolder = this.createSessionAttrHolder(sessionId, "", sess, "");
            DollarUniverseSessionAttributes session = new DollarUniverseSessionAttributes(sessionAttrHolder);
            this.addAllStandAloneUprsToStanAloneSession(uprs, session);
            this.getSessions().put(sessionId, session);
            AttrHolder tasksWithoutSession = DollarUniverseDefs.getTaskAttr(sess, sess, "", "");
            this.sessionTasks.put(sess, new DollarUniverseTaskAttributes((IAttrHolder)tasksWithoutSession));
            this.topLevelParents.add((Object)tasksWithoutSession);
        }
    }

    private void addAllStandAloneUprsToStanAloneSession(HashMap<String, DollarUniverseTaskAttributes> uprs, DollarUniverseSessionAttributes session) {
        Integer numberUpr = 1;
        Map<String, Integer> attrName2Index = this.getSessionAttrMap();
        for (String taskKey : uprs.keySet()) {
            DollarUniverseTaskAttributes task = uprs.get(taskKey);
            if (!this.convertDisabledTask(task)) continue;
            String uprNumberStr = String.format("%03d", numberUpr);
            IAttrHolder attributes = task.getAttributes();
            String uprName = attributes.getAttr("upr");
            this.addUprToSession(attrName2Index, session, uprNumberStr, attributes, uprName, attributes.getAttr("node name"));
            session.getAttributes().appendAttr("NumF", "000");
            session.getAttributes().appendAttr("NumS", uprNumberStr);
            session.getAttributes().appendAttr("Father", uprName);
            session.getAttributes().appendAttr("Son", uprName);
            if (session.getAttributes().getAttr("ID").contains("_WithoutScheduling")) {
                attributes.setAttr("ses", "StandAloneJobs_WithoutScheduling");
            } else {
                attributes.setAttr("ses", "StandAloneJobs");
            }
            this.sessionTasks.put(attributes.getAttr("ID"), task);
            Integer n = numberUpr;
            numberUpr = numberUpr + 1;
        }
    }

    private void addUprToSession(Map<String, Integer> attrName2Index, DollarUniverseSessionAttributes session, String uprNumberStr, IAttrHolder attributes, String uprName, String nodeName) {
        DollarUniverseUprAttributes upr = this.getUprs().get(this.getUprID(uprName, nodeName));
        if (upr != null) {
            AttrHolder attr = new AttrHolder(new String[]{session.getAttributes().getAttr("ses"), uprName, "", "000", uprNumberStr, "OK", uprName, uprName, "", "", "", nodeName}, attrName2Index);
            attr.setAttr("ID", attributes.getAttr("ID"));
            session.appendUpr((IAttrHolder)attr);
        }
    }

    private void putEachStandAloneJobIntoHisOwnSmartFolder() {
        int idCounter = this.sessionTable.sessions.size();
        for (String taskKey : this.uprTasks.keySet()) {
            DollarUniverseTaskAttributes task = this.uprTasks.get(taskKey);
            if (!this.convertDisabledTask(task)) continue;
            IAttrHolder attributes = task.getAttributes();
            String uprName = attributes.getAttr("upr");
            String nodeName = attributes.getAttr("node name");
            String sessionName = "Standalone_" + uprName;
            attributes.setAttr("ses", sessionName);
            String sessionId = Session.sessionId(sessionName, uprName, nodeName);
            IAttrHolder sessionAttrHolder = this.createSessionAttrHolder(sessionId, uprName, sessionName, nodeName);
            DollarUniverseSessionAttributes session = new DollarUniverseSessionAttributes(sessionAttrHolder);
            this.getSessions().put(sessionId, session);
            this.sessionTasks.put(attributes.getAttr("ID"), task);
            this.topLevelParents.add((Object)task.getAttributes());
        }
    }

    @NotNull
    private Map<String, Integer> getSessionAttrMap() {
        HashMap<String, Integer> attrName2Index = new HashMap<String, Integer>();
        attrName2Index.put("ID", 0);
        attrName2Index.put("ses", 1);
        attrName2Index.put("header", 8);
        attrName2Index.put("NumF", 3);
        attrName2Index.put("NumS", 4);
        attrName2Index.put("Path", 5);
        attrName2Index.put("Father", 6);
        attrName2Index.put("Son", 7);
        attrName2Index.put("HDP/MU", 8);
        attrName2Index.put("LABEL", 9);
        attrName2Index.put("Return Code", 10);
        attrName2Index.put("node name", 11);
        return attrName2Index;
    }

    private IAttrHolder createSessionAttrHolder(String idCounter, String uprName, String sessionName, String nodeName) {
        EmptyAttrHolder sessionAttrHolder = new EmptyAttrHolder();
        sessionAttrHolder.appendAttr("ID", String.valueOf(idCounter));
        sessionAttrHolder.appendAttr("NumF", "000");
        sessionAttrHolder.appendAttr("NumS", "000");
        sessionAttrHolder.appendAttr("Father", uprName);
        sessionAttrHolder.appendAttr("header", uprName);
        sessionAttrHolder.appendAttr("ses", sessionName);
        sessionAttrHolder.appendAttr("Path", "OK");
        sessionAttrHolder.appendAttr("HDP/MU", "");
        sessionAttrHolder.appendAttr("LABEL", "");
        sessionAttrHolder.appendAttr("node name", nodeName);
        return sessionAttrHolder;
    }

    public boolean hasChildren(String entId) {
        if (entId.contains("SessionsWithoutATask")) {
            return this.generatedSessionsWithoutATask.size() > 0;
        }
        return this.sessionTasks.containsKey(entId);
    }

    public void init() throws ConvertorCancelClickException {
        this.sapConvertor = new FileConfigurationConvertor();
        String sapMappingPath = Globs.DATA_DIR + Globs.DIRSEP + "DUSapMapping.xml";
        Path path = Paths.get(sapMappingPath, new String[0]);
        boolean isFileExists = Files.exists(path, new LinkOption[0]);
        if (isFileExists) {
            this.sapConvertor.loadConfigurations(sapMappingPath);
        }
        this.getTopLevelEntities();
        String topLevel = "0";
        this.applyFilter(topLevel);
    }

    public boolean isContainerEntity(IAttrHolder entAttr) {
        return false;
    }

    public boolean isStandAloneGrouped() {
        return this.rules.getStringRule("DOLLAR UNIVERSE rules", new String[]{"GROUP_STANDALONE_JOBS_IN_ONE_TABLE"}).equals("OneTable");
    }

    public SchedEntity spawnJob(String table, IAttrHolder attributes) {
        DollarUniverseJob schedEntity;
        if (!table.isEmpty()) {
            DollarUniverseTaskAttributes task = this.uprTasks.get(attributes.getAttr("ID"));
            if (task == null || task.getUpdated()) {
                return null;
            }
            schedEntity = new DollarUniverseJob(attributes.getAttr("ID"), this, this.uniqueValueGenerator);
        } else {
            schedEntity = new DollarUniverseJob(attributes.getAttr("ID"), this, this.uniqueValueGenerator);
            schedEntity.getChildren();
        }
        return schedEntity;
    }

    public SchedEntity spawnJob(SchedEntity parent, IAttrHolder attributes) {
        return new DollarUniverseJob(attributes, (DollarUniverseJob)parent, this);
    }

    public HashMap<String, DollarUniverseTaskAttributes> getSessionTasks() {
        return this.sessionTasks;
    }

    public HashMap<String, DollarUniverseTaskAttributes> getUPRTasks() {
        return this.uprTasks;
    }

    public Map<String, DollarUniverseSessionAttributes> getSessions() {
        return this.sessionTable.getSessions();
    }

    public HashMap<String, DollarUniverseMUAttributes> getMUs() {
        return this.muTable.getMU();
    }

    public Map<String, DollarUniverseUprAttributes> getUprs() {
        return this.uprTable.getUprs();
    }

    public Map<String, DollarUniverseUprAttributes> getUprsByNode(String nodeName) {
        return this.uprTable.getUprsByNode(nodeName);
    }

    public Map<String, DollarUniverseSessionAttributes> getSessionsByNode(String nodeName) {
        return this.sessionTable.getSessionsByNode(nodeName);
    }

    public IAttrHolder getSapParams(String jobName) {
        return this.sapTable.getAttrWhere(jobName);
    }

    private void loadMUmapFile(InputStream dataMappingFile) {
        try {
            String line;
            BufferedReader input = new BufferedReader(new InputStreamReader(dataMappingFile));
            while ((line = input.readLine()) != null) {
                String[] params;
                if ((line = line.trim()).isEmpty() || (params = line.split("[ \\t]+")).length != 2) continue;
                this.muToPhysicalNodes.put(params[0], params[1]);
            }
            input.close();
        }
        catch (IOException e) {
            ExceptionHandler.writeToExceptionFile((Exception)e);
        }
    }

    public String managmentUnitToPhysicalNode(String mu) {
        if (this.muToPhysicalNodes.isEmpty()) {
            return "";
        }
        if (this.muToPhysicalNodes.containsKey(mu)) {
            return this.muToPhysicalNodes.get(mu);
        }
        return "";
    }

    protected boolean convertPriority() {
        if (this.convertEqualPriority == null) {
            boolean allEqual;
            this.convertEqualPriority = this.rules.getStringRule("DOLLAR UNIVERSE rules", new String[]{"CONVERT_EQUAL_PRIORITIES"}).equalsIgnoreCase("CONVERT") ? Boolean.valueOf(true) : ((allEqual = this.areAllPrioritiesEqual()) ? Boolean.valueOf(false) : Boolean.valueOf(true));
        }
        return this.convertEqualPriority;
    }

    private boolean areAllPrioritiesEqual() {
        int priority;
        boolean isFirst = true;
        int firstPriorityInt = 0;
        for (DollarUniverseTaskAttributes dollarUniverseTaskAttributes : this.getSessionTasks().values()) {
            if (isFirst) {
                try {
                    firstPriorityInt = Integer.parseInt(dollarUniverseTaskAttributes.getAttributes().getAttr("prty"));
                }
                catch (NumberFormatException ex) {
                    ExceptionHandler.writeToExceptionFile((Exception)ex);
                    return false;
                }
                isFirst = false;
                continue;
            }
            try {
                priority = Integer.parseInt(dollarUniverseTaskAttributes.getAttributes().getAttr("prty"));
            }
            catch (NumberFormatException ex) {
                ExceptionHandler.writeToExceptionFile((Exception)ex);
                return false;
            }
            if (priority == firstPriorityInt) continue;
            return false;
        }
        for (DollarUniverseTaskAttributes dollarUniverseTaskAttributes : this.getUPRTasks().values()) {
            try {
                priority = Integer.parseInt(dollarUniverseTaskAttributes.getAttributes().getAttr("prty"));
            }
            catch (NumberFormatException ex) {
                ExceptionHandler.writeToExceptionFile((Exception)ex);
                return false;
            }
            if (priority == firstPriorityInt) continue;
            return false;
        }
        return true;
    }

    public static String buildJobIdKey(String id, String job, String num) {
        return id + HASH_SEPARATOR + job + HASH_SEPARATOR + num;
    }

    public int[] getDateFormat() {
        if (this.datFormatArr == null) {
            String format = this.rules.getStringRule("DOLLAR UNIVERSE rules", new String[]{"DATE_FORMAT"});
            String[] formatArr = format.split("/");
            this.datFormatArr = new int[3];
            int index = 1;
            for (String str : formatArr) {
                if (str.toUpperCase().startsWith("YY")) {
                    this.datFormatArr[0] = index;
                } else if (str.toUpperCase().startsWith("MM")) {
                    this.datFormatArr[1] = index;
                } else if (str.toUpperCase().startsWith("DD")) {
                    this.datFormatArr[2] = index;
                } else {
                    this.datFormatArr[0] = 3;
                    this.datFormatArr[1] = 2;
                    this.datFormatArr[2] = 1;
                }
                ++index;
            }
        }
        return this.datFormatArr;
    }

    public boolean isToDummy() {
        if (this.isToDummy == null) {
            this.isToDummy = this.rules.getTaskTypeHandler().isToDummy();
        }
        return this.isToDummy;
    }

    public ArrayList<String> getSAPHeaders() {
        return this.sapTable.getHeaders();
    }

    public FileConfigurationConvertor getCleanSapConvertor() {
        this.sapConvertor.restart();
        return this.sapConvertor;
    }

    public MuHierarchy getMuDependencies() {
        return this.muHierarchy;
    }

    public HdpHandler.HdpLogicHandler getHdpLogic() {
        boolean logicInScript = true;
        Boolean isConditionNeeded = false;
        if (logicInScript) {
            return new HdpLogicInScript(this.muHierarchy, this::getMuPhysicalName, isConditionNeeded);
        }
        return new HdpLogicInJava(this.muHierarchy, this::getMuPhysicalName, isConditionNeeded);
    }

    public NodeGroupCollector getNodeGroupCollector() {
        return this.nodeGroupCollector;
    }

    public IAttrHolder getMuAttributes(String muName, String commandNode) {
        String muId = MUTable.buildMuId(muName, commandNode);
        DollarUniverseMUAttributes muAttribute = this.muTable.getMU().get(muId);
        if (muAttribute == null) {
            return null;
        }
        return muAttribute.getAttributes();
    }

    public String getMuPhysicalName(String muName, String commandNode) {
        String physicalName = "";
        IAttrHolder muAttributes = this.getMuAttributes(muName, commandNode);
        if (muAttributes != null) {
            String logicMU = muAttributes.getAttr("tnode");
            physicalName = this.managmentUnitToPhysicalNode(logicMU);
        }
        return physicalName;
    }

    public ResourceConvertor getResourceConvertor() {
        return this.resourceConvertor;
    }

    public RbcGenerator getRbcGenerator() {
        return this.rbcGenerator;
    }

    public RulesDataSet getRules() {
        return this.rules;
    }

    public void loadToTaskTable() {
        this.taskToSessionTable = new TaskTable(this, "SESSION");
        this.taskToSessionTable.load(Params.instance().getDatasourcePath() + "task_session.csv");
        new TaskTable(this, "UPR").load(Params.instance().getDatasourcePath() + "task_upr.csv");
        try (DefCalFile defCalFile = DefCalFile.createDefCalFile();){
            DollarUniverseCalendars calendars = new DollarUniverseCalendars();
            calendars.writeCalendars(Params.instance().getDatacenterName(), this.rules.getStringRule("DOLLAR UNIVERSE rules", new String[]{"AREA"}), defCalFile);
        }
        catch (IOException e) {
            ExceptionHandler.writeToExceptionFile((Exception)e);
        }
        this.generateNotInUseUprocs();
    }

    public void loadTaskTableData_ForTest(DollarUniverseData data) {
        this.taskToSessionTable = new TaskTable(this, "SESSION");
        this.taskToSessionTable.load(data.getTaskSessionStream());
        new TaskTable(this, "UPR").load(data.getTaskUprStream());
        try (DefCalFile defCalFile = DefCalFile.createDefCalFile();){
            ArrayList<DollarUCal> calendar = new ArrayList<DollarUCal>();
            DollarUniverseCalendars calendars = new DollarUniverseCalendars(calendar);
            calendars.writeCalendars(Params.instance().getDatacenterName(), this.rules.getStringRule("DOLLAR UNIVERSE rules", new String[]{"AREA"}), defCalFile);
        }
        catch (IOException e) {
            ExceptionHandler.writeToExceptionFile((Exception)e);
        }
        this.generateNotInUseUprocs();
    }

    public List<Properties> getResconJobInconds(DollarUniverseJob dollarUniverseJob) {
        List<Properties> ret = DollarUniverseUtils.isAtoBConditionFormat(this.rules) ? this.newFormatCondition.getJobRescon(dollarUniverseJob) : this.defaultConditions.getResconJobInConditions(dollarUniverseJob);
        return ret;
    }

    public List<String> getNotInUseUprocs() {
        return new ArrayList<String>(this.notInUseUprocs);
    }

    public List<String> getNotInUseSession() {
        return new ArrayList<String>(this.notInUseSess);
    }

    public TaskTable getTaskToSessionTable() {
        return this.taskToSessionTable;
    }

    public Map<Properties, List<Properties>> getOnEndedDoCond(DollarUniverseJob job) {
        if (DollarUniverseUtils.isAtoBConditionFormat(this.rules)) {
            return this.newFormatCondition.getOnEndedDoCond(job);
        }
        return this.defaultConditions.getOnEndedDoCond(job);
    }

    @NotNull
    public Map<Properties, List<Properties>> getOnEndedNotOkDoCond(DollarUniverseJob job) {
        if (DollarUniverseUtils.isAtoBConditionFormat(this.rules)) {
            return this.newFormatCondition.getOnEndedNotOkDoCond(job);
        }
        return this.defaultConditions.getOnEndedNotOkDoCond(job);
    }

    boolean isDisabledTask(DollarUniverseTaskAttributes sourceTaskDefinition) {
        return Optional.ofNullable(sourceTaskDefinition).map(taskDefinition -> taskDefinition.getAttributes().getAttr("disable")).map("disable"::equals).orElse(false);
    }

    boolean convertDisabledTask(DollarUniverseTaskAttributes sourceTaskDefinition) {
        if (Boolean.TRUE.equals(this.rules.getBooleanRule("DOLLAR UNIVERSE rules", new String[]{"ConvertEnableTask"}))) {
            return !this.isDisabledTask(sourceTaskDefinition);
        }
        return true;
    }

    public static AttrHolder getTaskAttr(String taskID, String sessionName, String headerName, String nodeName) {
        HashMap taskHeaderMap = AttrHolder.buildHeadersMap((String)"ID,ses,vses,upr,vupr,mu,model,type,printer,queue,prty,user,offset,hold,force,central,restart,serial,parallel,mult,pdate,rule,sdate,prlw,autorel,history,edate,xdate,exclusion,dalw,mon,tue,wed,thu,fri,sat,sun,mulw,elapse,relw,cyclical,launchvar,node name");
        AttrHolder taskAttributes = new AttrHolder("ID,ses,vses,upr,vupr,mu,model,type,printer,queue,prty,user,offset,hold,force,central,restart,serial,parallel,mult,pdate,rule,sdate,prlw,autorel,history,edate,xdate,exclusion,dalw,mon,tue,wed,thu,fri,sat,sun,mulw,elapse,relw,cyclical,launchvar,node name".split(","), (Map)taskHeaderMap);
        taskAttributes.setAttr("upr", headerName);
        taskAttributes.setAttr("ID", taskID);
        taskAttributes.setAttr("type", "s");
        taskAttributes.setAttr("prty", "");
        taskAttributes.setAttr("ses", sessionName);
        taskAttributes.setAttr("mu", "");
        taskAttributes.setAttr("node name", nodeName);
        return taskAttributes;
    }
}

