/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.dollar_universe;

import com.bmc.ctmconvert.base.BaseProgressBar;
import com.bmc.ctmconvert.common.ExceptionHandler;
import com.bmc.ctmconvert.common.GlobalFunctions;
import com.bmc.ctmconvert.common.Globs;
import com.bmc.ctmconvert.common.exceptions.ConvertorCancelClickException;
import com.bmc.ctmconvert.dollar_universe.MU2csv;
import com.bmc.ctmconvert.dollar_universe.Resources2csv;
import com.bmc.ctmconvert.dollar_universe.Rules2csv;
import com.bmc.ctmconvert.dollar_universe.SAP2csv;
import com.bmc.ctmconvert.dollar_universe.Session;
import com.bmc.ctmconvert.dollar_universe.Task;
import com.bmc.ctmconvert.dollar_universe.Uproc2csv;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.HashMap;

public class DollarUniverseDataCapture {
    private String dataSourcePath = null;
    private HashMap<SOURCE_INPUT_TYPE, File> fileMap = null;
    private BaseProgressBar m_progressBar = null;

    public DollarUniverseDataCapture(String dataSourcePath, HashMap<SOURCE_INPUT_TYPE, File> fileMap, BaseProgressBar pb) {
        this.dataSourcePath = dataSourcePath;
        this.fileMap = fileMap;
        this.m_progressBar = pb;
    }

    public File createDataSource() throws ConvertorCancelClickException {
        if (this.m_progressBar != null) {
            this.m_progressBar.setProgressMax(this.fileMap.keySet().size() * 2);
        }
        int i = 0;
        try {
            for (SOURCE_INPUT_TYPE source : this.fileMap.keySet()) {
                if (this.fileMap.get((Object)source) == null || !this.fileMap.get((Object)source).exists()) continue;
                if (this.m_progressBar != null && this.m_progressBar.getTask().isCancelled()) {
                    throw new ConvertorCancelClickException();
                }
                if (this.m_progressBar != null) {
                    this.m_progressBar.setProgressValue(++i);
                }
                this.copyToWorkArea(source);
                if (this.m_progressBar != null && this.m_progressBar.getTask().isCancelled()) {
                    throw new ConvertorCancelClickException();
                }
                if (this.m_progressBar != null) {
                    this.m_progressBar.setProgressValue(++i);
                }
                this.createCsv(source);
            }
        }
        catch (IOException e) {
            ExceptionHandler.writeToExceptionFile((Exception)e);
            return null;
        }
        return new File(this.dataSourcePath + Globs.DIRSEP + "Task.csv");
    }

    private void copyToWorkArea(SOURCE_INPUT_TYPE source) throws IOException {
        File target = null;
        switch (source.ordinal()) {
            case 1: {
                target = new File(this.dataSourcePath + "SessionDetails.txt");
                break;
            }
            case 2: {
                target = new File(this.dataSourcePath + "Task.txt");
                break;
            }
            case 3: {
                target = new File(this.dataSourcePath + "UPR.txt");
                break;
            }
            case 8: {
                target = new File(this.dataSourcePath + "AgentMapping.txt");
                break;
            }
            case 4: {
                target = new File(this.dataSourcePath + "Rules.txt");
                break;
            }
            case 5: {
                target = new File(this.dataSourcePath + "Resources.txt");
                break;
            }
            case 6: {
                target = new File(this.dataSourcePath + "Calendars.txt");
                break;
            }
            case 7: {
                target = new File(this.dataSourcePath + "MUDetails.txt");
                break;
            }
            case 9: {
                target = new File(this.dataSourcePath + "SAPDetails.txt");
                break;
            }
            case 10: {
                target = new File(this.dataSourcePath + "MuDependencies.txt");
                break;
            }
        }
        GlobalFunctions.copy((File)this.fileMap.get((Object)source), (File)target);
    }

    private void createCsv(SOURCE_INPUT_TYPE source) throws IOException {
        switch (source.ordinal()) {
            case 1: {
                Session session2csv = new Session(this.fileMap.get((Object)SOURCE_INPUT_TYPE.SESSION_DETAILS), this.dataSourcePath);
                session2csv.writeToCSV();
                break;
            }
            case 2: {
                Task task2csv = new Task(this.fileMap.get((Object)SOURCE_INPUT_TYPE.TASK), this.dataSourcePath);
                task2csv.writeToCSV();
                break;
            }
            case 3: {
                File target = new File(this.dataSourcePath + Globs.DIRSEP);
                try (FileOutputStream uprCSVOutput = new FileOutputStream(target.getPath() + Globs.DIRSEP + "UPR.csv");
                     FileOutputStream uprCSVExtensionOutput = new FileOutputStream(target.getPath() + Globs.DIRSEP + "UPR_EXTENSION.csv");){
                    File uprocSourceFile = this.fileMap.get((Object)SOURCE_INPUT_TYPE.UPR);
                    FileInputStream uprInputStream = new FileInputStream(uprocSourceFile);
                    Uproc2csv tmpUpr = new Uproc2csv();
                    tmpUpr.readEntries(uprInputStream);
                    tmpUpr.dumpUpr2csv(uprCSVOutput, uprCSVExtensionOutput);
                    break;
                }
            }
            case 4: {
                Rules2csv rul = new Rules2csv(this.fileMap.get((Object)SOURCE_INPUT_TYPE.RULES), new File(this.dataSourcePath + Globs.DIRSEP + "Rules.csv"));
                rul.writeToCSV();
                break;
            }
            case 5: {
                Resources2csv res = new Resources2csv(this.fileMap.get((Object)SOURCE_INPUT_TYPE.RESOURCES), new File(this.dataSourcePath + Globs.DIRSEP + "Resources.csv"));
                res.writeToCSV();
                break;
            }
            case 7: {
                MU2csv mu2csv = new MU2csv(this.fileMap.get((Object)SOURCE_INPUT_TYPE.MU_DETAILS), new File(this.dataSourcePath + Globs.DIRSEP + "mu.csv"));
                mu2csv.writeToCSV();
                break;
            }
            case 9: {
                FileInputStream srcdetailedFile = new FileInputStream(this.fileMap.get((Object)SOURCE_INPUT_TYPE.SAP_JOBS));
                FileOutputStream sapCreatedFile = new FileOutputStream(this.fileMap.get((Object)SOURCE_INPUT_TYPE.SAP_JOBS));
                SAP2csv sap2csv = new SAP2csv(srcdetailedFile, sapCreatedFile);
                if (!this.fileMap.get((Object)SOURCE_INPUT_TYPE.SAP_JOBS).exists()) break;
                sap2csv.writeToCSV();
                break;
            }
        }
    }

    public static enum SOURCE_INPUT_TYPE {
        SESSION_LIST,
        SESSION_DETAILS,
        TASK,
        UPR,
        RULES,
        RESOURCES,
        CALENDARS,
        MU_DETAILS,
        AGENT_MAPPING,
        SAP_JOBS,
        MU_DEPENDENCIES;

    }
}

