/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.dollar_universe;

import com.bmc.ctmconvert.common.AttrHolderList;
import com.bmc.ctmconvert.common.IAttrHolder;
import com.bmc.ctmconvert.common.SchedEntity;
import com.bmc.ctmconvert.common.conditions.InCondition;
import com.bmc.ctmconvert.dollar_universe.DollarUniverseCreateDefaultConditions;
import com.bmc.ctmconvert.dollar_universe.DollarUniverseDependencies;
import com.bmc.ctmconvert.dollar_universe.DollarUniverseFormulaExtension;
import com.bmc.ctmconvert.dollar_universe.DollarUniverseGlobals;
import com.bmc.ctmconvert.dollar_universe.DollarUniverseJob;
import com.bmc.ctmconvert.dollar_universe.DollarUniverseSessionAttributes;
import com.bmc.ctmconvert.dollar_universe.ResourceConvertor;
import com.bmc.ctmconvert.dollar_universe.SessionTable;
import com.bmc.ctmconvert.dollar_universe.UprTable;
import com.bmc.ctmconvert.dollar_universe.handlers.HandleDepCondName;
import com.bmc.ctmconvert.rules.RulesDataSet;
import com.bmc.ctmconvert.utils.Pair;
import com.bmc.ctmconvert.utils.PropertiesBuilder;
import com.bmc.ctmconvert.utils.UniqueConditionNameGenerator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public class DollarUniverseCreateConditionByNewFormat {
    private static final String STATUS = "status";
    private final DollarUniverseDependencies dependencies;
    private final UprTable uprTable;
    private final DollarUniverseFormulaExtension formulaExtension;
    private final UniqueConditionNameGenerator uniqueConditionNameGenerator;
    private final ResourceConvertor resourceConvertor;
    private final Map<Pair<String, String>, List<String>> inConditionMap;
    private final Map<Pair<String, String>, List<String>> outConditionMap;
    private final SessionTable sessionTable;
    private RulesDataSet rules;
    private static nameToNum uprNameToNum;

    public DollarUniverseCreateConditionByNewFormat(UprTable uprTable, SessionTable sessionTable, ResourceConvertor resourceConvertor, UniqueConditionNameGenerator uniqueConditionNameGenerator, RulesDataSet rules) {
        this.dependencies = new DollarUniverseDependencies(uprTable, sessionTable);
        this.sessionTable = sessionTable;
        this.inConditionMap = new HashMap<Pair<String, String>, List<String>>();
        this.outConditionMap = new HashMap<Pair<String, String>, List<String>>();
        this.uprTable = uprTable;
        this.formulaExtension = new DollarUniverseFormulaExtension();
        this.uniqueConditionNameGenerator = uniqueConditionNameGenerator;
        this.resourceConvertor = resourceConvertor;
        this.rules = rules;
    }

    public void updateNameToNum(nameToNum updatedNameToNum) {
        uprNameToNum = new nameToNum(updatedNameToNum.name, updatedNameToNum.number);
    }

    public List<Properties> getJobInconds(SchedEntity job) {
        ArrayList<Properties> inConditionList = new ArrayList<Properties>();
        if (!(((DollarUniverseJob)job).isHeaderJob() || ((DollarUniverseJob)job).isStandAloneJob() || ((DollarUniverseJob)job).getHdpExpressionHendler().ishdp() || DollarUniverseCreateConditionByNewFormat.isFolder((DollarUniverseJob)job))) {
            int numS = ((DollarUniverseJob)job).getUprocNumber();
            String originalSessionId = ((DollarUniverseJob)job).getOriginalSessionId();
            String sessionNodeName = ((DollarUniverseJob)job).getOriginalSessionNode();
            nameToNum uprName = new nameToNum(job.getOriginalJobName(), DollarUniverseDependencies.getFormatNumS(numS));
            ArrayList<nameToNum> dependeduprs = this.dependencies.getInConditionsOfSessionByNameAndSession(uprName, originalSessionId, sessionNodeName);
            for (nameToNum upr : dependeduprs) {
                this.updateNameToNum(upr);
                if (DollarUniverseCreateDefaultConditions.isRemoveHeaderAndTrailerRuleEnabled(job) && this.fatherIsHeader((DollarUniverseJob)job, upr.name)) continue;
                inConditionList.add(this.createInCondSession(this.getFieldEditorFormattedName(), (DollarUniverseJob)job));
            }
        }
        this.warnCheck((DollarUniverseJob)job);
        List<Properties> uprIncond = this.getJobUprInconds((DollarUniverseJob)job, this.uprTable::getUprsDepconByUpr, this::createUprInCond, this.uprTable::getUprsResconByUpr);
        if (uprIncond != null) {
            inConditionList.addAll(uprIncond);
        }
        List<Properties> resconInCondition = this.getJobUprInconds((DollarUniverseJob)job, this.uprTable::getUprsResconByUpr, this::createUprResCond, this.uprTable::getUprsDepconByUpr);
        if (resconInCondition != null && !resconInCondition.isEmpty()) {
            inConditionList.addAll(resconInCondition);
        }
        return inConditionList;
    }

    public String getFieldEditorFormattedName() {
        return this.rules.getFieldEditor().generateCTMField("JOBNAME", this::getValueForFieldConversion);
    }

    private String getValueForFieldConversion(String field) {
        String toRet = field.equalsIgnoreCase("UPROC") ? DollarUniverseCreateConditionByNewFormat.uprNameToNum.name : (field.equalsIgnoreCase("NUM") ? DollarUniverseCreateConditionByNewFormat.uprNameToNum.number : field);
        while (toRet.matches("^\".*\"$")) {
            toRet = toRet.replaceAll("^\"", "").replaceAll("\"$", "");
        }
        return toRet;
    }

    private boolean fatherIsHeader(DollarUniverseJob job, String upr) {
        DollarUniverseSessionAttributes session = this.sessionTable.sessions.get(job.getSessionId());
        return upr.equals(session.getHeaderUprName());
    }

    private void warnCheck(DollarUniverseJob job) {
        String jobName = job.getOriginalJobName();
        String formula = this.formulaExtension.getFormulaFromJob(job);
        if (formula != null && !formula.isEmpty()) {
            String[] formula_elements = formula.split(" ");
            Integer element_index = 0;
            while (element_index < formula_elements.length) {
                String element = formula_elements[element_index];
                if (!element.isEmpty()) {
                    if (element.startsWith("(")) {
                        job.addReporterMessage("WRN7004", jobName, formula, job.getJobName());
                        element = element.substring(1);
                    }
                    if (element.startsWith("#")) {
                        job.addReporterMessage("WRN7005", jobName, formula, element_index.toString(), element);
                    }
                }
                Integer n = element_index;
                element_index = element_index + 1;
            }
        }
    }

    private List<Properties> getJobUprInconds(DollarUniverseJob job, UprTable.UprFunction uprFunction_mainUse, createIncondFunction IncondCreatorFunction, UprTable.UprFunction uprFunction_check) {
        ArrayList<Properties> propList = new ArrayList<Properties>();
        String jobName = job.getOriginalJobName();
        String jobNodeName = job.getOriginalSessionNode();
        String and_or = "AND";
        String op = "(";
        IAttrHolder jobDepconAttr = null;
        String condno = "";
        Boolean addCond = false;
        String formula = this.formulaExtension.getFormulaFromJob(job);
        if (formula == null || formula.isEmpty()) {
            return null;
        }
        String[] formula_elements = formula.split(" ");
        Integer element_index = 0;
        while (element_index < formula_elements.length) {
            String element = formula_elements[element_index];
            if (!element.isEmpty()) {
                if (element.startsWith("(")) {
                    element = element.substring(1);
                }
                if (element.startsWith("=C")) {
                    IAttrHolder prevJobDepconAttr = jobDepconAttr;
                    String prevCondno = condno;
                    condno = element.substring(2, 4);
                    String uprId = UprTable.getUprID(jobName, jobNodeName);
                    jobDepconAttr = uprFunction_mainUse.depconResconGetter(uprId, condno);
                    if (jobDepconAttr == null && this.uprTable.getUprsIncconByUpr(uprId, condno) == null && uprFunction_check.depconResconGetter(jobName, condno) == null) {
                        job.addReporterMessage("INF7001", jobName, formula, element_index.toString(), element);
                        jobDepconAttr = prevJobDepconAttr;
                        condno = prevCondno;
                    } else if (addCond.booleanValue() && prevJobDepconAttr != null) {
                        List<Properties> prop = IncondCreatorFunction.depconResconCreator(job, prevJobDepconAttr, and_or, op, prevCondno);
                        if (prop != null && !prop.isEmpty()) {
                            propList.addAll(prop);
                        }
                        op = "";
                        addCond = false;
                    }
                } else {
                    addCond = false;
                    Optional<String> ret = this.formulaExtension.checkIfItsAndOrCondition(element);
                    if (ret.isPresent()) {
                        and_or = ret.get();
                        addCond = true;
                    }
                }
            }
            Integer n = element_index;
            element_index = element_index + 1;
        }
        List<Properties> prop = this.createUprInCondIfExist(job, jobDepconAttr, and_or, op, condno, IncondCreatorFunction);
        if (prop != null && !prop.isEmpty()) {
            propList.addAll(prop);
        }
        if (!propList.isEmpty()) {
            this.formulaExtension.validateBrackets(propList);
            return propList;
        }
        return null;
    }

    private List<Properties> createUprInCond(DollarUniverseJob job, IAttrHolder jobIncond, String and_or, String op, String condno) {
        List<Properties> listProps = new ArrayList<Properties>();
        String condName = "";
        String session = jobIncond.getAttr("sess");
        String dep = jobIncond.getAttr("dep");
        String jobNodeName = job.getOriginalSessionNode();
        String nameJob = jobIncond.getAttr("PARENT_UPR");
        String user = jobIncond.getAttr("user");
        String status = jobIncond.getAttr(STATUS);
        String mu = jobIncond.getAttr("mu");
        this.checkDepconFlag(job, jobIncond, "all", dep, condno, true);
        this.checkDepconFlag(job, jobIncond, "exclud", dep, condno, true);
        this.checkDepconFlag(job, jobIncond, "fatal", dep, condno, true);
        if (!this.checkMuAndStatus(job, dep, mu, session, user, status, condno, true)) {
            return listProps;
        }
        String jobInCondName = dep;
        if (session.equals("samerun")) {
            listProps = this.createConditionsBasedOnSameRunDepConditions(job, jobIncond, and_or, op);
            job.addReporterMessage("INF7003", session, jobIncond.getAttr("dep"), condno);
        } else {
            String uprId = UprTable.getUprID(dep, jobNodeName);
            if (this.uprTable.isSapUpr(uprId)) {
                jobInCondName = this.uprTable.getSapName(uprId);
            }
            if ((condName = DollarUniverseCreateConditionByNewFormat.buildAToBCondNameWithoutFolderName(job.getUprIdByUprAttributes(), jobInCondName)) == null) {
                return listProps;
            }
            InCondition depconIncondition = this.createInCondition(job, jobIncond, and_or, op, condName, session, dep);
            listProps.add(depconIncondition.getProperties());
        }
        return listProps;
    }

    private List<Properties> createUprResCond(DollarUniverseJob job, IAttrHolder rescon, String and_or, String op, String condno) {
        ArrayList<Properties> listProps = new ArrayList<Properties>();
        String odate = "ODAT";
        String res = job.getParent().getJobName() + "_" + rescon.getAttr("res");
        String upr = rescon.getAttr("PARENT_UPR");
        String mu = rescon.getAttr("mu");
        String condName = this.buildUprResCondName(job, upr, res, mu, condno);
        InCondition condion = new InCondition(condName, and_or, odate, op);
        listProps.add(condion.getProperties());
        return listProps;
    }

    private String buildUniqueInConditionName(String inConditionName) {
        return this.uniqueConditionNameGenerator.getUniqueInConditionName(inConditionName);
    }

    private InCondition createInCondition(DollarUniverseJob job, IAttrHolder jobIncond, String and_or, String op, String condName, String session, String dep) {
        String pdate = jobIncond.getAttr("pdate");
        String odate = this.formulaExtension.checkPdate(job, session, dep, pdate);
        InCondition depconIncondition = new InCondition(condName, and_or, odate);
        if (!op.isEmpty()) {
            depconIncondition.setOp(op);
        }
        return depconIncondition;
    }

    private List<Properties> createConditionsBasedOnSameRunDepConditions(DollarUniverseJob job, IAttrHolder jobIncond, String and_or, String op) {
        ArrayList<Properties> inconditions = new ArrayList<Properties>();
        String depUprName = jobIncond.getAttr("dep");
        String originalSessionNode = job.getOriginalSessionNode();
        String depID = UprTable.getUprID(depUprName, originalSessionNode);
        List<Integer> depUprNumS = this.dependencies.getAllUprNums(depUprName, job.getOriginalSessionId(), originalSessionNode);
        for (int numS : depUprNumS) {
            nameToNum jobTo = this.uprTable.isSapUpr(depID) ? new nameToNum(this.uprTable.getSapName(depID), "") : new nameToNum(depUprName, DollarUniverseDependencies.getFormatNumS(numS));
            this.updateNameToNum(jobTo);
            String jobFrom = job.applyFieldConversion("JOBNAME");
            String condName = this.buildUniqueInConditionName(DollarUniverseCreateConditionByNewFormat.buildAToBCondNameWithFolderName(jobFrom, this.getFieldEditorFormattedName(), job));
            if (condName == null) continue;
            String session = jobIncond.getAttr("sess");
            InCondition depconIncondition = this.createInCondition(job, jobIncond, and_or, op, condName, session, depUprName);
            if (!op.isEmpty()) {
                depconIncondition.setOp(op);
            }
            inconditions.add(depconIncondition.getProperties());
        }
        return inconditions;
    }

    private boolean checkMuAndStatus(DollarUniverseJob job, String upr, String mu, String session, String user, String status, String condno, Boolean writeMessage) {
        HandleDepCondName handleDepCondName = new HandleDepCondName();
        DollarUniverseJob parent = job.getParent();
        if ((mu = handleDepCondName.handleMu(job, upr, mu, condno, writeMessage, parent)) == null) {
            return false;
        }
        return (status = handleDepCondName.handleStatus(job, upr, mu, status, condno, writeMessage)) != null;
    }

    public List<Properties> getJobOutconds(SchedEntity job) {
        ArrayList<Properties> outConditionList = new ArrayList<Properties>();
        if (!DollarUniverseCreateConditionByNewFormat.isFolder((DollarUniverseJob)job)) {
            String originalSessionNode = ((DollarUniverseJob)job).getOriginalSessionNode();
            nameToNum pairJobName = new nameToNum(job.getOriginalJobName(), ((DollarUniverseJob)job).getOriginalSessionJobNum());
            List<nameToNum> uprIncondNamesFromSession = this.dependencies.getDependUprsNamesFromSession(pairJobName, ((DollarUniverseJob)job).getOriginalSessionId(), originalSessionNode);
            for (nameToNum uprName : uprIncondNamesFromSession) {
                this.updateNameToNum(uprName);
                if (DollarUniverseCreateDefaultConditions.isRemoveHeaderAndTrailerRuleEnabled(job) && this.isTrailer((DollarUniverseJob)job, uprName.name())) continue;
                outConditionList.add(this.createUprOutCondFromSession((DollarUniverseJob)job, this.getFieldEditorFormattedName()));
            }
            List<nameToNum> uprIncondNamesFromUprTable = this.dependencies.getDependUprsNamesFromUprTable(pairJobName, ((DollarUniverseJob)job).getOriginalSessionId(), originalSessionNode);
            for (nameToNum uprName : uprIncondNamesFromUprTable) {
                this.updateNameToNum(uprName);
                if (DollarUniverseCreateDefaultConditions.isRemoveHeaderAndTrailerRuleEnabled(job) && this.isTrailer((DollarUniverseJob)job, uprName.name())) continue;
                outConditionList.add(this.createUprOutCondFromUprTable((DollarUniverseJob)job, uprNameToNum));
            }
        }
        return outConditionList;
    }

    public static boolean isFolder(DollarUniverseJob job) {
        return job.getType().equals((Object)SchedEntity.TYPE.SMART_TABLE);
    }

    private boolean isTrailer(DollarUniverseJob job, String uprName) {
        DollarUniverseSessionAttributes session = this.sessionTable.sessions.get(job.getSessionId());
        if (session != null) {
            return uprName.equals(session.getTrailerUprName()) || uprName.equals(DollarUniverseCreateConditionByNewFormat.getTrailerNameWithNode(session));
        }
        return false;
    }

    @NotNull
    private static String getTrailerNameWithNode(DollarUniverseSessionAttributes session) {
        return session.getTrailerUprName() + "_" + session.getNodeName();
    }

    public List<Properties> getJobRescon(SchedEntity job) {
        ArrayList<Properties> inResconList = new ArrayList<Properties>();
        String uprId = UprTable.getUprID(job.getOriginalJobName(), job.getAttr("NODEID"));
        Optional<AttrHolderList> resconsOfJob = this.uprTable.getUprsResconsByUpr(uprId);
        if (resconsOfJob.isPresent()) {
            int size = resconsOfJob.get().size();
            for (int i = 0; i < size; ++i) {
                IAttrHolder rescon = (IAttrHolder)resconsOfJob.get().get(i);
                String res = rescon.getAttr("res");
                if (res != null && this.resourceConvertor.isFileRes(res)) {
                    inResconList.add(this.createUprResCond((DollarUniverseJob)job, rescon));
                    continue;
                }
                this.formulaExtension.writeResMesseges((DollarUniverseJob)job, res, this.resourceConvertor);
            }
        }
        return inResconList;
    }

    private Properties createUprResCond(DollarUniverseJob job, IAttrHolder rescon) {
        String and_or = "AND";
        String odate = "ODAT";
        String condno = rescon.getAttr("condno");
        String parentName = job.getParent().getJobName();
        String res = parentName + "_" + rescon.getAttr("res");
        String upr = rescon.getAttr("PARENT_UPR");
        String mu = rescon.getAttr("mu");
        String condName = this.buildUprResCondName(job, upr, res, mu, condno);
        InCondition condion = new InCondition(condName, and_or, odate);
        return condion.getProperties();
    }

    public String buildUprResCondName(DollarUniverseJob job, String upr, String res, String mu, String condno) {
        String condName = String.format(DollarUniverseGlobals.FW_COND_NAME_NEW_FORMAT, res, condno, upr);
        if (job.getHdpExpressionHendler().ishdp()) {
            condName = job.getHdpExpressionHendler().manipulateAssitngJobCondion(mu, condName);
        }
        return condName;
    }

    private static String buildAToBCondNameWithFolderName(String toJob, String fromJob, DollarUniverseJob toJobObject) {
        return String.format("%s_%s-TO-%s_%s", toJobObject.getTableName(), fromJob, toJobObject.getTableName(), toJob);
    }

    private static String buildAToBCondNameWithoutFolderName(String toJob, String fromJob) {
        return String.format("%s-TO-%s", fromJob, toJob);
    }

    public static String buildAtoBPart(String jobName, String folderName) {
        return String.format("%s_%s", folderName, jobName);
    }

    public List<String> buildAToBCondName(String parentPath, String session, String sourceJobName, int numS, DollarUniverseJob job, String nodeName) {
        String originalSessionNode = job.getOriginalSessionNode();
        List<nameToNum> targetJobsNameUpr = this.dependencies.getNameUprKO(new nameToNum(sourceJobName, DollarUniverseDependencies.getFormatNumS(numS)), session, originalSessionNode);
        ArrayList<String> condsList = new ArrayList<String>();
        if (targetJobsNameUpr == null) {
            return null;
        }
        for (nameToNum targetJobNameUpr : targetJobsNameUpr) {
            this.updateNameToNum(targetJobNameUpr);
            sourceJobName = job.applyFieldConversion("JOBNAME");
            String targetJobName = this.getFieldEditorFormattedName();
            String outCond = this.buildUniqueOutConditionName(DollarUniverseCreateConditionByNewFormat.buildAToBCondNameWithFolderName(targetJobName, sourceJobName, job));
            this.addConditionToTheConditionMap(sourceJobName, targetJobName, parentPath, outCond, this.outConditionMap, originalSessionNode);
            this.addConditionToTheConditionMap(targetJobName, sourceJobName, parentPath, outCond, this.inConditionMap, originalSessionNode);
            String path = parentPath + "#" + originalSessionNode;
            Pair outCondKey = new Pair((Object)path, (Object)sourceJobName);
            condsList.add(this.outConditionMap.get(outCondKey).stream().filter(condN -> condN.contains(targetJobName)).collect(Collectors.toList()).stream().findFirst().orElse(null));
        }
        return condsList;
    }

    private static boolean checkIfJobNameIsAlreadyFormatted(String sourceJobName) {
        return sourceJobName.contains("#");
    }

    private String buildUniqueOutConditionName(String outConditionName) {
        return this.uniqueConditionNameGenerator.getUniqueOutConditionName(outConditionName);
    }

    private Properties createInCondSession(String sourceJobName, DollarUniverseJob targetJob) {
        String and_or = "AND";
        String odate = "ODAT";
        int numS = targetJob.getUprocNumber();
        String originalJobName = targetJob.getOriginalJobName();
        String originalNodeName = targetJob.getOriginalSessionNode();
        String uprId = UprTable.getUprID(originalJobName, originalNodeName);
        String targetJobName = this.uprTable.isSapUpr(uprId) ? this.uprTable.getSapName(uprId) : targetJob.applyFieldConversion("JOBNAME");
        String condName = this.buildUniqueInConditionName(DollarUniverseCreateConditionByNewFormat.buildAToBCondNameWithFolderName(targetJobName, sourceJobName, targetJob));
        String parentPath = targetJob.getParentName() + "#" + originalNodeName;
        Pair inCondKey = new Pair((Object)parentPath, (Object)targetJobName);
        this.addConditionToTheConditionMap(targetJobName, sourceJobName, targetJob.getParentName(), condName, this.inConditionMap, originalNodeName);
        this.addConditionToTheConditionMap(sourceJobName, targetJobName, targetJob.getParentName(), condName, this.outConditionMap, originalNodeName);
        InCondition condion = new InCondition(this.inConditionMap.get(inCondKey).stream().filter(condN -> condN.contains(sourceJobName)).findFirst().orElse(""), and_or, odate);
        return condion.getProperties();
    }

    private static boolean isJobWithSession(String sourceJobName) {
        return DollarUniverseCreateConditionByNewFormat.checkIfJobNameIsAlreadyFormatted(sourceJobName);
    }

    private void addConditionToTheConditionMap(String jobA, String jobB, String parentPath, String condName, Map<Pair<String, String>, List<String>> conditionMap, String nodeName) {
        String path = parentPath + "#" + nodeName;
        Pair condKey = new Pair((Object)path, (Object)jobA);
        if (!conditionMap.containsKey(condKey)) {
            ArrayList<String> condsList = new ArrayList<String>();
            condsList.add(condName);
            conditionMap.put((Pair<String, String>)condKey, condsList);
        } else if (this.shouldAddCondition(jobB, conditionMap, condKey)) {
            conditionMap.get(condKey).add(condName);
        }
    }

    private boolean shouldAddCondition(String jobB, Map<Pair<String, String>, List<String>> conditionMap, Pair condKey) {
        return conditionMap.get(condKey).stream().filter(condN -> condN.contains(jobB)).collect(Collectors.toList()).isEmpty();
    }

    private Properties createUprOutCond(DollarUniverseJob job, nameToNum jobOutcond, Pair<String, String> nameJob, String oDate) {
        AttrHolderList attrs = this.uprTable.getUprsDepconByDep((String)nameJob.getKey());
        Properties props = new Properties();
        String add_del = "ADD";
        String originalSessionNode = job.getOriginalSessionNode();
        String uprId = UprTable.getUprID(job.getOriginalJobName(), originalSessionNode);
        if (this.uprTable.isSapUpr(uprId)) {
            nameJob = new Pair((Object)this.uprTable.getSapName(uprId), (Object)"");
        }
        String jobName = job.applyFieldConversion("JOBNAME");
        String condName = ((IAttrHolder)attrs.getFirst()).getAttr("sess").equals("samerun") ? this.buildUniqueOutConditionName(DollarUniverseCreateConditionByNewFormat.buildAToBCondNameWithFolderName(this.getFieldEditorFormattedName(), jobName, job)) : DollarUniverseCreateConditionByNewFormat.buildAToBCondNameWithoutFolderName(jobOutcond.name(), (String)nameJob.getKey());
        if (condName == null) {
            return props;
        }
        String path = job.getParentName() + "#" + originalSessionNode;
        Pair outCondKey = new Pair((Object)path, (Object)jobName);
        this.addConditionToTheConditionMap(jobOutcond.name(), jobName, job.getParentName(), condName, this.inConditionMap, originalSessionNode);
        this.addConditionToTheConditionMap(jobName, jobOutcond.name(), job.getParentName(), condName, this.outConditionMap, originalSessionNode);
        props.put("NAME", this.outConditionMap.get(outCondKey).stream().filter(condN -> condN.contains(jobOutcond.name())).collect(Collectors.toList()).stream().findFirst().orElse(""));
        props.put("SIGN", add_del);
        props.put("ODATE", oDate);
        return props;
    }

    private String getOdate(DollarUniverseJob job, String jobOutcond) {
        IAttrHolder outCondition = null;
        String jobName = job.getOriginalSessionJobName();
        String dep = null;
        String mu = null;
        String session = null;
        String user = null;
        String status = null;
        AttrHolderList jobDepconList = this.uprTable.getUprsDepconByDep(jobName);
        for (IAttrHolder jobDepcon : jobDepconList) {
            dep = jobDepcon.getAttr("dep");
            mu = jobDepcon.getAttr("mu");
            session = jobDepcon.getAttr("sess");
            user = jobDepcon.getAttr("user");
            status = jobDepcon.getAttr(STATUS);
            boolean contains = jobOutcond.contains(dep);
            outCondition = jobDepcon;
            if (!contains) continue;
            break;
        }
        if (!this.checkMuAndStatus(job, dep, mu, session, user, status, "", false)) {
            return "ODAT";
        }
        return this.checkOdate(job, outCondition);
    }

    private String checkOdate(DollarUniverseJob job, IAttrHolder jobOutcond) {
        String odate;
        String session = jobOutcond.getAttr("sess");
        String dep = jobOutcond.getAttr("dep");
        String pdate = jobOutcond.getAttr("pdate");
        if (pdate.equalsIgnoreCase("(same,same,same)") || pdate.equalsIgnoreCase("(,,)") || pdate.equalsIgnoreCase("( , , )")) {
            odate = "ODAT";
        } else if (pdate.equalsIgnoreCase("(same,same,same)")) {
            odate = "****";
        } else {
            odate = "ODAT";
            job.addReporterMessage("INF7002", session, dep, pdate, odate);
        }
        return odate;
    }

    private Properties createUprOutCondFromSession(DollarUniverseJob job, String jobOutcond) {
        String condName;
        String nameJob = job.applyFieldConversion("JOBNAME");
        Properties props = new Properties();
        String add_del = "ADD";
        String originalSessionNode = job.getOriginalSessionNode();
        String uprId = UprTable.getUprID(job.getOriginalJobName(), originalSessionNode);
        if (this.uprTable.isSapUpr(uprId)) {
            nameJob = this.uprTable.getSapName(uprId);
        }
        if ((condName = this.buildUniqueOutConditionName(DollarUniverseCreateConditionByNewFormat.buildAToBCondNameWithFolderName(jobOutcond, nameJob, job))) == null) {
            return props;
        }
        String path = job.getParentName() + "#" + originalSessionNode;
        Pair outCondKey = new Pair((Object)path, (Object)nameJob);
        this.addConditionToTheConditionMap(jobOutcond, nameJob, job.getParentName(), condName, this.inConditionMap, originalSessionNode);
        this.addConditionToTheConditionMap(nameJob, jobOutcond, job.getParentName(), condName, this.outConditionMap, originalSessionNode);
        props.put("NAME", this.outConditionMap.get(outCondKey).stream().filter(condN -> condN.contains(jobOutcond)).collect(Collectors.toList()).stream().findFirst().orElse(""));
        props.put("SIGN", add_del);
        props.put("ODATE", "ODAT");
        return props;
    }

    private Properties createUprOutCondFromUprTable(DollarUniverseJob job, nameToNum jobOutcond) {
        Pair nameJob = new Pair((Object)job.getOriginalJobName(), (Object)DollarUniverseDependencies.getFormatNumS(job.getUprocNumber()));
        String odate = this.getOdate(job, jobOutcond.name());
        return this.createUprOutCond(job, jobOutcond, (Pair<String, String>)nameJob, odate);
    }

    private List<Properties> createUprInCondIfExist(DollarUniverseJob job, IAttrHolder jobDepconAttr, String and_or, String op, String condno, createIncondFunction IncondCreatorFunction) {
        List<Properties> prop = null;
        op = op.isEmpty() ? ")" : "";
        if (jobDepconAttr != null) {
            prop = IncondCreatorFunction.depconResconCreator(job, jobDepconAttr, and_or, op, condno);
        }
        return prop;
    }

    private void checkDepconFlag(SchedEntity job, IAttrHolder depconAttr, String flag, String dep, String condno, Boolean writeMessage) {
        if (!depconAttr.isFieldExist(flag)) {
            return;
        }
        String flag_value = depconAttr.getAttr(flag);
        if (flag_value != null && flag_value.equalsIgnoreCase("TRUE") && writeMessage.booleanValue()) {
            ((DollarUniverseJob)job).addReporterMessage("INF7005", flag, dep, condno);
        }
    }

    public Map<Properties, List<Properties>> getOnEndedNotOkDoCond(DollarUniverseJob job) {
        return DollarUniverseCreateConditionByNewFormat.createOnCodeDoFromDoList(this.getDoListFromDepcons(job, this.getDepconsFromJobWithStatus(job, "aborted")), "NOTOK");
    }

    public Map<Properties, List<Properties>> getOnEndedDoCond(DollarUniverseJob job) {
        return DollarUniverseCreateConditionByNewFormat.createOnCodeDoFromDoList(this.getDoListFromDepcons(job, this.getDepconsFromJobWithStatus(job, "ended")), "COMPSTAT EQ ANY");
    }

    @NotNull
    private List<Properties> getDoListFromDepcons(DollarUniverseJob job, List<nameToNum> depconds) {
        if (job.getType().equals((Object)SchedEntity.TYPE.JOB) || job.isReferenceSubFolder()) {
            String originalJobName = job.getOriginalJobName();
            String jobNodeName = job.getOriginalSessionNode();
            String uprId = UprTable.getUprID(originalJobName, jobNodeName);
            String sourceJob = this.uprTable.isSapUpr(uprId) ? this.uprTable.getSapName(uprId) : originalJobName;
            return depconds.stream().map(targetUprName -> {
                String targetUprId = targetUprName.name();
                String targetJob = this.uprTable.isSapUpr(targetUprId) ? this.uprTable.getSapName(targetUprId) : targetUprId;
                return DollarUniverseCreateConditionByNewFormat.buildAToBCondNameWithoutFolderName(targetJob, sourceJob);
            }).distinct().map(DollarUniverseCreateConditionByNewFormat::createDoCond).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    private List<nameToNum> getDepconsFromJobWithStatus(DollarUniverseJob job, String status) {
        nameToNum pairJobName = new nameToNum(job.getOriginalJobName(), job.getOriginalSessionJobNum());
        String originalSessionNodeName = job.getOriginalSessionNode();
        HashSet<String> uprNamesWithStatus = new HashSet<String>(this.getUprNamesOfDepconsWithStatus(pairJobName.name(), status));
        return this.dependencies.getDepconUprsNames(pairJobName, job.getOriginalSessionId(), originalSessionNodeName).stream().filter(it -> uprNamesWithStatus.contains(it.name())).collect(Collectors.toList());
    }

    @NotNull
    private List<String> getUprNamesOfDepconsWithStatus(String originalJobName, String status) {
        return Optional.ofNullable(this.uprTable.getUprsDepconByDep(originalJobName)).map(uprsDepconByDep -> uprsDepconByDep.stream().filter(depcon -> status.equals(depcon.getAttr(STATUS))).map(depcon -> depcon.getAttr("PARENT_UPR")).collect(Collectors.toList())).orElse(Collections.emptyList());
    }

    @NotNull
    private static Properties createDoCond(String condName) {
        Properties docond = new Properties();
        docond.setProperty("ACTION", "DOCOND");
        docond.setProperty("ODAT", "ODATE");
        docond.setProperty("SIGN", "+");
        docond.setProperty("NAME", condName);
        return docond;
    }

    @NotNull
    private static Map<Properties, List<Properties>> createOnCodeDoFromDoList(List<Properties> doList, String OnCode) {
        if (doList.isEmpty()) {
            return Collections.emptyMap();
        }
        Properties on = new PropertiesBuilder().setProperty("STMT", "*").setProperty("CODE", OnCode).build();
        LinkedHashMap<Properties, List<Properties>> onDo = new LinkedHashMap<Properties, List<Properties>>();
        onDo.put(on, doList);
        return onDo;
    }

    public record nameToNum(String name, String number) {
    }

    @FunctionalInterface
    public static interface createIncondFunction {
        public List<Properties> depconResconCreator(DollarUniverseJob var1, IAttrHolder var2, String var3, String var4, String var5);
    }
}

