/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.dollar_universe;

import com.bmc.ctmconvert.common.ExceptionHandler;
import com.bmc.ctmconvert.common.Params;
import com.bmc.ctmconvert.common.calendars.CtmCalendar;
import com.bmc.ctmconvert.common.calendars.DefCalFile;
import com.bmc.ctmconvert.dollar_universe.DollarUCal;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.GregorianCalendar;

public class DollarUniverseCalendars {
    private BufferedReader source;
    private ArrayList<DollarUCal> allCalendars;
    private final String calendarDeclareExpression = "\\s*TYPE\\s*\\|\\s*cal\\s*";

    public DollarUniverseCalendars() {
        try {
            ArrayList<String> currRawCal;
            FileInputStream streamFile = new FileInputStream(Params.instance().getDatasourcePath() + "Calendars.txt");
            this.source = new BufferedReader(new InputStreamReader(streamFile));
            this.allCalendars = new ArrayList();
            while ((currRawCal = this.readNextCalendar()) != null) {
                DollarUCal tmpCal = new DollarUCal(currRawCal);
                if (tmpCal.isEmpty()) continue;
                this.allCalendars.add(tmpCal);
            }
            this.source.close();
        }
        catch (IOException ioe) {
            ExceptionHandler.writeToExceptionFile((Exception)ioe);
        }
    }

    public DollarUniverseCalendars(ArrayList<DollarUCal> calendar) {
        this.allCalendars = new ArrayList();
    }

    ArrayList<String> readNextCalendar() throws IOException {
        String currLine;
        ArrayList<String> toRet = null;
        boolean inCalendar = false;
        while ((currLine = this.source.readLine()) != null) {
            if (currLine.trim().isEmpty()) continue;
            if (currLine.matches("\\s*TYPE\\s*\\|\\s*cal\\s*")) {
                if (inCalendar) {
                    this.source.reset();
                    break;
                }
                inCalendar = true;
            }
            if (inCalendar) {
                if (toRet == null) {
                    toRet = new ArrayList<String>();
                }
                toRet.add(currLine);
            }
            this.source.mark(1024);
        }
        return toRet;
    }

    public void writeCalendars(String targetDc, String area, DefCalFile defCalFile) {
        for (DollarUCal current : this.allCalendars) {
            for (CtmCalendar tmpCal : current.toCtmCals(targetDc, area)) {
                defCalFile.write(tmpCal, false);
            }
        }
        CtmCalendar allDays = new CtmCalendar(area + "_ALLDAYS", targetDc);
        GregorianCalendar tmpGregorian = new GregorianCalendar();
        int lastYear = tmpGregorian.get(1) + 2;
        tmpGregorian.add(1, -2);
        tmpGregorian.set(2, 0);
        tmpGregorian.set(5, 1);
        while (tmpGregorian.get(1) <= lastYear) {
            allDays.addDay(tmpGregorian.get(1), tmpGregorian.get(2) + 1, tmpGregorian.get(5));
            tmpGregorian.add(5, 1);
        }
        defCalFile.write(allDays, false);
    }

    public String geUsedCalendarName(String area, String mu, String type) {
        String retVal = String.format("%s_%s", area, type);
        if (this.allCalendars != null) {
            for (DollarUCal cal : this.allCalendars) {
                if (!cal.getMu().equals(mu)) continue;
                retVal = String.format("%s_%s_%s", area, mu, type);
            }
            for (DollarUCal cal : this.allCalendars) {
                if (!cal.getMu().equals(mu.substring(0, 1) + "00")) continue;
                retVal = String.format("%s_%s_%s", area, Character.valueOf(mu.charAt(0)), type);
            }
        }
        return retVal;
    }
}

