/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.SAP;

import com.bmc.ctmconvert.SAP.SapJob;
import com.bmc.ctmconvert.SAP.Xbp2SapConvertor;
import com.bmc.ctmconvert.common.AttrHolderList;
import com.bmc.ctmconvert.common.IAttrHolder;
import com.bmc.ctmconvert.dollar_universe.DollarUniverseJob;
import com.bmc.ctmconvert.dollar_universe.DollarUniverseUprAttributes;
import java.util.Optional;

public class SapXBP2Handler {
    private DollarUniverseJob dollarUniverseJob;
    private DollarUniverseUprAttributes uprAttributes;

    public SapXBP2Handler(DollarUniverseJob dollarUniverseJob, DollarUniverseUprAttributes uprAttributes) {
        this.dollarUniverseJob = dollarUniverseJob;
        this.uprAttributes = uprAttributes;
    }

    public void execute() {
        SapJob sapJob = new SapJob(this.dollarUniverseJob);
        Xbp2SapConvertor sapConvertor = this.getSapConvrtor(sapJob);
        sapConvertor.convertSapParameters();
    }

    public Xbp2SapConvertor getSapConvrtor(SapJob sapJob) {
        AttrHolderList stepsArchiveParameters;
        AttrHolderList stepsPrintParameters;
        AttrHolderList stepsVariableParameters;
        Optional<IAttrHolder> sap_xbp2Attributes = Optional.empty();
        AttrHolderList xbpVariableParameter = this.uprAttributes.getVariableParameters("sap_xbp2");
        if (xbpVariableParameter != null && !xbpVariableParameter.isEmpty()) {
            sap_xbp2Attributes = Optional.of((IAttrHolder)xbpVariableParameter.get(0));
        }
        if ((stepsVariableParameters = this.uprAttributes.getVariableParameters("sap_xbp2_step")) == null) {
            stepsVariableParameters = new AttrHolderList();
        }
        if ((stepsPrintParameters = this.uprAttributes.getVariableParameters("sap_xbp2_step_pr")) == null) {
            stepsPrintParameters = new AttrHolderList();
        }
        if ((stepsArchiveParameters = this.uprAttributes.getVariableParameters("sap_xbp2_step_ar")) == null) {
            stepsArchiveParameters = new AttrHolderList();
        }
        Xbp2SapConvertor sapConvertor = new Xbp2SapConvertor(sapJob, sap_xbp2Attributes, stepsVariableParameters, stepsPrintParameters, stepsArchiveParameters);
        return sapConvertor;
    }
}

