/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.SAP;

import com.bmc.ctmconvert.common.Globs;
import com.bmc.ctmconvert.dollar_universe.DollarUniverseJob;
import com.bmc.ctmconvert.sap.Step;
import java.util.Map;

public class SapJob {
    static final String DEFAULT_ACCOUNT = "DEFAULT_PROFILE";
    private DollarUniverseJob dollarUniverseJob;
    private String acount;

    public SapJob(DollarUniverseJob dollarUniverseJob) {
        this.dollarUniverseJob = dollarUniverseJob;
        this.setSAPCmAttributes();
    }

    private void setSAPCmAttributes() {
        this.dollarUniverseJob.addAttribute("MEMLIB", "Not in use for SAP jobs");
        this.dollarUniverseJob.addAttribute("TASKTYPE", "Job");
        Globs.SAP_TYPE_FORM_VERSION.forEach(this.dollarUniverseJob::setOptionalAtrribute);
        this.setDefaultValue();
    }

    private void setDefaultValue() {
        String jobClass = "C";
        String jobname = this.dollarUniverseJob.getJobName();
        this.dollarUniverseJob.addAutoEdits("%%SAPR3-JOBNAME", jobname);
        this.dollarUniverseJob.addAutoEdits("%%SAPR3-GROUP_ORDID", "%%GROUP_ORDID");
        this.dollarUniverseJob.addAutoEdits("%%SAPR3-DETECT_CHILD_TABLE", "%%SCHEDTAB");
        this.dollarUniverseJob.addAutoEdits("%%SAPR3-JOB_MODE", "CREATE");
        this.dollarUniverseJob.addAutoEdits("%%SAPR3-SERVER_OR_GROUP_TYPE", "S");
        this.setAccount(DEFAULT_ACCOUNT);
        this.dollarUniverseJob.addAutoEdits("%%SAPR3-JOBCLASS", jobClass);
        this.dollarUniverseJob.addAutoEdits("%%SAPR3-JOB_COUNT", "LAST_SCHEDULED");
        this.dollarUniverseJob.addAutoEdits("%%SAPR3-JOBCOUNT", "LAST_SCHEDULED");
        this.dollarUniverseJob.addAutoEdits("%%SAPR3-KEEP_JOBLOG_OPTION", "S");
        this.dollarUniverseJob.addAutoEdits("%%SAPR3-OVERRIDE_JOBLOG_DEFAULT", "X");
        this.dollarUniverseJob.addAutoEdits("%%SAPR3-JOBLOG", "*SYSOUT");
        this.dollarUniverseJob.addAutoEdits("%%SAPR3-SUBMIT_ASAP", "X");
        this.dollarUniverseJob.addAutoEdits("%%SAPR3-DETECT_CHILD_RELEASE", "N");
        this.dollarUniverseJob.addAutoEdits("%%SAPR3-DETECT_OPTION", "1");
        this.dollarUniverseJob.addAutoEdits("%%SAPR3-INC_APP_STAT", "no");
        this.dollarUniverseJob.addAutoEdits("%%SAPR3-RERUN_STEP_NUM", "1");
        this.dollarUniverseJob.addAutoEdits("%%SAPR3-XBP_VERSION", "XBP30");
    }

    public void addStep(Step step) {
        Map stepAutoEdits = step.getAutoedits();
        for (Map.Entry autoEdit : stepAutoEdits.entrySet()) {
            this.dollarUniverseJob.addAutoEdits((String)autoEdit.getKey(), (String)autoEdit.getValue());
        }
    }

    public String getJobName() {
        return this.dollarUniverseJob.getJobName();
    }

    public void setName(String jobname) {
        String memname = this.dollarUniverseJob.getJobName();
        this.dollarUniverseJob.addAttribute("MEMNAME", memname);
        this.dollarUniverseJob.addAutoEdits("%%SAPR3-JOBNAME", jobname);
        this.dollarUniverseJob.setJobName(jobname);
    }

    public void setClass(String jobClass) {
        this.dollarUniverseJob.addAutoEdits("%%SAPR3-JOBCLASS", jobClass);
    }

    public void setRec(String jobRec) {
        this.dollarUniverseJob.addAutoEdits("%%SAPR3-RECIPIENT", jobRec);
    }

    public void setRecTyp(String jobRecTyp) {
        this.dollarUniverseJob.addAutoEdits("%%SAPR3-RECIP_TYPE", jobRecTyp);
    }

    public void setAccount(String account) {
        if (!account.isEmpty()) {
            this.acount = account;
            this.dollarUniverseJob.addAutoEdits("%%SAPR3-ACCOUNT", account);
            this.dollarUniverseJob.addAttribute("OWNER", account);
        }
    }

    public String getAccount() {
        return this.acount;
    }

    public void addMultipleStepsMessage() {
        this.dollarUniverseJob.addReporterMessage("WRN7028", this.dollarUniverseJob.getUprAttribute("upr"));
    }

    public void addUnsupportedStepAttrMessage(String stepAttr, String stepAttrValue) {
    }

    public void setChild(String jobChild) {
        this.dollarUniverseJob.addAutoEdits("%%SAPR3-DETECT_OPTION", jobChild);
    }
}

