/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert;

import com.bmc.ctmconvert.base.BasePanel;
import com.bmc.ctmconvert.base.BaseProgressBar;
import com.bmc.ctmconvert.base.CliImporter;
import com.bmc.ctmconvert.base.DataImportVendor;
import com.bmc.ctmconvert.common.Globs;
import com.bmc.ctmconvert.common.SourceDefinitions;
import com.bmc.ctmconvert.common.rbc.RBC;
import com.bmc.ctmconvert.dataimport.ImportEntryList;
import com.bmc.ctmconvert.dataimport.Importer;
import com.bmc.ctmconvert.dataimport.autofiledetect.DataForImportDetector;
import com.bmc.ctmconvert.dataimport.autofiledetect.DefaultDataForImportDetector;
import com.bmc.ctmconvert.dataimport.autofiledetect.DetectFileForEntry;
import com.bmc.ctmconvert.dollar_universe.CliImporterDollarUniverse;
import com.bmc.ctmconvert.dollar_universe.DollarUniverseData;
import com.bmc.ctmconvert.dollar_universe.DollarUniverseDefs;
import com.bmc.ctmconvert.dollar_universe.DollarUniverseEntryDetector;
import com.bmc.ctmconvert.dollar_universe.DollarUniverseImporter;
import com.bmc.ctmconvert.dollar_universe.assessmentreport.DollarUniverseAssessmentReport;
import com.bmc.ctmconvert.interfaces.VendorData;
import com.bmc.ctmconvert.rules.FirstDayOfTheWeekRule;
import com.bmc.ctmconvert.rules.RuleManager;
import com.bmc.ctmconvert.utils.UniqueConditionNameGenerator;
import java.awt.Dimension;
import java.io.InputStream;

public class AppData
implements VendorData {
    public String getName() {
        return "DOLLAR_UNIVERSE";
    }

    public String getDisplayName() {
        return "Broadcom Dollar Universe\u00ae";
    }

    public ImportEntryList getImportEntries() {
        ImportEntryList entries = super.getImportEntries();
        entries.sort();
        return entries;
    }

    public DataImportVendor getDataImport() {
        return null;
    }

    public Importer getVendorImporter() {
        return new DollarUniverseImporter(this.getImportEntries());
    }

    public DataForImportDetector getDataForImportDetector() {
        return new DefaultDataForImportDetector((DetectFileForEntry)new DollarUniverseEntryDetector());
    }

    public VendorData.VendorType getVendorType() {
        return VendorData.VendorType.Schedulers;
    }

    public BasePanel getAssessmentReport(String path) {
        return new DollarUniverseAssessmentReport(path, Globs.ASSESSMENT_REPORT_DESCRIPTION_XML, null);
    }

    public CliImporter getCLIImporter() {
        return new CliImporterDollarUniverse();
    }

    public SourceDefinitions getSourceDefinition(BaseProgressBar progressBar) {
        UniqueConditionNameGenerator uniqueConditionNameGenerator = new UniqueConditionNameGenerator("-");
        DollarUniverseData data = new DollarUniverseData(uniqueConditionNameGenerator);
        DollarUniverseDefs dollarUniverseDefs = new DollarUniverseDefs(data, RuleManager.instance().getCurrentRules(), uniqueConditionNameGenerator);
        dollarUniverseDefs.loadToTaskTable();
        return dollarUniverseDefs;
    }

    public InputStream getRulesResourceFile() {
        return AppData.class.getResourceAsStream("/rules.xml");
    }

    public boolean isZOS() {
        return false;
    }

    public Dimension getSize() {
        return new Dimension(670, 700);
    }

    public String getHelpTitle(boolean isAutomatic) {
        return "LOAD_DATA_DOLLAR_UNIVERSE";
    }

    public RBC.WEEKDAYS getFirstDayOfTheWeek() {
        return FirstDayOfTheWeekRule.getFirstDayOfTheWeek((String)"DOLLAR UNIVERSE rules", (String)"FIRST_DAY_OF_WEEK");
    }
}

