/*
 * Decompiled with CFR 0.152.
 */
package SapExtractor;

import SapExtractor.SapExt;
import com.jgoodies.forms.factories.FormFactory;
import com.jgoodies.forms.layout.ColumnSpec;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.RowSpec;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import org.w3c.dom.Document;

class SaveOutputGUI
extends JDialog {
    private final JPanel contentPanel = new JPanel();
    Document _doc;

    public SaveOutputGUI(Document document) {
        this._doc = document;
        this.setResizable(false);
        this.setIconImage(Toolkit.getDefaultToolkit().getImage("bmc.jpg"));
        this.setTitle("Save Output File");
        this.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
        this.setDefaultCloseOperation(2);
        this.setBounds(100, 100, 408, 107);
        this.getContentPane().setLayout(new BorderLayout());
        this.contentPanel.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.getContentPane().add((Component)this.contentPanel, "Center");
        this.contentPanel.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{FormFactory.RELATED_GAP_COLSPEC, ColumnSpec.decode((String)"default:grow")}, new RowSpec[]{FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, RowSpec.decode((String)"default:grow")}));
        JLabel jLabel = new JLabel("Jobs extracted successfully, click \"Save\" to save the output file.");
        this.contentPanel.add((Component)jLabel, "2, 2");
        JPanel jPanel = new JPanel();
        this.contentPanel.add((Component)jPanel, "2, 4, fill, fill");
        jPanel.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{ColumnSpec.decode((String)"45dlu"), ColumnSpec.decode((String)"40dlu"), ColumnSpec.decode((String)"5dlu"), FormFactory.RELATED_GAP_COLSPEC, ColumnSpec.decode((String)"40dlu"), FormFactory.RELATED_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, FormFactory.RELATED_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, FormFactory.RELATED_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, FormFactory.RELATED_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, FormFactory.RELATED_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, FormFactory.RELATED_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, FormFactory.RELATED_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, FormFactory.RELATED_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC}, new RowSpec[]{FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC}));
        JButton jButton = new JButton("Save");
        jButton.addActionListener(new SaveL());
        jButton.setFont(new Font("Tahoma", 0, 11));
        jPanel.add((Component)jButton, "2, 2");
        JButton jButton2 = new JButton("Cancel");
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SaveOutputGUI.this.dispose();
            }
        });
        jButton2.setFont(new Font("Tahoma", 0, 11));
        jPanel.add((Component)jButton2, "5, 2");
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new FlowLayout(2));
        this.getContentPane().add((Component)jPanel2, "South");
    }

    class SaveL
    implements ActionListener {
        SaveL() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            JFileChooser jFileChooser = new JFileChooser();
            jFileChooser.setCurrentDirectory(new File("./output"));
            int n = jFileChooser.showSaveDialog(SaveOutputGUI.this);
            if (n == 0) {
                try {
                    boolean bl;
                    String string = jFileChooser.getCurrentDirectory().toString() + "/" + jFileChooser.getSelectedFile().getName();
                    if (!string.endsWith(".xml")) {
                        string = string + ".xml";
                    }
                    if (bl = new File(string).exists()) {
                        int n2 = JOptionPane.showConfirmDialog(null, "File already exists, are you sure you want to override it?", "Confirmation", 0, 3);
                        if (n2 == 0) {
                            this.saveOutput(string);
                            SaveOutputGUI.this.dispose();
                        }
                    } else {
                        this.saveOutput(string);
                        SaveOutputGUI.this.dispose();
                    }
                }
                catch (Exception exception) {
                    JOptionPane.showMessageDialog(null, exception.getLocalizedMessage().toString(), "Save File", 2);
                }
            }
        }

        public void saveOutput(String string) {
            try {
                SapExt._outputFile = string;
                SapExt.jobsToXml();
                JOptionPane.showMessageDialog(null, "File saved successfully.", "Save output File", 1);
            }
            catch (Exception exception) {
                JOptionPane.showMessageDialog(null, exception.getLocalizedMessage().toString(), "Save File", 2);
            }
        }
    }
}

