/*
 * Decompiled with CFR 0.152.
 */
package SapExtractor;

import SapExtractor.EventsGUI;
import SapExtractor.SapExt;
import com.jgoodies.forms.factories.FormFactory;
import com.jgoodies.forms.layout.ColumnSpec;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.RowSpec;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Properties;
import java.util.Vector;
import java.util.logging.Level;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JProgressBar;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;

class MainUtilGUI
extends JFrame {
    private JPanel contentPane;
    private JTextField jobNameText;
    private JTextField jobCountText;
    private JTextField hostNameText;
    private JTextField userText;
    private JTextField userNameText;
    private JTextField systemNumberText;
    private JTextField clientNumberText;
    private JPasswordField passwordText;
    private JTextField fromDateText;
    private static JTextField toDateText;
    private JCheckBox chckbxScheduled;
    private JCheckBox chckbxActive;
    private JCheckBox chckbxReleased;
    private JCheckBox chckbxFinished;
    private JCheckBox chckbxReady;
    private JCheckBox chckbxCanceled;
    private JCheckBox chckbxTrace;
    public static JTextField afterEventText;
    private static MainUtilGUI _frame;

    public static void setCursorBusy() {
        _frame.setCursor(Cursor.getPredefinedCursor(3));
    }

    public static void setCursorDefault() {
        _frame.setCursor(Cursor.getDefaultCursor());
        _frame.setVisible(true);
    }

    public static void main(String[] stringArray) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    _frame = new MainUtilGUI();
                    _frame.setVisible(true);
                    _frame.setLocationRelativeTo(null);
                    _frame.getGlassPane();
                    WindowAdapter windowAdapter = new WindowAdapter(){

                        @Override
                        public void windowClosing(WindowEvent windowEvent) {
                            File[] fileArray;
                            File file = new File(".");
                            for (File file2 : fileArray = file.listFiles(new FilenameFilter(){

                                @Override
                                public boolean accept(File file, String string) {
                                    return string.matches(".*\\.jcoDestination");
                                }
                            })) {
                                file2.delete();
                            }
                        }
                    };
                    _frame.addWindowListener(windowAdapter);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        });
    }

    public MainUtilGUI() {
        this.setResizable(false);
        this.setIconImage(Toolkit.getDefaultToolkit().getImage("resources/bmc.jpg"));
        this.setTitle("BMC Control-M SAP Jobs Extractor");
        this.setDefaultCloseOperation(3);
        this.setBounds(100, 100, 673, 422);
        this.contentPane = new JPanel();
        this.contentPane.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.contentPane.setLayout(new BorderLayout(0, 0));
        this.setContentPane(this.contentPane);
        JPanel jPanel = new JPanel();
        this.contentPane.add((Component)jPanel, "Center");
        jPanel.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{FormFactory.RELATED_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, FormFactory.RELATED_GAP_COLSPEC, ColumnSpec.decode((String)"50dlu:grow(7)"), FormFactory.RELATED_GAP_COLSPEC, ColumnSpec.decode((String)"10dlu"), FormFactory.RELATED_GAP_COLSPEC, ColumnSpec.decode((String)"40dlu"), FormFactory.RELATED_GAP_COLSPEC, ColumnSpec.decode((String)"50dlu:grow(7)"), FormFactory.RELATED_GAP_COLSPEC, FormFactory.PREF_COLSPEC, FormFactory.RELATED_GAP_COLSPEC, ColumnSpec.decode((String)"40dlu"), FormFactory.RELATED_GAP_COLSPEC, ColumnSpec.decode((String)"50dlu:grow(7)"), FormFactory.RELATED_GAP_COLSPEC, ColumnSpec.decode((String)"10dlu"), FormFactory.RELATED_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, FormFactory.RELATED_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, FormFactory.RELATED_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC}, new RowSpec[]{FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, RowSpec.decode((String)"20px"), FormFactory.RELATED_GAP_ROWSPEC, RowSpec.decode((String)"20px"), FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, RowSpec.decode((String)"top:max(35dlu;default)"), FormFactory.DEFAULT_ROWSPEC}));
        JLabel jLabel = new JLabel("SAP Connection");
        jLabel.setFont(new Font("Tahoma", 0, 13));
        jPanel.add((Component)jLabel, "2, 2");
        JSeparator jSeparator = new JSeparator();
        jPanel.add((Component)jSeparator, "4, 2, 20, 1");
        JLabel jLabel2 = new JLabel("Host Name");
        jPanel.add((Component)jLabel2, "2, 4, right, default");
        this.hostNameText = new JTextField();
        this.hostNameText.setColumns(10);
        jPanel.add((Component)this.hostNameText, "4, 4, fill, default");
        JLabel jLabel3 = new JLabel("User Name");
        jPanel.add((Component)jLabel3, "8, 4, right, default");
        this.userNameText = new JTextField();
        this.userNameText.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent keyEvent) {
                MainUtilGUI.this.userNameText.setText(MainUtilGUI.this.userNameText.getText().toUpperCase());
            }
        });
        this.userNameText.setColumns(10);
        jPanel.add((Component)this.userNameText, "10, 4, fill, default");
        JLabel jLabel4 = new JLabel("Password");
        jPanel.add((Component)jLabel4, "14, 4, right, default");
        this.passwordText = new JPasswordField();
        jPanel.add((Component)this.passwordText, "16, 4, fill, default");
        JLabel jLabel5 = new JLabel("System Number");
        jPanel.add((Component)jLabel5, "2, 6, right, default");
        this.systemNumberText = new JTextField();
        this.systemNumberText.setColumns(10);
        jPanel.add((Component)this.systemNumberText, "4, 6, fill, default");
        JLabel jLabel6 = new JLabel("Client Number");
        jPanel.add((Component)jLabel6, "8, 6, right, default");
        this.clientNumberText = new JTextField();
        this.clientNumberText.setColumns(10);
        jPanel.add((Component)this.clientNumberText, "10, 6, fill, default");
        JLabel jLabel7 = new JLabel("Jobs Filter");
        jLabel7.setFont(new Font("Tahoma", 0, 13));
        jPanel.add((Component)jLabel7, "2, 10");
        JSeparator jSeparator2 = new JSeparator();
        jPanel.add((Component)jSeparator2, "4, 10, 21, 1");
        JLabel jLabel8 = new JLabel("Job Name");
        jPanel.add((Component)jLabel8, "2, 12, right, center");
        this.jobNameText = new JTextField();
        this.jobNameText.setToolTipText("Use '*' as a wildcard");
        this.jobNameText.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent keyEvent) {
                MainUtilGUI.this.jobNameText.setText(MainUtilGUI.this.jobNameText.getText().toUpperCase());
            }
        });
        jPanel.add((Component)this.jobNameText, "4, 12, 7, 1, default, top");
        this.jobNameText.setColumns(10);
        SapExt.jobsProgressBar = new JProgressBar();
        SapExt.jobsProgressBar.setStringPainted(true);
        jPanel.add((Component)SapExt.jobsProgressBar, "4, 30, 13, 1");
        final JButton jButton = new JButton("Get Jobs");
        jButton.setFont(new Font("Tahoma", 0, 11));
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                jButton.setEnabled(false);
                final SapExt sapExt = new SapExt("./logs/");
                sapExt.setTrace(MainUtilGUI.this.chckbxTrace.isSelected());
                sapExt.setJobName(MainUtilGUI.this.jobNameText.getText());
                sapExt.setJobCount(MainUtilGUI.this.jobCountText.getText());
                sapExt.setUser(MainUtilGUI.this.userText.getText());
                sapExt.setFromDate(MainUtilGUI.this.fromDateText.getText());
                sapExt.setToDate(toDateText.getText());
                sapExt.setAfterEvent(afterEventText.getText());
                sapExt.setClientNumber(MainUtilGUI.this.clientNumberText.getText());
                sapExt.setHostName(MainUtilGUI.this.hostNameText.getText());
                sapExt.setPassword(MainUtilGUI.this.passwordText.getPassword());
                sapExt.setSystemNumber(MainUtilGUI.this.systemNumberText.getText());
                sapExt.setUserName(MainUtilGUI.this.userNameText.getText());
                if (MainUtilGUI.this.chckbxActive.isSelected()) {
                    sapExt.setStatusActive("X");
                }
                if (MainUtilGUI.this.chckbxCanceled.isSelected()) {
                    sapExt.setStatusCanceled("X");
                }
                if (MainUtilGUI.this.chckbxFinished.isSelected()) {
                    sapExt.setStatusFinished("X");
                }
                if (MainUtilGUI.this.chckbxReady.isSelected()) {
                    sapExt.setStatusReady("X");
                }
                if (MainUtilGUI.this.chckbxReleased.isSelected()) {
                    sapExt.setStatusReleased("X");
                }
                if (MainUtilGUI.this.chckbxScheduled.isSelected()) {
                    sapExt.setStatusScheduled("X");
                }
                Thread thread = new Thread(){

                    @Override
                    public void run() {
                        try {
                            sapExt.getJobs(true);
                        }
                        catch (Exception exception) {
                            JOptionPane.showMessageDialog(null, exception.getLocalizedMessage(), "Error Message", 2);
                            SapExt.logger.log(Level.WARNING, "*** from GUI: " + exception.getLocalizedMessage());
                        }
                        jButton.setEnabled(true);
                    }
                };
                thread.start();
            }
        });
        this.userText = new JTextField();
        this.userText.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent keyEvent) {
                MainUtilGUI.this.userText.setText(MainUtilGUI.this.userText.getText().toUpperCase());
            }
        });
        JLabel jLabel9 = new JLabel("User Name");
        jPanel.add((Component)jLabel9, "14, 12, right, default");
        this.userText.setToolTipText("Use '*' as a wildcard");
        this.userText.setColumns(10);
        jPanel.add((Component)this.userText, "16, 12, default, top");
        JLabel jLabel10 = new JLabel("After Event");
        jPanel.add((Component)jLabel10, "2, 14, right, default");
        afterEventText = new JTextField();
        afterEventText.setToolTipText("<html>Optional.<br>Event name.<br>Use '%' as a wildcard</html>");
        afterEventText.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent keyEvent) {
                MainUtilGUI.this.fromDateText.setText("");
                toDateText.setText("");
            }
        });
        jPanel.add((Component)afterEventText, "4, 14, 7, 1, fill, default");
        afterEventText.setColumns(10);
        this.fromDateText = new JTextField();
        this.fromDateText.setToolTipText("<html>Optional.<br>Planned Start Date for Background Job.<br>Use format yyyyMMdd</html>");
        this.fromDateText.setColumns(10);
        this.fromDateText.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent keyEvent) {
                afterEventText.setText("");
            }
        });
        JButton jButton2 = new JButton("...");
        jButton2.setPreferredSize(new Dimension(20, 18));
        jButton2.setToolTipText("Load list of events from SAP, use \"%\" as a wild card");
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    EventsGUI eventsGUI = new EventsGUI();
                    eventsGUI.setLocationRelativeTo(null);
                    SapExt sapExt = new SapExt("./logs/");
                    sapExt.setTrace(MainUtilGUI.this.chckbxTrace.isSelected());
                    sapExt.setClientNumber(MainUtilGUI.this.clientNumberText.getText());
                    sapExt.setHostName(MainUtilGUI.this.hostNameText.getText());
                    sapExt.setPassword(MainUtilGUI.this.passwordText.getPassword());
                    sapExt.setSystemNumber(MainUtilGUI.this.systemNumberText.getText());
                    sapExt.setUserName(MainUtilGUI.this.userNameText.getText());
                    ArrayList<String> arrayList = sapExt.getEventsNames(true);
                    Vector<String> vector = new Vector<String>();
                    for (int i = 0; i < arrayList.size(); ++i) {
                        vector.add(arrayList.get(i));
                    }
                    EventsGUI.list.setListData(vector);
                    eventsGUI.setVisible(true);
                    if (EventsGUI.okClicked && EventsGUI.list.getSelectedValue().toString().length() > 0) {
                        afterEventText.setText((String)EventsGUI.list.getSelectedValue());
                        MainUtilGUI.this.fromDateText.setText("");
                        toDateText.setText("");
                    }
                }
                catch (Exception exception) {
                    JOptionPane.showMessageDialog(null, exception.getLocalizedMessage(), "Error Message", 2);
                    SapExt.logger.log(Level.WARNING, "*** from GUI: " + exception.getLocalizedMessage());
                }
            }
        });
        jPanel.add((Component)jButton2, "12, 14");
        JLabel jLabel11 = new JLabel("Job Count");
        jPanel.add((Component)jLabel11, "14, 14, right, center");
        this.jobCountText = new JTextField();
        this.jobCountText.setToolTipText("Optional");
        jPanel.add((Component)this.jobCountText, "16, 14, default, top");
        this.jobCountText.setColumns(10);
        JLabel jLabel12 = new JLabel("or From Date");
        jPanel.add((Component)jLabel12, "2, 16, right, default");
        jPanel.add((Component)this.fromDateText, "4, 16, fill, default");
        JLabel jLabel13 = new JLabel("To Date");
        jPanel.add((Component)jLabel13, "8, 16, right, default");
        toDateText = new JTextField();
        toDateText.setToolTipText("<html>Optional.<br>Planned Start Date for Background Job.<br>Use format yyyyMMdd</html>");
        toDateText.setColumns(10);
        toDateText.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent keyEvent) {
                afterEventText.setText("");
            }
        });
        jPanel.add((Component)toDateText, "10, 16, fill, default");
        JLabel jLabel14 = new JLabel("Job Status");
        jPanel.add((Component)jLabel14, "2, 18, right, default");
        this.chckbxScheduled = new JCheckBox("Scheduled");
        jPanel.add((Component)this.chckbxScheduled, "4, 18");
        this.chckbxActive = new JCheckBox("Active");
        jPanel.add((Component)this.chckbxActive, "8, 18");
        this.chckbxReleased = new JCheckBox("Released");
        jPanel.add((Component)this.chckbxReleased, "4, 20");
        this.chckbxFinished = new JCheckBox("Finished");
        jPanel.add((Component)this.chckbxFinished, "8, 20");
        this.chckbxReady = new JCheckBox("Ready");
        jPanel.add((Component)this.chckbxReady, "4, 22");
        this.chckbxCanceled = new JCheckBox("Canceled");
        jPanel.add((Component)this.chckbxCanceled, "8, 22");
        jPanel.add((Component)jButton, "2, 30");
        JPanel jPanel2 = new JPanel();
        jPanel.add((Component)jPanel2, "2, 34, 22, 1, fill, fill");
        jPanel2.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{FormFactory.DEFAULT_COLSPEC, FormFactory.RELATED_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, FormFactory.RELATED_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, FormFactory.RELATED_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, FormFactory.DEFAULT_COLSPEC, FormFactory.RELATED_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, FormFactory.RELATED_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, FormFactory.RELATED_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, FormFactory.RELATED_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, FormFactory.RELATED_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, FormFactory.RELATED_GAP_COLSPEC, ColumnSpec.decode((String)"50dlu"), FormFactory.RELATED_GAP_COLSPEC, ColumnSpec.decode((String)"50dlu")}, new RowSpec[]{FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC}));
        JButton jButton3 = new JButton("Load Rule File");
        jButton3.setFont(new Font("Tahoma", 0, 11));
        jButton3.addActionListener(new OpenL());
        jPanel2.add((Component)jButton3, "1, 2, left, default");
        JButton jButton4 = new JButton("Save Rule File");
        jButton4.setFont(new Font("Tahoma", 0, 11));
        jButton4.addActionListener(new SaveL());
        jPanel2.add((Component)jButton4, "3, 2");
        final JButton jButton5 = new JButton("Test Connection");
        jPanel2.add((Component)jButton5, "5, 2");
        jButton5.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                jButton5.setEnabled(false);
                SapExt sapExt = new SapExt("./logs/");
                sapExt.setClientNumber(MainUtilGUI.this.clientNumberText.getText());
                sapExt.setHostName(MainUtilGUI.this.hostNameText.getText());
                sapExt.setPassword(MainUtilGUI.this.passwordText.getPassword());
                sapExt.setSystemNumber(MainUtilGUI.this.systemNumberText.getText());
                sapExt.setUserName(MainUtilGUI.this.userNameText.getText());
                try {
                    sapExt.testConnection();
                    JOptionPane.showMessageDialog(null, "Connection tested successfully.", "SAP Extractor", 1);
                }
                catch (Exception exception) {
                    JOptionPane.showMessageDialog(null, exception.getLocalizedMessage(), "Error Message", 2);
                }
                jButton5.setEnabled(true);
            }
        });
        jButton5.setFont(new Font("Tahoma", 0, 11));
        JButton jButton6 = new JButton("Exit");
        jButton6.setFont(new Font("Tahoma", 0, 11));
        jButton6.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                System.exit(0);
            }
        });
        this.chckbxTrace = new JCheckBox("Trace");
        this.chckbxTrace.setFont(new Font("Tahoma", 0, 11));
        jPanel2.add((Component)this.chckbxTrace, "7, 2, center, default");
        jPanel2.add((Component)jButton6, "22, 2");
    }

    static {
        _frame = null;
    }

    class OpenL
    implements ActionListener {
        OpenL() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            JFileChooser jFileChooser = new JFileChooser();
            jFileChooser.setDialogTitle("Load Rule File");
            jFileChooser.setCurrentDirectory(new File("./rules"));
            int n = jFileChooser.showOpenDialog(MainUtilGUI.this);
            if (n == 0) {
                String string = jFileChooser.getCurrentDirectory().toString() + "/" + jFileChooser.getSelectedFile().getName();
                Properties properties = new Properties();
                try {
                    FileInputStream fileInputStream = new FileInputStream(string);
                    properties.load(fileInputStream);
                    fileInputStream.close();
                    MainUtilGUI.this.jobNameText.setText(properties.getProperty("jobname"));
                    MainUtilGUI.this.jobCountText.setText(properties.getProperty("jobcount"));
                    MainUtilGUI.this.userText.setText(properties.getProperty("user"));
                    MainUtilGUI.this.fromDateText.setText(properties.getProperty("fromdate"));
                    toDateText.setText(properties.getProperty("todate"));
                    afterEventText.setText(properties.getProperty("afterevent"));
                    MainUtilGUI.this.clientNumberText.setText(properties.getProperty("client"));
                    MainUtilGUI.this.hostNameText.setText(properties.getProperty("host"));
                    MainUtilGUI.this.passwordText.setText(properties.getProperty("password"));
                    MainUtilGUI.this.systemNumberText.setText(properties.getProperty("system"));
                    MainUtilGUI.this.userNameText.setText(properties.getProperty("username"));
                    MainUtilGUI.this.chckbxReleased.setSelected(properties.getProperty("released").toString().compareToIgnoreCase("X") == 0);
                    MainUtilGUI.this.chckbxScheduled.setSelected(properties.getProperty("scheduled").toString().compareToIgnoreCase("X") == 0);
                    MainUtilGUI.this.chckbxFinished.setSelected(properties.getProperty("finished").toString().compareToIgnoreCase("X") == 0);
                    MainUtilGUI.this.chckbxCanceled.setSelected(properties.getProperty("canceled").toString().compareToIgnoreCase("X") == 0);
                    MainUtilGUI.this.chckbxActive.setSelected(properties.getProperty("active").toString().compareToIgnoreCase("X") == 0);
                    MainUtilGUI.this.chckbxReady.setSelected(properties.getProperty("ready").toString().compareToIgnoreCase("X") == 0);
                }
                catch (IOException iOException) {
                    JOptionPane.showMessageDialog(null, "Failed to load file" + iOException.getLocalizedMessage(), "Load File", 2);
                }
            }
        }
    }

    class SaveL
    implements ActionListener {
        SaveL() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            JFileChooser jFileChooser = new JFileChooser();
            jFileChooser.setDialogTitle("Save Rule File");
            jFileChooser.setCurrentDirectory(new File("./rules"));
            int n = jFileChooser.showSaveDialog(MainUtilGUI.this);
            if (n == 0) {
                Properties properties = new Properties();
                properties.put("jobname", MainUtilGUI.this.jobNameText.getText());
                properties.put("jobcount", MainUtilGUI.this.jobCountText.getText());
                properties.put("user", MainUtilGUI.this.userText.getText());
                properties.put("fromdate", MainUtilGUI.this.fromDateText.getText());
                properties.put("todate", toDateText.getText());
                properties.put("afterevent", afterEventText.getText());
                properties.put("scheduled", MainUtilGUI.this.chckbxScheduled.isSelected() ? "X" : "");
                properties.put("released", MainUtilGUI.this.chckbxReleased.isSelected() ? "X" : "");
                properties.put("ready", MainUtilGUI.this.chckbxReady.isSelected() ? "X" : "");
                properties.put("active", MainUtilGUI.this.chckbxActive.isSelected() ? "X" : "");
                properties.put("finished", MainUtilGUI.this.chckbxFinished.isSelected() ? "X" : "");
                properties.put("canceled", MainUtilGUI.this.chckbxCanceled.isSelected() ? "X" : "");
                properties.put("host", MainUtilGUI.this.hostNameText.getText());
                properties.put("system", MainUtilGUI.this.systemNumberText.getText());
                properties.put("username", MainUtilGUI.this.userNameText.getText());
                properties.put("client", MainUtilGUI.this.clientNumberText.getText());
                properties.put("password", new String(MainUtilGUI.this.passwordText.getPassword()));
                try {
                    String string = jFileChooser.getCurrentDirectory().toString() + "/" + jFileChooser.getSelectedFile().getName();
                    boolean bl = new File(string).exists();
                    if (bl) {
                        int n2 = JOptionPane.showConfirmDialog(null, "File already exists, are you sure you want to overwrite it?", "Confirmation", 0, 3);
                        if (n2 == 0) {
                            properties.store(new FileOutputStream(string), null);
                            JOptionPane.showMessageDialog(null, "File saved successfully", "Save File", 1);
                        }
                    } else {
                        FileOutputStream fileOutputStream = new FileOutputStream(string);
                        properties.store(fileOutputStream, "BMC Software - SAP Extraction rule file");
                        ((OutputStream)fileOutputStream).close();
                        JOptionPane.showMessageDialog(null, "File saved successfully.", "Save Rule File", 1);
                    }
                }
                catch (Exception exception) {
                    JOptionPane.showMessageDialog(null, "Filed to save file: " + exception.getLocalizedMessage().toString(), "Save File", 2);
                }
            }
        }
    }
}

