/*
 * Decompiled with CFR 0.152.
 */
package SapExtractor;

import SapExtractor.FilterInfo;
import SapExtractor.LoginInfo;
import SapExtractor.SapExt;
import SapExtractor.SapExtException;
import java.util.ArrayList;

public class ConvSapExt {
    private SapExt _sapExt = null;
    public static final String VALUE_NOT_EXTRACTED = "CTM_VALUE_NOT_EXTRACTED";

    public ConvSapExt(boolean bl, String string) {
        this._sapExt = new SapExt(string);
        this._sapExt.setTrace(bl);
    }

    public void testConnection(LoginInfo loginInfo) throws SapExtException {
        if (loginInfo == null) {
            throw new SapExtException("LoginInfo object cannot be null");
        }
        this.setLoginInfo(loginInfo);
        try {
            this._sapExt.testConnection();
        }
        catch (Exception exception) {
            throw new SapExtException(exception.getLocalizedMessage());
        }
    }

    public void getData(LoginInfo loginInfo, FilterInfo filterInfo) throws SapExtException {
        if (loginInfo == null) {
            throw new SapExtException("LoginInfo object cannot be null");
        }
        if (filterInfo == null) {
            throw new SapExtException("LoginInfo object cannot be null");
        }
        this.setLoginInfo(loginInfo);
        this.setFilterInfo(filterInfo);
        try {
            this._sapExt.getJobs(false);
        }
        catch (Exception exception) {
            throw new SapExtException(exception.getLocalizedMessage());
        }
    }

    public ArrayList<String> getEventNames(LoginInfo loginInfo) throws SapExtException {
        if (loginInfo == null) {
            throw new SapExtException("LoginInfo object cannot be null");
        }
        this.setLoginInfo(loginInfo);
        try {
            return this._sapExt.getEventsNames(false);
        }
        catch (Exception exception) {
            throw new SapExtException(exception.getLocalizedMessage());
        }
    }

    public int getNumberOfJobs(LoginInfo loginInfo, FilterInfo filterInfo) throws SapExtException {
        if (loginInfo == null) {
            throw new SapExtException("LoginInfo object cannot be null");
        }
        if (filterInfo == null) {
            throw new SapExtException("LoginInfo object cannot be null");
        }
        this.setLoginInfo(loginInfo);
        this.setFilterInfo(filterInfo);
        try {
            return this._sapExt.getNumberOfJobs();
        }
        catch (Exception exception) {
            throw new SapExtException(exception.getLocalizedMessage());
        }
    }

    private void setFilterInfo(FilterInfo filterInfo) {
        this._sapExt.setFromDate(filterInfo.get_fromDate());
        this._sapExt.setJobCount(filterInfo.get_jobCount());
        this._sapExt.setJobName(filterInfo.get_jobName());
        this._sapExt.setOutputFile(filterInfo.get_outputFile());
        this._sapExt.setStatusActive(filterInfo.get_statusActive());
        this._sapExt.setStatusCanceled(filterInfo.get_statusCanceled());
        this._sapExt.setStatusFinished(filterInfo.get_statusFinished());
        this._sapExt.setStatusReady(filterInfo.get_statusReady());
        this._sapExt.setStatusReleased(filterInfo.get_statusReleased());
        this._sapExt.setStatusScheduled(filterInfo.get_statusScheduled());
        this._sapExt.setToDate(filterInfo.get_toDate());
        this._sapExt.setUser(filterInfo.get_user());
        this._sapExt.setAfterEvent(filterInfo.get_afterEvent());
    }

    private void setLoginInfo(LoginInfo loginInfo) {
        this._sapExt.setClientNumber(loginInfo.get_clientNumber());
        this._sapExt.setHostName(loginInfo.get_hostName());
        this._sapExt.setPassword(loginInfo.get_password().toCharArray());
        this._sapExt.setSystemNumber(loginInfo.get_systemNumber());
        this._sapExt.setUserName(loginInfo.get_userName());
    }

    public int getTotalNumberOfJobs() {
        return this._sapExt.getTotalNumOfJobs();
    }

    public int getNumberOfJobsExtractedSoFar() {
        return this._sapExt.getJobsExtractedSoFar();
    }
}

