/*
 * Decompiled with CFR 0.152.
 */
package SapExtractor;

import SapExtractor.MainUtilGUI;
import SapExtractor.MyDestinationDataProvider;
import SapExtractor.SaveOutputGUI;
import com.sap.conn.jco.JCoContext;
import com.sap.conn.jco.JCoDestination;
import com.sap.conn.jco.JCoDestinationManager;
import com.sap.conn.jco.JCoException;
import com.sap.conn.jco.JCoFunction;
import com.sap.conn.jco.JCoStructure;
import com.sap.conn.jco.JCoTable;
import com.sap.conn.jco.ext.DestinationDataProvider;
import com.sap.conn.jco.ext.Environment;
import java.awt.Dialog;
import java.awt.Window;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Properties;
import java.util.logging.FileHandler;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javax.swing.JOptionPane;
import javax.swing.JProgressBar;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

class SapExt {
    private String _jobName = "";
    private String _jobCount = "";
    private String _user = "";
    private String _fromDate = "";
    private String _toDate = "";
    private String _afterEvent = "";
    private String _statusScheduled = "";
    private String _statusActive = "";
    private String _statusReleased = "";
    private String _statusFinished = "";
    private String _statusReady = "";
    private String _statusCanceled = "";
    public static String _outputFile = "";
    private String _hostName = "";
    private String _systemNumber = "";
    private String _clientNumber = "";
    private String _userName = "";
    private char[] _password = new char[0];
    public static Document doc;
    private Properties _connectProperties = null;
    private JCoDestination destination = null;
    MyDestinationDataProvider provider = null;
    private int totalNumOfJobs = 0;
    private int jobsExtractedSoFar = 0;
    private String _logPath = null;
    public static JProgressBar jobsProgressBar;
    static Logger logger;
    static int logFlag;
    static String newLine;
    HashSet<String> calNames = new HashSet();

    public SapExt(String string) {
        if (logFlag == 0) {
            newLine = System.getProperty("os.name").startsWith("Win") ? "\r\n" : "\n";
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMddHHmmss");
            Date date = new Date();
            try {
                LogManager.getLogManager().readConfiguration(new FileInputStream("resources/log.properties"));
            }
            catch (Exception exception) {
                logger.setLevel(Level.WARNING);
            }
            Handler handler = null;
            try {
                File file = null;
                file = string != null ? new File(string) : new File("./logs/");
                if (!file.exists()) {
                    file.mkdirs();
                }
                handler = new FileHandler(string + "/sapext_" + simpleDateFormat.format(date) + ".log");
            }
            catch (SecurityException securityException) {
                securityException.printStackTrace();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            handler.setFormatter(new MyFormatter());
            logger.addHandler(handler);
            logger.log(Level.INFO, "Log started" + newLine);
            logFlag = 1;
        }
        _outputFile = "";
    }

    public void setTrace(boolean bl) {
        if (bl) {
            logger.setLevel(Level.INFO);
            logger.log(Level.INFO, "log trace set to " + bl);
        } else {
            logger.setLevel(Level.WARNING);
        }
    }

    public void setlogPath(String string) {
        if (string != null) {
            this._logPath = string;
        }
    }

    private void validateConnDetails() throws Exception {
        if (this._hostName == null || this._hostName.length() == 0 || this._systemNumber == null || this._systemNumber.length() == 0 || this._clientNumber == null || this._clientNumber.length() == 0 || this._userName == null || this._userName.length() == 0 || this._password == null || this._password.length == 0) {
            throw new Exception("Missing connection information. All Connection fields are mandatory.");
        }
    }

    private void validateFilterDetails() throws Exception {
        Date date;
        SimpleDateFormat simpleDateFormat;
        if (this._jobName.length() == 0) {
            throw new Exception("Filter Job Name is mandatory.");
        }
        if (this._user.length() == 0) {
            throw new Exception("Filter User Name is mandatory.");
        }
        if (this._statusActive.length() == 0 && this._statusCanceled.length() == 0 && this._statusFinished.length() == 0 && this._statusReady.length() == 0 && this._statusReleased.length() == 0 && this._statusScheduled.length() == 0) {
            throw new Exception("At least one Filter Job Status should be specified.");
        }
        if (this._fromDate.length() > 0) {
            simpleDateFormat = new SimpleDateFormat("yyyyMMdd");
            simpleDateFormat.setLenient(false);
            try {
                date = simpleDateFormat.parse(this._fromDate);
            }
            catch (ParseException parseException) {
                throw new Exception("Filter From Date format is incorrect, should be yyyyMMdd:" + parseException.getLocalizedMessage());
            }
        }
        if (this._toDate.length() > 0) {
            simpleDateFormat = new SimpleDateFormat("yyyyMMdd");
            simpleDateFormat.setLenient(false);
            try {
                date = simpleDateFormat.parse(this._toDate);
            }
            catch (ParseException parseException) {
                throw new Exception("Filter To Date format is incorrect, should be yyyyMMdd: " + parseException.getLocalizedMessage());
            }
        }
    }

    private void setConnectionDetails() {
        this._connectProperties = new Properties();
        this._connectProperties.setProperty("jco.client.ashost", this._hostName);
        this._connectProperties.setProperty("jco.client.sysnr", this._systemNumber);
        this._connectProperties.setProperty("jco.client.client", this._clientNumber);
        this._connectProperties.setProperty("jco.client.user", this._userName);
        this._connectProperties.setProperty("jco.client.passwd", new String(this._password));
        this._connectProperties.setProperty("jco.client.lang", "en");
    }

    public ArrayList<String> getEventsNames(boolean bl) throws Exception {
        try {
            ArrayList<String> arrayList = new ArrayList<String>();
            this.validateConnDetails();
            this.startSapContext("3.0");
            JCoFunction jCoFunction = this.destination.getRepository().getFunction("BAPI_XBP_EVENT_DEFINITIONS_GET");
            if (jCoFunction == null) {
                throw new JCoException(0, "BAPI_XBP_EVENT_DEFINITIONS_GET doesn't exist on SAP");
            }
            jCoFunction.getImportParameterList().setValue("I_EXTERNAL_USER_NAME", this._userName);
            if (bl) {
                jCoFunction.getImportParameterList().setValue("I_EVENTID_MASK", MainUtilGUI.afterEventText.getText());
            } else {
                jCoFunction.getImportParameterList().setValue("I_EVENTID_MASK", "%");
            }
            logger.log(Level.INFO, "Running BAPI_XBP_EVENT_DEFINITIONS_GET");
            jCoFunction.execute(this.destination);
            JCoTable jCoTable = jCoFunction.getExportParameterList().getTable("E_T_EVENTS");
            logger.log(Level.INFO, "Attributes for table E_T_EVENTS as extracted from SAP (list of events):");
            logger.log(Level.INFO, newLine + jCoTable.toString());
            for (int i = 0; i < jCoTable.getNumRows(); ++i) {
                jCoTable.setRow(i);
                arrayList.add((String)jCoTable.getValue("EVENTID"));
            }
            ArrayList<String> arrayList2 = arrayList;
            return arrayList2;
        }
        catch (JCoException jCoException) {
            throw new Exception("BAPI_XBP_EVENT_DEFINITIONS_GET doesn't exist on SAP");
        }
        catch (Exception exception) {
            logger.log(Level.WARNING, exception.getLocalizedMessage());
            throw new Exception(exception.getLocalizedMessage());
        }
        finally {
            this.endSapContext();
        }
    }

    public void testConnection() throws Exception {
        this.validateConnDetails();
        String string = this._hostName;
        this.setConnectionDetails();
        try {
            this.startSapContext("2.0");
            JCoDestination jCoDestination = null;
            jCoDestination = JCoDestinationManager.getDestination((String)string);
            jCoDestination.ping();
        }
        catch (JCoException jCoException) {
            String string2 = "Failed to connect to SAP system, please check the SAP connection details.\nSAP Error message follows:\n" + jCoException.getLocalizedMessage();
            throw new Exception(string2);
        }
        finally {
            this.endSapContext();
        }
    }

    private void endSapContext() {
        try {
            JCoContext.end((JCoDestination)this.destination);
        }
        catch (JCoException jCoException) {
            // empty catch block
        }
        Environment.unregisterDestinationDataProvider((DestinationDataProvider)this.provider);
    }

    private void startSapContext(String string) throws Exception {
        logger.log(Level.INFO, "Connecting to SAP system...");
        String string2 = this._hostName;
        this.setConnectionDetails();
        try {
            this.provider = new MyDestinationDataProvider();
            this.provider.addDestination(string2, this._connectProperties);
            Environment.registerDestinationDataProvider((DestinationDataProvider)this.provider);
            this.destination = JCoDestinationManager.getDestination((String)string2);
            this.destination.ping();
        }
        catch (JCoException jCoException) {
            throw new Exception("Failed to connect to SAP system, please check the SAP connection details.\nSAP Error message follows:\n" + jCoException.getLocalizedMessage());
        }
        JCoContext.begin((JCoDestination)this.destination);
        logger.log(Level.INFO, "Connected successfully");
        JCoFunction jCoFunction = this.destination.getRepository().getFunction("BAPI_XMI_LOGON");
        jCoFunction.getImportParameterList().setValue("EXTCOMPANY", "BMC Software");
        jCoFunction.getImportParameterList().setValue("EXTPRODUCT", "Control-M");
        jCoFunction.getImportParameterList().setValue("INTERFACE", "XBP");
        jCoFunction.getImportParameterList().setValue("VERSION", string);
        jCoFunction.execute(this.destination);
        String string3 = jCoFunction.getExportParameterList().getString("SESSIONID");
        if (string3 == null || string3.length() <= 0) {
            throw new Exception("Log in was not completed successfully, failed to create session.");
        }
        logger.log(Level.INFO, "XMI logged in with session ID: " + string3);
    }

    public int getNumberOfJobs() throws Exception {
        try {
            int n;
            SimpleDateFormat simpleDateFormat;
            this.validateConnDetails();
            this.validateFilterDetails();
            this.startSapContext("2.0");
            JCoFunction jCoFunction = this.destination.getRepository().getFunction("BAPI_XBP_JOB_SELECT");
            jCoFunction.getImportParameterList().setValue("EXTERNAL_USER_NAME", this._userName);
            JCoStructure jCoStructure = jCoFunction.getImportParameterList().getStructure("JOB_SELECT_PARAM");
            jCoStructure.setValue("USERNAME", this._user);
            jCoStructure.setValue("JOBNAME", this._jobName);
            jCoStructure.setValue("JOBCOUNT", this._jobCount);
            if (this._afterEvent.length() > 0) {
                jCoStructure.setValue("EVENTID", this._afterEvent.toUpperCase());
            } else {
                Date date;
                simpleDateFormat = new SimpleDateFormat("yyyyMMdd");
                if (this._fromDate.length() > 0) {
                    date = simpleDateFormat.parse(this._fromDate);
                    jCoStructure.setValue("FROM_DATE", (Object)date);
                }
                if (this._toDate.length() > 0) {
                    date = simpleDateFormat.parse(this._toDate);
                    jCoStructure.setValue("TO_DATE", (Object)date);
                }
            }
            jCoStructure.setValue("FINISHED", this._statusFinished);
            jCoStructure.setValue("READY", this._statusReady);
            jCoStructure.setValue("SCHEDUL", this._statusReleased);
            jCoStructure.setValue("RUNNING", this._statusActive);
            jCoStructure.setValue("ABORTED", this._statusCanceled);
            jCoStructure.setValue("PRELIM", this._statusScheduled);
            logger.log(Level.INFO, "Running BAPI_XBP_JOB_SELECT with the follwoing values:");
            logger.log(Level.INFO, "USERNAME = " + this._user);
            logger.log(Level.INFO, "JOBNAME = " + this._jobName);
            logger.log(Level.INFO, "JOBCOUNT = " + this._jobCount);
            logger.log(Level.INFO, "FROM_DATE = " + this._fromDate);
            logger.log(Level.INFO, "To_DATE = " + this._toDate);
            logger.log(Level.INFO, "FINISHED = " + this._statusFinished);
            logger.log(Level.INFO, "EVENTID = " + this._afterEvent);
            logger.log(Level.INFO, "READY = " + this._statusReady);
            logger.log(Level.INFO, "SCHEDUL = " + this._statusReleased);
            logger.log(Level.INFO, "RUNNING = " + this._statusActive);
            logger.log(Level.INFO, "ABORTED = " + this._statusCanceled);
            logger.log(Level.INFO, "PRELIM = " + this._statusScheduled);
            logger.log(Level.INFO, newLine + jCoStructure.toString());
            jCoFunction.execute(this.destination);
            simpleDateFormat = jCoFunction.getTableParameterList().getTable("SELECTED_JOBS");
            int n2 = n = simpleDateFormat.getNumRows();
            return n2;
        }
        catch (Exception exception) {
            throw new Exception(exception.getLocalizedMessage());
        }
        finally {
            this.endSapContext();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getJobs(boolean bl) throws Exception {
        if (bl) {
            jobsProgressBar.setValue(0);
        }
        this.validateConnDetails();
        this.validateFilterDetails();
        try {
            Object object;
            Object object2;
            Object object3;
            Object object4;
            String string;
            Object object5;
            Object object6;
            Element element;
            Element element2;
            Element element3;
            int n;
            SimpleDateFormat simpleDateFormat;
            this.startSapContext("2.0");
            JCoFunction jCoFunction = this.destination.getRepository().getFunction("BAPI_XBP_JOB_SELECT");
            jCoFunction.getImportParameterList().setValue("EXTERNAL_USER_NAME", this._userName);
            JCoStructure jCoStructure = jCoFunction.getImportParameterList().getStructure("JOB_SELECT_PARAM");
            jCoStructure.setValue("USERNAME", this._user);
            jCoStructure.setValue("JOBNAME", this._jobName);
            jCoStructure.setValue("JOBCOUNT", this._jobCount);
            if (this._afterEvent.length() > 0) {
                jCoStructure.setValue("EVENTID", this._afterEvent.toUpperCase());
            } else {
                Date date;
                simpleDateFormat = new SimpleDateFormat("yyyyMMdd");
                if (this._fromDate.length() > 0) {
                    date = simpleDateFormat.parse(this._fromDate);
                    jCoStructure.setValue("FROM_DATE", (Object)date);
                }
                if (this._toDate.length() > 0) {
                    date = simpleDateFormat.parse(this._toDate);
                    jCoStructure.setValue("TO_DATE", (Object)date);
                }
            }
            jCoStructure.setValue("FINISHED", this._statusFinished);
            jCoStructure.setValue("READY", this._statusReady);
            jCoStructure.setValue("SCHEDUL", this._statusReleased);
            jCoStructure.setValue("RUNNING", this._statusActive);
            jCoStructure.setValue("ABORTED", this._statusCanceled);
            jCoStructure.setValue("PRELIM", this._statusScheduled);
            logger.log(Level.INFO, "Running BAPI_XBP_JOB_SELECT with the follwoing values:");
            logger.log(Level.INFO, "USERNAME = " + this._user);
            logger.log(Level.INFO, "JOBNAME = " + this._jobName);
            logger.log(Level.INFO, "JOBCOUNT = " + this._jobCount);
            logger.log(Level.INFO, "FROM_DATE = " + this._fromDate);
            logger.log(Level.INFO, "To_DATE = " + this._toDate);
            logger.log(Level.INFO, "FINISHED = " + this._statusFinished);
            logger.log(Level.INFO, "EVENTID = " + this._afterEvent);
            logger.log(Level.INFO, "READY = " + this._statusReady);
            logger.log(Level.INFO, "SCHEDUL = " + this._statusReleased);
            logger.log(Level.INFO, "RUNNING = " + this._statusActive);
            logger.log(Level.INFO, "ABORTED = " + this._statusCanceled);
            logger.log(Level.INFO, "PRELIM = " + this._statusScheduled);
            logger.log(Level.INFO, newLine + jCoStructure.toString());
            if (bl) {
                MainUtilGUI.setCursorBusy();
            }
            jCoFunction.execute(this.destination);
            if (bl) {
                MainUtilGUI.setCursorDefault();
            }
            if ((n = (simpleDateFormat = jCoFunction.getTableParameterList().getTable("SELECTED_JOBS")).getNumRows()) == 0) {
                throw new Exception("No SAP jobs that match the filter criteria were found.");
            }
            logger.log(Level.INFO, "Found " + n + " jobs in SAP");
            this.totalNumOfJobs = n;
            if (bl) {
                int n2 = 0;
                int n3 = JOptionPane.showConfirmDialog(null, "Found " + simpleDateFormat.getNumRows() + " job(s) in SAP that match(es) the filter criteria.\n" + "Do you want to continue?", "Confirmation", n2);
                if (n3 == 1) {
                    return;
                }
            }
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            doc = documentBuilder.newDocument();
            Element element4 = doc.createElement("ApplicationData");
            doc.appendChild(element4);
            Element element5 = doc.createElement("ApplicationJobs");
            element4.appendChild(element5);
            element5.setAttribute("APPL_FORM", "SAP R3");
            element5.setAttribute("APPL_TYPE", "SAP");
            element5.setAttribute("APPL_VER", "46C/46D");
            element5.setAttribute("CM_VER", "610");
            Element element6 = doc.createElement("CalendarData");
            element4.appendChild(element6);
            int n4 = simpleDateFormat.getNumRows();
            if (bl) {
                jobsProgressBar.setMaximum(n4 > 0 ? n4 : 1);
                jobsProgressBar.setMinimum(0);
                jobsProgressBar.setValue(0);
            }
            for (int i = 0; i < simpleDateFormat.getNumRows(); ++i) {
                String string2;
                String string3;
                Object object7;
                Object object8;
                Object object9;
                String string4;
                String string5;
                block93: {
                    block96: {
                        element3 = doc.createElement("JobData");
                        element5.appendChild(element3);
                        element2 = doc.createElement("Variables");
                        element3.appendChild(element2);
                        element = doc.createElement("Cyclic");
                        element3.appendChild(element);
                        object6 = doc.createElement("Scheduling");
                        element3.appendChild((Node)object6);
                        object5 = this.destination.getRepository().getFunction("BAPI_XBP_JOB_DEFINITION_GET");
                        object5.getImportParameterList().setValue("EXTERNAL_USER_NAME", this._userName);
                        simpleDateFormat.setRow(i);
                        string5 = simpleDateFormat.getString("JOBNAME");
                        string4 = simpleDateFormat.getString("JOBCOUNT");
                        object5.getImportParameterList().setValue("JOBCOUNT", string4);
                        object5.getImportParameterList().setValue("JOBNAME", string5);
                        object5.execute(this.destination);
                        element3.setAttribute("JOBNAME", string5);
                        element3.setAttribute("FOLDER", "");
                        logger.log(Level.INFO, "--> Job definitions for jobname '" + string5 + "' jobcount '" + string4 + "'");
                        try {
                            string = object5.getExportParameterList().getStructure("RECIPIENT");
                            logger.log(Level.INFO, newLine + string.toString());
                            logger.log(Level.INFO, "Attributes for struct RECIPIENT as extracted from SAP (spool list recipient):");
                            object4 = (String)string.getValue("COPY");
                            logger.log(Level.INFO, String.format("%1$-14s", "COPY") + "= " + (String)object4);
                            if (((String)object4).length() == 0) {
                                object4 = "N";
                            }
                            this.addField(element2, "COPY", (String)object4, "%%SAPR3-RECIP_COPY");
                            object3 = (String)string.getValue("EXPRESS");
                            logger.log(Level.INFO, String.format("%1$-14s", "EXPRESS") + "= " + (String)object3);
                            if (((String)object3).length() == 0) {
                                object3 = "N";
                            }
                            this.addField(element2, "EXPRESS", (String)object3, "%%SAPR3-RECIP_EXPRESS");
                            object2 = (String)string.getValue("RECIPIENT");
                            logger.log(Level.INFO, String.format("%1$-14s", "RECIPIENT") + "= " + (String)object2);
                            this.addField(element2, "RECIPIENT", (String)object2, "%%SAPR3-RECIPIENT");
                            object = (String)string.getValue("BLIND_COPY");
                            logger.log(Level.INFO, String.format("%1$-14s", "BLIND_COPY") + "= " + (String)object);
                            if (((String)object).length() == 0) {
                                object = "N";
                            }
                            this.addField(element2, "BLIND_COPY", (String)object, "%%SAPR3-RECIP_BLIND_COPY");
                            String string6 = (String)string.getValue("NO_FORWARDING");
                            logger.log(Level.INFO, String.format("%1$-14s", "NO_FORWARDING") + "= " + string6);
                            if (string6.length() == 0) {
                                string6 = "N";
                            }
                            this.addField(element2, "NO_FORWARDING", string6, "%%SAPR3-RECIP_NO_FORWARDING");
                            object9 = (String)string.getValue("REC_TYPE");
                            logger.log(Level.INFO, String.format("%1$-14s", "REC_TYPE") + "= " + (String)object9);
                            this.addField(element2, "REC_TYPE", (String)object9, "%%SAPR3-RECIP_TYPE");
                        }
                        catch (Exception exception) {
                            logger.log(Level.WARNING, "**** Failed to get structure RECIPIENT from SAP, spool list recipient information will not be extracted: " + exception.getLocalizedMessage());
                            this.addField(element2, "COPY", "CTM_VALUE_NOT_EXTRACTED", "%%SAPR3-RECIP_COPY");
                            this.addField(element2, "EXPRESS", "CTM_VALUE_NOT_EXTRACTED", "%%SAPR3-RECIP_EXPRESS");
                            this.addField(element2, "RECIPIENT", "CTM_VALUE_NOT_EXTRACTED", "%%SAPR3-RECIPIENT");
                            this.addField(element2, "BLIND_COPY", "CTM_VALUE_NOT_EXTRACTED", "%%SAPR3-RECIP_BLIND_COPY");
                            this.addField(element2, "NO_FORWARDING", "CTM_VALUE_NOT_EXTRACTED", "%%SAPR3-RECIP_NO_FORWARDING");
                            this.addField(element2, "REC_TYPE", "CTM_VALUE_NOT_EXTRACTED", "%%SAPR3-RECIP_TYPE");
                        }
                        string = object5.getExportParameterList().getStructure("JOB_HEAD");
                        logger.log(Level.INFO, "Attributes for struct JOB_HEAD as extracted from SAP:");
                        logger.log(Level.INFO, newLine + string.toString());
                        object4 = (String)string.getValue("JOBNAME");
                        logger.log(Level.INFO, String.format("%1$-14s", "JOBNAME") + "= " + (String)object4);
                        this.addField(element2, "JOBNAME", (String)object4, "%%SAPR3-JOBNAME");
                        object3 = (String)string.getValue("JOBCOUNT");
                        logger.log(Level.INFO, String.format("%1$-14s", "JOBCOUNT") + "= " + (String)object3);
                        this.addField(element2, "JOBCOUNT", (String)object3, "");
                        object2 = (String)string.getValue("STATUS");
                        logger.log(Level.INFO, String.format("%1$-14s", "STATUS") + "= " + (String)object2);
                        this.addField(element2, "STATUS", (String)object2, "");
                        object = (String)string.getValue("JOBCLASS");
                        logger.log(Level.INFO, String.format("%1$-14s", "JOBCLASS") + "= " + (String)object);
                        this.addField(element2, "JOBCLASS", (String)object, "%%SAPR3-JOBCLASS");
                        int n5 = (Integer)string.getValue("STEPCOUNT");
                        logger.log(Level.INFO, String.format("%1$-14s", "STEPCOUNT") + "= " + n5);
                        this.addField(element2, "STEPCOUNT", new Integer(n5).toString(), "");
                        if (((String)object2).compareToIgnoreCase("S") != 0) break block96;
                        object9 = new SimpleDateFormat("dd.MM.yyyy");
                        object8 = null;
                        try {
                            object8 = ((DateFormat)object9).format((Date)string.getValue("SDLSTRTDT")).toString();
                        }
                        catch (Exception exception) {
                            try {
                                object8 = "";
                            }
                            catch (Throwable throwable) {
                                logger.log(Level.INFO, String.format("%1$-14s", "SDLSTRTDT") + "= " + (String)object8);
                                this.addField((Element)object6, "SDLSTRTDT", (String)object8, "");
                                throw throwable;
                            }
                            logger.log(Level.INFO, String.format("%1$-14s", "SDLSTRTDT") + "= " + (String)object8);
                            this.addField((Element)object6, "SDLSTRTDT", (String)object8, "");
                        }
                        logger.log(Level.INFO, String.format("%1$-14s", "SDLSTRTDT") + "= " + (String)object8);
                        this.addField((Element)object6, "SDLSTRTDT", (String)object8, "");
                        object7 = new SimpleDateFormat("HH:mm:ss");
                        string3 = null;
                        try {
                            string3 = ((DateFormat)object7).format((Date)string.getValue("SDLSTRTTM")).toString();
                        }
                        catch (Exception exception) {
                            try {
                                string3 = "";
                            }
                            catch (Throwable throwable) {
                                logger.log(Level.INFO, String.format("%1$-14s", "SDLSTRTTM") + "= " + string3);
                                this.addField((Element)object6, "SDLSTRTTM", string3, "");
                                throw throwable;
                            }
                            logger.log(Level.INFO, String.format("%1$-14s", "SDLSTRTTM") + "= " + string3);
                            this.addField((Element)object6, "SDLSTRTTM", string3, "");
                            break block93;
                        }
                        logger.log(Level.INFO, String.format("%1$-14s", "SDLSTRTTM") + "= " + string3);
                        this.addField((Element)object6, "SDLSTRTTM", string3, "");
                        break block93;
                    }
                    this.addField((Element)object6, "SDLSTRTDT", "", "");
                    this.addField((Element)object6, "SDLSTRTTM", "", "");
                }
                object9 = null;
                try {
                    object9 = ((Date)string.getValue("LASTSTRTTM")).toString();
                    object8 = ((String)object9).split("\\s+");
                    object9 = object8[3];
                }
                catch (Exception exception) {
                    try {
                        object9 = "";
                    }
                    catch (Throwable throwable) {
                        logger.log(Level.INFO, String.format("%1$-14s", "LASTSTRTTM") + "= " + (String)object9);
                        this.addField((Element)object6, "LASTSTRTTM", (String)object9, "");
                        throw throwable;
                    }
                    logger.log(Level.INFO, String.format("%1$-14s", "LASTSTRTTM") + "= " + (String)object9);
                    this.addField((Element)object6, "LASTSTRTTM", (String)object9, "");
                }
                logger.log(Level.INFO, String.format("%1$-14s", "LASTSTRTTM") + "= " + (String)object9);
                this.addField((Element)object6, "LASTSTRTTM", (String)object9, "");
                object8 = new SimpleDateFormat("dd.MM.yyyy");
                object7 = null;
                try {
                    object7 = ((DateFormat)object8).format((Date)string.getValue("LASTSTRTDT")).toString();
                    string3 = null;
                    string3 = ((String)object9).length() == 0 ? "don't execute before" : "latest execution date";
                }
                catch (Exception exception) {
                    try {
                        object7 = "";
                        string3 = null;
                        string3 = ((String)object9).length() == 0 ? "don't execute before" : "latest execution date";
                    }
                    catch (Throwable throwable) {
                        string2 = null;
                        string2 = ((String)object9).length() == 0 ? "don't execute before" : "latest execution date";
                        logger.log(Level.INFO, String.format("%1$-14s", "LASTSTRTDT") + "= " + (String)object7);
                        this.addField((Element)object6, "LASTSTRTDT", (String)object7, "");
                        throw throwable;
                    }
                    logger.log(Level.INFO, String.format("%1$-14s", "LASTSTRTDT") + "= " + (String)object7);
                    this.addField((Element)object6, "LASTSTRTDT", (String)object7, "");
                }
                logger.log(Level.INFO, String.format("%1$-14s", "LASTSTRTDT") + "= " + (String)object7);
                this.addField((Element)object6, "LASTSTRTDT", (String)object7, "");
                this.addField(element2, "", "S", "%%SAPR3-KEEP_JOBLOG_OPTION");
                this.addField(element2, "", "X", "%%SAPR3-OVERRIDE_JOBLOG_DEFAULT");
                this.addField(element2, "", "*SYSOUT", "%%SAPR3-JOBLOG");
                string3 = (String)string.getValue("EXECSERVER");
                logger.log(Level.INFO, String.format("%1$-14s", "EXECSERVER") + "= " + string3);
                this.addField(element2, "EXECSERVER", string3, "%%SAPR3-TARGET_SERVER");
                String string7 = (String)string.getValue("EVENTID");
                logger.log(Level.INFO, String.format("%1$-14s", "EVENTID") + "= " + string7);
                this.addField(element2, "EVENTID", string7, "%%SAPR3-EVENT_ID");
                String string8 = (String)string.getValue("EVENTPARM");
                logger.log(Level.INFO, String.format("%1$-14s", "EVENTPARM") + "= " + string8);
                this.addField(element2, "EVENTPARM", string8, "%%SAPR3-EVENT_PARAM");
                String string9 = (String)string.getValue("CALENDARID");
                logger.log(Level.INFO, String.format("%1$-14s", "CALENDARID") + "= " + string9);
                this.addField((Element)object6, "CALENDARID", string9, "");
                if (string9.length() > 0) {
                    this.calNames.add(string9);
                }
                String string10 = (String)string.getValue("PERIODIC");
                logger.log(Level.INFO, String.format("%1$-10s", "PERIODIC") + "= " + string10);
                this.addField(element, "PERIODIC", string10, "");
                string2 = this.destination.getRepository().getFunction("BAPI_XBP_JOB_READ");
                string2.getImportParameterList().setValue("EXTERNAL_USER_NAME", this._userName);
                string2.getImportParameterList().setValue("JOBCOUNT", string4);
                string2.getImportParameterList().setValue("JOBNAME", string5);
                string2.getImportParameterList().setValue("JOB_HEADER_ONLY", "X");
                string2.execute(this.destination);
                JCoStructure jCoStructure2 = string2.getExportParameterList().getStructure("JOBHEAD");
                logger.log(Level.INFO, "Attributes for struct JOBHEAD as extracted from SAP (periodic values):");
                logger.log(Level.INFO, newLine + jCoStructure2.toString());
                String string11 = (String)jCoStructure2.getValue("PRDMINS");
                logger.log(Level.INFO, String.format("%1$-10s", "PRDMINS") + "= " + string11);
                this.addField(element, "PRDMINS", string11, "");
                String string12 = (String)jCoStructure2.getValue("PRDHOURS");
                logger.log(Level.INFO, String.format("%1$-10s", "PRDHOURS") + "= " + string12);
                this.addField(element, "PRDHOURS", string12, "");
                String string13 = (String)jCoStructure2.getValue("PRDDAYS");
                logger.log(Level.INFO, String.format("%1$-10s", "PRDDAYS") + "= " + string13);
                this.addField(element, "PRDDAYS", string13, "");
                String string14 = (String)jCoStructure2.getValue("PRDWEEKS");
                logger.log(Level.INFO, String.format("%1$-10s", "PRDWEEKS") + "= " + string14);
                this.addField(element, "PRDWEEKS", string14, "");
                String string15 = (String)jCoStructure2.getValue("PRDMONTHS");
                logger.log(Level.INFO, String.format("%1$-10s", "PRDMONTHS") + "= " + string15);
                this.addField(element, "PRDMONTHS", string15, "");
                JCoTable jCoTable = object5.getTableParameterList().getTable("STEP_TBL");
                JCoTable jCoTable2 = null;
                try {
                    jCoTable2 = object5.getTableParameterList().getTable("SPOOL_ATTR");
                }
                catch (Exception exception) {
                    logger.log(Level.WARNING, "**** Failed to get table SPOOL_ATTR from SAP, some fields will not be extracted: " + exception.getLocalizedMessage());
                }
                logger.log(Level.INFO, "Attributes for struct STEP_TBL as extracted from SAP (steps):");
                logger.log(Level.INFO, newLine + jCoTable.toString());
                if (jCoTable2 != null) {
                    try {
                        logger.log(Level.INFO, "Attributes for struct SPOOL_ATTR as extracted from SAP (steps):");
                        logger.log(Level.INFO, newLine + jCoTable2.toString());
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                for (int j = 0; j < jCoTable.getNumRows(); ++j) {
                    String string16;
                    String string17;
                    String string18;
                    String string19;
                    String string20;
                    String string21;
                    String string22;
                    String string23;
                    String string24;
                    jCoTable.setRow(j);
                    if (jCoTable2 != null) {
                        try {
                            jCoTable2.setRow(j);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    String string25 = "%%SAPR3-STEP-S" + String.format("%02d", j + 1);
                    logger.log(Level.INFO, "Attributes for step " + (j + 1));
                    String string26 = (String)jCoTable.getValue("TYP");
                    logger.log(Level.INFO, String.format("%1$-10s", "TYP") + "= " + string26);
                    if (string26.compareToIgnoreCase("A") == 0) {
                        String string27;
                        String string28;
                        block94: {
                            String string29;
                            this.addField(element2, "TYP", "A", string25 + "-STEP_TYPE");
                            string24 = (String)jCoTable.getValue("PROGRAM");
                            logger.log(Level.INFO, String.format("%1$-10s", "PROGRAM") + "= " + string24);
                            this.addField(element2, "PROGRAM", string24, string25 + "-PROGRAM");
                            string23 = (String)jCoTable.getValue("PARAMETER");
                            logger.log(Level.INFO, String.format("%1$-10s", "PARAMETER") + "= " + string23);
                            this.addField(element2, "PARAMETER", string23, string25 + "-VAR-NAME");
                            string22 = (String)jCoTable.getValue("AUTHCKNAM");
                            logger.log(Level.INFO, String.format("%1$-10s", "AUTHCKNAM") + "= " + string22);
                            this.addField(element2, "AUTHCKNAM", string22, string25 + "-OWNER");
                            string21 = (String)jCoTable.getValue("LANGUAGE");
                            logger.log(Level.INFO, String.format("%1$-10s", "LANGUAGE") + "= " + string21);
                            this.addField(element2, "LANGUAGE", string21, string25 + "-LANGU");
                            string20 = (String)jCoTable.getValue("PDEST");
                            logger.log(Level.INFO, String.format("%1$-10s", "PDEST") + "= " + string20);
                            this.addField(element2, "PDEST", string20, string25 + "-PRINT_DEST");
                            string19 = (String)jCoTable.getValue("PRCOP");
                            logger.log(Level.INFO, String.format("%1$-10s", "PRCOP") + "= " + string19);
                            this.addField(element2, "PRCOP", string19, string25 + "-PRINT_COPIES");
                            string18 = (String)jCoTable.getValue("PRNEW");
                            logger.log(Level.INFO, String.format("%1$-10s", "PRNEW") + "= " + string18);
                            if (string18.compareToIgnoreCase("X") == 0) {
                                this.addField(element2, "PRNEW", "X", string25 + "-NEW_LIST_ID");
                            } else {
                                this.addField(element2, "PRNEW", "N", string25 + "-NEW_LIST_ID");
                            }
                            string17 = (String)jCoTable.getValue("PEXPI");
                            logger.log(Level.INFO, String.format("%1$-10s", "PEXPI") + "= " + string17);
                            this.addField(element2, "PEXPI", string17, string25 + "-PRINT_EXPIRATION");
                            string16 = (String)jCoTable.getValue("PRREL");
                            logger.log(Level.INFO, String.format("%1$-10s", "PRREL") + "= " + string16);
                            if (string16.compareToIgnoreCase("X") == 0) {
                                this.addField(element2, "PRREL", "X", string25 + "-PRINT_RELEASE");
                            } else {
                                this.addField(element2, "PRREL", "N", string25 + "-PRINT_RELEASE");
                            }
                            String string30 = (String)jCoTable.getValue("PRIMM");
                            logger.log(Level.INFO, String.format("%1$-10s", "PRIMM") + "= " + string30);
                            if (string30.length() == 0) {
                                this.addField(element2, "PRIMM", "N", string25 + "-PRINT_IMMED");
                            } else {
                                this.addField(element2, "PRIMM", string30, string25 + "-PRINT_IMMED");
                            }
                            String string31 = (String)jCoTable.getValue("ARMOD");
                            logger.log(Level.INFO, String.format("%1$-10s", "ARMOD") + "= " + string31);
                            if (string31.compareToIgnoreCase("1") == 0) {
                                this.addField(element2, "ARMOD", "PRINT", string25 + "-PRINT_ARCHMODE");
                            } else if (string31.compareToIgnoreCase("2") == 0) {
                                this.addField(element2, "ARMOD", "ARCHIVE", string25 + "-PRINT_ARCHMODE");
                            } else if (string31.compareToIgnoreCase("3") == 0) {
                                this.addField(element2, "ARMOD", "PRINT_ARCHIVE", string25 + "-PRINT_ARCHMODE");
                            }
                            if (jCoTable2 != null) {
                                try {
                                    string29 = (String)jCoTable2.getValue("RECEIVER");
                                    logger.log(Level.INFO, String.format("%1$-10s", "RECEIVER") + "= " + string29);
                                    this.addField(element2, "RECEIVER", string29, string25 + "-PRINT_RECIPIENT");
                                }
                                catch (Exception exception) {}
                            } else {
                                this.addField(element2, "RECEIVER", "CTM_VALUE_NOT_EXTRACTED", string25 + "-PRINT_RECIPIENT");
                            }
                            string29 = (String)jCoTable.getValue("PRBIG");
                            logger.log(Level.INFO, String.format("%1$-10s", "PRBIG") + "= " + string29);
                            if (string29.compareToIgnoreCase("x") == 0) {
                                this.addField(element2, "PRBIG", "X", string25 + "-PRINT_BANNER_PAGE");
                            } else {
                                this.addField(element2, "PRBIG", "N", string25 + "-PRINT_BANNER_PAGE");
                            }
                            String string32 = (String)jCoTable.getValue("PRSAP");
                            logger.log(Level.INFO, String.format("%1$-10s", "PRSAP") + "= " + string32);
                            if (string32.compareTo("D") == 0) {
                                this.addField(element2, "PRSAP", "D", string25 + "-PRINT_BANNER");
                            } else if (string32.compareTo("X") == 0) {
                                this.addField(element2, "PRSAP", "X", string25 + "-PRINT_BANNER");
                            } else {
                                this.addField(element2, "PRSAP", "N", string25 + "-PRINT_BANNER");
                            }
                            String string33 = (String)jCoTable.getValue("PRABT");
                            logger.log(Level.INFO, String.format("%1$-10s", "PRABT") + "= " + string33);
                            this.addField(element2, "PRABT", string33, string25 + "-DEPT");
                            if (jCoTable2 != null) {
                                try {
                                    string28 = (String)jCoTable2.getValue("OSCOVER");
                                    logger.log(Level.INFO, String.format("%1$-10s", "OSCOVER") + "= " + string28);
                                    if (string28.compareTo("D") == 0) {
                                        this.addField(element2, "OSCOVER", "D", string25 + "-PRINT_HOST_BANNER");
                                        break block94;
                                    }
                                    if (string28.compareTo("X") == 0) {
                                        this.addField(element2, "OSCOVER", "X", string25 + "-PRINT_HOST_BANNER");
                                        break block94;
                                    }
                                    this.addField(element2, "OSCOVER", "N", string25 + "-PRINT_HOST_BANNER");
                                }
                                catch (Exception exception) {}
                            } else {
                                this.addField(element2, "OSCOVER", "CTM_VALUE_NOT_EXTRACTED", string25 + "-PRINT_HOST_BANNER");
                            }
                        }
                        string28 = (String)jCoTable.getValue("PLIST");
                        logger.log(Level.INFO, String.format("%1$-10s", "PLIST") + "= " + string28);
                        this.addField(element2, "PLIST", string28, string25 + "-LIST_NAME");
                        String string34 = (String)jCoTable.getValue("PRTXT");
                        logger.log(Level.INFO, String.format("%1$-10s", "PRTXT") + "= " + string34);
                        this.addField(element2, "PRTXT", string34, string25 + "-LIST_TEXT");
                        if (jCoTable2 != null) {
                            try {
                                string27 = (String)jCoTable2.getValue("AUTHORITY");
                                logger.log(Level.INFO, String.format("%1$-10s", "AUTHORITY") + "= " + string27);
                                this.addField(element2, "AUTHORITY", string27, string25 + "-PRINT_AUTH");
                            }
                            catch (Exception exception) {}
                        } else {
                            this.addField(element2, "AUTHORITY", "CTM_VALUE_NOT_EXTRACTED", string25 + "-PRINT_AUTH");
                        }
                        string27 = Integer.toString((Integer)jCoTable.getValue("LINCT"));
                        logger.log(Level.INFO, String.format("%1$-10s", "LINCT") + "= " + string27);
                        this.addField(element2, "LINCT", string27, string25 + "-PRINT_NUMLINES");
                        String string35 = Integer.toString((Integer)jCoTable.getValue("LINSZ"));
                        logger.log(Level.INFO, String.format("%1$-10s", "LINSZ") + "= " + string35);
                        this.addField(element2, "LINSZ", string35, string25 + "-PRINT_NUMCOLUMNS");
                        String string36 = (String)jCoTable.getValue("PAART");
                        logger.log(Level.INFO, String.format("%1$-10s", "PAART") + "= " + string36);
                        this.addField(element2, "PAART", string36, string25 + "-PRINT_LAYOUT");
                        String string37 = (String)jCoTable.getValue("SAP_OBJECT");
                        logger.log(Level.INFO, String.format("%1$-10s", "SAP_OBJECT") + "= " + string37);
                        this.addField(element2, "SAP_OBJECT", string37, string25 + "-ARCHIVE_SAPOBJECT");
                        String string38 = (String)jCoTable.getValue("AR_OBJECT");
                        logger.log(Level.INFO, String.format("%1$-10s", "AR_OBJECT") + "= " + string38);
                        this.addField(element2, "AR_OBJECT", string38, string25 + "-ARCHIVE_OBJECT");
                        String string39 = (String)jCoTable.getValue("INFO");
                        logger.log(Level.INFO, String.format("%1$-10s", "INFO") + "= " + string39);
                        this.addField(element2, "INFO", string39, string25 + "-ARCHIVE_INFO");
                        String string40 = (String)jCoTable.getValue("ARCHIV_ID");
                        logger.log(Level.INFO, String.format("%1$-10s", "ARCHIV_ID") + "= " + string40);
                        this.addField(element2, "ARCHIV_ID", string40, string25 + "-ARCH_ID");
                        String string41 = (String)jCoTable.getValue("ARCTEXT");
                        logger.log(Level.INFO, String.format("%1$-10s", "ARCTEXT") + "= " + string41);
                        this.addField(element2, "ARCTEXT", string41, string25 + "-ARCH_TEXT");
                        continue;
                    }
                    if (string26.compareToIgnoreCase("X") != 0 && string26.compareToIgnoreCase("C") != 0) continue;
                    if (string26.compareToIgnoreCase("X") == 0) {
                        this.addField(element2, "TYP", "E", string25 + "-STEP_TYPE");
                    } else {
                        this.addField(element2, "TYP", "C", string25 + "-STEP_TYPE");
                    }
                    string24 = (String)jCoTable.getValue("OPSYSTEM");
                    logger.log(Level.INFO, String.format("%1$-10s", "OPSYSTEM") + "= " + string24);
                    this.addField(element2, "OPSYSTEM", string24, string25 + "-OPERSYS");
                    string23 = (String)jCoTable.getValue("PROGRAM");
                    logger.log(Level.INFO, String.format("%1$-10s", "PROGRAM") + "= " + string23);
                    this.addField(element2, "PROGRAM", string23, string25 + "-PROGRAM");
                    string22 = (String)jCoTable.getValue("AUTHCKNAM");
                    logger.log(Level.INFO, String.format("%1$-10s", "AUTHCKNAM") + "= " + string22);
                    this.addField(element2, "AUTHCKNAM", string22, string25 + "-OWNER");
                    string21 = (String)jCoTable.getValue("PARAMETER");
                    logger.log(Level.INFO, String.format("%1$-10s", "PARAMETER") + "= " + string21);
                    this.addField(element2, "PARAMETER", string21, string25 + "-VAR-NAME");
                    string20 = (String)jCoTable.getValue("XPGTGTSYS");
                    logger.log(Level.INFO, String.format("%1$-10s", "XPGTGTSYS") + "= " + string20);
                    this.addField(element2, "XPGTGTSYS", string20, string25 + "-TARGET_HOST");
                    string19 = (String)jCoTable.getValue("TERMCNTL");
                    logger.log(Level.INFO, String.format("%1$-10s", "TERMCNTL") + "= " + string19);
                    this.addField(element2, "TERMCNTL", string19.compareToIgnoreCase("C") == 0 ? "X" : "N", string25 + "-WAIT_FOR_TERM");
                    string18 = (String)jCoTable.getValue("STDOUTCNTL");
                    logger.log(Level.INFO, String.format("%1$-10s", "STDOUTCNTL") + "= " + string18);
                    this.addField(element2, "STDOUTCNTL", string18.compareToIgnoreCase("M") == 0 ? "X" : "N", string25 + "-LOG_STDOUT");
                    string17 = (String)jCoTable.getValue("STDERRCNTL");
                    logger.log(Level.INFO, String.format("%1$-10s", "STDERRCNTL") + "= " + string17);
                    this.addField(element2, "STDERRCNTL", string17.compareToIgnoreCase("M") == 0 ? "X" : "N", string25 + "-LOG_STDERR");
                    string16 = (String)jCoTable.getValue("TRACECNTL");
                    logger.log(Level.INFO, String.format("%1$-10s", "TRACECNTL") + "= " + string16);
                    this.addField(element2, "TRACECNTL", string16.compareToIgnoreCase("3") == 0 ? "X" : "N", string25 + "-ACTIVATE_TRACE");
                }
                if (bl) {
                    jobsProgressBar.setValue(i + 1);
                }
                this.jobsExtractedSoFar = i + 1;
            }
            Iterator<String> iterator = this.calNames.iterator();
            element3 = this.destination.getRepository().getFunction("SBFC_FACTORY_CALENDAR_TRANSFER");
            element3.execute(this.destination);
            element2 = element3.getTableParameterList().getTable("E_T_TFACS");
            element = null;
            object6 = null;
            while (iterator.hasNext()) {
                object5 = iterator.next().toString();
                boolean bl2 = false;
                for (int i = 0; i < element2.getNumRows(); ++i) {
                    element2.setRow(i);
                    if (element2.getValue("IDENT").toString().compareToIgnoreCase((String)object5) != 0) continue;
                    if (!bl2) {
                        bl2 = true;
                        element = doc.createElement("Calendar");
                        element.setAttribute("NAME", (String)element2.getValue("IDENT"));
                        element6.appendChild(element);
                    }
                    string = (String)element2.getValue("JAHR");
                    object4 = doc.createElement("Year");
                    object4.setAttribute("Number", string);
                    element.appendChild((Node)object4);
                    object3 = 1;
                    while ((Integer)object3 <= 12) {
                        object6 = (Integer)object3 < 10 ? "MON0" + ((Integer)object3).toString() : "MON" + ((Integer)object3).toString();
                        object2 = (String)element2.getValue((String)object6);
                        object = doc.createElement("Month");
                        object.setAttribute("Number", ((Integer)object3).toString());
                        object.setAttribute("Days", (String)object2);
                        object4.appendChild((Node)object);
                        object2 = object3;
                        object = object3 = Integer.valueOf((Integer)object3 + 1);
                    }
                }
            }
            if (_outputFile.length() > 0) {
                SapExt.jobsToXml();
            } else {
                if (!bl) {
                    throw new Exception("Output filename is missing");
                }
                object5 = new SaveOutputGUI(doc);
                ((Window)object5).setLocationRelativeTo(null);
                ((Dialog)object5).setVisible(true);
            }
            this.endSapContext();
        }
        catch (Exception exception) {
            throw new Exception(exception.getLocalizedMessage());
        }
        finally {
            this.endSapContext();
            if (bl) {
                MainUtilGUI.setCursorDefault();
            }
        }
    }

    static void jobsToXml() throws TransformerFactoryConfigurationError, TransformerException {
        Transformer transformer = TransformerFactory.newInstance().newTransformer();
        DOMSource dOMSource = new DOMSource(doc);
        StreamResult streamResult = new StreamResult(new File(_outputFile));
        transformer.setOutputProperty("indent", "yes");
        transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
        transformer.transform(dOMSource, streamResult);
    }

    public String getJobName() {
        return this._jobName;
    }

    public void setJobName(String string) {
        this._jobName = string;
    }

    public String getJobCount() {
        return this._jobCount;
    }

    public void setJobCount(String string) {
        this._jobCount = string;
    }

    public String gethostNamet() {
        return this._hostName;
    }

    public void setHostName(String string) {
        this._hostName = string;
    }

    public String getSystemNumber() {
        return this._systemNumber;
    }

    public void setSystemNumber(String string) {
        this._systemNumber = string;
    }

    public String getClientNumber() {
        return this._clientNumber;
    }

    public void setClientNumber(String string) {
        this._clientNumber = string;
    }

    public String getUserName() {
        return this._userName;
    }

    public void setUserName(String string) {
        this._userName = string;
    }

    public char[] getPassword() {
        return this._password;
    }

    public void setPassword(char[] cArray) {
        this._password = cArray;
    }

    public String getUser() {
        return this._user;
    }

    public void setUser(String string) {
        this._user = string;
    }

    public String getFromDate() {
        return this._fromDate;
    }

    public void setFromDate(String string) {
        this._fromDate = string;
    }

    public String getToDate() {
        return this._toDate;
    }

    public void setToDate(String string) {
        this._toDate = string;
    }

    public String getStatusActive() {
        return this._statusActive;
    }

    public void setStatusActive(String string) {
        this._statusActive = string;
    }

    public String getStatusCanceled() {
        return this._statusCanceled;
    }

    public void setStatusCanceled(String string) {
        this._statusCanceled = string;
    }

    private void addField(Element element, String string, String string2, String string3) {
        Element element2 = doc.createElement("Field");
        element.appendChild(element2);
        element2.setAttribute("NAME", string);
        element2.setAttribute("VALUE", string2);
        element2.setAttribute("AUTOEDIT", string3);
    }

    public String getStatusScheduled() {
        return this._statusScheduled;
    }

    public void setStatusScheduled(String string) {
        this._statusScheduled = string;
    }

    public String getStatusReleased() {
        return this._statusReleased;
    }

    public void setStatusReleased(String string) {
        this._statusReleased = string;
    }

    public String getStatusFinished() {
        return this._statusFinished;
    }

    public void setStatusFinished(String string) {
        this._statusFinished = string;
    }

    public String getStatusReady() {
        return this._statusReady;
    }

    public void setStatusReady(String string) {
        this._statusReady = string;
    }

    public String getOutputFile() {
        return _outputFile;
    }

    public void setOutputFile(String string) {
        _outputFile = string;
    }

    public String getAfterEevent() {
        return this._afterEvent;
    }

    public void setAfterEvent(String string) {
        this._afterEvent = string;
    }

    public int getTotalNumOfJobs() {
        return this.totalNumOfJobs;
    }

    public int getJobsExtractedSoFar() {
        return this.jobsExtractedSoFar;
    }

    static {
        logger = Logger.getLogger(SapExt.class.getName());
        logFlag = 0;
        newLine = "\n";
    }

    public class MyFormatter
    extends Formatter {
        @Override
        public String format(LogRecord logRecord) {
            return new Date(logRecord.getMillis()) + "::" + logRecord.getMessage() + newLine;
        }
    }
}

