/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.zena.utils;

import com.bmc.ctmconvert.common.xml.XmlElement;
import com.bmc.ctmconvert.zena.EntitiesDefinitionsManager;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.w3c.dom.Element;

public class ZenaXmlUtils {
    private ZenaXmlUtils() {
    }

    public static List<XmlElement> getProcessLinksFrom(XmlElement task) {
        return task.findParent(e -> "PROCESS".equals(e.getTagName())).map(e -> e.getAllDecnedElementByName("LINK")).orElse(Collections.emptyList());
    }

    public static String getTagNameFromTaskDefinition(XmlElement task, EntitiesDefinitionsManager entitiesDefinitionsManager) {
        return Optional.ofNullable(entitiesDefinitionsManager.getElementByTypeAndID("TASK", task.getAttribute("UID"))).map(Element::getTagName).orElse("");
    }

    public static long countOutConditions(String itemUid, List<XmlElement> links) {
        return links.stream().filter(link -> ZenaXmlUtils.isSourceLink(link, itemUid)).count();
    }

    public static boolean hasTrivialConditionStructure(XmlElement task) {
        String itemUid = task.getAttribute("ITEM_UID");
        List<XmlElement> links = ZenaXmlUtils.getProcessLinksFrom(task);
        long outConditionsCount = ZenaXmlUtils.countOutConditions(itemUid, links);
        long inConditionsCount = ZenaXmlUtils.countInConditions(itemUid, links);
        return outConditionsCount == 1L && inConditionsCount == 1L;
    }

    private static long countInConditions(String itemUid, List<XmlElement> links) {
        return links.stream().filter(link -> itemUid.equals(link.getAttribute("TARGET"))).count();
    }

    public static String getItemUid(Element source) {
        return source.getAttribute("ITEM_UID");
    }

    public static Stream<XmlElement> getProcessItems(XmlElement element) {
        return element.findParent(e -> "DEFINITION".equals(e.getTagName())).map(parent -> parent.getFirstChildElementByName("PROCESS")).map(parent -> parent.getFirstChildElementByName("ITEMS")).map(XmlElement::getAllDirectchildsElement).orElse(Collections.emptyList()).stream();
    }

    private static boolean isSourceLink(XmlElement link, XmlElement entityProcessData) {
        String itemUid = entityProcessData.getAttribute("ITEM_UID");
        return ZenaXmlUtils.isSourceLink(link, itemUid);
    }

    public static boolean isSourceLink(XmlElement link, String itemUid) {
        return itemUid.equals(link.getAttribute("SOURCE"));
    }

    public static Predicate<XmlElement> isTargetTask(XmlElement sourceLink) {
        return item -> ZenaXmlUtils.isTargetTask(sourceLink, item);
    }

    public static boolean isTargetTask(XmlElement link, XmlElement item) {
        String itemUid = item.getAttribute("ITEM_UID");
        String targetUid = link.getAttribute("TARGET");
        return itemUid.equals(targetUid);
    }

    public static Stream<XmlElement> getNextTasks(Element entityProcessData) {
        return ZenaXmlUtils.getNextTasks(XmlElement.ofNullable((Element)entityProcessData));
    }

    public static Stream<XmlElement> getNextTasks(XmlElement task) {
        return ZenaXmlUtils.getProcessLinksFrom(task).stream().filter(link -> ZenaXmlUtils.isSourceLink(link, task)).flatMap(sourceLink -> ZenaXmlUtils.getProcessItems(sourceLink).filter(ZenaXmlUtils.isTargetTask(sourceLink)));
    }

    public static XmlElement getTaskDefinitionFromItem(EntitiesDefinitionsManager entitiesDefinitionsManager, XmlElement taskItem) {
        return XmlElement.ofNullable((Element)entitiesDefinitionsManager.getElementByTypeAndID("TASK", taskItem.getAttribute("UID")));
    }

    public static XmlElement getDefinitionFromItem(EntitiesDefinitionsManager entitiesDefinitionsManager, XmlElement taskItem) {
        return XmlElement.ofNullable((Element)entitiesDefinitionsManager.getElementByID(taskItem.getAttribute("UID")));
    }

    public static Optional<String> getFolderIdFrom(Element element) {
        return Optional.ofNullable(XmlElement.ofNullable((Element)element).getParent().getAttribute("FOLDER_ID"));
    }

    public static Optional<XmlElement> findLinkBetween(String sourceItemUid, XmlElement targetItem) {
        return ZenaXmlUtils.getProcessLinksFrom(targetItem).stream().filter(link -> ZenaXmlUtils.isTargetTask(link, targetItem)).filter(link -> ZenaXmlUtils.isSourceLink(link, sourceItemUid)).findFirst();
    }

    public static boolean isDependency(XmlElement task) {
        return task.getTagName().contains("DEPENDENCY");
    }

    public static Stream<XmlElement> extractParametersOrdered(XmlElement taskDefinition) {
        return Optional.ofNullable(taskDefinition.getFirstChildElementByName("VARIABLES")).map(XmlElement::getAllDirectchildsElement).orElse(Collections.emptyList()).stream().filter(variable -> variable.hasAttribute("ORDER")).sorted(Comparator.comparing(variable -> variable.getAttribute("ORDER")));
    }

    public static Optional<XmlElement> getItemDefinition(XmlElement taskDefinition, String itemUid) {
        return ZenaXmlUtils.getProcessItems(taskDefinition).filter(item -> item.getAttribute("ITEM_UID").equals(itemUid)).findFirst();
    }

    public static List<XmlElement> getVariablesFromDefinition(Optional<XmlElement> processItem, EntitiesDefinitionsManager entitiesDefinitionsManager) {
        return processItem.map(item -> ZenaXmlUtils.getDefinitionFromItem(entitiesDefinitionsManager, item)).map(definition -> definition.getFirstChildElementByName("VARIABLES")).map(XmlElement::getAllDirectchildsElement).orElse(Collections.emptyList());
    }

    public static <T> List<T> getVariablesFrom(XmlElement processItem, Function<XmlElement, T> getFromVariable) {
        List variables = Optional.ofNullable(processItem.getFirstChildElementByName("VARIABLES")).map(vars -> vars.getDirectchildsElementbyName("VARIABLE")).orElse(Collections.emptyList());
        return variables.stream().map(getFromVariable).collect(Collectors.toList());
    }

    public static Optional<Element> getItemFromProcessByUid(Element process, String itemUid) {
        List processItems = XmlElement.ofNullable((Element)process).getFirstChildElementByName("ITEMS").getAllDirectchildsElement();
        return processItems.stream().filter(child -> itemUid.equals(child.getAttribute("ITEM_UID"))).map(XmlElement::getElement).findFirst();
    }

    public static String getUidOrItemUidFrom(Element element) {
        return Optional.of(element.getAttribute("UID")).filter(s -> !s.isEmpty()).orElse(element.getAttribute("ITEM_UID"));
    }

    public static XmlElement getProcessDefinition(EntitiesDefinitionsManager entitiesDefinitionsManager, String processUID) {
        return XmlElement.ofNullable((Element)entitiesDefinitionsManager.getElementByTypeAndID("PROCESS", processUID));
    }
}

