/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.zena.tasktypes.sql_query;

import com.bmc.ctmconvert.common.GlobalFunctions;
import com.bmc.ctmconvert.common.Params;
import com.bmc.ctmconvert.common.SchedEntity;
import com.bmc.ctmconvert.db.DbSqlWrapper;
import com.bmc.ctmconvert.zena.ZenaJob;
import com.bmc.ctmconvert.zena.handlers.MSSQL_ConnectionProfileActionHandler;
import com.bmc.ctmconvert.zena.handlers.ZenaVariablesHandler;
import com.bmc.ctmconvert.zena.tasktypes.sql_query.SqlTask;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;

public class SqlTaskConvertor {
    SqlTask sqlTask;
    private ZenaJob job;
    DbSqlWrapper wrapper;
    ZenaVariablesHandler zenaVariablesHandler;

    public SqlTaskConvertor(SqlTask sqlTask, ZenaJob job, ZenaVariablesHandler zenaVariablesHandler) {
        this.sqlTask = sqlTask;
        this.job = job;
        this.wrapper = new DbSqlWrapper((SchedEntity)job);
        this.zenaVariablesHandler = zenaVariablesHandler;
    }

    public void convert() {
        this.setFormat();
        this.setConnectionProfile();
        this.setAppendOutput();
    }

    void setDefaultValues(String databaseExecType) {
        this.wrapper.setDefaultValues(databaseExecType);
        this.job.addAutoEdits("%%DB-CSV_SEPERATOR", ",");
    }

    private void setFormat() {
        if (this.isSupportedFormat()) {
            this.job.addAutoEdits("%%DB-OUTPUT_FORMAT", this.sqlTask.FORMAT);
        }
    }

    private void setConnectionProfile() {
        if (this.hasLoginName()) {
            this.job.addAutoEdits("%%DB-ACCOUNT", this.validateConnectionProfile(this.sqlTask.LOGIN.NAME));
        }
        this.addDatabaseAccountAction();
    }

    private void addDatabaseAccountAction() {
        HashMap<Object, Object> action = new HashMap<String, String>();
        if (this.sqlTask.LOGIN.SERVERTYPE.map(s -> s.equals("1")).orElse(false).booleanValue()) {
            action = MSSQL_ConnectionProfileActionHandler.getMSSQL_ConncetionProfileAction(this.sqlTask.LOGIN, this.job.getJobName(), this.job.getAutoedits().get("%%DB-ACCOUNT"), this.job.getAttr("NODEID"), this.sqlTask.DATABASENAME, Params.instance().getDatacenterName());
        } else {
            action.put("ACTENTTYPE", "DATABASEACC");
            action.put("JOBID", this.job.getJobName());
            action.put("ACTENTNAME", this.job.getAutoedits().get("%%DB-ACCOUNT"));
            action.put("ACTSTATUS", "0");
        }
        this.job.addAction(action);
    }

    private String validateConnectionProfile(String connectionProfileName) {
        return this.job.getFieldValidation().validateAndReturnFixedValue(this.job::addMessage, "CONNECTION_PROFILE", connectionProfileName, true, "LOGIN");
    }

    private void setAppendOutput() {
        if ("YES".equals(this.sqlTask.APPEND_OUTPUT)) {
            this.job.addAutoEdits("%%DB-APPEND_OUTPUT", "Y");
        }
    }

    private boolean hasLoginName() {
        return GlobalFunctions.isNotEmpty((String)this.sqlTask.LOGIN.NAME);
    }

    private boolean isSupportedFormat() {
        List<String> supportedFormats = Arrays.asList("XML", "CSV");
        return supportedFormats.contains(this.sqlTask.FORMAT);
    }
}

